/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.SiteMember;
import com.trs.components.wcm.content.persistent.SiteMembers;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;

public class SiteMemberMgr {
    public void addSiteUser(WebSite _site, User _user) throws WCMException {
        this.assertNotNull(_site, I18NMessage.get(SiteMemberMgr.class, "SiteMemberMgr.label1", "\u6307\u5b9a\u7684\u7ad9\u70b9\u65e0\u6548!"));
        this.assertNotNull(_user, I18NMessage.get(SiteMemberMgr.class, "SiteMemberMgr.label2", "\u6307\u5b9a\u7684\u7528\u6237\u65e0\u6548!"));
        this.addSiteMember(_site.getId(), _user.getWCMType(), _user.getId());
    }

    public void removeSiteUser(WebSite _site, User _user) throws WCMException {
        this.assertNotNull(_site, I18NMessage.get(SiteMemberMgr.class, "SiteMemberMgr.label1", "\u6307\u5b9a\u7684\u7ad9\u70b9\u65e0\u6548!"));
        this.assertNotNull(_user, I18NMessage.get(SiteMemberMgr.class, "SiteMemberMgr.label2", "\u6307\u5b9a\u7684\u7528\u6237\u65e0\u6548!"));
        this.removeSiteMember(_site.getId(), _user.getWCMType(), _user.getId());
    }

    public void addSiteGroup(WebSite _site, Group _group) throws WCMException {
        this.assertNotNull(_site, I18NMessage.get(SiteMemberMgr.class, "SiteMemberMgr.label1", "\u6307\u5b9a\u7684\u7ad9\u70b9\u65e0\u6548!"));
        this.assertNotNull(_group, I18NMessage.get(SiteMemberMgr.class, "SiteMemberMgr.label3", "\u6307\u5b9a\u7684\u7528\u6237\u7ec4\u65e0\u6548!"));
        this.addSiteMember(_site.getId(), _group.getWCMType(), _group.getId());
    }

    public void removeSiteGroup(WebSite _site, Group _group) throws WCMException {
        this.assertNotNull(_site, I18NMessage.get(SiteMemberMgr.class, "SiteMemberMgr.label1", "\u6307\u5b9a\u7684\u7ad9\u70b9\u65e0\u6548!"));
        this.assertNotNull(_group, I18NMessage.get(SiteMemberMgr.class, "SiteMemberMgr.label3", "\u6307\u5b9a\u7684\u7528\u6237\u7ec4\u65e0\u6548!"));
        this.removeSiteMember(_site.getId(), _group.getWCMType(), _group.getId());
    }

    public WebSites getUserSites(User _currUser, WCMFilter _filter) throws WCMException {
        this.assertNotNull(_currUser, I18NMessage.get(SiteMemberMgr.class, "SiteMemberMgr.label4", "\u5f53\u524d\u7528\u6237\u65e0\u6548,\u65e0\u6cd5\u83b7\u53d6\u5176\u6240\u5728\u7ad9\u70b9\u96c6\u5408!"));
        String sWhere = "Status=0";
        if (!_currUser.isAdministrator()) {
            sWhere = sWhere + " and (CrUser='" + CMyString.filterForSQL(_currUser.getName()) + "' OR " + this.getSelectSiteWhere(_currUser) + ")";
        }
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        aFilter.mergeWith(_filter);
        return WebSites.openWCMObjs(_currUser, aFilter);
    }

    private String getSelectSiteWhere(User _user) throws WCMException {
        int nUserId = _user.getId();
        String sUserMembersWhere = "(ObjType=204 and ObjId=" + nUserId + ")";
        String sExtraWhere = "Exists(\tselect b.SiteId from WCMSiteUser b where \t(" + sUserMembersWhere + "\t  or\t  (ObjType=" + 203 + " and ObjId=2)\t  or\t  (ObjType=" + 203 + " and Exists(select UserId from WCMRoleUser where UserId=" + nUserId + " and RoleId=b.ObjId))";
        Groups groups = _user.getGroups();
        if (groups != null && !groups.isEmpty()) {
            int nSize = groups.size();
            for (int i = 0; i < nSize; ++i) {
                Group group = (Group)groups.getAt(i);
                if (group == null) continue;
                for (Group parentGroup = group.getParent(); parentGroup != null && groups.indexOf(parentGroup.getId()) < 0; parentGroup = parentGroup.getParent()) {
                    groups.addElement(parentGroup.getId());
                }
            }
            sExtraWhere = sExtraWhere + " or (b.ObjType=201 and b.ObjId in(" + groups.getIdListAsString() + "))";
        }
        sExtraWhere = sExtraWhere + ")";
        return sExtraWhere + " and b.SiteId=WCMWebSite.SiteId )";
    }

    public Users getSiteUsers(WebSite _site, WCMFilter _filter) throws WCMException {
        this.assertNotNull(_site, I18NMessage.get(SiteMemberMgr.class, "SiteMemberMgr.label1", "\u6307\u5b9a\u7684\u7ad9\u70b9\u65e0\u6548!"));
        String sWhere = "ISDELETED=0 AND EXISTS(SELECT ObjId FROM WCMsiteUser WHERE SiteId=? AND ObjType=204 AND WCMUser.UserId=WCMsiteUser.ObjId)";
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        aFilter.addSearchValues(_site.getId());
        aFilter.mergeWith(_filter);
        Users users = new Users(this.getLoginUser());
        users.open(aFilter);
        User user = null;
        int size = users.size();
        for (int i = 0; i < size; ++i) {
            user = (User)users.getAt(i);
            if (user != null && user.getName().indexOf("$") == -1) continue;
            users.remove(user, false);
        }
        return users;
    }

    public boolean isVisible(User _user, WebSite _site) throws WCMException {
        if (_user.isAdministrator() || _user.getName().equalsIgnoreCase(_site.getCrUserName())) {
            return true;
        }
        String sWhere = "SiteId=? and " + this.getSelectSiteWhere(_user);
        WCMFilter filter = new WCMFilter("WCMWEBSITE", sWhere, "", "SiteId");
        filter.addSearchValues(_site.getId());
        return DBManager.getDBManager().sqlExecuteIntQuery(filter) > 0;
    }

    public boolean isVisible(CMSObj _operator, WebSite _site) throws WCMException {
        if (_operator instanceof User) {
            return this.isVisible((User)_operator, _site);
        }
        if (_operator instanceof Group) {
            return this.isBelongToSite((Group)_operator, _site);
        }
        return this.isBelongToSite(_operator, _site);
    }

    public boolean isBelongToSite(User _user, WebSite _site) throws WCMException {
        if (_user == null || _site == null) {
            return false;
        }
        return this.getSiteUser(_site.getId(), _user.getId(), _user.getWCMType()) != null;
    }

    public boolean isBelongToSite(Group _group, WebSite _site) throws WCMException {
        boolean bBelongTo;
        if (_group == null || _site == null) {
            return false;
        }
        boolean bl = bBelongTo = this.getSiteUser(_site.getId(), _group.getId(), _group.getWCMType()) != null;
        if (bBelongTo) {
            return true;
        }
        return this.isBelongToSite(_group.getParent(), _site);
    }

    public boolean isBelongToSite(Role _role, WebSite _site) throws WCMException {
        if (_role == null || _site == null) {
            return false;
        }
        return this.getSiteUser(_site.getId(), _role.getId(), _role.getWCMType()) != null;
    }

    public boolean isBelongToSite(CMSObj _operator, WebSite _site) throws WCMException {
        if (_operator == null || _site == null) {
            return false;
        }
        return this.getSiteUser(_site.getId(), _operator.getId(), _operator.getWCMType()) != null;
    }

    public Groups getSiteGroups(WebSite _site, WCMFilter _filter) throws WCMException {
        this.assertNotNull(_site, I18NMessage.get(SiteMemberMgr.class, "SiteMemberMgr.label1", "\u6307\u5b9a\u7684\u7ad9\u70b9\u65e0\u6548!"));
        String sWhere = "EXISTS(SELECT ObjId FROM WCMSiteUser WHERE SiteId=" + _site.getId() + " AND ObjType=" + 201 + " AND WCMGroup.GroupId=WCMSiteUser.ObjId)";
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        aFilter.mergeWith(_filter);
        return Groups.openWCMObjs(this.getLoginUser(), aFilter);
    }

    public Roles getSiteRoles(WebSite _site, WCMFilter _fitler) throws WCMException {
        this.assertNotNull(_site, I18NMessage.get(SiteMemberMgr.class, "SiteMemberMgr.label1", "\u6307\u5b9a\u7684\u7ad9\u70b9\u65e0\u6548!"));
        String sWhere = "EXISTS(SELECT ObjId FROM WCMSiteUser WHERE SiteId=? AND ObjType=203 AND WCMRole.RoleId=WCMSiteUser.ObjId)";
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        aFilter.addSearchValues(0, _site.getId());
        aFilter.mergeWith(_fitler);
        return Roles.openWCMObjs(this.getLoginUser(), aFilter);
    }

    public void addSiteMember(int _nSiteId, int _nObjType, int _nObjId) throws WCMException {
        SiteMember siteUser = this.getSiteUser(_nSiteId, _nObjId, _nObjType);
        if (siteUser != null) {
            return;
        }
        siteUser = SiteMember.createNewInstance();
        siteUser.setSiteId(_nSiteId);
        siteUser.setObjId(_nObjId);
        siteUser.setObjType(_nObjType);
        siteUser.save(this.getLoginUser());
    }

    public void removeSiteMember(int _nSiteId, int _nObjType, int _nObjId) throws WCMException {
        SiteMember siteUser = this.getSiteUser(_nSiteId, _nObjId, _nObjType);
        if (siteUser == null) {
            return;
        }
        siteUser.delete(this.getLoginUser());
    }

    private SiteMember getSiteUser(int _nSiteId, int _nObjId, int _nObjType) throws WCMException {
        StringBuffer sbWhere = new StringBuffer("SITEID=");
        sbWhere.append(_nSiteId);
        sbWhere.append(" AND ObjId=");
        sbWhere.append(_nObjId);
        sbWhere.append(" AND ObjType=");
        sbWhere.append(_nObjType);
        WCMFilter aFilter = new WCMFilter("", sbWhere.toString(), "");
        aFilter.setMaxRowNumber(1);
        SiteMembers siteUsers = SiteMembers.openWCMObjs(this.getLoginUser(), aFilter);
        return !siteUsers.isEmpty() ? (SiteMember)siteUsers.getAt(0) : null;
    }

    private void assertNotNull(Object _object, String _sDesc) throws WCMException {
        if (_object == null) {
            throw new WCMException(10, _sDesc);
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    SiteMembers getSiteMembers(int _nSiteId, int _nMemberType) throws WCMException {
        WCMFilter aFilter = new WCMFilter("", "SiteId=" + _nSiteId + " AND ObjType=" + _nMemberType, "");
        return SiteMembers.openWCMObjs(this.getLoginUser(), aFilter);
    }

    public WebSites getWebSites(int _objType, int _objId, String _sOrder) throws WCMException {
        if (CMyString.isEmpty(_sOrder)) {
            _sOrder = "SiteOrder Desc";
        }
        WCMFilter filter = new WCMFilter("", "", _sOrder);
        if (!this.isAdmin(_objType, _objId)) {
            StringBuffer sbWhere = new StringBuffer();
            sbWhere.append("exists(select 1 from ");
            sbWhere.append("WCMSITEUSER");
            sbWhere.append(" where objId=? and objType=?");
            sbWhere.append(" and ");
            sbWhere.append("WCMSITEUSER").append(".siteId");
            sbWhere.append(" = ");
            sbWhere.append("WCMWEBSITE").append(".siteId");
            sbWhere.append(")");
            filter.setWhere(sbWhere.toString());
            filter.addSearchValues(_objId);
            filter.addSearchValues(_objType);
            if (_objType == 204) {
                sbWhere.append(" or exists(select 1 from ");
                sbWhere.append("WCMSITEUSER");
                sbWhere.append(" where objType=?");
                sbWhere.append(" and objId in ");
                sbWhere.append("(select groupid from WCMGrpUser where UserId=?)");
                sbWhere.append(" and ");
                sbWhere.append("WCMSITEUSER").append(".siteId");
                sbWhere.append(" = ");
                sbWhere.append("WCMWEBSITE").append(".siteId");
                sbWhere.append(")");
                filter.addSearchValues(201);
                filter.addSearchValues(_objId);
                sbWhere.append(" or exists(select 1 from ");
                sbWhere.append("WCMSITEUSER");
                sbWhere.append(" where objType=?");
                sbWhere.append(" and objId in ");
                sbWhere.append("(select roleId from WCMRoleUser where UserId=?)");
                sbWhere.append(" and ");
                sbWhere.append("WCMSITEUSER").append(".siteId");
                sbWhere.append(" = ");
                sbWhere.append("WCMWEBSITE").append(".siteId");
                sbWhere.append(")");
                filter.addSearchValues(203);
                filter.addSearchValues(_objId);
            }
            filter.setWhere(sbWhere.toString());
        }
        return WebSites.openWCMObjs(this.getLoginUser(), filter);
    }

    private boolean isAdmin(int _objType, int _objId) throws WCMException {
        switch (_objType) {
            case 203: {
                return _objId == 1;
            }
            case 204: {
                User user = User.findById(_objId);
                return user != null && user.isAdministrator();
            }
        }
        return false;
    }
}

