/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.IDepartmentMgr;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.wcm.content.domain.DocumentsGetHelper;
import com.trs.components.wcm.content.domain.IDocumentsTimeRangeMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.resource.DocLevel;
import com.trs.components.wcm.resource.DocLevelMgr;
import com.trs.components.wcm.resource.DocLevels;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class DatasWithChnlDocFilterHelper {
    private String m_sRegContainsDataTable = "(?ism).*WCMDOCUMENT.*";
    private static Logger logger = Logger.getLogger(DatasWithChnlDocFilterHelper.class);
    private static IDocumentsTimeRangeMgr m_oTimeRangeMgr = null;
    private IMetaViewEmployerMgr m_oMetaViewEmployerMgr = null;
    private String m_sTableName = "WCMDOCUMENT";
    private String m_sIdFieldName = "DOCID";
    private boolean m_bNeedWithAuthFilter = false;
    private User m_oLoginUser = null;
    private int m_nRightIndex = 34;

    public DatasWithChnlDocFilterHelper() {
        this.m_oLoginUser = ContextHelper.getLoginUser();
    }

    public DatasWithChnlDocFilterHelper(String _sTableName, String _sIdFieldName) {
        this.m_sTableName = _sTableName.toUpperCase();
        this.m_sIdFieldName = _sIdFieldName;
        this.m_sRegContainsDataTable = "(?ism).*" + this.m_sTableName + ".*";
        this.m_oLoginUser = ContextHelper.getLoginUser();
    }

    public WCMFilter makeChannelFilter(Channel _channel, WCMFilter _filter) throws WCMException {
        return this.makeChannelFilter(_channel, _filter, false, false);
    }

    public WCMFilter makeChannelFilter(Channel _channel, WCMFilter _filter, boolean _bIncludeOrder, boolean _bFromRecycle) throws WCMException {
        String sOrder;
        String sQuery;
        if (m_oTimeRangeMgr == null) {
            m_oTimeRangeMgr = (IDocumentsTimeRangeMgr)DreamFactory.createObjectById("IDocumentsTimeRangeMgr");
        }
        WCMFilter joinFilter = null;
        if (this.isQueryInSpecifyTable(_filter, _channel)) {
            joinFilter = this.makeChannelFilterWithJoin(_channel, _filter, _bIncludeOrder, _bFromRecycle);
        }
        if ((joinFilter = this.makeMetadataChannelFilterWithJoin(_channel, _filter, joinFilter, _bIncludeOrder, _bFromRecycle)) != null) {
            return joinFilter;
        }
        WCMFilter aFilter = new WCMFilter("WCMCHNLDOC", null, null);
        StringBuffer sbWhere = new StringBuffer();
        if (!_channel.isOnlySearch()) {
            sbWhere.append("CHNLID=?");
            aFilter.addSearchValues(_channel.getId());
        }
        if (!CMyString.isEmpty(sQuery = _channel.getQuery())) {
            sbWhere.append(sbWhere.length() > 0 ? " and (" : "(");
            sbWhere.append(sQuery);
            sbWhere.append(')');
        }
        if (this.m_bNeedWithAuthFilter) {
            boolean bHasRight = AuthServer.hasRight(this.m_oLoginUser, (CMSObj)_channel, this.m_nRightIndex);
            if (bHasRight) {
                if (!this.m_oLoginUser.isAdministrator() && !_channel.getCrUserName().equalsIgnoreCase(this.m_oLoginUser.getName()) && _channel.isUseDocLevel()) {
                    this.makeDocLevelWhere(aFilter, sbWhere);
                }
            } else {
                sbWhere.append(" and CrUser=?");
                aFilter.addSearchValues(this.m_oLoginUser.getName());
            }
        }
        String sWhere = sbWhere.toString();
        sbWhere.setLength(0);
        String sUperCaseWhere = sWhere.toUpperCase();
        if (sUperCaseWhere.indexOf("SRCCHNLID=0") >= 0) {
            sWhere = sUperCaseWhere = CMyString.replaceStr(sUperCaseWhere, "SRCCHNLID=0", "MODAL=1");
        }
        if (sUperCaseWhere.indexOf("WCMDOCUMENT.DOCID=WCMCHNLDOC.DOCID") >= 0) {
            sWhere = sUperCaseWhere = CMyString.replaceStr(sUperCaseWhere, "WCMDOCUMENT.DOCID=WCMCHNLDOC.DOCID", "1=1");
        }
        String sExtraWhere = null;
        if (_filter != null && _filter.getWhere() != null && (sExtraWhere = _filter.getWhere().trim().toUpperCase()).length() == 0) {
            sExtraWhere = null;
        }
        if ((sExtraWhere == null || sExtraWhere.indexOf("DOCSTATUS") < 0) && sUperCaseWhere.indexOf("DOCSTATUS") < 0) {
            sbWhere.append(_bFromRecycle ? " (WCMChnlDoc.DOCSTATUS<0 or WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : " WCMChnlDoc.DOCSTATUS>0 and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        } else {
            sbWhere.append(_bFromRecycle ? " (WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : " WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        }
        if ((sExtraWhere == null || sExtraWhere.indexOf("CHNLID") < 0) && sUperCaseWhere.indexOf("CHNLID") < 0) {
            sbWhere.append(_bFromRecycle ? "" : " and WCMChnlDoc.CHNLID>0");
        }
        sWhere = sWhere + " AND (" + sbWhere.toString() + ")";
        if (_bIncludeOrder) {
            sOrder = _channel.getOrderBy();
            if (!(sOrder != null && sOrder.trim().length() != 0 || (sOrder = _channel.getSite().getOrderBy()) != null && sOrder.trim().length() != 0)) {
                sOrder = "WCMChnlDoc.DOCORDERPRI desc, WCMChnlDoc.DocOrder desc";
            }
        } else {
            sOrder = "";
        }
        aFilter.setWhere(sWhere);
        aFilter.setOrder(sOrder);
        aFilter.mergeWith(_filter);
        CMyDateTime dtStartTime = m_oTimeRangeMgr.getStartDateTime(_channel.getId());
        if (dtStartTime != null) {
            sWhere = aFilter.getWhere();
            if (sWhere.length() > 0) {
                sWhere = sWhere + " and ";
            }
            sWhere = sWhere + "CrTime >= ?";
            aFilter.setWhere(sWhere);
            int nIndex = 0;
            if (aFilter.getSearchValues() != null) {
                nIndex = aFilter.getSearchValues().size();
            }
            aFilter.addSearchValues(nIndex, dtStartTime);
        }
        aFilter.mergeWith(this.makeDeptFilter(_channel));
        return aFilter;
    }

    private WCMFilter makeMetadataChannelFilterWithJoin(Channel _channel, WCMFilter _filter, WCMFilter joinFilter, boolean _bIncludeOrder, boolean _bFromRecycle) throws WCMException {
        MetaView view;
        if (this.m_oMetaViewEmployerMgr == null) {
            this.m_oMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
        }
        if ((view = this.m_oMetaViewEmployerMgr.getViewOfEmployer(_channel)) == null) {
            return joinFilter;
        }
        this.m_sTableName = !view.isMultiTable() ? MetaDataConstants.makeTrueTableName(view.getName()) : view.getName();
        this.m_sIdFieldName = "MetaDataId";
        this.m_sRegContainsDataTable = "(?ism).*" + this.m_sTableName + ".*";
        if (!this.isQueryInSpecifyTable(_filter, _channel)) {
            return joinFilter;
        }
        if (joinFilter == null) {
            return this.makeChannelFilterWithJoin(_channel, _filter, _bIncludeOrder, _bFromRecycle);
        }
        if (joinFilter.getFrom().toUpperCase().indexOf(this.m_sTableName.toUpperCase()) > 0) {
            return joinFilter;
        }
        joinFilter.setFrom(joinFilter.getFrom() + "," + this.m_sTableName);
        joinFilter.setWhere(joinFilter.getWhere() + " AND WCMChnlDoc.DocId=" + this.m_sTableName + "." + this.m_sIdFieldName);
        return joinFilter;
    }

    private WCMFilter makeChannelFilterWithJoin(Channel _channel, WCMFilter _filter, boolean _bIncludeOrder, boolean _bFromRecycle) throws WCMException {
        String sOrder;
        String sQuery;
        WCMFilter aFilter = new WCMFilter("WCMCHNLDOC," + this.m_sTableName, null, null);
        StringBuffer sbWhere = new StringBuffer();
        sbWhere.append("WCMChnlDoc.DocId=" + this.m_sTableName + "." + this.m_sIdFieldName);
        if (!_channel.isOnlySearch()) {
            sbWhere.append(" and WCMChnlDoc.CHNLID=?");
            aFilter.addSearchValues(_channel.getId());
        }
        if (!CMyString.isEmpty(sQuery = _channel.getQuery())) {
            sbWhere.append(" AND (").append(sQuery).append(')');
        }
        if (this.m_bNeedWithAuthFilter) {
            boolean bHasRight = AuthServer.hasRight(this.m_oLoginUser, (CMSObj)_channel, this.m_nRightIndex);
            if (bHasRight) {
                if (!this.m_oLoginUser.isAdministrator() && !_channel.getCrUserName().equalsIgnoreCase(this.m_oLoginUser.getName()) && _channel.isUseDocLevel()) {
                    this.makeDocLevelWhere(aFilter, sbWhere);
                }
            } else {
                sbWhere.append(" and WCMChnlDoc.CrUser=?");
                aFilter.addSearchValues(this.m_oLoginUser.getName());
            }
        }
        String sWhere = sbWhere.toString();
        sbWhere.setLength(0);
        String sUperCaseWhere = sWhere.toUpperCase();
        if (sUperCaseWhere.indexOf("SRCCHNLID=0") >= 0) {
            sWhere = sUperCaseWhere = CMyString.replaceStr(sUperCaseWhere, "SRCCHNLID=0", "MODAL=1");
        }
        String sExtraWhere = null;
        if (_filter != null && _filter.getWhere() != null && (sExtraWhere = _filter.getWhere().trim().toUpperCase()).length() == 0) {
            sExtraWhere = null;
        }
        if ((sExtraWhere == null || sExtraWhere.indexOf("DOCSTATUS") < 0) && sUperCaseWhere.indexOf("DOCSTATUS") < 0) {
            sbWhere.append(_bFromRecycle ? " ( WCMChnlDoc.DOCSTATUS<0 or WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : " WCMChnlDoc.DOCSTATUS>0 and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        } else {
            sbWhere.append(_bFromRecycle ? "( WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : "WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        }
        if ((sExtraWhere == null || sExtraWhere.indexOf("CHNLID") < 0) && sUperCaseWhere.indexOf("CHNLID") < 0) {
            sbWhere.append(_bFromRecycle ? "" : " and WCMChnlDoc.CHNLID>0");
        }
        sWhere = sWhere + " AND (" + sbWhere.toString() + ")";
        if (_bIncludeOrder) {
            WebSite site;
            sOrder = _channel.getOrderBy();
            if (!(sOrder != null && sOrder.trim().length() != 0 || (site = _channel.getSite()) != null && (sOrder = site.getOrderBy()) != null && sOrder.trim().length() != 0)) {
                sOrder = "WCMChnlDoc.DOCORDERPRI desc, WCMChnlDoc.DocOrder desc";
            }
        } else {
            sOrder = "";
        }
        aFilter.setWhere(sWhere);
        aFilter.setOrder(sOrder);
        aFilter.mergeWith(_filter);
        aFilter.mergeWith(this.makeDeptFilter(_channel));
        CMyDateTime dtStartTime = m_oTimeRangeMgr.getStartDateTime(_channel.getId());
        if (dtStartTime != null) {
            sWhere = aFilter.getWhere();
            if (sWhere.length() > 0) {
                sWhere = sWhere + " and ";
            }
            sWhere = sWhere + this.m_sTableName + ".CrTime >= ?";
            aFilter.setWhere(sWhere);
            aFilter.addSearchValues(dtStartTime);
        }
        return aFilter;
    }

    public WCMFilter makeFilter(WebSite _site, WCMFilter _extraFilter, boolean _bIncludeOrder, boolean _bFromRecycle) {
        CMyDateTime dtStartTime;
        if (this.isQueryInSpecifyTable(_extraFilter, null)) {
            return this.makeFilterWithJoin(_site, _extraFilter, _bIncludeOrder, _bFromRecycle);
        }
        String sWCMChnlWhere = "WCMChnlDoc.CHNLID=WCMChannel.ChannelId";
        if (_bFromRecycle) {
            sWCMChnlWhere = "(WCMChnlDoc.CHNLID=WCMChannel.ChannelId or WCMChnlDoc.CHNLID=-WCMChannel.ChannelId)";
            try {
                if (DBManager.getDBManager().getTableInfo("WCMCHNLDOC").getFieldInfo("POSCHNLID") != null) {
                    sWCMChnlWhere = "(WCMChnlDoc.POSCHNLID=WCMChannel.ChannelId)";
                }
            }
            catch (WCMException e) {
                logger.warn((Object)"WCMCHNLDOC\u8868\u4e2d\u4e0d\u5b58\u5728\u5b57\u6bb5POSCHNLID");
            }
        }
        WCMFilter aFilter = new WCMFilter("WCMCHNLDOC", null, null);
        String sWhere = "exists(Select WCMChannel.ChannelId from WCMChannel where " + sWCMChnlWhere + " and Status>=0 and SiteId=?)";
        String sExtraWhere = null;
        if (_extraFilter != null && _extraFilter.getWhere() != null && (sExtraWhere = _extraFilter.getWhere().trim().toUpperCase()).length() == 0) {
            sExtraWhere = null;
        }
        StringBuffer buff = new StringBuffer(sWhere.length() + 40);
        buff.append(sWhere);
        if (sExtraWhere == null || sExtraWhere.indexOf("DOCSTATUS") < 0) {
            buff.append(_bFromRecycle ? " and (WCMChnlDoc.DocStatus<0 or WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0 or WCMChnlDoc.ChnlId<0)" : " and WCMChnlDoc.DOCSTATUS>0 and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        } else {
            buff.append(_bFromRecycle ? " and (WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0 or WCMChnlDoc.ChnlId<0)" : " and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        }
        aFilter.setWhere(buff.toString());
        aFilter.addSearchValues(_site.getId());
        String sOrder = _bIncludeOrder ? "WCMChnlDoc.CrTime Desc" : "";
        aFilter.setOrder(sOrder);
        aFilter.mergeWith(_extraFilter);
        if (m_oTimeRangeMgr == null) {
            m_oTimeRangeMgr = (IDocumentsTimeRangeMgr)DreamFactory.createObjectById("IDocumentsTimeRangeMgr");
        }
        if ((dtStartTime = m_oTimeRangeMgr.getStartDateTime(_site.getId(), 103)) != null) {
            sWhere = aFilter.getWhere();
            if (sWhere.length() > 0) {
                sWhere = sWhere + " and ";
            }
            sWhere = sWhere + "WCMChnlDoc.CrTime >= ?";
            aFilter.setWhere(sWhere);
            aFilter.addSearchValues(dtStartTime);
        }
        return aFilter;
    }

    private WCMFilter makeFilterWithJoin(WebSite _site, WCMFilter _extraFilter, boolean _bIncludeOrder, boolean _bFromRecycle) {
        CMyDateTime dtStartTime;
        WCMFilter aFilter = new WCMFilter("WCMCHNLDOC," + this.m_sTableName, null, null);
        String sWhere = "exists(Select WCMChannel.ChannelId from WCMChannel where " + (_bFromRecycle ? "(WCMChnlDoc.CHNLID=WCMChannel.ChannelId or WCMChnlDoc.CHNLID=-WCMChannel.ChannelId)" : "WCMChnlDoc.CHNLID=WCMChannel.ChannelId") + " and SiteId=?) and WCMChnlDoc.DocId=" + this.m_sTableName + "." + this.m_sIdFieldName;
        String sExtraWhere = null;
        if (_extraFilter != null && _extraFilter.getWhere() != null && (sExtraWhere = _extraFilter.getWhere().trim().toUpperCase()).length() == 0) {
            sExtraWhere = null;
        }
        StringBuffer buff = new StringBuffer(sWhere.length() + 40);
        buff.append(sWhere);
        if (sExtraWhere == null || sExtraWhere.indexOf("DOCSTATUS") < 0) {
            buff.append(_bFromRecycle ? " and (WCMChnlDoc.DOCSTATUS<0 or WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0 or WCMChnlDoc.ChnlId<0)" : " and WCMChnlDoc.DOCSTATUS>0 and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        } else {
            buff.append(_bFromRecycle ? " and (WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0 or WCMChnlDoc.ChnlId<0)" : " and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        }
        aFilter.setWhere(buff.toString());
        aFilter.addSearchValues(_site.getId());
        String sOrder = _bIncludeOrder ? "WCMChnlDoc.CrTime Desc" : "";
        aFilter.setOrder(sOrder);
        aFilter.mergeWith(_extraFilter);
        if (m_oTimeRangeMgr == null) {
            m_oTimeRangeMgr = (IDocumentsTimeRangeMgr)DreamFactory.createObjectById("IDocumentsTimeRangeMgr");
        }
        if ((dtStartTime = m_oTimeRangeMgr.getStartDateTime(_site.getId(), 103)) != null) {
            sWhere = aFilter.getWhere();
            if (sWhere.length() > 0) {
                sWhere = sWhere + " and ";
            }
            sWhere = sWhere + "WCMChnlDoc.CrTime >= ?";
            aFilter.setWhere(sWhere);
            aFilter.addSearchValues(dtStartTime);
        }
        return aFilter;
    }

    public WCMFilter makeFilter(WebSites _sites, WCMFilter _extraFilter, boolean _bIncludeOrder, boolean _bFromRecycle) {
        if (_sites == null || _sites.isEmpty()) {
            return null;
        }
        if (_sites.size() == 1) {
            return this.makeFilter((WebSite)_sites.getAt(0), _extraFilter, _bIncludeOrder, _bFromRecycle);
        }
        if (this.isQueryInSpecifyTable(_extraFilter, null)) {
            return this.makeFilterWithJoin(_sites, _extraFilter, _bIncludeOrder, _bFromRecycle);
        }
        WCMFilter aFilter = new WCMFilter("WCMCHNLDOC", null, null);
        StringBuffer sbWhere = new StringBuffer(300 + _sites.size() * 2);
        sbWhere.append("exists(Select WCMChannel.ChannelId from WCMChannel where WCMChnlDoc.CHNLID=WCMChannel.ChannelId and Status>=0 and SiteId in(?");
        aFilter.addSearchValues(_sites.getIdAt(0));
        int nSize = _sites.size();
        for (int i = 1; i < nSize; ++i) {
            sbWhere.append(",?");
            aFilter.addSearchValues(_sites.getIdAt(i));
        }
        sbWhere.append("))");
        sbWhere.append(_bFromRecycle ? " and (WCMChnlDoc.DocChannel<0 or WCMChnlDoc.Modal<0)" : " and WCMChnlDoc.DocChannel>0");
        String sExtraWhere = null;
        if (_extraFilter != null && _extraFilter.getWhere() != null && (sExtraWhere = _extraFilter.getWhere().trim().toUpperCase()).length() == 0) {
            sExtraWhere = null;
        }
        if (sExtraWhere == null || sExtraWhere.indexOf("DOCSTATUS") < 0) {
            sbWhere.append(_bFromRecycle ? " and (WCMChnlDoc.Modal<0 and WCMChnlDoc.DOCSTATUS<0)" : " and (WCMChnlDoc.Modal>0 and WCMChnlDoc.DOCSTATUS>0)");
        }
        aFilter.setWhere(sbWhere.toString());
        String sOrder = _bIncludeOrder ? "WCMChnlDoc.CrTime Desc" : "";
        aFilter.setOrder(sOrder);
        aFilter.mergeWith(_extraFilter);
        return aFilter;
    }

    private WCMFilter makeFilterWithJoin(WebSites _sites, WCMFilter _extraFilter, boolean _bIncludeOrder, boolean _bFromRecycle) {
        WCMFilter aFilter = new WCMFilter("WCMCHNLDOC," + this.m_sTableName, null, null);
        StringBuffer sbWhere = new StringBuffer(300 + _sites.size() * 2);
        sbWhere.append("exists(Select WCMChannel.ChannelId from WCMChannel where WCMChnlDoc.CHNLID=WCMChannel.ChannelId and SiteId in(?");
        aFilter.addSearchValues(_sites.getIdAt(0));
        int nSize = _sites.size();
        for (int i = 1; i < nSize; ++i) {
            sbWhere.append(",?");
            aFilter.addSearchValues(_sites.getIdAt(i));
        }
        sbWhere.append(")) and WCMChnlDoc.DocId=" + this.m_sTableName + "." + this.m_sIdFieldName);
        String sExtraWhere = null;
        if (_extraFilter != null && _extraFilter.getWhere() != null && (sExtraWhere = _extraFilter.getWhere().trim().toUpperCase()).length() == 0) {
            sExtraWhere = null;
        }
        if (sExtraWhere == null || sExtraWhere.indexOf("DOCSTATUS") < 0) {
            sbWhere.append(_bFromRecycle ? " and (WCMChnlDoc.DOCSTATUS<0 or WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : " and WCMChnlDoc.DOCSTATUS>0 and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        } else {
            sbWhere.append(_bFromRecycle ? " and (WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : " and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        }
        aFilter.setWhere(sbWhere.toString());
        String sOrder = _bIncludeOrder ? "WCMChnlDoc.CrTime Desc" : "";
        aFilter.setOrder(sOrder);
        aFilter.mergeWith(_extraFilter);
        return aFilter;
    }

    public WCMFilter makeChannelFilter(Channels _channels, WCMFilter _filter, boolean _bFromRecycle) throws WCMException {
        if (_channels.isEmpty()) {
            return null;
        }
        if (_channels.size() == 1) {
            return this.makeChannelFilter((Channel)_channels.getAt(0), _filter, true, _bFromRecycle);
        }
        if (this.isQueryInSpecifyTable(_filter, null)) {
            return this.makeChannelFilterWithJoin(_channels, _filter, _bFromRecycle);
        }
        WCMFilter filter = new WCMFilter("", "", "WCMChnlDoc.CrTime Desc");
        StringBuffer sbWhereOnlySelf = new StringBuffer(_channels.size() * 10 + 16);
        StringBuffer sbWhereNotLimit = new StringBuffer(_channels.size() * 2 + 16);
        StringBuffer sbWhereOnlyDocLevel = new StringBuffer(_channels.size() * 2 + 16);
        this.makeChnlIdWhere(_channels, filter, sbWhereOnlySelf, sbWhereNotLimit, sbWhereOnlyDocLevel);
        String DEFAULT_WHERE = _bFromRecycle ? "(WCMChnlDoc.DocStatus<0 or WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : "WCMChnlDoc.DocChannel>0 and WCMChnlDoc.DocStatus>0 and WCMChnlDoc.Modal>0";
        StringBuffer sbWhere = new StringBuffer(_channels.size() * 2 + DEFAULT_WHERE.length() + 16);
        if (sbWhereNotLimit.length() > 0) {
            sbWhere.append("(");
            sbWhere.append(sbWhereNotLimit);
            sbWhere.append(")");
        }
        if (sbWhereOnlySelf.length() > 0) {
            if (sbWhere.length() > 0) {
                sbWhere.append(" or ");
            }
            sbWhere.append("(");
            sbWhere.append(sbWhereOnlySelf);
            sbWhere.append(")");
        }
        if (sbWhereOnlyDocLevel.length() > 0) {
            if (sbWhere.length() > 0) {
                sbWhere.append(" or ");
            }
            sbWhere.append("(");
            sbWhere.append(sbWhereOnlyDocLevel);
            sbWhere.append(")");
        }
        sbWhere.insert(0, '(').insert(sbWhere.length(), ')');
        sbWhere.append(" and ");
        sbWhere.append(DEFAULT_WHERE);
        filter.setWhere(sbWhere.toString());
        filter.mergeWith(_filter);
        filter.mergeWith(this.makeDeptFilter(_channels));
        return filter;
    }

    private void makeChnlIdWhere(Channels _channels, WCMFilter _filter, StringBuffer _sbWhereOnlySelf, StringBuffer _sbWhereNotLimit, StringBuffer _sbWhereOnlyDocLevel) throws WCMException {
        int i;
        int nSize = _channels.size();
        if (nSize >= 1000) {
            this.makeChnlIdWhereWithOr(_channels, _filter, _sbWhereOnlySelf, _sbWhereNotLimit, _sbWhereOnlyDocLevel);
            return;
        }
        int[] pNotLimitChannelIds = new int[nSize];
        int[] pLimitChannelIds = new int[nSize];
        int[] pUseDocLevelChannelIds = new int[nSize];
        int nNotLimitCount = 0;
        int nLimitCount = 0;
        int nUseDocLevelCount = 0;
        boolean bAdministrator = this.m_oLoginUser.isAdministrator();
        for (i = 0; i < nSize; ++i) {
            Channel channel = (Channel)_channels.getAt(i);
            if (this.m_bNeedWithAuthFilter) {
                if (!AuthServer.hasRight(this.m_oLoginUser, (CMSObj)channel, this.m_nRightIndex)) {
                    if (_sbWhereOnlySelf.length() > 0) {
                        _sbWhereOnlySelf.append(",");
                    } else {
                        _sbWhereOnlySelf.append("WCMChnlDoc.ChnlId in(");
                    }
                    _sbWhereOnlySelf.append("?");
                    pLimitChannelIds[nLimitCount++] = channel.getId();
                    continue;
                }
                if (bAdministrator || channel.getCrUserName().equalsIgnoreCase(this.m_oLoginUser.getName()) || !channel.isUseDocLevel()) {
                    if (_sbWhereNotLimit.length() > 0) {
                        _sbWhereNotLimit.append(",");
                    } else {
                        _sbWhereNotLimit.append("WCMChnlDoc.ChnlId in(");
                    }
                    _sbWhereNotLimit.append("?");
                    pNotLimitChannelIds[nNotLimitCount++] = channel.getId();
                    continue;
                }
                if (_sbWhereOnlyDocLevel.length() > 0) {
                    _sbWhereOnlyDocLevel.append(",");
                } else {
                    _sbWhereOnlyDocLevel.append("WCMChnlDoc.ChnlId in(");
                }
                _sbWhereOnlyDocLevel.append("?");
                pUseDocLevelChannelIds[nUseDocLevelCount++] = channel.getId();
                continue;
            }
            if (_sbWhereNotLimit.length() > 0) {
                _sbWhereNotLimit.append(",");
            } else {
                _sbWhereNotLimit.append("WCMChnlDoc.ChnlId in(");
            }
            _sbWhereNotLimit.append("?");
            pNotLimitChannelIds[nNotLimitCount++] = channel.getId();
        }
        for (i = 0; i < nSize && pNotLimitChannelIds[i] > 0; ++i) {
            _filter.addSearchValues(pNotLimitChannelIds[i]);
        }
        for (i = 0; i < nSize && pLimitChannelIds[i] > 0; ++i) {
            _filter.addSearchValues(pLimitChannelIds[i]);
        }
        if (_sbWhereOnlySelf.length() > 0) {
            _sbWhereOnlySelf.append(") and WCMChnlDoc.CrUser=?");
            _filter.addSearchValues(this.m_oLoginUser.getName());
        }
        if (_sbWhereNotLimit.length() > 0) {
            _sbWhereNotLimit.append(")");
        }
        for (i = 0; i < nSize && pUseDocLevelChannelIds[i] > 0; ++i) {
            _filter.addSearchValues(pUseDocLevelChannelIds[i]);
        }
        if (_sbWhereOnlyDocLevel.length() > 0) {
            _sbWhereOnlyDocLevel.append(")");
            this.makeDocLevelWhere(_filter, _sbWhereOnlyDocLevel);
        }
    }

    private void makeChnlIdWhereWithOr(Channels _channels, WCMFilter _filter, StringBuffer _sbWhereOnlySelf, StringBuffer _sbWhereNotLimit, StringBuffer _sbWhereOnlyDocLevel) throws WCMException {
        this.makeChnlIdWhereWithOr2(_channels, _filter, _sbWhereOnlySelf, _sbWhereNotLimit, _sbWhereOnlyDocLevel);
    }

    private void makeChnlIdWhereWithOr2(Channels _channels, WCMFilter _filter, StringBuffer _sbWhereOnlySelf, StringBuffer _sbWhereNotLimit, StringBuffer _sbWhereOnlyDocLevel) throws WCMException {
        int nSize = _channels.size();
        int[] pNotLimitChannelIds = new int[nSize];
        int[] pLimitChannelIds = new int[nSize];
        int[] pUseDocLevelChannelIds = new int[nSize];
        int nNotLimitCount = 0;
        int nLimitCount = 0;
        int nUseDocLevelCount = 0;
        Channel channel = null;
        boolean bAdministrator = this.m_oLoginUser.isAdministrator();
        for (int i = 0; i < nSize; ++i) {
            channel = (Channel)_channels.getAt(i);
            if (this.m_bNeedWithAuthFilter) {
                if (!AuthServer.hasRight(this.m_oLoginUser, (CMSObj)channel, this.m_nRightIndex)) {
                    pLimitChannelIds[nLimitCount++] = channel.getId();
                    continue;
                }
                if (bAdministrator || channel.getCrUserName().equalsIgnoreCase(this.m_oLoginUser.getName()) || !channel.isUseDocLevel()) {
                    pNotLimitChannelIds[nNotLimitCount++] = channel.getId();
                    continue;
                }
                pUseDocLevelChannelIds[nUseDocLevelCount++] = channel.getId();
                continue;
            }
            pNotLimitChannelIds[nNotLimitCount++] = channel.getId();
        }
        if (nLimitCount > 0) {
            int[] pLimited = new int[nLimitCount];
            System.arraycopy(pLimitChannelIds, 0, pLimited, 0, nLimitCount);
            pLimitChannelIds = null;
            this.appendParams(pLimited, _filter, _sbWhereOnlySelf);
        }
        if (nNotLimitCount > 0) {
            int[] pNotLimited = new int[nNotLimitCount];
            System.arraycopy(pNotLimitChannelIds, 0, pNotLimited, 0, nNotLimitCount);
            pNotLimitChannelIds = null;
            this.appendParams(pNotLimited, _filter, _sbWhereNotLimit);
        }
        if (nUseDocLevelCount > 0) {
            int[] pUseDocLevel = new int[nUseDocLevelCount];
            System.arraycopy(pUseDocLevelChannelIds, 0, pUseDocLevel, 0, nUseDocLevelCount);
            pUseDocLevelChannelIds = null;
            this.appendParams(pUseDocLevel, _filter, _sbWhereOnlyDocLevel);
        }
        if (_sbWhereOnlySelf.length() > 0) {
            _sbWhereOnlySelf.insert(0, '(');
            _sbWhereOnlySelf.append(") and WCMChnlDoc.CrUser=?");
            _filter.addSearchValues(ContextHelper.getLoginUser().getName());
        }
        if (_sbWhereNotLimit.length() > 0) {
            _sbWhereNotLimit.insert(0, '(');
            _sbWhereNotLimit.append(")");
        }
        if (_sbWhereOnlyDocLevel.length() > 0) {
            _sbWhereOnlyDocLevel.insert(0, '(');
            this.makeDocLevelWhere(_filter, _sbWhereOnlyDocLevel);
            _sbWhereOnlyDocLevel.append(")");
        }
    }

    private void appendParams(int[] ids, WCMFilter _filter, StringBuffer where) {
        Arrays.sort(ids);
        StringBuffer buff = new StringBuffer(768);
        int len = ids.length;
        for (int i = 0; i < len; ++i) {
            int current;
            int left = current = ids[i];
            while (i < len - 1 && ids[i + 1] == current + 1) {
                current = ids[++i];
            }
            if (left == current) {
                buff.append(" or WCMChnlDoc.ChnlId=?");
                _filter.addSearchValues(left);
                continue;
            }
            buff.append(" or WCMChnlDoc.ChnlId>=?");
            buff.append(" and WCMChnlDoc.ChnlId<=?");
            _filter.addSearchValues(left);
            _filter.addSearchValues(current);
        }
        where.append(buff.substring(4));
    }

    private WCMFilter makeChannelFilterWithJoin(Channels _channels, WCMFilter _filter, boolean _bFromRecycle) throws WCMException {
        String DEFAULT_WHERE = (_bFromRecycle ? " (WCMChnlDoc.DocStatus<0 or WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : " WCMChnlDoc.DocStatus>0 and WCMChnlDoc.DocChannel>0 and WCMChnlDoc.Modal>0") + " and WCMChnlDoc.DocId=" + this.m_sTableName + "." + this.m_sIdFieldName;
        WCMFilter filter = new WCMFilter("WCMChnlDoc," + this.m_sTableName, null, null);
        StringBuffer sbWhereOnlySelf = new StringBuffer(_channels.size() * 10 + 16);
        StringBuffer sbWhereNotLimit = new StringBuffer(_channels.size() * 2 + 16);
        StringBuffer sbWhereOnlyDocLevel = new StringBuffer(_channels.size() * 2 + 16);
        this.makeChnlIdWhere(_channels, filter, sbWhereOnlySelf, sbWhereNotLimit, sbWhereOnlyDocLevel);
        StringBuffer sbWhere = new StringBuffer(_channels.size() * 2 + DEFAULT_WHERE.length() + 16);
        if (sbWhereNotLimit.length() > 0) {
            sbWhere.append("(");
            sbWhere.append(sbWhereNotLimit);
            sbWhere.append(")");
        }
        if (sbWhereOnlySelf.length() > 0) {
            if (sbWhere.length() > 0) {
                sbWhere.append(" or ");
            }
            sbWhere.append("(");
            sbWhere.append(sbWhereOnlySelf);
            sbWhere.append(")");
        }
        if (sbWhereOnlyDocLevel.length() > 0) {
            if (sbWhere.length() > 0) {
                sbWhere.append(" or ");
            }
            sbWhere.append("(");
            sbWhere.append(sbWhereOnlyDocLevel);
            sbWhere.append(")");
        }
        if (sbWhere.length() > 0) {
            sbWhere.insert(0, '(').append(")").append(" and ");
        }
        sbWhere.append(DEFAULT_WHERE);
        filter.setWhere(sbWhere.toString());
        filter.mergeWith(_filter);
        return filter;
    }

    private boolean isQueryInSpecifyTable(WCMFilter _filter, Channel _channel) {
        if (_filter != null) {
            if (_filter.getWhere() != null && _filter.getWhere().matches(this.m_sRegContainsDataTable)) {
                return true;
            }
            if (_filter.getOrder() != null && _filter.getOrder().matches(this.m_sRegContainsDataTable)) {
                return true;
            }
            if (_filter.getSelect() != null && _filter.getSelect().matches(this.m_sRegContainsDataTable)) {
                return true;
            }
        }
        if (_channel == null) {
            return false;
        }
        String sQuery = _channel.getQuery();
        if (sQuery != null && sQuery.matches(this.m_sRegContainsDataTable)) {
            return true;
        }
        String sOrder = _channel.getOrderBy();
        return sOrder != null && sOrder.matches(this.m_sRegContainsDataTable);
    }

    public static void main(String[] args) {
        String[] pPath = new String[]{"D:\\YHIntranet\\webapps\\wcm\\wcm_use\\", "D:\\YHIntranet\\webapps\\wcm\\test\\", "D:\\YHIntranet\\webapps\\wcm\\temp\\"};
        for (int i = 0; i < pPath.length; ++i) {
            System.out.println("\u76ee\u5f55:" + pPath[i] + "<BR>");
            FileService file = new FileService(pPath[i]);
            FileStore[] pFiles = file.listFiles();
            for (int j = 0; j < pFiles.length; ++j) {
                if (pFiles[j].getName().indexOf("jsp") > 0) {
                    System.out.println("\u6587\u4ef6:" + pFiles[j].getName());
                }
                if (!pFiles[j].isDirectory()) continue;
                System.out.println("\u76ee\u5f55:" + pFiles[j].getName());
            }
        }
        try {
            DebugTimer timer = new DebugTimer();
            Documents newDocuments = null;
            WCMFilter filter = new WCMFilter();
            filter.setMaxRowNumber(1);
            WCMFilter chnlFilter = new WCMFilter("", "", "ChannelId");
            Channels channels = Channels.openWCMObjs(null, chnlFilter);
            int nSize = channels.size();
            for (int i = 0; i < nSize; ++i) {
                Channel channel = (Channel)channels.getAt(i);
                if (channel == null) continue;
                timer.start();
                try {
                    newDocuments = DocumentsGetHelper.getDocuments(channel, filter);
                }
                catch (Throwable ex) {
                    logger.error((Object)("[" + channel + "]\u51fa\u73b0\u5f02\u5e38!"), ex);
                }
                timer.stop();
                if (timer.getTime() > 2000L && newDocuments != null) {
                    logger.info((Object)("Long!!! get [" + channel + "] documents use[" + timer.getTime() + "]ms [" + newDocuments.size() + "] SQL:" + newDocuments.getFilter().toSQL()));
                }
                if (newDocuments == null) continue;
                newDocuments.clear();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"\u6d4b\u8bd5\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)ex);
        }
    }

    public void setNeedWithAuthFilter(User _loginUser, boolean _bNeedWithAuthFilter) {
        this.m_oLoginUser = _loginUser;
        this.m_bNeedWithAuthFilter = _bNeedWithAuthFilter;
    }

    private WCMFilter makeDeptFilter(Channel oChannel) throws WCMException {
        Channels oChannels = Channels.createNewInstance(this.m_oLoginUser);
        oChannels.addElement(oChannel);
        return this.makeDeptFilter(oChannels);
    }

    private WCMFilter makeDeptFilter(Channels oChannels) throws WCMException {
        if (this.m_oLoginUser.isAdministrator()) {
            return null;
        }
        boolean bWithDeptFilter = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("WITH_DEPT_FILTER", "false"));
        if (DBManager.getDBManager().getFieldInfo("WCMCHNLDOC", "CRDEPT") == null) {
            bWithDeptFilter = false;
        }
        if (!bWithDeptFilter) {
            return null;
        }
        IDepartmentMgr departmentMgr = (IDepartmentMgr)DreamFactory.createObjectById("IDepartmentMgr");
        String sLoginUserDeptInfo = departmentMgr.getDepartmentInfo(this.m_oLoginUser);
        boolean bIsDepartmentAdmin = departmentMgr.isDepartmentAdmin(this.m_oLoginUser);
        String sQueryDeptDocuments = null;
        boolean bLoginUserNoDeptInfo = CMyString.isEmpty(sLoginUserDeptInfo);
        if (!bLoginUserNoDeptInfo) {
            String sQueryCurrDeptDocuments = "WCMChnlDoc.CrDept = ?";
            sQueryDeptDocuments = bIsDepartmentAdmin ? "(" + sQueryCurrDeptDocuments + " or WCMChnlDoc.CrDept like ?)" : sQueryCurrDeptDocuments;
        } else {
            sQueryDeptDocuments = "WCMCHNLDOC.CRUSER=?";
        }
        WCMFilter filter = new WCMFilter();
        StringBuffer sbWhere = new StringBuffer();
        int nSize = oChannels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel oChannel = (Channel)oChannels.getAt(i);
            if (oChannel == null || !oChannel.isDoDeptFilter()) continue;
            if (sbWhere.length() > 0) {
                sbWhere.append(" or ");
            }
            sbWhere.append("(WCMChnlDoc.docChannel=?");
            filter.addSearchValues(oChannel.getId());
            sbWhere.append(" and ");
            sbWhere.append(sQueryDeptDocuments);
            if (!bLoginUserNoDeptInfo) {
                filter.addSearchValues(sLoginUserDeptInfo);
                if (bIsDepartmentAdmin) {
                    filter.addSearchValues(sLoginUserDeptInfo + "%");
                }
            } else {
                filter.addSearchValues(this.m_oLoginUser.getName());
            }
            sbWhere.append(")");
        }
        filter.setWhere(sbWhere.toString());
        return filter;
    }

    private void makeDocLevelWhere(WCMFilter _filter, StringBuffer _sbWhere) throws WCMException {
        DocLevel docLevel = this.m_oLoginUser.getDocLevel();
        int nDocLevelId = docLevel.getId();
        DocLevelMgr docLevelMgr = new DocLevelMgr();
        DocLevels docLevels = docLevelMgr.queryLowerDocLevels(this.m_oLoginUser, docLevel);
        _sbWhere.append(" and (");
        if (docLevels.isEmpty()) {
            _sbWhere.append("WCMChnlDoc.DOCLEVEL=?");
            _filter.addSearchValues(nDocLevelId);
        } else {
            _sbWhere.append("WCMChnlDoc.DOCLEVEL in(");
            int nSize = docLevels.size();
            for (int i = 0; i < nSize; ++i) {
                DocLevel currLevel = (DocLevel)docLevels.getAt(i);
                if (currLevel == null) continue;
                _sbWhere.append(" ?,");
                _filter.addSearchValues(currLevel.getId());
            }
            _sbWhere.append(" ?)");
            _filter.addSearchValues(nDocLevelId);
        }
        _sbWhere.append(" or WCMChnlDoc.DOCLEVEL is null");
        _sbWhere.append(" or WCMChnlDoc.DOCLEVEL=0");
        _sbWhere.append(" or WCMChnlDoc.CrUser=?");
        _filter.addSearchValues(this.m_oLoginUser.getName());
        _sbWhere.append(")");
    }
}

