/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.components.wcm.content.domain.AutoDocBakMgr;
import com.trs.components.wcm.content.persistent.AutoBakConfig;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;

public class ChnlDocLCListenerForAutoDocBak
implements IObjectLCListenerOnModify {
    private AutoDocBakMgr m_oAutoDocBakMgr = (AutoDocBakMgr)DreamFactory.createObjectById("AutoDocBakMgr");

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        ChnlDoc chnlDoc;
        if (this.isListening(_oObjModified) && this.needAutoBak(chnlDoc = (ChnlDoc)_oObjModified)) {
            this.m_oAutoDocBakMgr.autoBakDocument(chnlDoc.getDocument(), 20);
        }
    }

    private boolean isListening(BaseObj _oObjModified) {
        if (_oObjModified == null || _oObjModified.getWCMType() != 614) {
            return false;
        }
        ChnlDoc chnldoc = (ChnlDoc)_oObjModified;
        return chnldoc.isChangeProperty("DOCSTATUS") && chnldoc.getModal() == 1;
    }

    private boolean needAutoBak(ChnlDoc _chnldoc) throws WCMException {
        String statusId = _chnldoc.getNewPropertyAsString("DOCSTATUS");
        AutoBakConfig config = this.m_oAutoDocBakMgr.getAutoSaveConfig(_chnldoc.getChannel().getSite());
        if (config == null) {
            return false;
        }
        String autoSaveIds = config.getCanSavedDocStatusIds();
        return autoSaveIds.indexOf(statusId) != -1;
    }
}

