/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.LockerMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.domain.ReplaceMgr;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.IChildrenMgr;
import com.trs.components.wcm.content.persistent.Replace;
import com.trs.components.wcm.content.persistent.Replaces;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ChannelMgr {
    private static Logger m_oLogger = Logger.getLogger(ChannelMgr.class);
    public static final int ORDER_TYPE_BEFORE = 1;
    public static final int ORDER_TYPE_AFTER = -1;

    public Channel getChannelByName(int _nSiteId, String _sChnlName) {
        return Channel.findByName(_nSiteId, _sChnlName);
    }

    public WebSite getSiteByName(String _sSiteName, WCMFilter _filter) throws WCMException {
        WCMFilter aFilter = new WCMFilter("", "SiteName=?", "SITEORDER desc");
        aFilter.addSearchValues(_sSiteName);
        aFilter.mergeWith(_filter);
        WebSites objs = WebSites.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
        int nSize = objs.size();
        for (int i = 0; i < nSize; ++i) {
            WebSite obj = (WebSite)objs.getAt(i);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public Channel getChannelByPath(String _sPath) throws WCMException {
        if (CMyString.isEmpty(_sPath)) {
            return null;
        }
        String[] paths = _sPath.replace('\\', '/').split("/");
        int nIndex = 0;
        String sSiteName = null;
        for (nIndex = 0; nIndex < paths.length; ++nIndex) {
            if (CMyString.isEmpty(paths[nIndex])) continue;
            sSiteName = paths[nIndex];
            break;
        }
        if (CMyString.isEmpty(sSiteName)) {
            return null;
        }
        WebSite site = this.getSiteByName(sSiteName, null);
        if (site == null) {
            if (m_oLogger.isDebugEnabled()) {
                m_oLogger.debug((Object)("\u6307\u5b9a\u7684\u7ad9\u70b9[" + sSiteName + "]\u6ca1\u6709\u627e\u5230!"));
            }
            return null;
        }
        String sChnlName = null;
        for (int i = paths.length - 1; i > nIndex; --i) {
            if (CMyString.isEmpty(paths[nIndex])) continue;
            sChnlName = paths[i];
            break;
        }
        if (CMyString.isEmpty(sChnlName)) {
            return null;
        }
        return this.getChannelByName(site.getId(), sChnlName);
    }

    public Channels getChannels(int _nSiteId, int _nChannelType, boolean _bIncludingDeletedChannel) throws WCMException {
        String sWhere;
        String string = sWhere = _nChannelType == -1 ? "" : "ChnlType=" + _nChannelType;
        if (!_bIncludingDeletedChannel) {
            if (sWhere.length() != 0) {
                sWhere = sWhere + " and ";
            }
            sWhere = sWhere + "Status=0";
        }
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        return this.getChannels(_nSiteId, aFilter);
    }

    public Channels getChannels(int _nSiteId, WCMFilter _filter) throws WCMException {
        WCMFilter aFilter = new WCMFilter("", "SiteId=" + _nSiteId, "CHNLORDER desc");
        aFilter.mergeWith(_filter);
        return Channels.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public Channels getRecycleChannels(BaseChannel _oChannel, WCMFilter _chnlFilter) throws WCMException {
        if (_oChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label1", "\u65e0\u6548\u7684\u7ad9\u70b9\u6216\u680f\u76ee\u5bf9\u8c61,\u65e0\u6cd5\u53d6\u5f97\u5176\u5b50\u680f\u76ee."));
        }
        String sWhere = "Status=-1";
        if (_oChannel.isSite()) {
            sWhere = sWhere + " and SiteId=" + _oChannel.getId();
        } else {
            Channel currChannel = (Channel)_oChannel;
            sWhere = sWhere + " and ParentId=" + currChannel.getId() + " and SiteId=" + currChannel.getSiteId();
        }
        WCMFilter aFilter = new WCMFilter("", sWhere, "ChnlType desc,ChnlOrder desc");
        aFilter.mergeWith(_chnlFilter);
        return Channels.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public CMSBaseObjs getChildren(BaseChannel _oChannel, int _nChannelType, boolean _bIncludingDeletedChannel, WCMFilter _filter) throws WCMException {
        if (_oChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label2", "\u65e0\u6548\u7684\u7ad9\u70b9/\u7236\u680f\u76ee,\u65e0\u6cd5\u83b7\u53d6\u5b83\u7684\u5b50\u680f\u76ee!"));
        }
        String sWhere = "ParentId=" + (_oChannel.isSite() ? 0 : _oChannel.getId());
        if (_nChannelType != -1) {
            sWhere = sWhere + " and ChnlType=" + _nChannelType;
        }
        if (!_bIncludingDeletedChannel) {
            sWhere = sWhere + " and Status=0";
        }
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        aFilter.mergeWith(_filter);
        int nSiteId = _oChannel.isSite() ? _oChannel.getId() : ((Channel)_oChannel).getSiteId();
        return this.getChannels(nSiteId, aFilter);
    }

    public BaseChannel save(BaseChannel _oChannel) throws WCMException {
        this.prepareSaveBaseChannel(_oChannel);
        if (_oChannel.isAddMode()) {
            _oChannel.insert(ContextHelper.getLoginUser());
        } else {
            _oChannel = this.updateBaseChannel(_oChannel);
        }
        return _oChannel;
    }

    private BaseChannel prepareSaveChannel(Channel _currChannel) throws WCMException {
        if (_currChannel.getDesc() == null || _currChannel.getDesc().length() == 0) {
            _currChannel.setDesc(_currChannel.getName());
        }
        if (_currChannel.isAddMode() && _currChannel.getType() != 12) {
            return _currChannel;
        }
        if (!_currChannel.isAddMode() && _currChannel.getNewPropertyAsInt("CHNLTYPE", 0) != 12) {
            return _currChannel;
        }
        String sName = "";
        sName = _currChannel.isAddMode() ? _currChannel.getSureFormFileName() : _currChannel.getNewSureFormFileName();
        if (sName == null) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label3", "\u4e66\u751f\u8868\u5355\u680f\u76ee\u5fc5\u987b\u5148\u8bbe\u7f6e\u4e66\u751f\u6a21\u677f\u6587\u4ef6\u624d\u80fd\u7ee7\u7eed\u4fdd\u5b58\uff01"));
        }
        FilesMan filesman = FilesMan.getFilesMan();
        if (!filesman.fileExists(sName)) {
            throw new WCMException(50, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label4", "\u4e66\u751f\u8868\u5355\u6587\u4ef6\uff08") + sName + I18NMessage.get(ChannelMgr.class, "ChannelMgr.label5", "\uff09\u5728\u670d\u52a1\u5668\u4e0a\u65e0\u6cd5\u627e\u5230\uff0c\u8bf7\u5148\u4e0a\u4f20\u5230\u670d\u52a1\u5668\u4e0a\u518d\u4fdd\u5b58\uff01"));
        }
        if (!CMyFile.extractFileExt(sName).toUpperCase().equals("SEF")) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label6", "\u76ee\u524d\u53ea\u63a5\u6536sef\u683c\u5f0f\u7684\u4e66\u751f\u8868\u5355\u6587\u4ef6\uff0c\u60a8\u63d0\u4ea4\u7684\u6587\u4ef6\uff08") + sName + I18NMessage.get(ChannelMgr.class, "ChannelMgr.label7", "\uff09\u683c\u5f0f\u65e0\u6548\uff01"));
        }
        if (filesman.getFileFlag(sName) == "U0") {
            sName = filesman.copyWCMFile(sName, "W0");
            _currChannel.setSureFormFile(sName);
        }
        if (filesman.getFileFlag(sName) != "W0") {
            m_oLogger.warn((Object)I18NMessage.get(ChannelMgr.class, "ChannelMgr.label8", "\u4e66\u751f\u8868\u5355\u6587\u4ef6\u4e0d\u5728WebPic\u76ee\u5f55\u4e0b\uff0c\u53ef\u80fd\u4f1a\u4ea7\u751f\u5f02\u5e38\uff01"));
        }
        return _currChannel;
    }

    private BaseChannel prepareSaveSite(WebSite _currSite) throws WCMException {
        if (!_currSite.isAddMode() && !_currSite.isChangeProperty("SITEORDER")) {
            return _currSite;
        }
        if (_currSite.isAddMode() && !_currSite.containsProperty("ParentId")) {
            _currSite.setParent(_currSite.getParentId());
        }
        return _currSite;
    }

    private BaseChannel prepareSaveBaseChannel(BaseChannel _currBaseChannel) throws WCMException {
        _currBaseChannel = _currBaseChannel.isSite() ? this.prepareSaveSite((WebSite)_currBaseChannel) : this.prepareSaveChannel((Channel)_currBaseChannel);
        return _currBaseChannel;
    }

    private BaseChannel updateBaseChannel(BaseChannel _currBaseChannel) throws WCMException {
        if (_currBaseChannel.isSite()) {
            _currBaseChannel.update(ContextHelper.getLoginUser());
        } else {
            Channel currChannel = (Channel)_currBaseChannel;
            currChannel.update(ContextHelper.getLoginUser());
        }
        return _currBaseChannel;
    }

    private void deleteChildren(BaseChannel _oChannel, boolean _bDrop) throws WCMException {
        List<Channel> childChannels = null;
        childChannels = _bDrop ? _oChannel.getAllChildren(this.getLoginUser()) : _oChannel.getChildren(this.getLoginUser());
        for (int i = 0; i < childChannels.size(); ++i) {
            Channel subChannel = childChannels.get(i);
            if (subChannel == null) continue;
            this.delete(subChannel, _bDrop, true);
        }
    }

    public BaseChannel getHost(BaseChannel _oChannel) throws WCMException {
        if (_oChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label9", "\u65e0\u6548\u7684\u680f\u76ee\u5bf9\u8c61,\u65e0\u6cd5\u53d6\u5f97\u7236\u680f\u76ee"));
        }
        if (_oChannel.isSite()) {
            return _oChannel;
        }
        int nParentId = ((Channel)_oChannel).getParentId();
        if (nParentId == 0) {
            return _oChannel.getSite();
        }
        return Channel.findById(nParentId);
    }

    public void restore(BaseChannel _oChannel) throws WCMException {
        this.restore(_oChannel, false);
    }

    public void restore(BaseChannel _oChannel, boolean _bSystemNotifyRestore) throws WCMException {
        if (_oChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label10", "\u65e0\u6548\u7684\u7ad9\u70b9/\u680f\u76ee\u5bf9\u8c61,\u65e0\u6cd5\u6062\u590d!"));
        }
        if (_oChannel.isDeleted()) {
            _oChannel.canEdit(this.getLoginUser());
            boolean bCanRestore = _oChannel.restore(_bSystemNotifyRestore);
            if (!bCanRestore) {
                _oChannel.cancelUpdate(this.getLoginUser());
                return;
            }
            this.restoreChildren(_oChannel);
            _oChannel.setOperUser(ContextHelper.getLoginUser());
            _oChannel.setOperTime();
            _oChannel.update(ContextHelper.getLoginUser());
        }
        if (_bSystemNotifyRestore || _oChannel.isSite()) {
            return;
        }
        BaseChannel parent = _oChannel.getHost();
        if (parent.isSite()) {
            return;
        }
        this.restore(parent, false);
    }

    private void restoreChildren(BaseChannel _oChannel) throws WCMException {
        List<Channel> childChannels = _oChannel.getAllChildren(this.getLoginUser());
        for (int i = 0; i < childChannels.size(); ++i) {
            Channel currChannel = childChannels.get(i);
            if (currChannel == null) continue;
            this.restore(currChannel, true);
        }
    }

    public void delete(BaseChannel _oChannel, boolean _bDrop) throws WCMException {
        this.delete(_oChannel, _bDrop, false);
    }

    private void delete(BaseChannel _oChannel, boolean _bDrop, boolean _bSystemNotifyDelete) throws WCMException {
        if (_oChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label11", "\u65e0\u6548\u7684\u7ad9\u70b9/\u680f\u76ee\u5bf9\u8c61,\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\u64cd\u4f5c!"));
        }
        User user = this.getLoginUser();
        if (!_oChannel.canEdit(user)) {
            throw new WCMException(1013, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label12", "\u5bf9\u8c61\u5df2\u88ab[") + _oChannel.getLockerUser() + I18NMessage.get(ChannelMgr.class, "ChannelMgr.label13", "\u9501\u5b9a,\u7528\u6237[") + user.getName() + I18NMessage.get(ChannelMgr.class, "ChannelMgr.label14", "]\u65e0\u6cd5\u5bf9\u9501\u5b9a\u5bf9\u8c61\u8fdb\u884c\u64cd\u4f5c!"));
        }
        if (!_bSystemNotifyDelete) {
            this.assertNoContentInFolderInEdit(user, _oChannel);
        }
        try {
            this.deleteChildren(_oChannel, _bDrop);
        }
        catch (WCMException ex) {
            m_oLogger.debug((Object)"Failed to delete children", (Throwable)ex);
            throw new WCMException(1100, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label15", "\u5220\u9664\u5b50\u680f\u76ee\u5931\u8d25!"), ex);
        }
        if (!_bDrop) {
            _oChannel.setDeleted(_bSystemNotifyDelete);
            _oChannel.setOperUser(user);
            _oChannel.setOperTime();
            _oChannel.update(user);
            return;
        }
        _oChannel.delete(user);
        if (!_oChannel.isSite()) {
            this.deleteReplaceAfterDropChnl(_oChannel);
        }
    }

    private void deleteReplaceAfterDropChnl(BaseChannel _oChannel) throws WCMException {
        ReplaceMgr m_oReplaceMgr = (ReplaceMgr)DreamFactory.createObjectById("ReplaceMgr");
        try {
            if (_oChannel.isSite()) {
                return;
            }
            Replaces replaces = m_oReplaceMgr.getReplaces((Channel)_oChannel, null);
            for (int i = 0; i < replaces.size(); ++i) {
                Replace replace = (Replace)replaces.getAt(i);
                m_oReplaceMgr.delete(replace);
            }
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label41", "\u5f7b\u5e95\u5220\u9664\u680f\u76ee\u540e\u6e05\u9664\u680f\u76ee\u7684\u66ff\u6362\u5185\u5bb9\u5931\u8d25."), ex);
        }
    }

    private void assertNoContentInFolderInEdit(User _user, BaseChannel _siteOrChnl) throws WCMException {
        LockerMgr manager = (LockerMgr)DreamFactory.createObjectById("LockerMgr");
        String sDocumentIds = manager.getLockedObjIds(605);
        if (sDocumentIds.length() == 0) {
            return;
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("DOCID");
        sqlBuffer.append(" IN (").append(sDocumentIds).append(") AND ");
        sqlBuffer.append("EXISTS (").append("SELECT ");
        sqlBuffer.append("CHANNELID").append(" FROM ");
        sqlBuffer.append("WCMCHANNEL").append(" WHERE ");
        sqlBuffer.append("WCMDOCUMENT").append(".DocChannel=");
        sqlBuffer.append("WCMCHANNEL").append('.');
        sqlBuffer.append("CHANNELID").append(" AND ");
        if (_siteOrChnl.isSite()) {
            sqlBuffer.append("SiteId=").append(_siteOrChnl.getId()).append(")");
        } else {
            sqlBuffer.append("(").append("CHANNELID").append("=");
            sqlBuffer.append(_siteOrChnl.getId()).append(" OR ParentId=");
            sqlBuffer.append(_siteOrChnl.getId()).append("))");
        }
        String select = "DOCID, DocTitle";
        WCMFilter aFilter = new WCMFilter("", sqlBuffer.toString(), "", select);
        Documents documents = Documents.openWCMObjs(_user, aFilter);
        if (documents.isEmpty()) {
            return;
        }
        sqlBuffer.setLength(0);
        if (_siteOrChnl.isSite()) {
            sqlBuffer.append(I18NMessage.get(ChannelMgr.class, "ChannelMgr.label16", "\u7ad9\u70b9\u4e0b\u7684"));
        } else {
            sqlBuffer.append(I18NMessage.get(ChannelMgr.class, "ChannelMgr.label17", "\u680f\u76ee\u4e0b\u7684"));
        }
        for (int i = 0; i < documents.size(); ++i) {
            Document document = (Document)documents.getAt(i);
            if (document == null) continue;
            sqlBuffer.append("\n[").append(document);
            sqlBuffer.append(I18NMessage.get(ChannelMgr.class, "ChannelMgr.label18", "]\u88ab[")).append(document.getLockerUser());
            sqlBuffer.append(I18NMessage.get(ChannelMgr.class, "ChannelMgr.label19", "]\u9501\u5b9a!"));
        }
        throw new WCMException(1100, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label20", "\u4e0d\u80fd\u5220\u9664!\u56e0\u4e3a:\n") + sqlBuffer);
    }

    private void moveToAsChild(Channel _fromBaseChannel, BaseChannel _toBaseChannel) throws WCMException {
        this.validateMoveToAsChild(_fromBaseChannel, _toBaseChannel);
        WebSite oldSite = _fromBaseChannel.getSite();
        if (!_fromBaseChannel.canEdit(ContextHelper.getLoginUser())) {
            throw new WCMException(1013, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label21", "\u680f\u76ee\u5bf9\u8c61[") + _fromBaseChannel.getName() + I18NMessage.get(ChannelMgr.class, "ChannelMgr.label22", "]\u5df2\u88ab\u7528\u6237[") + _fromBaseChannel.getLockerUserName() + I18NMessage.get(ChannelMgr.class, "ChannelMgr.label23", "]\u9501\u5b9a\uff0c\u6682\u65f6\u4e0d\u80fd\u79fb\u52a8\uff01"));
        }
        try {
            this.changeDataPathOnMoveAsChild(_fromBaseChannel, _toBaseChannel);
            ArrayList<Integer> listParameters = new ArrayList<Integer>(1);
            listParameters.add(_toBaseChannel.getKey());
            if (_toBaseChannel.isSite()) {
                _fromBaseChannel.setParent(0);
                _fromBaseChannel.setSite(_toBaseChannel.getId());
                String SQL_QUERY_LAST_ORDER = "select min(ChnlOrder) from WCMChannel where ParentId=0 and SiteId=?";
                _fromBaseChannel.setOrder(DBManager.getDBManager().sqlExecuteQuery("select min(ChnlOrder) from WCMChannel where ParentId=0 and SiteId=?", (List)listParameters, -1));
            } else {
                _fromBaseChannel.setParent(_toBaseChannel.getId());
                _fromBaseChannel.setSite(((Channel)_toBaseChannel).getSiteId());
                String SQL_QUERY_LAST_ORDER = "select min(ChnlOrder) from WCMChannel where ParentId=?";
                _fromBaseChannel.setOrder(DBManager.getDBManager().sqlExecuteQuery("select min(ChnlOrder) from WCMChannel where ParentId=?", (List)listParameters, -1));
            }
            this.save(_fromBaseChannel);
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label24", "\u79fb\u52a8\u680f\u76ee\u5931\u8d25\uff01") + ex.getMyMessage(), ex);
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label24", "\u79fb\u52a8\u680f\u76ee\u5931\u8d25\uff01"), ex);
        }
        if (oldSite.getId() != _fromBaseChannel.getSiteId()) {
            this.setChnlSite(_fromBaseChannel);
        }
    }

    private void validateMoveToAsChild(BaseChannel _fromBaseChannel, BaseChannel _toBaseChannel) throws WCMException {
        Channel channel;
        if (_fromBaseChannel.isSite()) {
            return;
        }
        if (_fromBaseChannel.getSite().getId() != _toBaseChannel.getSiteId() && (channel = Channel.findByName(_toBaseChannel.getSiteId(), _fromBaseChannel.getName())) != null) {
            throw new WCMException(10, _toBaseChannel + I18NMessage.get(ChannelMgr.class, "ChannelMgr.label25", "\u4e0b\u5df2\u5b58\u5728\u540d\u79f0\u4e3a[") + _fromBaseChannel.getName() + I18NMessage.get(ChannelMgr.class, "ChannelMgr.label26", "]\u7684\u680f\u76ee,\u680f\u76ee\u4e0d\u5141\u8bb8\u91cd\u540d!"));
        }
    }

    private void setChnlSite(Channel _currChannel) throws WCMException {
        if (_currChannel == null) {
            return;
        }
        int nNewSiteId = _currChannel.getSiteId();
        List<Channel> aChannels = _currChannel.getChildren(this.getLoginUser());
        Channel aChnl = null;
        if (aChannels == null || aChannels.isEmpty()) {
            return;
        }
        for (int i = 0; i < aChannels.size(); ++i) {
            aChnl = aChannels.get(i);
            if (aChnl != null) {
                try {
                    aChnl.canEdit(ContextHelper.getLoginUser());
                    aChnl.setSite(nNewSiteId);
                    this.save(aChnl);
                }
                catch (Exception ex) {
                    m_oLogger.debug((Object)(I18NMessage.get(ChannelMgr.class, "ChannelMgr.label27", "\u4fee\u6539\u680f\u76ee\u7ad9\u70b9\u5c5e\u6027\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u6709\u680f\u76ee\u3010") + aChnl.getId() + I18NMessage.get(ChannelMgr.class, "ChannelMgr.label28", "\u3011\u6ca1\u6709\u66f4\u65b0\uff1a") + ex.toString()));
                    throw new WCMException(1100, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label27", "\u4fee\u6539\u680f\u76ee\u7ad9\u70b9\u5c5e\u6027\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u6709\u680f\u76ee\u3010") + aChnl.getId() + I18NMessage.get(ChannelMgr.class, "ChannelMgr.label29", "\u3011\u6ca1\u6709\u66f4\u65b0"), ex);
                }
                this.setChnlSite(aChnl);
                continue;
            }
            m_oLogger.error((Object)I18NMessage.get(ChannelMgr.class, "ChannelMgr.label30", "\u4ece\u680f\u76ee\u96c6\u5408\u4e2d\u53d6\u51fa\u4e86\u4e00\u4e2a\u7a7a\u7684\u680f\u76ee\uff01setChnlSite"));
        }
    }

    public WebSites getWebSites(WCMFilter _filter, boolean _bIncludeDel) throws WCMException {
        WCMFilter aFilter = new WCMFilter("WCMWEBSITE", "", "SiteOrder", "SiteId");
        if (!_bIncludeDel) {
            aFilter.setWhere("Status=0");
        }
        aFilter.mergeWith(_filter);
        try {
            return WebSites.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
        }
        catch (WCMException ex) {
            m_oLogger.debug((Object)(I18NMessage.get(ChannelMgr.class, "ChannelMgr.label31", "\u83b7\u53d6\u7cfb\u7edf\u4e2d\u6240\u6709\u7684\u7ad9\u70b9\u5931\u8d25:") + ex.getStackTraceText()));
            throw new WCMException(1100, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label32", "\u83b7\u53d6\u7cfb\u7edf\u4e2d\u6240\u6709\u7684\u7ad9\u70b9\u5931\u8d25"), ex);
        }
    }

    public void moveTo(Channel _fromChannel, BaseChannel _toSiteOrChannel, int _nMoveToType) throws WCMException {
        if (_toSiteOrChannel.isSite()) {
            this.moveTo(_fromChannel, (WebSite)_toSiteOrChannel, _nMoveToType);
        } else {
            this.moveTo(_fromChannel, (Channel)_toSiteOrChannel, _nMoveToType);
        }
    }

    public void moveTo(Channel _fromChannel, WebSite _toWebSite, int _nMoveToType) throws WCMException {
        this.validateChnl2Site(_fromChannel, _toWebSite, _nMoveToType);
        if (_nMoveToType == 1) {
            this.moveToAsChild(_fromChannel, _toWebSite);
        }
    }

    private void validateChnl2Site(Channel _fromChannel, WebSite _toWebSite, int _nMoveToType) throws WCMException {
        if (_nMoveToType == 0) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label33", "\u76ee\u524d\u6682\u65f6\u4e0d\u652f\u6301\u5c06\u680f\u76ee\u79fb\u52a8\u6210\u4e3a\u7ad9\u70b9\uff01"));
        }
        if (_fromChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label34", "\u6b32\u79fb\u52a8\u7684\u680f\u76ee\u4e3a\u7a7a\uff01"));
        }
        if (_toWebSite == null) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label35", "\u76ee\u6807\u7ad9\u70b9\u4e3a\u7a7a\uff01"));
        }
    }

    public void moveTo(Channel _fromChannel, Channel _toChannel, int _nMoveToType) throws WCMException {
        this.validateChnl2Chnl(_fromChannel, _toChannel);
        if (_nMoveToType == 1) {
            this.moveToAsChild(_fromChannel, _toChannel);
        } else {
            this.moveToAsBrother(_fromChannel, _toChannel);
        }
    }

    private void validateChnl2Chnl(Channel _fromChannel, Channel _toChannel) throws WCMException {
        if (_fromChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label34", "\u6b32\u79fb\u52a8\u7684\u680f\u76ee\u4e3a\u7a7a\uff01"));
        }
        if (_toChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label36", "\u76ee\u6807\u680f\u76ee\u4e3a\u7a7a\uff01"));
        }
    }

    private void moveToAsBrother(Channel _fromBaseChannel, BaseChannel _toBaseChannel) throws WCMException {
        BaseChannel toParent = null;
        if (_toBaseChannel.getParentId() == 0) {
            if (_toBaseChannel.getSite() == null) {
                throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label37", "\u76ee\u6807\u7ad9\u70b9\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u79fb\u52a8\uff01"));
            }
            toParent = _toBaseChannel.getSite();
        } else {
            toParent = Channel.findById(_toBaseChannel.getParentId());
            if (toParent == null) {
                throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label38", "\u76ee\u6807\u680f\u76ee\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u79fb\u52a8\uff01"));
            }
        }
        this.moveToAsChild(_fromBaseChannel, toParent);
    }

    protected DBManager getDBManager() throws WCMException {
        DBManager currDBManager = DBManager.getDBManager();
        if (currDBManager == null || !currDBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label39", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!currDBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label40", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
        }
        return currDBManager;
    }

    public WebSites getRecycleSites(WCMFilter _filter) throws WCMException {
        User user = this.getLoginUser();
        WCMFilter aFilter = new WCMFilter("", "Status=-1", "");
        aFilter.mergeWith(_filter);
        return WebSites.openWCMObjs(user, aFilter);
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private void changeDataPathOnMoveAsChild(Channel _channel, BaseChannel _oNewParent) throws WCMException {
        IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_channel);
        WCMFolderPublishConfig config = new WCMFolderPublishConfig(folder);
        String sDataPath = config.getDataPath();
        if (CMyString.isEmpty(sDataPath)) {
            return;
        }
        String sNewDataPath = sDataPath;
        int k = 1;
        while (this.existsDataPath(_oNewParent, sNewDataPath)) {
            sNewDataPath = sDataPath + "_" + k;
            ++k;
        }
        if (sNewDataPath.equals(sDataPath)) {
            return;
        }
        config.setDataPath(sNewDataPath);
        User loginUser = ContextHelper.getLoginUser();
        config.canEdit(loginUser);
        config.save(loginUser);
    }

    private boolean existsDataPath(BaseChannel _oNewParent, String _sDataPath) throws WCMException {
        if (CMyString.isEmpty(_sDataPath)) {
            return false;
        }
        WCMFilter filter = new WCMFilter("WCMFOLDERPUBLISHCONFIG", "", "", "FolderId");
        String sWhere = _oNewParent.isSite() ? "DataPath=? and FolderType=? and exists(select WCMChannel.ChannelId from WCMChannel where WCMChannel.SiteId=? and WCMChannel.ParentId=0 and WCMFOLDERPUBLISHCONFIG.FolderId=WCMChannel.ChannelId)" : " DataPath=? and FolderType=? and exists(select WCMChannel.ChannelId from WCMChannel where WCMChannel.ParentId=? and WCMFOLDERPUBLISHCONFIG.FolderId=WCMChannel.ChannelId)";
        filter.setWhere(sWhere);
        filter.addSearchValues(_sDataPath);
        filter.addSearchValues(101);
        filter.addSearchValues(_oNewParent.getId());
        return DBManager.getDBManager().sqlExecuteIntQuery(filter) > 0;
    }

    public void changeOrder(Channel _oSrcChannel, Channel _oDstChannel, int _nOrderType) throws WCMException {
        int nDstOrder;
        if (_oSrcChannel.getSiteId() != _oDstChannel.getSiteId()) {
            throw new WCMException("Invalid parameter! siteid");
        }
        if (_oSrcChannel.getParentId() != _oDstChannel.getParentId()) {
            throw new WCMException("Invalid parameter! parentid");
        }
        User user = ContextHelper.getLoginUser();
        int nOldOrder = _oSrcChannel.getOrder();
        boolean bMoveToAfter = nOldOrder > (nDstOrder = _oDstChannel.getOrder());
        int nStartOrder = -1;
        int nEndOrder = -1;
        int nNewOrder = 0;
        switch (_nOrderType) {
            case 1: {
                nNewOrder = nDstOrder + 1;
                if (bMoveToAfter) {
                    nStartOrder = nOldOrder - 1;
                    nEndOrder = nDstOrder + 1;
                    break;
                }
                nStartOrder = nOldOrder + 1;
                nEndOrder = nDstOrder - 1;
                break;
            }
            case -1: {
                nNewOrder = nDstOrder;
                if (bMoveToAfter) {
                    nStartOrder = nOldOrder - 1;
                    nEndOrder = nDstOrder;
                    break;
                }
                nStartOrder = nOldOrder + 1;
                nEndOrder = nDstOrder;
                break;
            }
            default: {
                throw new WCMException("\u672a\u77e5\u7684\u6392\u5e8f\u65b9\u5f0f\uff01[Order=" + _nOrderType + "]");
            }
        }
        String sWhere = "ParentId=? and ChnlOrder>=? and ChnlOrder<=?";
        int[] pParameters = new int[]{_oSrcChannel.getParentId(), nStartOrder, nEndOrder};
        DBManager.getDBManager().sqlExecuteUpdate(pParameters, "update WCMChannel set ChnlOrder=ChnlOrder" + (bMoveToAfter ? (char)'+' : '-') + " 1 where " + sWhere);
        WCMFilter filter = new WCMFilter(null, sWhere, null);
        for (int nParameter : pParameters) {
            filter.addSearchValues(nParameter);
        }
        Channels channels = Channels.openWCMObjs(null, filter);
        for (int i = 0; i < channels.size(); ++i) {
            Channel child = (Channel)channels.getAt(i);
            if (child == null) continue;
            child.refreshProperty("ChnlOrder", child.getOrder() + (bMoveToAfter ? 1 : -1));
        }
        pParameters = new int[]{nNewOrder, _oSrcChannel.getId()};
        DBManager.getDBManager().sqlExecuteUpdate(pParameters, "update WCMChannel set ChnlOrder=? where ChannelId=?");
        _oSrcChannel.refreshProperty("ChnlOrder", nNewOrder);
        IChildrenMgr childrenMgr = (IChildrenMgr)DreamFactory.createObjectById("IChildrenMgr");
        childrenMgr.reloadChildren(_oSrcChannel.getHost());
    }

    public void setPosition(Channel _oSrcChannel, int _nPosition) throws WCMException {
    }
}

