/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.ajaxservice.ChannelServiceProviderHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.ExtendedField;
import com.trs.cms.content.ExtendedFields;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.template.TemplateParseMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfigs;
import com.trs.components.common.publish.persistent.template.TempApdRel;
import com.trs.components.common.publish.persistent.template.TempAppendix;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateArgument;
import com.trs.components.common.publish.persistent.template.TemplateEmploy;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.domain.IChannelImporterConverter;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ContentExtField;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.content.service.portervisitors.PorterUtil;
import com.trs.components.wcm.publish.WCMPubStatusConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.persistent.XmlToObjConverter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.Reports;
import com.trs.infra.util.WCMDiscoveryFactory;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ChannelImporter {
    private static final String PROPERTY_CRUSER = "CRUSER";
    private static final String PROPERTY_CRTIME = "CRTIME";
    private static final String FILEEXT_ZIP = "zip";
    private static final String FILEEXT_XML = "xml";
    private static final char CHAR_S = 'S';
    private static final String TAG_TEMPAPDS = "WCMTEMPAPPENDIXS";
    private static final String TAG_TEMPLATES = "WCMTEMPLATES";
    private static final String TAG_TEMPAPDRELS = "WCMTEMPAPDRELS";
    private static final String TAG_TEMPEMPLOYS = "WCMTEMPLATEEMPLOYS";
    private static final String TAG_FOLDERPUBCONFS = "WCMFOLDERPUBLISHCONFIGS";
    private static final String TAG_WCMPUBSTATUSCONFS = "WCMPUBSTATUSCONFIGS";
    private static final String TAG_CHILDCHANNELS = "WCMCHANNELS";
    private static final String TAG_CONTEXTFIELDS = "WCMCONTENTEXTFIELDS";
    private static final String TAG_EXTFIELDS = "WCMEXTFIELDS";
    private static final String TAG_TEMPLATEARGS = "WCMTEMPLATEARGUMENTS";
    private static Logger s_logger = Logger.getLogger(ChannelImporter.class);
    private int CHNL_IMPORT_DELAY_MILLIS = 500;
    private ChannelMgr m_channelMgr = null;
    private XmlToObjConverter m_converter = null;
    private Reports m_reports;
    private final Map m_siteOrChnlIds = new HashMap();
    private Map m_templateIds = null;
    private boolean m_bCheckDataPathNecessary = true;
    private String m_sNewSiteName = null;
    private String m_sNewSiteDesc = null;
    private Map m_hTemplateInChannelMap = new HashMap();
    private static List implementors = null;

    public String getNewSiteDesc() {
        return this.m_sNewSiteDesc;
    }

    public void setNewSiteDesc(String newSiteDesc) {
        this.m_sNewSiteDesc = newSiteDesc;
    }

    public ChannelImporter() {
        this.m_converter = new XmlToObjConverter(1);
        this.m_channelMgr = (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");
        this.registerConverter();
    }

    public Reports importFromFile(String _sFile, String _sXslFile, BaseChannel _destSiteOrChnl) throws WCMException {
        this.assertNotEmptyString(_sFile);
        String sExt = CMyFile.extractFileExt(_sFile);
        this.assertUnSupportFile(sExt);
        String sFullFile = this.getFullName(_sFile);
        if (_sXslFile != null) {
            _sXslFile = this.getFullName(_sXslFile);
        }
        this.m_reports = new Reports("");
        if (FILEEXT_XML.equalsIgnoreCase(sExt)) {
            return this.importFromXml(sFullFile, _sXslFile, _destSiteOrChnl);
        }
        return this.importFromZip(sFullFile, _sXslFile, _destSiteOrChnl);
    }

    private Reports importFromZip(String _sZip, String _sXslFile, BaseChannel _destSiteOrChnl) throws WCMException {
        String sUnZipPath = CMyFile.extractFilePath(_sZip) + "unzip" + System.currentTimeMillis();
        sUnZipPath = CMyString.setStrEndWith(sUnZipPath, File.separatorChar);
        CMyUnZipFile uzf = new CMyUnZipFile(_sZip, sUnZipPath);
        uzf.addFileExtFilters(FILEEXT_XML);
        try {
            uzf.doUnZipAnd();
        }
        catch (CMyException e) {
            s_logger.error((Object)"failed to unzip the file!", (Throwable)e);
            throw new WCMException(200, I18NMessage.get(ChannelImporter.class, "ChannelImporter.label1", "\u89e3\u538b\u7f29\u6587\u4ef6\u5931\u8d25!"), e);
        }
        ArrayList xmlFiles = uzf.getFilteredFiles();
        if (xmlFiles == null) {
            throw new WCMException(10, I18NMessage.get(ChannelImporter.class, "ChannelImporter.label2", "\u5bfc\u5165\u7684zip\u5305\u4e2d\u6ca1\u6709\u6709\u6548\u7684\u63cf\u8ff0\u7ad9\u70b9/\u680f\u76ee\u4fe1\u606f\u7684xml\u6587\u4ef6!"));
        }
        String xmlFile = null;
        for (int i = 0; i < xmlFiles.size(); ++i) {
            xmlFile = (String)xmlFiles.get(i);
            XmlObject[] xmlObjects = this.convertXmlFile(xmlFile, _sXslFile);
            this.importSitesOrChnls(xmlObjects, _destSiteOrChnl, sUnZipPath);
        }
        CMyFile.deleteDir(sUnZipPath);
        this.m_reports.setTitle(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label3", "\u4eceZip\u6587\u4ef6\u4e2d\u5bfc\u5165\u7ad9\u70b9/\u680f\u76ee"));
        return this.m_reports;
    }

    private void importSitesOrChnls(XmlObject[] _xmlObjects, BaseChannel _destSiteOrChnl, String _sUnZipPath) throws WCMException {
        String sDelayMillis = ConfigServer.getServer().getSysConfigValue("CHNL_IMPORT_DELAY_MILLIS", "500");
        this.CHNL_IMPORT_DELAY_MILLIS = Integer.parseInt(sDelayMillis);
        int[] resultIds = new int[_xmlObjects.length];
        for (int i = 0; i < _xmlObjects.length; ++i) {
            this.m_bCheckDataPathNecessary = true;
            BaseChannel result = this.importSiteOrChnlInfo(_xmlObjects[i], _destSiteOrChnl, _sUnZipPath);
            if (result == null) continue;
            resultIds[i] = result.getId();
        }
        this.m_reports.setResultIds(resultIds);
    }

    private BaseChannel importSiteOrChnlInfo(XmlObject _xmlObject, BaseChannel _destSiteOrChnl, String _sUnZipPath) throws WCMException {
        WebSite parentSite;
        int nDestSiteType;
        BaseObj currObj = _xmlObject.getCurrentObj();
        if (currObj == null || !(currObj instanceof BaseChannel)) {
            throw new WCMException(1100, I18NMessage.get(ChannelImporter.class, "ChannelImporter.label4", "\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u6b63\u786e,xml\u6587\u4ef6\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u7ad9\u70b9/\u680f\u76ee\u63cf\u8ff0\u6587\u4ef6!"));
        }
        currObj.getId();
        BaseChannel siteOrChnl = (BaseChannel)currObj;
        boolean bSite = siteOrChnl.isSite();
        if (this.isUnSupportImportMode(bSite, _destSiteOrChnl)) {
            String exMsg = bSite ? I18NMessage.get(ChannelImporter.class, "ChannelImporter.label5", "\u65e0\u6cd5\u5c06\u7ad9\u70b9\u5bfc\u5165\u5230\u7ad9\u70b9\u6216\u8005\u680f\u76ee\u5e95\u4e0b!") : I18NMessage.get(ChannelImporter.class, "ChannelImporter.label6", "\u65e0\u6cd5\u5c06\u680f\u76ee\u5bfc\u5165\u6210\u7ad9\u70b9,\u5fc5\u987b\u6307\u5b9a\u7236\u8282\u70b9(\u680f\u76ee/\u7ad9\u70b9)!");
            WCMException exception = new WCMException(10, exMsg);
            this.addFailedReports(siteOrChnl, exception);
            return null;
        }
        if (!bSite && this.isExcludeSiteType(nDestSiteType = (parentSite = _destSiteOrChnl.getSite()).getPropertyAsInt("SiteType", 0)) && !this.isNormChannel((Channel)siteOrChnl)) {
            String msg = I18NMessage.get(ChannelImporter.class, "ChannelImporter.label7", "\u975e\u6587\u5b57\u5e93\u7ad9\u70b9[") + parentSite.getName() + I18NMessage.get(ChannelImporter.class, "ChannelImporter.label8", "]\u4e0d\u652f\u6301[");
            msg = msg + ((Channel)siteOrChnl).getTypeDesc();
            msg = msg + I18NMessage.get(ChannelImporter.class, "ChannelImporter.label9", "]\u7c7b\u578b\u7684\u680f\u76ee\uff01");
            this.addFailedReports(siteOrChnl, new WCMDatainvalidException(msg));
            return null;
        }
        try {
            siteOrChnl.setNextId();
            this.changeNameIfNescessary(bSite, siteOrChnl, _destSiteOrChnl);
        }
        catch (Throwable t) {
            this.addFailedReports(siteOrChnl, t);
            return null;
        }
        if (!bSite) {
            try {
                ((Channel)siteOrChnl).setParent(_destSiteOrChnl);
                ((Channel)siteOrChnl).setSite(_destSiteOrChnl.getSite());
                ((Channel)siteOrChnl).setOrder(1);
            }
            catch (Throwable t) {
                this.addFailedReports(siteOrChnl, t);
                return null;
            }
        } else {
            ((WebSite)siteOrChnl).setOrder(1);
        }
        try {
            String sIdFieldName = bSite ? "SITEID" : "CHANNELID";
            String sOldSiteOrChnlId = siteOrChnl.getPropertyAsString(sIdFieldName);
            siteOrChnl.removeProperty(PROPERTY_CRTIME);
            siteOrChnl.removeProperty(PROPERTY_CRUSER);
            this.m_channelMgr.save(siteOrChnl);
            this.m_siteOrChnlIds.put(this.makeSiteOrChnlIdMapKey(sOldSiteOrChnlId, siteOrChnl.getWCMType()), new Integer(siteOrChnl.getId()));
            Thread.sleep(this.CHNL_IMPORT_DELAY_MILLIS);
            ChannelServiceProviderHelper.createRelatedEmployes(sOldSiteOrChnlId, siteOrChnl);
        }
        catch (Throwable t) {
            boolean bIgnore = t instanceof Error && t.getMessage().indexOf(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label10", "\u6ce8\u518c\u7801")) >= 0;
            this.addFailedReports(siteOrChnl, bIgnore ? new Error(t.getMessage()) : t);
            return null;
        }
        this.importFolderPubConfs(_xmlObject.getChild(TAG_FOLDERPUBCONFS), (IPublishFolder)PublishElementFactory.makeElementFrom(siteOrChnl));
        PorterUtil.doImports(siteOrChnl, _xmlObject, null);
        if (bSite && _sUnZipPath != null) {
            Map tempApdIds = this.importTempAppendixs(_xmlObject.getChild(TAG_TEMPAPDS), _sUnZipPath, siteOrChnl.getSiteId());
            this.m_templateIds = this.importTemplates(tempApdIds, _xmlObject.getChild(TAG_TEMPLATES), siteOrChnl.getId());
        }
        this.importTemplateArgs(siteOrChnl, _xmlObject.getChild(TAG_TEMPLATEARGS));
        try {
            BaseChannel forChildren = bSite ? siteOrChnl : siteOrChnl.getSite();
            this.importChildChannels(_xmlObject.getChild(TAG_CHILDCHANNELS), siteOrChnl, forChildren);
        }
        catch (Throwable t) {
            s_logger.debug((Object)I18NMessage.get(ChannelImporter.class, "ChannelImporter.label11", "\u5bfc\u5165\u5b50\u680f\u76ee\u5931\u8d25"), t);
            this.m_reports.addWarnedReport(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label12", "\u5bfc\u5165") + siteOrChnl + I18NMessage.get(ChannelImporter.class, "ChannelImporter.label13", "\u7684\u5b50\u680f\u76ee\u5931\u8d25!"), t);
        }
        this.importTempEmploys(_xmlObject.getChild(TAG_TEMPEMPLOYS), siteOrChnl.getId(), this.m_templateIds);
        this.importChildChannelsTempEmploys(_xmlObject.getChild(TAG_CHILDCHANNELS), this.m_templateIds);
        this.importPubStatusConfs(_xmlObject.getChild(TAG_WCMPUBSTATUSCONFS), siteOrChnl.getWCMType(), siteOrChnl.getId());
        this.importContExtFields(_xmlObject.getChild(TAG_CONTEXTFIELDS), siteOrChnl);
        this.m_reports.addSucessedReport(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label14", "\u6210\u529f\u5bfc\u5165[") + siteOrChnl + "].");
        return siteOrChnl;
    }

    private boolean isExcludeSiteType(int _nSiteType) {
        int[] excludeSiteType = new int[]{1, 2};
        for (int i = 0; i < excludeSiteType.length; ++i) {
            if (_nSiteType != excludeSiteType[i]) continue;
            return true;
        }
        return false;
    }

    private boolean isNormChannel(Channel channel) {
        return channel.getType() == 0;
    }

    private String makeSiteOrChnlIdMapKey(String _sSiteOrChnlOldId, int _nObjType) {
        return _nObjType + ":" + _sSiteOrChnlOldId;
    }

    private boolean isUnSupportImportMode(boolean _bSite, BaseChannel _destSiteOrChnl) {
        if (_bSite) {
            return _destSiteOrChnl != null;
        }
        return _destSiteOrChnl == null;
    }

    private Map importTempAppendixs(XmlObject[] _tempApds, String _sUnZipPath, int _nSiteId) {
        HashMap tempApdIds = new HashMap(_tempApds.length);
        String sDestPath = "";
        try {
            sDestPath = FilesMan.getFilesMan().getTemplateAppendixPath(103, _nSiteId, 0, true);
        }
        catch (Throwable t) {
            s_logger.debug((Object)"failed to get the template appendix directory!", t);
            this.m_reports.addWarnedReport(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label15", "\u83b7\u53d6\u6a21\u677f\u9644\u4ef6\u7684\u6587\u4ef6\u76ee\u5f55\u5931\u8d25\uff01"), t);
            return tempApdIds;
        }
        for (int i = 0; i < _tempApds.length; ++i) {
            this.importTempApdInfo(tempApdIds, _tempApds[i], _sUnZipPath, sDestPath, _nSiteId);
        }
        return tempApdIds;
    }

    private void importTempApdInfo(Map _tempApdIds, XmlObject _tempApd, String _sUnZipPath, String _sDestPath, int _nSiteId) {
        TempAppendix appendix = null;
        try {
            appendix = (TempAppendix)_tempApd.getCurrentObj();
            String sOldId = appendix.getPropertyAsString("TEMPAPPENDIXID");
            appendix.setRoot(103, _nSiteId);
            appendix.removeProperty(PROPERTY_CRTIME);
            appendix.setFlag(0);
            appendix.save(this.getLoginUser());
            _tempApdIds.put(sOldId, new Integer(appendix.getId()));
            String sSrcFile = _sUnZipPath + appendix.getFile();
            String sDestFile = _sDestPath + appendix.getFile();
            this.processApdFile(sSrcFile, sDestFile);
        }
        catch (Throwable t) {
            s_logger.debug((Object)I18NMessage.get(ChannelImporter.class, "ChannelImporter.label16", "\u5bfc\u5165\u6a21\u677f\u9644\u4ef6\u5931\u8d25"), t);
            this.m_reports.addWarnedReport(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label17", "\u5bfc\u5165\u6a21\u677f\u9644\u4ef6\u5931\u8d25:") + appendix, t);
        }
    }

    private void processApdFile(String _sSrcFile, String _sDestFile) {
        try {
            if (!CMyFile.fileExists(_sDestFile)) {
                if (!CMyFile.fileExists(_sSrcFile)) {
                    String sSrcFile = CMyFile.extractFileName(_sSrcFile);
                    s_logger.warn((Object)("missing template appendix file[" + sSrcFile + "]!"));
                    this.m_reports.addWarnedReport(CMyString.format(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label18", "\u7f3a\u5c11\u6a21\u677f\u9644\u4ef6[{0}]"), new String[]{sSrcFile}), null);
                    return;
                }
                CMyFile.copyFile(_sSrcFile, _sDestFile);
            }
        }
        catch (Throwable t) {
            s_logger.debug((Object)"failed to copy a template appendix file", t);
            this.m_reports.addWarnedReport(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label19", "\u62f7\u8d1d\u6a21\u677f\u9644\u4ef6\u5bf9\u5e94\u7684\u6587\u4ef6[") + _sSrcFile + I18NMessage.get(ChannelImporter.class, "ChannelImporter.label20", "]\u5931\u8d25"), t);
        }
    }

    private Map importTemplates(Map _tempApdIds, XmlObject[] _templates, int _nRootId) {
        HashMap templateIds = new HashMap(_templates.length);
        for (int i = 0; i < _templates.length; ++i) {
            this.importTemplateInfo(templateIds, _templates[i], _tempApdIds, _nRootId);
        }
        this.parseImportedTemplates(templateIds.values());
        return templateIds;
    }

    private void parseImportedTemplates(Collection _ids) {
        TemplateParseMgr manager = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
        Integer[] idArray = new Integer[_ids.size()];
        _ids.toArray(idArray);
        Template template = null;
        for (int i = 0; i < idArray.length; ++i) {
            int nId = idArray[i];
            try {
                template = Template.findById(nId);
            }
            catch (WCMException e) {
                continue;
            }
            if (template == null) continue;
            manager.notifyTemplateAdded(template);
        }
    }

    private void importTemplateInfo(Map _tempalteIds, XmlObject _template, Map _temApdIds, int _nRootId) {
        Template template = null;
        try {
            template = (Template)_template.getCurrentObj();
            int nFolderType = template.getFolderType();
            int nFolderId = template.getFolderId();
            String sFolderId = String.valueOf(nFolderId);
            Integer iNewFolderId = (Integer)this.m_siteOrChnlIds.get(this.makeSiteOrChnlIdMapKey(sFolderId, nFolderType));
            String sOldTempId = template.getPropertyAsString("TEMPID");
            if (iNewFolderId != null) {
                nFolderId = iNewFolderId;
            } else {
                if (nFolderType == 101) {
                    ArrayList<String> oldTempIdList = (ArrayList<String>)this.m_hTemplateInChannelMap.get(sFolderId);
                    if (oldTempIdList == null) {
                        oldTempIdList = new ArrayList<String>();
                        this.m_hTemplateInChannelMap.put(sFolderId, oldTempIdList);
                    }
                    oldTempIdList.add(sOldTempId);
                }
                nFolderId = _nRootId;
                nFolderType = 103;
            }
            template.setFolder(nFolderType, nFolderId, 103, _nRootId);
            template.removeProperty(PROPERTY_CRTIME);
            template.removeProperty(PROPERTY_CRUSER);
            template.setParsed(false);
            template.setApdModified(true);
            this.processContent(template);
            template.save(this.getLoginUser());
            int nTemplateId = template.getId();
            _tempalteIds.put(sOldTempId, new Integer(nTemplateId));
            this.importTempApdRels(_template.getChild(TAG_TEMPAPDRELS), nTemplateId, _temApdIds);
        }
        catch (Throwable t) {
            s_logger.debug((Object)I18NMessage.get(ChannelImporter.class, "ChannelImporter.label21", "\u5bfc\u5165\u6a21\u677f\u5931\u8d25"), t);
            this.m_reports.addWarnedReport(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label22", "\u5bfc\u5165\u6a21\u677f\u5931\u8d25:") + template, t);
        }
    }

    private void processContent(Template _template) throws WCMException {
        String[] sSrcAttributeNames;
        String sContent = _template.getText();
        String[] sWithSrcTags = PublishServerConfigMapper.getTemplateTagsHavingSrc();
        int nTagCount = sWithSrcTags.length > (sSrcAttributeNames = PublishServerConfigMapper.getTemplateTagSrcAttributeNames()).length ? sSrcAttributeNames.length : sWithSrcTags.length;
        HtmlElementFinder finder = null;
        for (int i = 0; i < nTagCount; ++i) {
            HtmlElement element = null;
            String sTagName = sWithSrcTags[i];
            String sSrcAttributeName = sSrcAttributeNames[i];
            String sSrcAttributeValue = null;
            finder = new HtmlElementFinder(sContent);
            while ((element = finder.findNextElement(sTagName, true)) != null) {
                sSrcAttributeValue = element.getAttributeValue(sSrcAttributeName);
                if (!CMyString.isEmpty(sSrcAttributeValue)) {
                    element.removeAttribute("OLDID");
                    if (element.removeAttribute("RELATED")) {
                        element.setAttribute(sSrcAttributeName, CMyFile.extractFileName(sSrcAttributeValue, "/"));
                    }
                }
                finder.putElement(element);
            }
            sContent = finder.getContent();
        }
        _template.setText(sContent);
    }

    private void importTempApdRels(XmlObject[] _tempApdRels, int _nTemplateId, Map _tempApdIds) {
        for (int i = 0; i < _tempApdRels.length; ++i) {
            this.importTempApdRelInfo(_tempApdRels[i], _nTemplateId, _tempApdIds);
        }
    }

    private void importTempApdRelInfo(XmlObject _tempApdRel, int _nTemplateId, Map _temApdIds) {
        TempApdRel tempApdRel = null;
        try {
            tempApdRel = (TempApdRel)_tempApdRel.getCurrentObj();
            tempApdRel.setTemplateId(_nTemplateId);
            int nOldApdId = tempApdRel.getTempAppendixId();
            Integer iNewApdId = (Integer)_temApdIds.get(String.valueOf(nOldApdId));
            tempApdRel.setTempAppendixId(iNewApdId);
            tempApdRel.removeProperty(PROPERTY_CRTIME);
            tempApdRel.save();
        }
        catch (Throwable t) {
            s_logger.debug((Object)I18NMessage.get(ChannelImporter.class, "ChannelImporter.label23", "\u5bfc\u5165\u6a21\u677f\u4e0e\u9644\u4ef6\u7684\u5173\u8054\u5173\u7cfb\u5931\u8d25"), t);
            this.m_reports.addWarnedReport(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label24", "\u5bfc\u5165\u6a21\u677f[") + _nTemplateId + I18NMessage.get(ChannelImporter.class, "ChannelImporter.label25", "]\u4e0e\u9644\u4ef6\u7684\u5173\u8054\u5173\u7cfb\u5931\u8d25!"), t);
        }
    }

    private void importTempEmploys(XmlObject[] _tempEmploys, int _nEmployId, Map _templateIds) {
        for (int i = 0; i < _tempEmploys.length; ++i) {
            this.importTempEmployInfo(_tempEmploys[i], _nEmployId, _templateIds);
        }
    }

    private void importTempEmployInfo(XmlObject _tempEmploy, int _nEmployId, Map _templateIds) {
        TemplateEmploy tempEmploy = null;
        try {
            tempEmploy = (TemplateEmploy)_tempEmploy.getCurrentObj();
            int nEmployerType = tempEmploy.getEmployerType();
            tempEmploy.setEmployer(nEmployerType, _nEmployId);
            int nOldTempId = tempEmploy.getTemplateId();
            int nTempType = tempEmploy.getTemplateType();
            if (_templateIds != null) {
                Integer iNewTempId = (Integer)_templateIds.get(String.valueOf(nOldTempId));
                tempEmploy.setTemplate(nTempType, iNewTempId);
            } else {
                Template template = tempEmploy.getTemplate();
                if (template == null || !template.isAccessibleFrom((IPublishFolder)PublishElementFactory.lookupElement(nEmployerType, _nEmployId)) || template.getType() != tempEmploy.getTemplateType()) {
                    return;
                }
            }
            tempEmploy.save(this.getLoginUser());
            Thread.sleep(this.CHNL_IMPORT_DELAY_MILLIS);
        }
        catch (Throwable t) {
            s_logger.debug((Object)I18NMessage.get(ChannelImporter.class, "ChannelImporter.label26", "\u5bfc\u5165\u6a21\u677f\u5173\u7cfb\u5931\u8d25"), t);
            this.m_reports.addWarnedReport(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label27", "\u5bfc\u5165\u6a21\u677f\u5173\u7cfb\u5931\u8d25!"), t);
        }
    }

    private void importFolderPubConfs(XmlObject[] _folderPubConfs, IPublishFolder _folder) {
        for (int i = 0; i < _folderPubConfs.length; ++i) {
            this.importFolderPubConfInfo(_folderPubConfs[i], _folder);
        }
    }

    private void importFolderPubConfInfo(XmlObject _folderPubConf, IPublishFolder _folder) {
        FolderPublishConfig folderPubConf = null;
        try {
            folderPubConf = (FolderPublishConfig)_folderPubConf.getCurrentObj();
            folderPubConf.setFolder(_folder.getType(), _folder.getId());
            folderPubConf.removeProperty(PROPERTY_CRTIME);
            this.changeDataPathIfNecessary(folderPubConf, _folder);
            folderPubConf.save(this.getLoginUser());
            Thread.sleep(this.CHNL_IMPORT_DELAY_MILLIS);
        }
        catch (Throwable t) {
            s_logger.debug((Object)I18NMessage.get(ChannelImporter.class, "ChannelImporter.label28", "\u5bfc\u5165\u53d1\u5e03\u5c5e\u6027\u5931\u8d25"), t);
            this.m_reports.addWarnedReport(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label29", "\u5bfc\u5165[") + folderPubConf + I18NMessage.get(ChannelImporter.class, "ChannelImporter.label20", "]\u5931\u8d25"), t);
        }
    }

    private void changeDataPathIfNecessary(FolderPublishConfig _folderPubConf, IPublishFolder _folder) throws Throwable {
        if (!this.m_bCheckDataPathNecessary) {
            return;
        }
        String sDataPath = _folderPubConf.getDataPath();
        if (!this.existsDataPath(_folder, sDataPath)) {
            return;
        }
        String sNewDataPath = sDataPath = sDataPath.replaceAll("(_\\d+)+", "");
        int k = _folder.getId();
        while (this.existsDataPath(_folder, sNewDataPath)) {
            sNewDataPath = sDataPath + "_" + k;
            ++k;
        }
        _folderPubConf.setDataPath(sNewDataPath);
        this.m_bCheckDataPathNecessary = false;
    }

    private boolean existsDataPath(IPublishFolder _folder, String _sDataPath) throws WCMException {
        String sWhere = "DataPath='" + CMyString.filterForSQL(_sDataPath) + "' AND ";
        if (103 == _folder.getType()) {
            sWhere = sWhere + " FolderType=103";
        } else {
            IPublishFolder parent = _folder.getParent();
            int nParentId = 0;
            if (103 != parent.getType()) {
                nParentId = parent.getId();
            }
            sWhere = sWhere + " EXISTS(SELECT WCMChannel.ChannelId from WCMChannel where ParentId=" + nParentId + " AND WCMChannel.ChannelId=WCMFolderPublishConfig.FolderId)";
        }
        WCMFilter aFilter = new WCMFilter("WCMFOLDERPUBLISHCONFIG", sWhere, "");
        aFilter.setMaxRowNumber(1);
        FolderPublishConfigs configs = new FolderPublishConfigs(this.getLoginUser());
        configs.open(aFilter);
        return !configs.isEmpty();
    }

    private void importPubStatusConfs(XmlObject[] _pubStatusConfs, int _nFolderType, int _nFolderId) {
        for (int i = 0; i < _pubStatusConfs.length; ++i) {
            this.importPubStatusConfInfo(_pubStatusConfs[i], _nFolderType, _nFolderId);
        }
    }

    private void importPubStatusConfInfo(XmlObject _pubStatusConf, int _nFolderType, int _nFolderId) {
        WCMPubStatusConfig pubStatusConf = null;
        try {
            pubStatusConf = (WCMPubStatusConfig)_pubStatusConf.getCurrentObj();
            pubStatusConf.setFolderType(_nFolderType, _nFolderId);
            pubStatusConf.removeProperty(PROPERTY_CRTIME);
            pubStatusConf.save(this.getLoginUser());
            Thread.sleep(this.CHNL_IMPORT_DELAY_MILLIS);
        }
        catch (Throwable t) {
            s_logger.debug((Object)I18NMessage.get(ChannelImporter.class, "ChannelImporter.label30", "\u5bfc\u5165\u53d1\u5e03\u72b6\u6001\u8bbe\u7f6e\u5931\u8d25"), t);
            this.m_reports.addWarnedReport(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label31", "\u5bfc\u5165\u53d1\u5e03\u72b6\u6001\u8bbe\u7f6e[") + pubStatusConf + I18NMessage.get(ChannelImporter.class, "ChannelImporter.label20", "]\u5931\u8d25"), t);
        }
    }

    private void importChildChannels(XmlObject[] _childChannels, BaseChannel _parent, BaseChannel _destSiteOrChnl) {
        for (int i = 0; i < _childChannels.length; ++i) {
            this.importChildChnlInfo(_childChannels[i], _parent, _destSiteOrChnl);
        }
    }

    private void importChildChnlInfo(XmlObject _childChnl, BaseChannel _parent, BaseChannel _destSiteOrChnl) {
        Channel childChnl = null;
        try {
            childChnl = (Channel)_childChnl.getCurrentObj();
            String sOldChannelId = childChnl.getPropertyAsString("CHANNELID");
            childChnl.setParent(_parent);
            WebSite parentSite = _parent.getSite();
            int nDestSiteType = parentSite.getPropertyAsInt("SiteType", 0);
            if (this.isExcludeSiteType(nDestSiteType) && !this.isNormChannel(childChnl)) {
                String msg = I18NMessage.get(ChannelImporter.class, "ChannelImporter.label7", "\u975e\u6587\u5b57\u5e93\u7ad9\u70b9[") + parentSite.getName() + I18NMessage.get(ChannelImporter.class, "ChannelImporter.label8", "]\u4e0d\u652f\u6301[");
                msg = msg + childChnl.getTypeDesc();
                msg = msg + I18NMessage.get(ChannelImporter.class, "ChannelImporter.label9", "]\u7c7b\u578b\u7684\u680f\u76ee\uff01");
                this.m_reports.addWarnedReport(CMyString.format(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label42", "\u5bfc\u5165\u5b50\u5bf9\u8c61[{0}]\u5931\u8d25\uff01"), new String[]{childChnl.toString()}), new WCMDatainvalidException(msg));
                return;
            }
            if (_destSiteOrChnl != null && _destSiteOrChnl.isSite()) {
                childChnl.setSite(_destSiteOrChnl.getId());
            }
            childChnl.setNextId();
            this.changeNameIfNescessary(false, childChnl, _destSiteOrChnl);
            childChnl.removeProperty(PROPERTY_CRTIME);
            childChnl.removeProperty(PROPERTY_CRUSER);
            this.m_channelMgr.save(childChnl);
            Thread.sleep(this.CHNL_IMPORT_DELAY_MILLIS);
            this.processTemplateFolderIfNeed(sOldChannelId, childChnl.getId());
            this.m_siteOrChnlIds.put(this.makeSiteOrChnlIdMapKey(sOldChannelId, 101), new Integer(childChnl.getId()));
            this.importFolderPubConfs(_childChnl.getChild(TAG_FOLDERPUBCONFS), (IPublishFolder)PublishElementFactory.makeElementFrom(childChnl));
            this.importPubStatusConfs(_childChnl.getChild(TAG_WCMPUBSTATUSCONFS), childChnl.getWCMType(), childChnl.getId());
            this.importContExtFields(_childChnl.getChild(TAG_CONTEXTFIELDS), childChnl);
            this.importTemplateArgs(childChnl, _childChnl.getChild(TAG_TEMPLATEARGS));
            this.importChildChannels(_childChnl.getChild(TAG_CHILDCHANNELS), childChnl, _destSiteOrChnl);
            ChannelServiceProviderHelper.createRelatedEmployes(sOldChannelId, (BaseChannel)childChnl);
            PorterUtil.doImports(childChnl, _childChnl, null);
        }
        catch (Throwable t) {
            s_logger.debug((Object)I18NMessage.get(ChannelImporter.class, "ChannelImporter.label33", "\u5bfc\u5165\u5b50\u5bf9\u8c61\u5931\u8d25"), t);
            this.m_reports.addWarnedReport(CMyString.format(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label42", "\u5bfc\u5165\u5b50\u5bf9\u8c61[{0}]\u5931\u8d25\uff01"), new String[]{childChnl.toString()}), t);
        }
    }

    private void processTemplateFolderIfNeed(String sOldChannelId, int id) {
        if (this.m_templateIds == null || this.m_templateIds.isEmpty()) {
            return;
        }
        List oldTempList = (List)this.m_hTemplateInChannelMap.remove(sOldChannelId);
        if (oldTempList == null || oldTempList.isEmpty()) {
            return;
        }
        User user = this.getLoginUser();
        int size = oldTempList.size();
        for (int i = 0; i < size; ++i) {
            String oldId = (String)oldTempList.get(i);
            Integer newId = (Integer)this.m_templateIds.get(oldId);
            if (newId == null) continue;
            try {
                Template temp = Template.findByKey(newId);
                temp.setFolder(101, id);
                temp.save(user);
                continue;
            }
            catch (WCMException wCMException) {
                // empty catch block
            }
        }
    }

    private void importTemplateArgs(BaseChannel siteOrChnl, XmlObject[] templateArgs) {
        if (templateArgs == null || templateArgs.length == 0) {
            return;
        }
        TemplateArgument arg = null;
        boolean bWithTemplate = this.m_templateIds != null && !this.m_templateIds.isEmpty();
        IPublishFolder folder = null;
        int nTyype = siteOrChnl.getWCMType();
        int nId = siteOrChnl.getId();
        if (!bWithTemplate) {
            try {
                folder = (IPublishFolder)PublishElementFactory.makeElementFrom(siteOrChnl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int len = templateArgs.length;
        for (int i = 0; i < len; ++i) {
            try {
                arg = (TemplateArgument)templateArgs[i].getCurrentObj();
                arg.setEmployer(nTyype, nId);
                int nOldTempId = arg.getTemplateId();
                if (bWithTemplate) {
                    Integer iNewTempId = (Integer)this.m_templateIds.get(String.valueOf(nOldTempId));
                    if (iNewTempId != null) {
                        arg.setTemplateId(iNewTempId);
                        arg.save();
                    }
                } else {
                    Template template = Template.findById(nOldTempId);
                    if (template != null && template.isAccessibleFrom(folder)) {
                        arg.save();
                    }
                }
                Thread.sleep(this.CHNL_IMPORT_DELAY_MILLIS);
                continue;
            }
            catch (Throwable t) {
                if (!s_logger.isDebugEnabled()) continue;
                s_logger.error((Object)"Failed to import template arguments.", t);
            }
        }
    }

    private void changeNameIfNescessary(boolean _bSite, BaseChannel _siteOrChnl, BaseChannel _destSiteOrChnl) throws Throwable {
        if (_bSite) {
            if (!CMyString.isEmpty(this.m_sNewSiteName)) {
                ((WebSite)_siteOrChnl).setName(this.m_sNewSiteName);
                ((WebSite)_siteOrChnl).setDesc(this.m_sNewSiteName);
            }
            if (!CMyString.isEmpty(this.m_sNewSiteDesc)) {
                ((WebSite)_siteOrChnl).setDesc(this.m_sNewSiteDesc);
            }
            this.changeSiteName(_siteOrChnl);
        } else {
            this.changeChnlName(_siteOrChnl, _destSiteOrChnl);
        }
    }

    private void changeSiteName(BaseChannel _site) throws Throwable {
        String sSiteName = _site.getName();
        if (!this.existsSiteName(sSiteName)) {
            return;
        }
        String sNewSiteName = sSiteName = sSiteName.replaceAll("(_\\d+)+", "");
        int nCount = _site.getId();
        while (this.existsSiteName(sNewSiteName)) {
            sNewSiteName = sSiteName + "_" + nCount;
            ++nCount;
        }
        _site.setName(sNewSiteName);
    }

    private boolean existsSiteName(String _sSiteName) throws Throwable {
        WCMFilter aFilter = new WCMFilter("", "SiteName='" + CMyString.filterForSQL(_sSiteName) + "'", "");
        aFilter.setMaxRowNumber(1);
        WebSites sites = WebSites.openWCMObjs(User.getSystem(), aFilter);
        return !sites.isEmpty();
    }

    private void changeChnlName(BaseChannel _channel, BaseChannel _destSiteOrChnl) throws Throwable {
        String sChnlName = _channel.getName();
        if (!this.existsChnlName(sChnlName, _destSiteOrChnl)) {
            return;
        }
        String sNewChnlName = sChnlName = sChnlName.replaceAll("(_\\d+)+", "");
        int nCount = _channel.getId();
        while (this.existsChnlName(sNewChnlName, _destSiteOrChnl)) {
            sNewChnlName = sChnlName + "_" + nCount;
            ++nCount;
        }
        _channel.setName(sNewChnlName);
    }

    private boolean existsChnlName(String _sChnlName, BaseChannel _destSiteOrChnl) {
        return Channel.findByName(_destSiteOrChnl.getSiteId(), _sChnlName) != null;
    }

    private void importContExtFields(XmlObject[] _contExtFields, BaseChannel _siteOrChnl) {
        for (int i = 0; i < _contExtFields.length; ++i) {
            this.importContExtFieldInfo(_contExtFields[i], _siteOrChnl);
        }
    }

    private void importContExtFieldInfo(XmlObject _contExtField, BaseChannel _siteOrChannel) {
        ContentExtField contExtField = null;
        try {
            ExtendedField physical = this.importExtFieldInfo(_contExtField.getChild(TAG_EXTFIELDS)[0]);
            contExtField = (ContentExtField)_contExtField.getCurrentObj();
            if (physical != null) {
                contExtField.setProperty("EXTFIELDID", physical.getId());
            }
            contExtField.setObjId(_siteOrChannel.getId());
            contExtField.setObjType(_siteOrChannel.getWCMType());
            contExtField.save(this.getLoginUser());
            Thread.sleep(this.CHNL_IMPORT_DELAY_MILLIS);
        }
        catch (Throwable t) {
            this.m_reports.addWarnedReport(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label29", "\u5bfc\u5165[") + _siteOrChannel + I18NMessage.get(ChannelImporter.class, "ChannelImporter.label35", "]\u7684") + "[" + contExtField + I18NMessage.get(ChannelImporter.class, "ChannelImporter.label34", "]\u5931\u8d25!"), t);
        }
    }

    private ExtendedField importExtFieldInfo(XmlObject _extField) throws WCMException {
        ExtendedField field = (ExtendedField)_extField.getCurrentObj();
        String sFiledName = field.getName();
        ExtendedField existsField = this.findExtFieldByName(sFiledName, field.getTableName());
        if (existsField != null) {
            if (existsField.equals(field)) {
                return existsField;
            }
            this.changeExtFieldNameIfNecessary(field);
        }
        field.save(this.getLoginUser());
        return field;
    }

    private void changeExtFieldNameIfNecessary(ExtendedField _extField) throws WCMException {
        String sTempName = _extField.getName();
        int suffix = 0;
        while (this.findExtFieldByName(sTempName, _extField.getTableName()) != null) {
            sTempName = sTempName + suffix;
        }
        _extField.setName(sTempName);
    }

    private ExtendedField findExtFieldByName(String _sFieldName, String _sTableName) throws WCMException {
        if (CMyString.isEmpty(_sTableName)) {
            throw new WCMException(1100, I18NMessage.get(ChannelImporter.class, "ChannelImporter.label36", "\u6269\u5c55\u5b57\u6bb5\u5224\u91cd\u5931\u8d25,\u6269\u5c55\u5b57\u6bb5[") + _sFieldName + I18NMessage.get(ChannelImporter.class, "ChannelImporter.label37", "]\u6ca1\u6709\u6307\u5b9a\u6240\u5c5e\u8868\u540d!"));
        }
        WCMFilter aFilter = new WCMFilter("WCMEXTFIELD", "FIELDNAME=? AND TableName='" + _sTableName.toUpperCase() + "'", "");
        aFilter.setMaxRowNumber(1);
        aFilter.addSearchValues(0, _sFieldName);
        ExtendedFields fields = ExtendedFields.openWCMObjs(this.getLoginUser(), aFilter);
        if (fields.isEmpty()) {
            return null;
        }
        return (ExtendedField)fields.getAt(0);
    }

    private Reports importFromXml(String _sXmlFile, String _sXslFile, BaseChannel _destSiteOrChnl) throws WCMException {
        XmlObject[] xmlObjects = this.convertXmlFile(_sXmlFile, _sXslFile);
        this.importSitesOrChnls(xmlObjects, _destSiteOrChnl, null);
        this.m_reports.setTitle(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label38", "\u4eceXML\u6587\u4ef6\u4e2d\u5bfc\u5165\u7ad9\u70b9/\u680f\u76ee\u4fe1\u606f!"));
        return this.m_reports;
    }

    private void importChildChannelsTempEmploys(XmlObject[] _childChnls, Map _templateIds) {
        for (int i = 0; i < _childChnls.length; ++i) {
            this.importChildChannelsTempEmploys(_childChnls[i].getChild(TAG_CHILDCHANNELS), _templateIds);
            String oldId = _childChnls[i].getCurrentObj().getPropertyAsString("CHANNELID");
            int nId = Integer.parseInt(oldId);
            this.importTempEmploys(_childChnls[i].getChild(TAG_TEMPEMPLOYS), nId, _templateIds);
        }
    }

    private XmlObject[] convertXmlFile(String _sXmlFile, String _sXslFile) throws WCMException {
        try {
            XmlObject[] xmlObjects = this.m_converter.convertXml(_sXmlFile, _sXslFile, null);
            return xmlObjects;
        }
        catch (Throwable t) {
            s_logger.debug((Object)"failed to convert xml to object!", t);
            throw new WCMException(150, I18NMessage.get(ChannelImporter.class, "ChannelImporter.label39", "\u8f6c\u6362XML\u6587\u4ef6\u5931\u8d25!\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u7ad9\u70b9/\u680f\u76ee\u63cf\u8ff0xml\u6587\u4ef6"), t);
        }
    }

    private void assertNotEmptyString(String _str) throws WCMException {
        if (_str == null || _str.trim().length() == 0) {
            throw new WCMException(10, I18NMessage.get(ChannelImporter.class, "ChannelImporter.label40", "\u65e0\u6548\u7684\u6587\u4ef6\u540d!"));
        }
    }

    private void assertUnSupportFile(String _sExt) throws WCMException {
        if (!FILEEXT_XML.equalsIgnoreCase(_sExt) && !FILEEXT_ZIP.equalsIgnoreCase(_sExt)) {
            throw new WCMException(1200, I18NMessage.get(ChannelImporter.class, "ChannelImporter.label41", "\u53ea\u652f\u6301\u4eceXML/ZIP\u6587\u4ef6\u4e2d\u5bfc\u5165!"));
        }
    }

    private String getFullName(String _sFile) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        if (!CMyFile.fileExists(_sFile)) {
            String sPath = filesMan.mapFilePath(_sFile, 0);
            _sFile = sPath + _sFile;
        }
        return _sFile;
    }

    public static List getImplementors() throws Exception {
        String iterfaceName = IChannelImporterConverter.class.getName();
        if (implementors == null) {
            Iterator itrImplementors = WCMDiscoveryFactory.getDiscovery().getImplementors(iterfaceName);
            implementors = new ArrayList();
            while (itrImplementors != null && itrImplementors.hasNext()) {
                String sImplementor = (String)itrImplementors.next();
                implementors.add(Class.forName(sImplementor).newInstance());
            }
        }
        return implementors;
    }

    private void registerConverter() {
        this.m_converter.registPersistentObj("WCMWEBSITE", WebSite.class);
        this.m_converter.registPersistentObj("WCMCHANNEL", Channel.class);
        this.m_converter.registPersistentObj("WCMTEMPLATEEMPLOY", TemplateEmploy.class);
        this.m_converter.registPersistentObj("WCMFOLDERPUBLISHCONFIG", FolderPublishConfig.class);
        this.m_converter.registPersistentObj("WCMPUBSTATUSCONFIG", WCMPubStatusConfig.class);
        this.m_converter.registPersistentObj("WCMTEMPLATE", Template.class);
        this.m_converter.registPersistentObj("WCMTEMPAPDREL", TempApdRel.class);
        this.m_converter.registPersistentObj("WCMTEMPAPPENDIX", TempAppendix.class);
        this.m_converter.registPersistentObj("WCMCONTENTEXTFIELD", ContentExtField.class);
        this.m_converter.registPersistentObj("WCMEXTFIELD", ExtendedField.class);
        this.m_converter.registPersistentObj("WCMTEMPLATEARGUMENT", TemplateArgument.class);
        try {
            List aimplementors = ChannelImporter.getImplementors();
            for (IChannelImporterConverter implementor : aimplementors) {
                implementor.registerConverter(this.m_converter);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addFailedReports(BaseChannel _siteOrChnl, Throwable _throwable) {
        this.m_reports.addFailedReport(CMyString.format(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label43", "\u5bfc\u5165[{0}]\u5931\u8d25!"), new Object[]{_siteOrChnl}), _throwable);
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public String getNewSiteName() {
        return this.m_sNewSiteName;
    }

    public void setNewSiteName(String newSiteName) {
        this.m_sNewSiteName = newSiteName;
    }
}

