/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.advisor;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.advisor.Advisor;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;

public class Step
extends CMSObj {
    public static final int OBJ_TYPE = 78549201;
    public static final String DB_TABLE_NAME = "XWCMSTEP";
    public static final String DB_ID_NAME = "STEPID";
    public static final int MULTI_SELECT_TYPE = 1;
    public static final int SINGLE_SELECT_TYPE = 0;
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;

    public static String getSelectTypeString(int _nType) {
        switch (_nType) {
            case 1: {
                return I18NMessage.get(Step.class, "Step.label1", "\u591a\u9009");
            }
            case 0: {
                return I18NMessage.get(Step.class, "Step.label2", "\u5355\u9009");
            }
        }
        return I18NMessage.get(Step.class, "Step.label2", "\u5355\u9009");
    }

    public static String getSelectTypeInfo(int _nType) {
        switch (_nType) {
            case 1: {
                return "checkbox";
            }
            case 0: {
                return "radio";
            }
        }
        return "radio";
    }

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 78549201;
    }

    public String getStepName() {
        return this.getPropertyAsString("STEPNAME");
    }

    public boolean setStepName(String _sStepName) throws WCMException {
        return this.setProperty("STEPNAME", _sStepName);
    }

    public String getStepDesc() {
        return this.getPropertyAsString("STEPDESC");
    }

    public boolean setStepDesc(String _sStepDesc) throws WCMException {
        return this.setProperty("STEPDESC", _sStepDesc);
    }

    public boolean isMultiSelect() {
        return this.getPropertyAsBoolean("ISMULTISELECT", false);
    }

    public boolean setMultiSelect(boolean _bIsMultiSelect) throws WCMException {
        return this.setProperty("ISMULTISELECT", _bIsMultiSelect);
    }

    public int getAdvisorId() {
        return this.getPropertyAsInt("ADVISORID", 0);
    }

    public boolean setAdvisorId(int _nAdvisorId) throws WCMException {
        return this.setProperty("ADVISORID", _nAdvisorId);
    }

    public int getOrder() {
        return this.getPropertyAsInt("AORDER", 0);
    }

    public boolean setOrder(int _nAOrder) throws WCMException {
        return this.setProperty("AORDER", _nAOrder);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("STEPNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(Step.class, "Step.label3", "\u5c5e\u6027StepName\u6ca1\u6709\u8bbe\u7f6e(Step.isValid)"));
            }
            if (this.getProperty("ISMULTISELECT") == null) {
                throw new WCMException(1106, I18NMessage.get(Step.class, "Step.label4", "\u5c5e\u6027IsMultiSelect\u6ca1\u6709\u8bbe\u7f6e(Step.isValid)"));
            }
            if (this.getProperty("ADVISORID") == null) {
                throw new WCMException(1106, I18NMessage.get(Step.class, "Step.label5", "\u5c5e\u6027AdvisorId\u6ca1\u6709\u8bbe\u7f6e(Step.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(Step.class, "Step.label6", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Step.isValid)"));
        }
        this.changeOrder();
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(_currUser);
        }
    }

    private void changeOrder() throws WCMException {
        int nMaxOrder;
        int nNewOrder;
        int nMoveBeginAt = 0;
        int nMoveEndAt = 0;
        int nMoveDirection = 0;
        if (this.isAddMode()) {
            nNewOrder = this.getOrder();
            nMaxOrder = this.getMaxOrder();
            if (nNewOrder == -1) {
                nNewOrder = nMaxOrder + 1;
                this.setOrder(nNewOrder);
                return;
            }
            nMoveDirection = 1;
            nMoveEndAt = nMaxOrder;
            nMoveBeginAt = nNewOrder;
        } else {
            if (!this.isChangeProperty("AORDER")) {
                return;
            }
            nNewOrder = this.getNewPropertyAsInt("AORDER", -1);
            if (nNewOrder == -1) {
                nMaxOrder = this.getMaxOrder();
                if (nMaxOrder == this.getOrder()) {
                    nNewOrder = this.getOrder();
                } else {
                    nMoveDirection = -1;
                    nMoveEndAt = nMaxOrder;
                    nMoveBeginAt = this.getOrder() + 1;
                    nNewOrder = nMaxOrder;
                }
            } else if (nNewOrder > this.getOrder()) {
                nMoveDirection = -1;
                nMoveEndAt = nNewOrder;
                nMoveBeginAt = this.getOrder() + 1;
            } else {
                nMoveDirection = 1;
                nMoveEndAt = this.getOrder() - 1;
                nMoveBeginAt = nNewOrder;
            }
        }
        String sRegionWhere = "AORDER>=" + nMoveBeginAt + " AND AORDER <= " + nMoveEndAt + " and ADVISORID=" + this.getAdvisorId();
        String sMoveSql = "UPDATE XWCMSTEP SET AORDER = AORDER+(" + nMoveDirection + ") WHERE " + sRegionWhere;
        DBManager.getDBManager().sqlExecuteUpdate(sMoveSql);
        this.setOrder(nNewOrder);
    }

    private int getMaxOrder() throws WCMException {
        String SQL_QUERY_MAX_ORDER = "select max(AORDER) from XWCMSTEP where ADVISORID=?";
        return DBManager.getDBManager().sqlExecuteIntQuery("select max(AORDER) from XWCMSTEP where ADVISORID=?", new int[]{this.getAdvisorId()});
    }

    public static final Step findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (Step)BaseObj.findById(Step.class, _nId);
    }

    public static final Step createNewInstance() throws WCMException {
        return (Step)BaseObj.createNewInstance(Step.class);
    }

    public static final Step findByKey(Object _oKey) throws WCMException {
        return (Step)BaseObj.findByKey(Step.class, _oKey);
    }

    public Advisor getAdvisor() throws WCMException {
        return Advisor.findById(this.getAdvisorId());
    }
}

