/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.advisor;

import com.trs.components.wcm.advisor.Advisor;
import com.trs.components.wcm.advisor.Option;
import com.trs.components.wcm.advisor.OptionGroup;
import com.trs.components.wcm.advisor.OptionGroups;
import com.trs.components.wcm.advisor.Options;
import com.trs.components.wcm.advisor.Step;
import com.trs.components.wcm.advisor.Steps;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class AdvisorXMLMaker {
    private List m_arFiles = new ArrayList();

    public List getRelateFiles() {
        return this.m_arFiles;
    }

    public String parseToXML(Advisor _advisor) throws WCMException {
        Element root = DocumentHelper.createElement((String)"consultant");
        root.addAttribute("name", _advisor.getAdvisorName());
        root.addAttribute("viewName", _advisor.getViewName());
        WCMFilter filterForSteps = new WCMFilter("", "ADVISORID=?", "AOrder");
        filterForSteps.addSearchValues(_advisor.getId());
        Steps steps = Steps.openWCMObjs(null, filterForSteps);
        int nStepSize = steps.size();
        for (int nStepIndex = 0; nStepIndex < nStepSize; ++nStepIndex) {
            Step step = (Step)steps.getAt(nStepIndex);
            Element elStep = this.makeXMLElement(step);
            root.add(elStep);
        }
        return root.asXML();
    }

    private Element makeXMLElement(Step _step) throws WCMException {
        Element elStep = DocumentHelper.createElement((String)"step");
        elStep.addAttribute("id", String.valueOf(_step.getId()));
        elStep.addAttribute("name", _step.getStepName());
        elStep.addAttribute("seq", String.valueOf(_step.getOrder()));
        int nType = _step.getPropertyAsInt("ISMULTISELECT", 0);
        elStep.addAttribute("type", String.valueOf(Step.getSelectTypeInfo(nType)));
        WCMFilter filterForGroups = new WCMFilter("", "STEPID=?", "AOrder");
        filterForGroups.addSearchValues(_step.getId());
        OptionGroups oOptionGroups = OptionGroups.openWCMObjs(null, filterForGroups);
        int nGroupSize = oOptionGroups.size();
        for (int nGroupIndex = 0; nGroupIndex < nGroupSize; ++nGroupIndex) {
            OptionGroup oOptionGroup = (OptionGroup)oOptionGroups.getAt(nGroupIndex);
            Element elOptionGroup = this.makeXMLElement(oOptionGroup);
            elStep.add(elOptionGroup);
        }
        return elStep;
    }

    private Element makeXMLElement(OptionGroup _oOptionGroup) throws WCMException {
        Element elOptionGroup = DocumentHelper.createElement((String)"optiongroup");
        elOptionGroup.addAttribute("id", String.valueOf(_oOptionGroup.getId()));
        elOptionGroup.addAttribute("name", _oOptionGroup.getOptionGroupName());
        elOptionGroup.addAttribute("previousproblem", _oOptionGroup.getLastOptions());
        elOptionGroup.addAttribute("inputName", _oOptionGroup.getOptionGroupDesc());
        WCMFilter filterForOptions = new WCMFilter("", "GROUPID=?", "AOrder");
        filterForOptions.addSearchValues(_oOptionGroup.getId());
        Options oOptions = Options.openWCMObjs(null, filterForOptions);
        int nOptionSize = oOptions.size();
        for (int nOptionIndex = 0; nOptionIndex < nOptionSize; ++nOptionIndex) {
            Option oOption = (Option)oOptions.getAt(nOptionIndex);
            Element elOption = this.makeXMLElement(oOption);
            elOptionGroup.add(elOption);
        }
        return elOptionGroup;
    }

    private Element makeXMLElement(Option _option) throws WCMException {
        Element elOption = DocumentHelper.createElement((String)"option");
        String sPicFile = _option.getPicFileName();
        if (!CMyString.isEmpty(sPicFile)) {
            this.m_arFiles.add(sPicFile);
        }
        elOption.addAttribute("id", String.valueOf(_option.getId()));
        elOption.addAttribute("seq", String.valueOf(_option.getOrder()));
        elOption.addAttribute("desc", _option.getOptionName());
        elOption.addAttribute("pic", _option.getPicFileName());
        elOption.addAttribute("query", _option.getSearchCondition());
        elOption.addAttribute("previousproblem", _option.getLastOptions());
        elOption.addAttribute("uirelation", _option.getNotAllowedSelectOptions());
        elOption.addAttribute("srcstep", String.valueOf(_option.getStepId()));
        return elOption;
    }
}

