/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.DreamFactory;
import com.trs.components.stat.IBonusCalculator;
import com.trs.components.stat.IStatResult;
import com.trs.components.stat.StatAnalysisTool;
import com.trs.components.stat.StatBonusResultForUser;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.DebugTimer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class StatBonusDataForUser {
    private static Logger logger = Logger.getLogger(StatBonusDataForUser.class);
    private String[] m_pSQL = null;
    private ArrayList m_arUserNames = null;
    private ArrayList m_arDocIds = null;

    public StatBonusDataForUser(String _sStatSQL) {
        this.m_pSQL = new String[1];
        this.m_pSQL[0] = _sStatSQL;
    }

    public StatBonusDataForUser(String[] _pStatSQL) {
        this.m_pSQL = _pStatSQL;
    }

    public StatBonusResultForUser stat(CMyDateTime _dtStartTime, CMyDateTime _dtEndTime) throws Exception {
        return this.stat(_dtStartTime, _dtEndTime, 1, true);
    }

    public StatBonusResultForUser stat(CMyDateTime _dtStartTime, CMyDateTime _dtEndTime, int _nSortBy, boolean _bSortDesc) throws Exception {
        CMyDateTime dtStartTime = new CMyDateTime();
        dtStartTime.setDateTimeWithString(_dtStartTime.toString("yy-MM-01 00:00:00"));
        CMyDateTime dtEndTime = new CMyDateTime();
        dtEndTime.setDateTimeWithString(_dtEndTime.toString("yy-MM-01 00:00:00"));
        if (dtEndTime.dateDiff(2, dtStartTime) == 0L) {
            logger.info((Object)"\u7edf\u8ba1\u65f6\u95f4\u5c0f\u4e8e\u4e00\u4e2a\u6708\uff01");
            return null;
        }
        StatBonusResultForUser statResult = new StatBonusResultForUser(2);
        statResult.setResult(this.statIssuedAmountBonus(dtStartTime, dtEndTime, _bSortDesc), 0);
        statResult.setResult(this.statHitsBonus(dtStartTime, dtEndTime, _bSortDesc), 1);
        statResult.setUserNames(this.m_arUserNames);
        statResult.setDocIds(this.m_arDocIds);
        return statResult;
    }

    private HashMap statIssuedAmountBonus(CMyDateTime _dtStartTime, CMyDateTime _dtEndTime, boolean _bSortDesc) throws Exception {
        HashMap amountBonusResult = this.calculateIssuedAmountBonusByMonth(_dtStartTime, _dtEndTime, _bSortDesc);
        if (this.m_arUserNames == null) {
            return null;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(this.m_arUserNames.size());
        String sUserName = "";
        for (int i = 0; i < this.m_arUserNames.size(); ++i) {
            sUserName = (String)this.m_arUserNames.get(i);
            CMyDateTime startTime = (CMyDateTime)_dtStartTime.clone();
            startTime.dateAdd(2, -1);
            float fBonus = 0.0f;
            while (startTime.compareTo(_dtEndTime) < 0L) {
                startTime.dateAdd(2, 1);
                Object value = amountBonusResult.get(sUserName + "&" + startTime.getDateTimeAsString("yyyy\u5e74MM\u6708"));
                if (value == null) continue;
                fBonus += Float.parseFloat(value.toString().split("&")[0]);
            }
            result.put(sUserName, String.valueOf(fBonus));
        }
        return result;
    }

    public StatBonusResultForUser statIssuedAmountBonusByMonth(CMyDateTime _dtStartTime, CMyDateTime _dtEndTime, boolean _bSortDesc) throws Exception {
        if (_dtEndTime.dateDiff(2, _dtStartTime) == 0L) {
            logger.info((Object)"\u7edf\u8ba1\u65f6\u95f4\u5c0f\u4e8e\u4e00\u4e2a\u6708\uff01");
            return null;
        }
        StatBonusResultForUser statResult = new StatBonusResultForUser(1);
        statResult.setResult(this.calculateIssuedAmountBonusByMonth(_dtStartTime, _dtEndTime, _bSortDesc), 0);
        return statResult;
    }

    private HashMap calculateIssuedAmountBonusByMonth(CMyDateTime _dtStartTime, CMyDateTime _dtEndTime, boolean _bSortDesc) throws Exception {
        long lNumberOfMonth = _dtEndTime.dateDiff(2, _dtStartTime);
        if (lNumberOfMonth == 0L) {
            logger.info((Object)"\u7edf\u8ba1\u65f6\u95f4\u5c0f\u4e8e\u4e00\u4e2a\u6708\uff01");
            return null;
        }
        CMyDateTime startTime = (CMyDateTime)_dtStartTime.clone();
        CMyDateTime endTime = (CMyDateTime)_dtStartTime.clone();
        startTime.dateAdd(2, -1);
        StatAnalysisTool tool = new StatAnalysisTool(new String[]{this.m_pSQL[0]});
        IStatResult statResult = null;
        int nDataCount = 0;
        LinkedHashMap<String, String> statDataOfBonus = new LinkedHashMap<String, String>(2000);
        DebugTimer timer = new DebugTimer();
        timer.start();
        int i = 1;
        while ((long)i <= lNumberOfMonth) {
            List arUserNames;
            statResult = tool.stat(startTime.dateAdd(2, 1), endTime.dateAdd(2, 1));
            if (statResult != null && (arUserNames = statResult.sort(_bSortDesc)) != null) {
                float fBonus = 0.0f;
                IBonusCalculator calculator = (IBonusCalculator)DreamFactory.createObjectById("IBonusCalculator");
                for (int j = 0; j < arUserNames.size(); ++j) {
                    String sUserName = (String)arUserNames.get(j);
                    nDataCount = statResult.getResult(sUserName);
                    if (nDataCount == 0) continue;
                    fBonus = calculator.caclulateIssuedAmountBonus(nDataCount);
                    String sKey = sUserName.toLowerCase() + "&" + startTime.getDateTimeAsString("yyyy\u5e74MM\u6708");
                    statDataOfBonus.put(sKey, fBonus + "&" + nDataCount);
                    if (this.m_arUserNames == null) {
                        this.m_arUserNames = new ArrayList(2000);
                    }
                    if (this.m_arUserNames.indexOf(sUserName) >= 0) continue;
                    this.m_arUserNames.add(sUserName);
                }
            }
            ++i;
        }
        timer.stop();
        logger.debug((Object)("stat use[" + timer.getTime() + "]"));
        timer.start();
        return statDataOfBonus;
    }

    private HashMap statHitsBonus(CMyDateTime _dtStartTime, CMyDateTime _dtEndTime, boolean _bSortDesc) throws Exception {
        HashMap hitsBonusResult = this.calculateHitsBonusByMonth(_dtStartTime, _dtEndTime, _bSortDesc);
        if (this.m_arDocIds == null) {
            return null;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(this.m_arDocIds.size());
        String sDocId = "";
        for (int i = 0; i < this.m_arDocIds.size(); ++i) {
            sDocId = (String)this.m_arDocIds.get(i);
            CMyDateTime startTime = (CMyDateTime)_dtStartTime.clone();
            startTime.dateAdd(2, -1);
            float fBonus = 0.0f;
            while (startTime.compareTo(_dtEndTime) < 0L) {
                startTime.dateAdd(2, 1);
                Object value = hitsBonusResult.get(sDocId + "&" + startTime.getDateTimeAsString("yyyy\u5e74MM\u6708"));
                if (value == null) continue;
                fBonus += Float.parseFloat(value.toString().split("&")[0]);
            }
            result.put(sDocId, String.valueOf(fBonus));
        }
        return result;
    }

    public StatBonusResultForUser statHitsBonusByMonth(CMyDateTime _dtStartTime, CMyDateTime _dtEndTime, boolean _bSortDesc) throws Exception {
        if (_dtEndTime.dateDiff(2, _dtStartTime) == 0L) {
            logger.info((Object)"\u7edf\u8ba1\u65f6\u95f4\u5c0f\u4e8e\u4e00\u4e2a\u6708\uff01");
            return null;
        }
        StatBonusResultForUser statResult = new StatBonusResultForUser(1);
        statResult.setResult(this.calculateHitsBonusByMonth(_dtStartTime, _dtEndTime, _bSortDesc), 0);
        statResult.setDocIds(this.m_arDocIds);
        return statResult;
    }

    private HashMap calculateHitsBonusByMonth(CMyDateTime _dtStartTime, CMyDateTime _dtEndTime, boolean _bSortDesc) throws Exception {
        long lNumberOfMonth = _dtEndTime.dateDiff(2, _dtStartTime);
        if (lNumberOfMonth == 0L) {
            logger.info((Object)"\u7edf\u8ba1\u65f6\u95f4\u5c0f\u4e8e\u4e00\u4e2a\u6708\uff01");
            return null;
        }
        String sSQL = this.m_pSQL[0];
        if (this.m_pSQL.length >= 2) {
            sSQL = this.m_pSQL[1];
        }
        StatAnalysisTool tool = new StatAnalysisTool(new String[]{sSQL});
        IStatResult statResult = null;
        int nHitsCount = 0;
        LinkedHashMap<String, String> statHitsBonus = new LinkedHashMap<String, String>(2000);
        CMyDateTime startTime = (CMyDateTime)_dtStartTime.clone();
        CMyDateTime endTime = (CMyDateTime)_dtStartTime.clone();
        startTime.dateAdd(2, -1);
        DebugTimer timer = new DebugTimer();
        timer.start();
        int i = 1;
        while ((long)i <= lNumberOfMonth) {
            List arDocIds;
            statResult = tool.stat(startTime.dateAdd(2, 1), endTime.dateAdd(2, 1));
            if (statResult != null && (arDocIds = statResult.sort(_bSortDesc)) != null) {
                float fBonus = 0.0f;
                String sDocId = "";
                IBonusCalculator calculator = (IBonusCalculator)DreamFactory.createObjectById("IBonusCalculator");
                for (int j = 0; j < arDocIds.size(); ++j) {
                    sDocId = (String)arDocIds.get(j);
                    nHitsCount = statResult.getResult(sDocId);
                    if (nHitsCount == 0) continue;
                    fBonus = calculator.caclulateHitsBonus(nHitsCount);
                    String sKey = sDocId + "&" + startTime.getDateTimeAsString("yyyy\u5e74MM\u6708");
                    statHitsBonus.put(sKey, fBonus + "&" + nHitsCount);
                    if (this.m_arDocIds == null) {
                        this.m_arDocIds = new ArrayList(2000);
                    }
                    if (this.m_arDocIds.indexOf(sDocId) >= 0) continue;
                    this.m_arDocIds.add(sDocId);
                }
            }
            ++i;
        }
        timer.stop();
        logger.debug((Object)("stat use[" + timer.getTime() + "]"));
        return statHitsBonus;
    }
}

