/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.components.stat.BaseStatHandler;
import com.trs.components.stat.IChnlDeptMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.common.WCMException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class HitsStatHandler4ChnlDept
extends BaseStatHandler {
    private static Logger logger = Logger.getLogger(HitsStatHandler4ChnlDept.class);
    private HashMap m_hRelGroupsOfChannel = new HashMap();
    private IChnlDeptMgr m_oChnlDeptMgr = (IChnlDeptMgr)DreamFactory.createObjectById("IChnlDeptMgr");
    private Channels filterChannels = null;
    private boolean bFilterByChannel = false;

    public HitsStatHandler4ChnlDept() {
    }

    public HitsStatHandler4ChnlDept(Channels currhannels) {
        this.filterChannels = currhannels;
        this.bFilterByChannel = true;
    }

    @Override
    public void visitStatItem(ResultSet resultSet, int nSQLIndex) throws WCMException {
        try {
            int nCurrHitsCount = resultSet.getInt(1);
            if (nCurrHitsCount == 0) {
                return;
            }
            int nChannelId = resultSet.getInt(2);
            if (this.bFilterByChannel && (this.filterChannels == null || this.filterChannels.indexOf(nChannelId) < 0)) {
                return;
            }
            Channel channel = Channel.findById(nChannelId);
            if (channel == null) {
                throw new WCMException("\u672a\u627e\u5230\u6307\u5b9a\u680f\u76ee! [ChannelId = " + nChannelId + "]");
            }
            Groups oRelGroups = this.makeCurrRelGroups(channel);
            int nSize = oRelGroups.size();
            for (int nRelChannelIndex = 0; nRelChannelIndex < nSize; ++nRelChannelIndex) {
                Group oRelGroup = (Group)oRelGroups.getAt(nRelChannelIndex);
                if (oRelGroup == null) continue;
                String oGroupKey = oRelGroup.getId() + "";
                int nHitsCount = this.getValue(nSQLIndex, oGroupKey);
                this.setValue(nSQLIndex, oGroupKey, nHitsCount += nCurrHitsCount);
                this.addMajorObject(oGroupKey);
            }
        }
        catch (SQLException e) {
            logger.debug((Object)"\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new WCMException("\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", e);
        }
    }

    private Groups makeCurrRelGroups(Channel _oChannel) throws WCMException {
        User currUser = ContextHelper.getLoginUser();
        Groups oCurrRelGroups = (Groups)this.m_hRelGroupsOfChannel.get(_oChannel);
        if (oCurrRelGroups != null) {
            return oCurrRelGroups;
        }
        oCurrRelGroups = new Groups(null);
        String _sDepIds = this.m_oChnlDeptMgr.getDepIdsByChannel(_oChannel).toString();
        _sDepIds = _sDepIds.length() <= 2 ? "" : _sDepIds.substring(1, _sDepIds.length() - 1);
        oCurrRelGroups = Groups.findByIds(currUser, _sDepIds.trim());
        int nSize = oCurrRelGroups.size();
        for (int i = 0; i < nSize; ++i) {
            Group group = (Group)oCurrRelGroups.getAt(i);
            if (group == null) continue;
            for (Group parent = group; parent != null; parent = parent.getParent()) {
                oCurrRelGroups.addElement(parent);
            }
        }
        this.m_hRelGroupsOfChannel.put(_oChannel.getKey(), oCurrRelGroups);
        return oCurrRelGroups;
    }
}

