/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.components.stat.BaseStatHandler;
import com.trs.components.stat.DefaultStatHandler;
import com.trs.components.stat.IChnlDeptMgr;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.DebugTimer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DocStatHandler4ChnlDeptChannel
extends BaseStatHandler {
    private static Logger logger = Logger.getLogger(DefaultStatHandler.class);
    private ChannelMgr m_oChannelMgr = null;
    private IChnlDeptMgr m_oChnlDeptMgr = null;
    private HashMap m_hRelGroupsOfChannel = null;
    private int m_ChannelId = 0;
    private Channels channels;

    public DocStatHandler4ChnlDeptChannel(int _nChannelId) {
        this.m_ChannelId = _nChannelId;
        this.m_hRelGroupsOfChannel = new HashMap();
        this.m_oChannelMgr = (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");
        this.m_oChnlDeptMgr = (IChnlDeptMgr)DreamFactory.createObjectById("IChnlDeptMgr");
    }

    @Override
    public void visitStart(ResultSet resultSet, int nSQLIndex) throws WCMException {
        super.visitStart(resultSet, nSQLIndex);
        Channel currChannel = Channel.findById(this.m_ChannelId);
        this.channels = (Channels)this.m_oChannelMgr.getChildren(currChannel, -1, false, new WCMFilter());
        this.channels.addElement(currChannel);
    }

    @Override
    public void visitStatItem(ResultSet resultSet, int nSQLIndex) throws WCMException {
        try {
            int nColumnCount = resultSet.getMetaData().getColumnCount();
            int nChannelId = resultSet.getInt(nColumnCount);
            if (this.channels.indexOf(nChannelId) < 0) {
                return;
            }
            int nDataCount = resultSet.getInt(1);
            Channel channel = Channel.findById(this.m_ChannelId);
            DebugTimer timerTemp = new DebugTimer();
            timerTemp.start();
            Groups oRelGroups = this.makeCurrRelGroups(channel);
            timerTemp.stop();
            logger.debug((Object)("makeCurrRelGroups of Channel-" + this.m_ChannelId + " use[" + timerTemp.getTime() + "]ms"));
            timerTemp.start();
            int nSize = oRelGroups.size();
            for (int nRelGroupIndex = 0; nRelGroupIndex < nSize; ++nRelGroupIndex) {
                Group oRelGroup = (Group)oRelGroups.getAt(nRelGroupIndex);
                if (oRelGroup == null) continue;
                String sGroupId = oRelGroup.getId() + "";
                String oGroupKey = this.makePrivateKey(sGroupId, this.m_ChannelId + "", resultSet);
                int iExistsDataCount = this.getValue(nSQLIndex, oGroupKey);
                int nDataCountOfCurrGroup = nDataCount;
                this.setValue(nSQLIndex, oGroupKey, nDataCountOfCurrGroup += iExistsDataCount);
                this.addMajorObject(sGroupId);
            }
        }
        catch (SQLException e) {
            logger.debug((Object)"\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new WCMException("\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", e);
        }
    }

    private String makePrivateKey(String groupKey, String sChannelId, ResultSet resultSet) throws SQLException {
        int nColumnCount = resultSet.getMetaData().getColumnCount();
        String[] sParam = new String[nColumnCount - 1];
        sParam[0] = groupKey;
        sParam[1] = sChannelId;
        for (int i = 3; i < nColumnCount; ++i) {
            sParam[i - 1] = resultSet.getString(i);
        }
        return this.makeKey(sParam);
    }

    private Groups makeCurrRelGroups(Channel _oChannel) throws WCMException {
        User currUser = ContextHelper.getLoginUser();
        Groups oCurrRelGroups = (Groups)this.m_hRelGroupsOfChannel.get(_oChannel);
        if (oCurrRelGroups != null) {
            return oCurrRelGroups;
        }
        Groups groups = currUser.getGroups();
        Groups ogroups = new Groups(currUser);
        for (int i = 0; i < groups.size(); ++i) {
            Group group = (Group)groups.getAt(i);
            Users users = group.getUsers(currUser);
            User noAdminUser = null;
            for (int j = 0; j < users.size(); ++j) {
                User oUser = (User)users.getAt(j);
                if (group.isAdministrator(oUser) || oUser.isAdministrator()) continue;
                noAdminUser = (User)users.getAt(j);
                break;
            }
            if (noAdminUser == null) {
                return null;
            }
            if (currUser.isAdministrator()) {
                ogroups.addElement(group);
                continue;
            }
            if (!AuthServer.hasRight(noAdminUser, (CMSObj)_oChannel, 31)) continue;
            ogroups.addElement(group);
        }
        this.m_hRelGroupsOfChannel.put(_oChannel.getKey(), ogroups);
        return ogroups;
    }
}

