/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.IDepartmentMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.components.govinfo.GovInfoViewFinder;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.service.IDefaultChannelMaker;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import org.apache.log4j.Logger;

public class UserRelateInfoMaker
implements IDefaultChannelMaker {
    private static Logger logger = Logger.getLogger(UserRelateInfoMaker.class);
    private static final String WHERE_QUERY_GROUP_ID_BY_PATH = "CName=? and exists(select 1 from XWCMClassInfo b where b.CName=? and b.ClassInfoId=a.ParentId) and RootId in(select ClassInfoId from XWCMClassInfo where ParentId=0 and CName=?)";

    public static ClassInfo makeDefaultClassInfo(String _sDeptClassInfoRootName, User _currUser) throws WCMException {
        IDepartmentMgr departmentMgr = (IDepartmentMgr)DreamFactory.createObjectById("IDepartmentMgr");
        Groups deptGroupTree = departmentMgr.getDeptGroupTree(_currUser);
        if (deptGroupTree.size() < 2) {
            return null;
        }
        WCMFilter filter = new WCMFilter("XWCMClassInfo a", WHERE_QUERY_GROUP_ID_BY_PATH, "");
        filter.addSearchValues(((Group)deptGroupTree.getAt(0)).getName());
        filter.addSearchValues(((Group)deptGroupTree.getAt(1)).getName());
        filter.addSearchValues(_sDeptClassInfoRootName);
        filter.setMaxRowNumber(1);
        ClassInfos classInfos = ClassInfos.openWCMObjs(null, filter);
        if (classInfos.isEmpty()) {
            return null;
        }
        return (ClassInfo)classInfos.getAt(0);
    }

    @Override
    public Channel makeDefaultChannel(User _loginUser, int _nViewId) throws WCMException {
        IDepartmentMgr departmentMgr = (IDepartmentMgr)DreamFactory.createObjectById("IDepartmentMgr");
        Groups deptGroupTree = departmentMgr.getDeptGroupTree(_loginUser);
        if (deptGroupTree.isEmpty()) {
            return UserRelateInfoMaker.findByDefaultChannel();
        }
        Group tempGroup = (Group)deptGroupTree.getAt(deptGroupTree.size() - 1);
        WebSite site = UserRelateInfoMaker.findSiteByName(tempGroup.getName());
        if (site == null) {
            return UserRelateInfoMaker.findByDefaultChannel();
        }
        int nSize = deptGroupTree.size() - 1;
        for (int i = 0; i < nSize; ++i) {
            Group tempGroup2 = (Group)deptGroupTree.getAt(i);
            if (tempGroup2 == null) continue;
            String sChannelName = tempGroup2.getName();
            Channel channel = Channel.findByName(site.getId(), sChannelName);
            if (channel == null) {
                sChannelName = sChannelName + tempGroup2.getId();
                channel = Channel.findByName(site.getId(), sChannelName);
            }
            if (channel == null) continue;
            return channel;
        }
        return UserRelateInfoMaker.findByDefaultChannel();
    }

    @Override
    public int[] registerViewIds() {
        MetaView oMetaView = null;
        int nGovInfoViewId = 39;
        try {
            oMetaView = GovInfoViewFinder.findMetaViewOfGovInfo(null);
            if (oMetaView != null) {
                nGovInfoViewId = oMetaView.getId();
            }
        }
        catch (WCMException e) {
            logger.error((Object)"\u83b7\u53d6\u653f\u5e9c\u4fe1\u606f\u516c\u5f00\u89c6\u56fe\u51fa\u73b0\u9519\u8bef\u3002", (Throwable)e);
        }
        return new int[]{nGovInfoViewId};
    }

    private static Channel findByDefaultChannel() throws WCMException {
        String sDefaultChannel = ConfigServer.getServer().getSysConfigValue("DEFAULT_CHANNEL", "0");
        int nDefaultChannelId = Integer.parseInt(sDefaultChannel);
        Channel channel = Channel.findById(nDefaultChannelId);
        if (channel == null) {
            logger.error((Object)I18NMessage.get(UserRelateInfoMaker.class, "UserRelateInfoMaker.label1", "\u6ca1\u6709\u6307\u5b9a\u9ed8\u8ba4\u680f\u76ee"));
        }
        return channel;
    }

    private static WebSite findSiteByName(String _sSiteName) throws WCMException {
        WCMFilter filterBySiteName = new WCMFilter("", "SiteName=?", "");
        filterBySiteName.addSearchValues(_sSiteName);
        WebSites sites = WebSites.openWCMObjs(null, filterBySiteName);
        if (sites.isEmpty()) {
            return null;
        }
        return (WebSite)sites.getAt(0);
    }
}

