/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.definition.IMetaViewFieldGroupMgr;
import com.trs.components.metadata.definition.MetaViewFieldGroup;
import com.trs.components.metadata.definition.MetaViewFieldGroups;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;

public class MetaViewFieldGroupServiceProvider
implements ISelfDefinedServiceProvider {
    private IMetaViewFieldGroupMgr m_oMetaViewFieldGroupMgr = (IMetaViewFieldGroupMgr)DreamFactory.createObjectById("IMetaViewFieldGroupMgr");

    public Reports deleteMetaViewFieldGroups(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        if (!loginUser.isAdministrator()) {
            throw new WCMException(1002, I18NMessage.get(MetaViewFieldGroupServiceProvider.class, "MetaViewFieldGroupServiceProvider.label2", "\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u6743\u9650\u5220\u9664\u5b57\u6bb5\u5206\u7ec4\uff01"));
        }
        String sMetaViewFieldGroupIds = _methodContext.getValue("MetaViewFieldGroupIds");
        MetaViewFieldGroups currMetaViewFieldGroups = MetaViewFieldGroups.findByIds(loginUser, sMetaViewFieldGroupIds);
        Reports reports = new Reports(I18NMessage.get(MetaViewFieldGroupServiceProvider.class, "MetaViewFieldGroupServiceProvider.label8", "\u5220\u9664\u5b57\u6bb5\u5206\u7ec4"));
        int nSize = currMetaViewFieldGroups.size();
        for (int i = 0; i < nSize; ++i) {
            MetaViewFieldGroup oMetaViewFieldGroup = (MetaViewFieldGroup)currMetaViewFieldGroups.getAt(i);
            if (oMetaViewFieldGroup == null) continue;
            try {
                this.m_oMetaViewFieldGroupMgr.delete(loginUser, oMetaViewFieldGroup);
                reports.addSucessedReport(I18NMessage.get(MetaViewFieldGroupServiceProvider.class, "MetaViewFieldGroupServiceProvider.label9", "\u5220\u9664\u5b57\u6bb5\u5206\u7ec4[") + oMetaViewFieldGroup.getGroupName() + "][" + I18NMessage.get(MetaViewFieldGroupServiceProvider.class, "MetaViewFieldGroupServiceProvider.label5", "]\u6210\u529f\uff01"));
                continue;
            }
            catch (Exception e) {
                reports.addFailedReport(I18NMessage.get(MetaViewFieldGroupServiceProvider.class, "MetaViewFieldGroupServiceProvider.label9", "\u5220\u9664\u5b57\u6bb5\u5206\u7ec4[") + oMetaViewFieldGroup.getGroupName() + "][" + I18NMessage.get(MetaViewFieldGroupServiceProvider.class, "MetaViewFieldGroupServiceProvider.label6", "]\u5931\u8d25\uff01"), e);
            }
        }
        return reports;
    }

    private User getLoginUser() {
        User loginUser = ContextHelper.getLoginUser();
        return loginUser;
    }
}

