/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.center.MetaViewDatas;
import com.trs.components.metadata.center.xml.MetaViewDataToExcel;
import com.trs.components.metadata.center.xml.MetaViewDataToXML;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.persistent.BaseObjToXmlConverterForSpecialProperty;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyZip;
import com.trs.infra.util.CPager;
import java.util.ArrayList;
import java.util.Hashtable;

public class MetaViewDataExporter4MuchData {
    public static final int THREADS_HOLD = 500;
    private int m_nDataCount;
    private boolean m_bWithAppendix;
    private boolean m_bExportAsXml;

    public MetaViewDataExporter4MuchData(int _nDataCount, boolean _bWithAppendix, boolean _bExportAsXml) {
        this.m_nDataCount = _nDataCount;
        this.m_bWithAppendix = _bWithAppendix;
        this.m_bExportAsXml = _bExportAsXml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportData(Channels _oChannels, MetaView _oView, String _sSelectFields, WCMFilter _oFilter) throws Exception {
        BaseObjToXmlConverterForSpecialProperty converter = null;
        converter = this.m_bExportAsXml ? new MetaViewDataToXML(_oView) : new MetaViewDataToExcel(_oView);
        FilesMan filesMan = FilesMan.getFilesMan();
        CMyZip oMyZip = new CMyZip();
        String sZipFile = filesMan.getNextFileName("ST", "zip", null, true);
        oMyZip.setZipFileName(sZipFile);
        CPager currPager = new CPager(500);
        currPager.setItemCount(this.m_nDataCount);
        int nPageCount = currPager.getPageCount();
        for (int nPageIndex = 1; nPageIndex <= nPageCount; ++nPageIndex) {
            MetaViewDatas oViewDatas = new MetaViewDatas(_oView);
            oViewDatas.setPageSize(500);
            oViewDatas.setCurrPage(nPageIndex);
            currPager.setCurrentPageIndex(nPageIndex);
            oViewDatas.open(_oChannels, _oFilter);
            MetaViewDatas datas = new MetaViewDatas();
            datas.setMetaView(_oView);
            for (int i = currPager.getFirstItemIndex(); i <= currPager.getLastItemIndex(); ++i) {
                Document document;
                MetaViewData oViewData = (MetaViewData)oViewDatas.getAt(i - 1);
                if (oViewData == null || (document = Document.findById(oViewData.getDocumentId(), "DocTitle,DocContent")) == null) continue;
                Hashtable<String, Object> props = oViewData.getProperties();
                props.put("DOCTITLE", CMyString.showNull(document.getTitle()));
                props.put("DOCCONTENT", CMyString.showNull(document.getContent()));
                datas.addElement(oViewData);
            }
            String sFileName = filesMan.getNextFileName("ST", this.m_bExportAsXml ? "xml" : "xls", null, true);
            converter.toXMLFile(datas, sFileName, null, _sSelectFields);
            try {
                oMyZip.addToZip(sFileName, false);
            }
            finally {
                CMyFile.deleteFile(sFileName);
            }
            if (!this.m_bWithAppendix) continue;
            ArrayList apdfiles = null;
            apdfiles = this.m_bExportAsXml ? ((MetaViewDataToXML)converter).getAppFiles() : ((MetaViewDataToExcel)converter).getAppFiles();
            if (apdfiles == null || apdfiles.isEmpty()) continue;
            for (int i = apdfiles.size() - 1; i >= 0; --i) {
                sFileName = (String)apdfiles.get(i);
                sFileName = filesMan.mapFilePath(sFileName, 0) + sFileName;
                oMyZip.addToZip(sFileName, false);
            }
            apdfiles.clear();
        }
        oMyZip.done();
        return CMyFile.extractFileName(sZipFile);
    }
}

