/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.IDepartmentMgr;
import com.trs.cms.auth.domain.IObjectMemberMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowEmployMgr;
import com.trs.cms.process.definition.Flows;
import com.trs.components.common.publish.domain.template.TemplateCacheMgr;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.domain.template.TemplateImporter;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IClassInfoMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.service.ClassInfoToGroupCreator;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.publish.WCMPubStatusConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ClassInfoToChannelHelper {
    private static Logger m_oLogger = Logger.getLogger(ClassInfoToChannelHelper.class);
    private static final long RIGHTVALUE_WITH_MGR = 540092153856L;
    private static final long RIGHTVALUE_ONLY_BROWER = 16384L;
    private static final long RIGHT_VALUE_WITH_ADDDOC = 0xC0004000L;
    private static final String SQL_QUERY_GROUP_ID_BY_PATH = "select GroupId from WCMGroup a where GName=? and exists(select 1 from WCMGroup b where b.GName=? and b.GroupId=a.ParentId)";
    private static IMetaViewEmployerMgr m_oMetaViewEmployerMgr;
    private static IClassInfoMgr m_oClassInfoMgr;
    private static IObjectMemberMgr m_oObjectMemberMgr;
    private static Flow s_oFlow;

    private static IMetaViewEmployerMgr getMetaViewEmployerMgr() {
        if (m_oMetaViewEmployerMgr == null) {
            m_oMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
        }
        return m_oMetaViewEmployerMgr;
    }

    private static IClassInfoMgr getClassInfoMgr() {
        if (m_oClassInfoMgr == null) {
            m_oClassInfoMgr = (IClassInfoMgr)DreamFactory.createObjectById("IClassInfoMgr");
        }
        return m_oClassInfoMgr;
    }

    private static IObjectMemberMgr getObjectMemberMgr() {
        if (m_oObjectMemberMgr == null) {
            m_oObjectMemberMgr = (IObjectMemberMgr)DreamFactory.createObjectById("IObjectMemberMgr");
        }
        return m_oObjectMemberMgr;
    }

    public static void createSites(ClassInfo _oParentClassInfo, MetaView _oView, int _nMaxLevel, String _sRootDomain) throws WCMException {
        if (_oParentClassInfo == null) {
            throw new WCMException(I18NMessage.get(ClassInfoToChannelHelper.class, "ClassInfoToChannelHelper.label1", "\u6ca1\u6709\u6307\u5b9a\u5bf9\u5e94\u7684\u5206\u7c7b"));
        }
        User currUser = ContextHelper.getLoginUser();
        IClassInfoMgr oClassInfoMgr = ClassInfoToChannelHelper.getClassInfoMgr();
        ClassInfos oChildren = oClassInfoMgr.queryChildren(currUser, _oParentClassInfo, null);
        for (int i = oChildren.size() - 1; i >= 0; --i) {
            WebSite currSite;
            ClassInfo child = (ClassInfo)oChildren.getAt(i);
            if (child == null || (currSite = ClassInfoToChannelHelper.findSiteByName(child.getName())) != null) continue;
            currSite = ClassInfoToChannelHelper.newSite(currUser, child.getName(), _sRootDomain);
            ClassInfoToChannelHelper.importTemplates(currSite);
            ClassInfoToChannelHelper.setDefaultOulineTemplate(currSite, "publicInformationSiteHome");
            ClassInfoToChannelHelper.setOtherOulineTemplates(currSite, new String[]{"navigationHomePage"});
            ClassInfoToChannelHelper.setDetailTemplate(currSite, "detail");
            ClassInfoToChannelHelper.createChildChannels(child, currSite, _oView, _nMaxLevel, 2);
        }
    }

    public static void createChannels(ClassInfo _oParentClassInfo, BaseChannel _host, MetaView _oView, int _nMaxLevel) throws WCMException {
        if (_oParentClassInfo == null || _host == null) {
            throw new WCMException(I18NMessage.get(ClassInfoToChannelHelper.class, "ClassInfoToChannelHelper.label5", "\u6ca1\u6709\u6307\u5b9a\u5bf9\u5e94\u7684\u5206\u7c7b\u6216\u8005\u680f\u76ee\u7684Host"));
        }
        ClassInfoToChannelHelper.createChildChannels(_oParentClassInfo, _host, _oView, _nMaxLevel, 1);
    }

    private static void createChildChannels(ClassInfo _oParentClassInfo, BaseChannel _host, MetaView _oView, int _nMaxLevel, int _nLevel) throws WCMException {
        if (_nMaxLevel > 0 && _nLevel > _nMaxLevel) {
            return;
        }
        User currUser = ContextHelper.getLoginUser();
        IClassInfoMgr oClassInfoMgr = ClassInfoToChannelHelper.getClassInfoMgr();
        ClassInfos oChildren = oClassInfoMgr.queryChildren(currUser, _oParentClassInfo, null);
        int nSize = oChildren.size();
        for (int i = 0; i < nSize; ++i) {
            long lRightValue;
            ClassInfo childClassInfo = (ClassInfo)oChildren.getAt(i);
            if (childClassInfo == null) continue;
            boolean bIsLeafChannel = childClassInfo.isLeaf() && _nLevel + 1 > _nMaxLevel;
            String sChnlName = childClassInfo.getName();
            Channel oChannel = ClassInfoToChannelHelper.newChannel(_host, sChnlName, sChnlName, childClassInfo.getCode(), currUser);
            Group currGroup = ClassInfoToChannelHelper.convertToGroup(oChannel, _host);
            long l = lRightValue = bIsLeafChannel ? 0xC0004000L : 16384L;
            if (bIsLeafChannel) {
                ClassInfoToChannelHelper.saveRightValue(currUser, currGroup, oChannel, lRightValue);
            } else {
                String sGroupAdmin = sChnlName + "_\u8d1f\u8d23\u4eba";
                User user = User.findByName(sGroupAdmin);
                IObjectMemberMgr oObjectMemberMgr = ClassInfoToChannelHelper.getObjectMemberMgr();
                oObjectMemberMgr.addVisible(currUser, user.getWCMType(), user.getId(), oChannel.getWCMType(), oChannel.getId());
            }
            lRightValue = 540092153856L;
            Role role = ClassInfoToChannelHelper.findRoleByName(currGroup);
            ClassInfoToChannelHelper.saveRightValue(currUser, role, oChannel, lRightValue);
            ClassInfoToChannelHelper.getMetaViewEmployerMgr().setEmployer(currUser, oChannel, _oView);
            ClassInfoToChannelHelper.setDefaultOulineTemplate(oChannel, _nLevel == 2 ? "navigationHomePage" : "interimGeneralOutline");
            ClassInfoToChannelHelper.setDetailTemplate(oChannel, "detail");
            Flow flow = ClassInfoToChannelHelper.findFlow();
            if (flow.getId() > 0) {
                FlowEmployMgr flowEmployMgr = (FlowEmployMgr)DreamFactory.createObjectById("FlowEmployMgr");
                flowEmployMgr.setFlow(oChannel, flow.getId());
            }
            ClassInfoToChannelHelper.createChildChannels(childClassInfo, oChannel, _oView, _nMaxLevel, _nLevel + 1);
        }
    }

    private static Role findRoleByName(Group _currGroup) throws WCMException {
        String sRoleName = _currGroup.getName() + "_" + ClassInfoToGroupCreator.ROLENAME_SFX_MGR;
        for (Group parentGroup = _currGroup.getParent(); parentGroup != null && parentGroup.getParentId() > 0; parentGroup = parentGroup.getParent()) {
            sRoleName = parentGroup.getName() + "_" + sRoleName;
        }
        WCMFilter filterByRoleName = new WCMFilter("", "RoleName=?", "");
        filterByRoleName.addSearchValues(sRoleName);
        Roles roles = Roles.openWCMObjs(null, filterByRoleName);
        if (roles.isEmpty()) {
            return null;
        }
        return (Role)roles.getAt(0);
    }

    private static Right saveRightValue(User _currUser, CMSObj _operator, Channel _oChannel, long _lRightValue) throws WCMException {
        if (_operator == null) {
            return null;
        }
        Right right = new Right();
        right.setOperator(_operator);
        right.setObject(_oChannel);
        right.setValue(_lRightValue);
        right.save(_currUser);
        return right;
    }

    private static Channel newChannel(BaseChannel _oHost, String _sChnlName, String _sDisplayName, String _sDataPath, User _oCrUser) throws WCMException {
        int nSiteId = _oHost.getSiteId();
        Channel currChannel = Channel.findByName(nSiteId, _sChnlName);
        if (currChannel != null) {
            return ClassInfoToChannelHelper.newChannel(_oHost, ClassInfoToChannelHelper.makeNewChannelName(_oHost, _sChnlName), _sDisplayName, _sDataPath, _oCrUser);
        }
        currChannel = Channel.createNewInstance();
        currChannel.setSite(nSiteId);
        if (_oHost.isSite()) {
            currChannel.setParent(0);
        } else {
            currChannel.setParent(_oHost.getId());
        }
        currChannel.setName(_sChnlName);
        currChannel.setDesc(_sDisplayName);
        if (currChannel.getChnlProperty() <= 0) {
            currChannel.setChnlProperty(4);
        }
        currChannel.setCrUser(_oCrUser);
        currChannel.save(_oCrUser);
        String sDataPath = null;
        sDataPath = CMyString.isEmpty(_sDataPath) ? "auto" + currChannel.getId() : _sDataPath;
        FolderPublishConfig publishConfig = FolderPublishConfig.createNewInstance();
        publishConfig.setFolder(101, currChannel.getId());
        publishConfig.setDataPath(sDataPath);
        publishConfig.save(_oCrUser);
        return currChannel;
    }

    private static String makeNewChannelName(BaseChannel _host, String _chnlName) throws WCMException {
        ArrayList<String> arParameters = new ArrayList<String>();
        arParameters.add(_host.getDesc());
        arParameters.add(_chnlName);
        int nGroupId = DBManager.getDBManager().sqlExecuteQuery(SQL_QUERY_GROUP_ID_BY_PATH, (List)arParameters, 0);
        if (nGroupId == 0) {
            return _chnlName + "_1";
        }
        return _chnlName + nGroupId;
    }

    private static WebSite newSite(User _oCrUser, String _sSiteName, String _sRootDomain) throws WCMException {
        WebSite currSite = WebSite.createNewInstance();
        currSite.setType(4);
        currSite.setName(_sSiteName);
        currSite.setDesc(_sSiteName);
        currSite.setParent(0);
        currSite.setCrUser(_oCrUser);
        currSite.save(_oCrUser);
        String sDataPath = "root" + currSite.getId();
        String sRootDomain = CMyString.setStrEndWith(_sRootDomain, '/') + sDataPath + '/';
        FolderPublishConfig publishConfig = FolderPublishConfig.createNewInstance();
        publishConfig.setFolder(103, currSite.getId());
        publishConfig.setDataPath(sDataPath);
        publishConfig.setSiteLanguage(8);
        publishConfig.setPageEncoding("utf-8");
        publishConfig.setRootDomain(sRootDomain);
        publishConfig.save(_oCrUser);
        WCMPubStatusConfig aConfig = WCMPubStatusConfig.createNewInstance();
        aConfig.setFolderType(currSite);
        aConfig.setStatusesCanDoPub("1,2,16,10");
        aConfig.setStatusIdAfterModify(16);
        aConfig.save(_oCrUser);
        return currSite;
    }

    private static WebSite findSiteByName(String _sSiteName) throws WCMException {
        WCMFilter filterBySiteName = new WCMFilter("", "SiteName=?", "");
        filterBySiteName.addSearchValues(_sSiteName);
        WebSites sites = WebSites.openWCMObjs(null, filterBySiteName);
        if (sites.isEmpty()) {
            return null;
        }
        return (WebSite)sites.getAt(0);
    }

    private static Group convertToGroup(Channel _currChannel, BaseChannel _host) throws WCMException {
        String[] pChannelPath = new String[5];
        pChannelPath[0] = _currChannel.getName();
        pChannelPath[1] = _host.getName();
        int nPathIndex = 2;
        for (BaseChannel host = _host.getHost(); host != null; host = host.getHost()) {
            pChannelPath[nPathIndex++] = host.getName();
        }
        IDepartmentMgr departmentMgr = (IDepartmentMgr)DreamFactory.createObjectById("IDepartmentMgr");
        int nParentGroupId = departmentMgr.getRootDepartmentGroup().getId();
        for (int j = pChannelPath.length - 1; j >= 0; --j) {
            String sChannelName = pChannelPath[j];
            if (sChannelName == null) continue;
            WCMFilter filter = new WCMFilter("", "ParentId=? and GName=?", "");
            filter.addSearchValues(nParentGroupId);
            filter.addSearchValues(sChannelName);
            filter.setMaxRowNumber(1);
            Groups groups = Groups.openWCMObjs(null, filter);
            if (groups.isEmpty()) {
                throw new WCMException(I18NMessage.get(ClassInfoToChannelHelper.class, "ClassInfoToChannelHelper.label7", "\u5bf9\u5e94\u4e0d\u4e0a\u7ec4\u7ec7[Name=") + sChannelName + ",ParentId=" + nParentGroupId + "]");
            }
            nParentGroupId = groups.getIdAt(0);
            if (j != 0) continue;
            return (Group)groups.getAt(0);
        }
        return null;
    }

    private static void importTemplates(WebSite _currSite) throws WCMException {
        String sWCMPath = ConfigServer.getServer().getInitProperty("WCM_PATH");
        sWCMPath = CMyString.setStrEndWith(sWCMPath, File.separatorChar);
        String sGovDataPath = sWCMPath + ConfigServer.getServer().getSysConfigValue("APP_PATH_NAME_4GOVINFO", "WCMV6") + File.separatorChar + "gkml" + File.separatorChar + "data" + File.separator;
        String sImportFile = sGovDataPath + "templates.zip";
        try {
            String sSrcFile = sImportFile;
            sImportFile = sGovDataPath + "templates_temp.zip";
            CMyFile.copyFile(sSrcFile, sImportFile);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(ClassInfoToChannelHelper.class, "ClassInfoToChannelHelper.label8", "\u62f7\u8d1d\u6587\u4ef6\u5931\u8d25"), e);
        }
        TemplateImporter importer = new TemplateImporter();
        IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_currSite);
        importer.importFromZip(folder, sImportFile, 1, 1, null);
    }

    private static void setDefaultOulineTemplate(BaseChannel _oSiteOrChannel, String _sTemplateName) throws WCMException {
        IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_oSiteOrChannel);
        TemplateCacheMgr templateCacheMgr = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
        Template template = templateCacheMgr.lookupByName(folder.getRoot(), _sTemplateName);
        if (template != null) {
            TemplateEmployMgr oEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
            oEmployMgr.setDefaultOutline(folder, template.getId());
        }
    }

    private static void setOtherOulineTemplates(BaseChannel _oSiteOrChannel, String[] _pTemplateName) throws WCMException {
        IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_oSiteOrChannel);
        TemplateCacheMgr templateCacheMgr = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
        StringBuffer sbTemplateIds = new StringBuffer();
        for (int i = 0; i < _pTemplateName.length; ++i) {
            Template template = templateCacheMgr.lookupByName(folder.getRoot(), _pTemplateName[i]);
            if (template == null) continue;
            sbTemplateIds.append(template.getId());
            sbTemplateIds.append(",");
        }
        if (sbTemplateIds.length() > 0) {
            sbTemplateIds.setLength(sbTemplateIds.length() - 1);
            TemplateEmployMgr oEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
            oEmployMgr.setOtherOutlines(User.getSystem(), folder, sbTemplateIds.toString());
        }
    }

    private static void setDetailTemplate(BaseChannel _oSiteOrChannel, String _sTemplateName) throws WCMException {
        IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_oSiteOrChannel);
        TemplateCacheMgr templateCacheMgr = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
        Template template = templateCacheMgr.lookupByName(folder.getRoot(), _sTemplateName);
        if (template != null) {
            TemplateEmployMgr oEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
            oEmployMgr.setDetailTemplate(folder, template.getId(), false);
        }
    }

    private static Flow findFlow() throws WCMException {
        if (s_oFlow == null) {
            WCMFilter filter = new WCMFilter("", "FlowName=?", "");
            filter.addSearchValues(I18NMessage.get(ClassInfoToChannelHelper.class, "ClassInfoToChannelHelper.label9", "\u4fe1\u606f\u516c\u5f00\u5ba1\u6838\u6d41\u7a0b"));
            Flows flows = Flows.openWCMObjs(null, filter);
            s_oFlow = flows.isEmpty() ? new Flow() : (Flow)flows.getAt(0);
        }
        return s_oFlow;
    }

    static {
        s_oFlow = null;
    }
}

