/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfoUtil;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IClassInfoMgr;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IFindByIdServiceProvider;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class ClassInfoServiceProviderForGB
implements ISelfDefinedServiceProvider,
IFindByIdServiceProvider {
    private IClassInfoMgr m_oClassInfoMgr = (IClassInfoMgr)DreamFactory.createObjectById("IClassInfoMgr");

    public String createClassInfoTreeHTMLOfIds(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sClassInfos = _methodContext.getValue("objectIds");
        StringBuffer sbResult = new StringBuffer(4096);
        if (_methodContext.getValue("type", 0) == 0) {
            int[] aClassInfos = CMyString.splitToInt(sClassInfos, ",");
            this.createClassInfoTreeHTMLOfIds(sbResult, aClassInfos, 0);
        } else {
            sClassInfos = this.m_oClassInfoMgr.getPath(ClassInfos.findByIds(loginUser, sClassInfos));
            int[] aClassInfos = CMyString.splitToInt(sClassInfos, ",");
            HashMap oUsedMap = new HashMap(aClassInfos.length);
            this.createClassInfoTreeHTMLOfIds(sbResult, aClassInfos, oUsedMap, 0);
        }
        return sbResult.toString();
    }

    private void createClassInfoTreeHTMLOfIds(StringBuffer _sbResult, int[] aClassInfo, int level) throws WCMException {
        if (level == aClassInfo.length) {
            return;
        }
        ClassInfo oClassInfo = ClassInfo.findById(aClassInfo[level]);
        if (oClassInfo == null) {
            return;
        }
        User loginUser = this.getLoginUser();
        ClassInfos oClassInfos = this.m_oClassInfoMgr.queryChildren(loginUser, oClassInfo, null);
        if (oClassInfos.size() <= 0) {
            return;
        }
        ++level;
        int nSize = oClassInfos.size();
        for (int i = 0; i < nSize; ++i) {
            ClassInfo _oClassInfo = (ClassInfo)oClassInfos.getAt(i);
            if (_oClassInfo == null) continue;
            if (level + 1 < aClassInfo.length && _oClassInfo.getId() == aClassInfo[level]) {
                this.appendOneClassInfoHTML(_sbResult, _oClassInfo);
                _sbResult.append("<ul>");
                this.createClassInfoTreeHTMLOfIds(_sbResult, aClassInfo, level);
                _sbResult.append("</ul>");
                continue;
            }
            this.makeClassInfoHTML(_sbResult, _oClassInfo);
        }
    }

    private void createClassInfoTreeHTMLOfIds(StringBuffer _sbResult, int[] aClassInfo, HashMap oUsedMap, int index) throws WCMException {
        if (index >= aClassInfo.length) {
            return;
        }
        if (oUsedMap.get(new Integer(aClassInfo[index])) == Boolean.TRUE) {
            this.createClassInfoTreeHTMLOfIds(_sbResult, aClassInfo, oUsedMap, index + 1);
            return;
        }
        oUsedMap.put(new Integer(aClassInfo[index]), Boolean.TRUE);
        ClassInfo oClassInfo = ClassInfo.findById(aClassInfo[index]);
        if (oClassInfo == null) {
            this.createClassInfoTreeHTMLOfIds(_sbResult, aClassInfo, oUsedMap, index + 1);
            return;
        }
        User loginUser = this.getLoginUser();
        this.appendOneClassInfoHTML(_sbResult, oClassInfo);
        ClassInfos oClassInfos = this.m_oClassInfoMgr.queryChildren(loginUser, oClassInfo, null);
        if (oClassInfos.size() <= 0) {
            return;
        }
        _sbResult.append("<ul>");
        ++index;
        int nSize = oClassInfos.size();
        for (int i = 0; i < nSize; ++i) {
            ClassInfo _oClassInfo = (ClassInfo)oClassInfos.getAt(i);
            if (_oClassInfo == null) continue;
            if (index < aClassInfo.length && this.isContain(aClassInfo, _oClassInfo.getId())) {
                this.createClassInfoTreeHTMLOfIds(_sbResult, aClassInfo, oUsedMap, index);
                continue;
            }
            this.makeClassInfoHTML(_sbResult, _oClassInfo);
        }
        _sbResult.append("</ul>");
        this.createClassInfoTreeHTMLOfIds(_sbResult, aClassInfo, oUsedMap, index + 1);
    }

    private boolean isContain(int[] array, int key) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != key) continue;
            return true;
        }
        return false;
    }

    public String createClassInfoTreeHTMLForGB(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nParentId = _methodContext.getValue("ParentId", 0);
        return this.createClassInfoTreeHTML(loginUser, nParentId);
    }

    public String createClassInfoTreeHTML(User _currUser, int _nParentId) throws WCMException {
        ClassInfos classInfos = this.queryClassInfos(_currUser, _nParentId, null);
        StringBuffer sbResult = new StringBuffer(51200);
        this.makeClassInfoHTML(sbResult, classInfos);
        return sbResult.toString();
    }

    public ClassInfos queryClassInfos(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nParentId = _methodContext.getValue("ParentId", 0);
        return this.queryClassInfos(loginUser, nParentId, _methodContext.getExtraWCMFilter());
    }

    public ClassInfos queryClassInfos(User _currUser, int _nParentId, WCMFilter _extraFilter) throws WCMException {
        ClassInfo parent = null;
        if (_nParentId > 0) {
            parent = this.findClassInfoById(_nParentId);
        }
        return this.m_oClassInfoMgr.queryChildren(_currUser, parent, _extraFilter);
    }

    public void deleteClassInfo(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nClassInfoId = _methodContext.getObjectId();
        if (nClassInfoId > 0) {
            this.deleteClassInfo(loginUser, nClassInfoId);
        } else {
            this.deleteClassInfo(loginUser, _methodContext.getObjectIds());
        }
    }

    public void deleteClassInfo(User _currUser, int _nClassInfoId) throws WCMException {
        ClassInfo classInfo = this.findClassInfoById(_nClassInfoId);
        this.m_oClassInfoMgr.deleteClassInfo(_currUser, classInfo);
    }

    public void deleteClassInfo(User _currUser, String _sClassInfoIds) throws WCMException {
        ClassInfos classInfos = ClassInfos.findByIds(_currUser, _sClassInfoIds);
        if (classInfos == null) {
            throw new WCMException("\u6307\u5b9a\u8282\u70b9\u6ca1\u6709\u627e\u5230\uff01");
        }
        int nSize = classInfos.size();
        for (int i = 0; i < nSize; ++i) {
            ClassInfo classInfo = (ClassInfo)classInfos.getAt(i);
            if (classInfo == null) continue;
            this.m_oClassInfoMgr.deleteClassInfo(_currUser, classInfo);
        }
    }

    public ClassInfo saveClassInfo(MethodContext _context) throws WCMException {
        return this.saveClassInfo(this.getLoginUser(), _context.getObjectId(), _context.getValue("ParentId", 0), _context.getValue("PreviousId", -2), _context.getValue("Name"), _context.getValue("Desc"));
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public ClassInfo saveClassInfo(User _currUser, int _nCurrId, int _nParentId, int _nPreviousId, String _sName, String _sDesc) throws WCMException {
        ClassInfo parent = null;
        if (_nParentId > 0 && (parent = ClassInfo.findById(_nParentId)) == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff01[Id=" + _nParentId + "]");
        }
        ClassInfo classInfo = null;
        if (_nCurrId > 0) {
            classInfo = ClassInfo.findById(_nCurrId);
            if (classInfo == null) {
                throw new WCMException("\u6307\u5b9a\u4e3b\u9898\u6ca1\u6709\u627e\u5230\uff01[ID=" + _nCurrId + "]");
            }
        } else {
            classInfo = ClassInfo.createNewInstance();
            classInfo.setParentId(_nParentId);
            if (parent != null) {
                classInfo.setRootId(parent.isRoot() ? parent.getId() : parent.getRootId());
            } else {
                classInfo.setRootId(0);
            }
        }
        if (_sName != null) {
            classInfo.setName(_sName);
        }
        if (_sDesc != null) {
            classInfo.setDesc(_sDesc);
        }
        if (_nPreviousId == -1) {
            classInfo.setOrder(_nPreviousId);
        } else if (_nPreviousId > 0) {
            String SQL_QUERY_ORDER = "select ClassOrder from XWCMCLASSINFO where CLASSINFOID=?";
            int nOrder = DBManager.getDBManager().sqlExecuteIntQuery("select ClassOrder from XWCMCLASSINFO where CLASSINFOID=?", new int[]{_nPreviousId});
            classInfo.setOrder(nOrder);
        }
        classInfo.save(_currUser);
        return classInfo;
    }

    private void makeClassInfoHTML(StringBuffer _sbResult, ClassInfos _classInfos) throws WCMException {
        int nSize = _classInfos.size();
        for (int i = 0; i < nSize; ++i) {
            this.makeClassInfoHTML(_sbResult, (ClassInfo)_classInfos.getAt(i));
        }
    }

    private void makeClassInfoHTML(StringBuffer _sbResult, ClassInfo _classInfo) throws WCMException {
        if (_classInfo == null) {
            return;
        }
        this.appendOneClassInfoHTML(_sbResult, _classInfo);
        if (_classInfo.getParentId() == _classInfo.getRootId()) {
            return;
        }
        String SQL_QUERY_CHILD = "select CLASSINFOID from XWCMCLASSINFO where ParentId=?";
        int nId = DBManager.getDBManager().sqlExecuteIntQuery("select CLASSINFOID from XWCMCLASSINFO where ParentId=?", new int[]{_classInfo.getId()});
        if (nId > 0) {
            _sbResult.append("<ul></ul>\n");
        }
    }

    private void appendOneClassInfoHTML(StringBuffer _sbResult, ClassInfo _classInfo) {
        _sbResult.append("<div objectId=");
        _sbResult.append(_classInfo.getId());
        _sbResult.append(" id=node_");
        _sbResult.append(_classInfo.getId());
        _sbResult.append(">");
        _sbResult.append("<a href=#>");
        _sbResult.append(CMyString.transDisplay(_classInfo.getName()));
        _sbResult.append("</a></div>");
    }

    @Override
    public Object findById(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nObjectId = _methodContext.getObjectId();
        ClassInfo classInfo = null;
        classInfo = nObjectId == 0 ? ClassInfo.createNewInstance() : this.findClassInfoById(nObjectId);
        return classInfo;
    }

    private ClassInfo findClassInfoById(int _nObjectId) throws WCMException {
        ClassInfo classInfo = ClassInfo.findById(_nObjectId);
        if (classInfo == null) {
            throw new WCMException(200006, "\u6307\u5b9a\u7684\u5206\u7c7b\u4e0d\u5b58\u5728\uff01[ID=" + _nObjectId + "]");
        }
        return classInfo;
    }

    public Object exists(MethodContext _methodContext) throws WCMException {
        WCMFilter extraFilter = _methodContext.getExtraWCMFilter();
        String propertyName = CMyString.showNull(_methodContext.getValue("propertyName"), "CName");
        WCMFilter existFilter = new WCMFilter("XWCMCLASSINFO", propertyName + "=?", "", "ClassInfoID");
        existFilter.addSearchValues(_methodContext.getValue("propertyValue"));
        int classInfoId = DBManager.getDBManager().sqlExecuteIntQuery(existFilter.mergeWith(extraFilter));
        if (classInfoId > 0) {
            return ClassInfo.findById(classInfoId);
        }
        return null;
    }

    public String getPath(MethodContext _methodContext) throws WCMException {
        int classInfoId = _methodContext.getValue("objectId", 0);
        if (classInfoId == 0) {
            throw new WCMException("\u6ca1\u6709\u6307\u5b9a\u5206\u7c7b\u6cd5ID");
        }
        ClassInfo classInfo = ClassInfo.findById(classInfoId);
        if (classInfo == null) {
            throw new WCMException(200006, "\u6307\u5b9a\u7684\u5206\u7c7b\u4e0d\u5b58\u5728\uff01[ID=" + classInfoId + "]");
        }
        return this.m_oClassInfoMgr.getPath(classInfo);
    }

    public Reports importClassInfos(MethodContext _methodContext) throws Exception {
        String sImportFile = _methodContext.getValue("importFile");
        Reports oReports = new Reports("\u4ece\u6587\u4ef6[" + sImportFile + "]\u5bfc\u5165\u5206\u7c7b\u6cd5!");
        String sFileExt = CMyFile.extractFileExt(sImportFile);
        if (sFileExt == null || (sFileExt = sFileExt.trim()).length() == 0) {
            oReports.addFailedReport("\u53c2\u6570[ImportFile=" + sImportFile + "]\u4e0d\u6b63\u786e\uff01\u6ca1\u6709\u540e\u7f00\u540d", null);
            return oReports;
        }
        sFileExt = sFileExt.toUpperCase();
        String sFileName = this.getAbsoluteFileName(sImportFile);
        if (sFileExt.equals("TXT")) {
            this.importFromTXT(sFileName, oReports, _methodContext);
        } else if (sFileExt.equals("ZIP")) {
            this.importFromZIP(sFileName, oReports, _methodContext);
        } else {
            oReports.addFailedReport("\u53c2\u6570[ImportFile=" + sImportFile + "]\u540e\u7f00\u4e0d\u6b63\u786e\uff01\u4e0d\u662f.zip\u540e\u7f00\u540d", null);
            return oReports;
        }
        return oReports;
    }

    private void importFromTXT(String _sTxtFile, Reports _oReports, MethodContext _methodContext) throws Exception {
        boolean bContainCode = _methodContext.getValue("ContainCode", true);
        int importType = _methodContext.getValue("importType", 0);
        ClassInfoUtil util = new ClassInfoUtil();
        String sClassInfoName = CMyFile.extractMainFileName(_sTxtFile);
        try {
            boolean bResult = util.importClassInfos(sClassInfoName, _sTxtFile, bContainCode, importType, 0);
            if (bResult) {
                _oReports.addSucessedReport("\u6210\u529f\u5bfc\u5165\u5206\u7c7b\u6cd5\uff1a" + sClassInfoName);
            }
        }
        catch (Exception e) {
            _oReports.addFailedReport("\u5bfc\u5165\u5206\u7c7b\u6cd5[" + sClassInfoName + "]\u5931\u8d25", e);
        }
    }

    private void importFromZIP(String _sZipFile, Reports _oReports, MethodContext _methodContext) {
        String sUnZIPTempPath = CMyFile.extractFilePath(_sZipFile);
        sUnZIPTempPath = sUnZIPTempPath + "temp" + System.currentTimeMillis() + File.separator;
        try {
            CMyUnZipFile uzf = new CMyUnZipFile(_sZipFile, sUnZIPTempPath);
            try {
                uzf.addFileExtFilters("TXT");
                uzf.doUnZipAnd();
                ArrayList allTxtFiles = uzf.getFilteredFiles();
                if (allTxtFiles == null || allTxtFiles.isEmpty()) {
                    return;
                }
                String sTxtFile = null;
                for (int i = allTxtFiles.size() - 1; i >= 0; --i) {
                    sTxtFile = (String)allTxtFiles.get(i);
                    this.importFromTXT(sTxtFile, _oReports, _methodContext);
                }
            }
            catch (CMyException e) {
                _oReports.addFailedReport("Zip\u6587\u4ef6\u89e3\u538b\u5931\u8d25![File=" + _sZipFile + ",DstPath=" + sUnZIPTempPath + "]", e);
            }
        }
        catch (Exception e) {
            _oReports.addFailedReport("\u5bfc\u5165\u5206\u7c7b\u6cd5\u5931\u8d25!", e);
        }
    }

    private String getAbsoluteFileName(String _sFileName) throws WCMException {
        String sAbsolutFileName = null;
        FilesMan filesMan = FilesMan.getFilesMan();
        String[] pFlag = new String[]{"U0", "ST"};
        for (int i = 0; i < pFlag.length; ++i) {
            if (!FilesMan.isValidFile(_sFileName, pFlag[i])) continue;
            sAbsolutFileName = filesMan.mapFilePath(_sFileName, 0) + _sFileName;
            break;
        }
        if (sAbsolutFileName == null) {
            throw new WCMException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=" + _sFileName + "]");
        }
        if (!CMyFile.fileExists(sAbsolutFileName)) {
            throw new WCMException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=" + sAbsolutFileName + "]");
        }
        return sAbsolutFileName;
    }
}

