/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.publish;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagParserFolderBase;
import com.trs.components.common.publish.domain.template.TemplateCacheMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.publish.IClassInfoCountCacheForPublish;
import com.trs.components.metadata.publish.PublishFolderClassImpl;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class WCMTagParserClassInfo
extends TagParserFolderBase {
    private static Logger logger = Logger.getLogger(TagParserFolderBase.class);
    private static final int DATA_COUNT = 1;
    private static final int FULL_PATH = 2;

    @Override
    protected String[] parseHostSpecialProperty(int _nPropertyId, PublishTagContext _context) {
        if (this.m_host == null || !(this.m_host instanceof ClassInfo)) {
            return null;
        }
        switch (_nPropertyId) {
            case 1: {
                return this.queryDataCount(_context);
            }
            case 2: {
                return this.getFullPath(_context);
            }
        }
        return null;
    }

    private String[] getFullPath(PublishTagContext _context) {
        ClassInfo classInfo = (ClassInfo)this.m_host;
        String sClassName = CMyString.showNull(_context.getAttribute("class"));
        String sTarget = CMyString.showNull(_context.getAttribute("target"), "_self");
        String sDelim = CMyString.showNull(_context.getAttribute("DELIM"), "&nbsp;&gt;&nbsp;");
        boolean bAutolink = _context.getAttribute("autolink", true);
        StringBuffer sb = new StringBuffer(100);
        try {
            String sURL = this.getAutoLinkUrl(_context);
            while (classInfo != null) {
                StringBuffer sbItem = new StringBuffer(50);
                if (bAutolink) {
                    sbItem.append("<span class='");
                    sbItem.append(sClassName);
                    sbItem.append("'>");
                    sbItem.append("<a href='");
                    sbItem.append(sURL);
                    sbItem.append("' target='");
                    sbItem.append(sTarget);
                    sbItem.append("'>");
                    sbItem.append(classInfo.getName());
                    sbItem.append("</a>");
                    sbItem.append("</span>");
                } else {
                    sbItem.append("<span class='");
                    sbItem.append(sClassName);
                    sbItem.append("'>");
                    sbItem.append(classInfo.getName());
                    sbItem.append("</span>");
                }
                if (sb.length() > 0) {
                    sb.insert(0, sDelim);
                }
                sb.insert(0, sbItem);
                sURL = this.subtractURL(sURL);
                classInfo = ClassInfo.findById(classInfo.getParentId());
            }
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(WCMTagParserClassInfo.class, "WCMTagParserClassInfo.label1", "\u83b7\u53d6\u6307\u5b9a\u5206\u7c7b\u7684\u8def\u5f84\u53d1\u751f\u5f02\u5e38\uff01"), (Throwable)e);
        }
        return new String[]{sb.toString()};
    }

    private String subtractURL(String sUrl) {
        if (sUrl == null) {
            return null;
        }
        int secondIndexOf = sUrl.lastIndexOf("/");
        if (secondIndexOf < 0) {
            return sUrl;
        }
        int firstIndexOf = sUrl.lastIndexOf("/", secondIndexOf - 1);
        if (firstIndexOf < 0) {
            return sUrl;
        }
        return sUrl.substring(0, firstIndexOf) + sUrl.substring(secondIndexOf);
    }

    private String[] queryDataCount(PublishTagContext _context) {
        ClassInfo classInfo = (ClassInfo)this.m_host;
        IPublishElement oUpperHost = _context.getUpperHost();
        if (oUpperHost instanceof PublishFolderClassImpl) {
            oUpperHost = ((PublishFolderClassImpl)oUpperHost).getHost();
        }
        CMSObj oCmsObj = oUpperHost.getSubstance();
        int nChannelId = 0;
        if (oCmsObj instanceof Channel) {
            nChannelId = ((Channel)oCmsObj).getId();
        }
        try {
            String sKey = "IClassInfoCountCacheForPublish";
            IClassInfoCountCacheForPublish dataCacheMgr = (IClassInfoCountCacheForPublish)_context.getPageContext().getTaskContext().getCachObject(sKey);
            if (dataCacheMgr == null) {
                dataCacheMgr = (IClassInfoCountCacheForPublish)DreamFactory.createObjectById(sKey);
                _context.getPageContext().getTaskContext().putInCache(sKey, dataCacheMgr);
            }
            int nDataCount = 0;
            String sWhere = _context.getAttribute("where");
            if (nChannelId == 0) {
                if (CMyString.isEmpty(_context.getAttribute("where"))) {
                    nDataCount = dataCacheMgr.getClassInfoDataCountOfSite(_context.getRoot().getId(), classInfo.getId());
                } else {
                    String[] strChnl = sWhere.split(":");
                    if (strChnl.length == 2 && "CHNLID".equals(strChnl[0].toUpperCase())) {
                        try {
                            nDataCount = dataCacheMgr.getClassInfoDataCountOfSite(_context.getRoot().getId(), classInfo.getId(), Integer.parseInt(strChnl[1]));
                        }
                        catch (Exception e) {
                            throw new WCMException(I18NMessage.get(WCMTagParserClassInfo.class, "WCMTagParserClassInfo.label5", "\u83b7\u53d6\u6307\u5b9a\u680f\u76eeID\u4e0d\u662f\u6570\u5b57\u7ec4\u6210!"));
                        }
                    }
                }
            } else if (CMyString.isEmpty(_context.getAttribute("where"))) {
                nDataCount = dataCacheMgr.getClassInfoDataCountOfChannel(nChannelId, classInfo.getId());
            } else {
                String[] strSiteId = sWhere.split(":");
                if (strSiteId.length == 2 && "SITEID".equals(strSiteId[0].toUpperCase())) {
                    try {
                        nDataCount = dataCacheMgr.getClassInfoDataCountOfSite(Integer.parseInt(strSiteId[1]), classInfo.getId());
                    }
                    catch (Exception e) {
                        throw new WCMException(I18NMessage.get(WCMTagParserClassInfo.class, "WCMTagParserClassInfo.label5", "\u83b7\u53d6\u6307\u5b9a\u7ad9\u70b9ID\u4e0d\u662f\u6570\u5b57\u7ec4\u6210!"));
                    }
                }
            }
            return new String[]{String.valueOf(nDataCount)};
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(WCMTagParserClassInfo.class, "WCMTagParserClassInfo.label2", "\u83b7\u53d6\u6307\u5b9a\u5206\u7c7b\u7684\u6587\u6863\u6570\u76ee\u53d1\u751f\u5f02\u5e38\uff01"), (Throwable)e);
            return null;
        }
    }

    @Override
    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("DATACOUNT", 1);
        this.registerHostSpecialProperty("FullPath", 2);
    }

    @Override
    public TagBeanInfo getBeanInfo() {
        return null;
    }

    @Override
    protected CMSObj findHost(PublishTagContext _context) throws WCMException {
        int nClassInfoId = _context.getAttribute("ID", 0);
        String bParent = _context.getAttribute("parent");
        if (nClassInfoId > 0) {
            ClassInfo oClassInfo = ClassInfo.findById(nClassInfoId);
            if (!CMyString.isEmpty(bParent) && bParent.equalsIgnoreCase("true")) {
                return oClassInfo.getParent();
            }
            return oClassInfo;
        }
        String sClassName = _context.getAttribute("ClassInfoName");
        if (!CMyString.isEmpty(sClassName)) {
            ClassInfo oClassInfo = ClassInfo.findByName(sClassName);
            if (!CMyString.isEmpty(bParent) && bParent.equalsIgnoreCase("true")) {
                return oClassInfo.getParent();
            }
            return oClassInfo;
        }
        CMSObj upperHost = super.findHost(_context);
        if (upperHost instanceof ClassInfo) {
            if (!CMyString.isEmpty(bParent) && bParent.equalsIgnoreCase("true")) {
                ClassInfo oClassInfo = (ClassInfo)upperHost;
                return oClassInfo.getParent();
            }
            return upperHost;
        }
        if (upperHost instanceof MetaViewField) {
            MetaViewField field = (MetaViewField)upperHost;
            ClassInfo classInfo = ClassInfo.findById(field.getClassId());
            if (classInfo == null) {
                throw new WCMException(I18NMessage.get(WCMTagParserClassInfo.class, "WCMTagParserClassInfo.label3", "\u6307\u5b9a\u7684\u5206\u7c7b\u6cd5\u4e0d\u5b58\u5728\uff01[ClassId=") + field.getClassId() + "]");
            }
            return classInfo;
        }
        throw new WCMException(I18NMessage.get(WCMTagParserClassInfo.class, "WCMTagParserClassInfo.label4", "\u4e0d\u652f\u6301\u7684\u4f7f\u7528\u573a\u666f\uff01[Class=") + upperHost.getClass() + "]");
    }

    @Override
    protected String getAutoLinkUrl(PublishTagContext _context) throws WCMException {
        PublishFolderClassImpl folder = (PublishFolderClassImpl)PublishElementFactory.makeElementFrom(this.m_host);
        folder.setRoot(_context.getRoot());
        IPublishElement oUpperHost = _context.getUpperHost();
        if (oUpperHost instanceof PublishFolderClassImpl) {
            oUpperHost = ((PublishFolderClassImpl)oUpperHost).getHost();
        }
        folder.setHost(oUpperHost);
        if (folder.isLink()) {
            return folder.getLinkUrl();
        }
        Template template = null;
        String sTemplateName = _context.getAttributeTrim("TemplateName");
        if (sTemplateName != null && sTemplateName.length() > 0) {
            TemplateCacheMgr templateCacheMgr = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
            template = templateCacheMgr.lookupByName(folder.getRoot(), sTemplateName);
        }
        if (template == null && _context.getPageElement() instanceof PublishFolderClassImpl) {
            template = _context.getPageContext().getTemplate();
        }
        String sTemplateFileName = "";
        if (template != null) {
            sTemplateFileName = template.getOutputFileName();
            boolean bNameByTemplateFile = ConfigServer.getServer().getSysConfigValue("NAME_BY_TEMPLATE_FILE", "false").equalsIgnoreCase("true");
            boolean bOnlyTemplateName = "true".equalsIgnoreCase(_context.getAttribute("OnlyTemplateName"));
            if (!bOnlyTemplateName && !bNameByTemplateFile) {
                sTemplateFileName = sTemplateFileName + "_" + template.getId();
            }
            sTemplateFileName = sTemplateFileName + "." + template.getOutputFileExt();
        }
        return CMyString.setStrEndWith(_context.getPathCompass().getAbsoluteHttpPath(folder), '/') + sTemplateFileName;
    }
}

