/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.publish;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.metadata.center.ClassInfoViewMgr;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.center.MetaViewDatas;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.publish.IClassInfoCountCacheForPublish;
import com.trs.components.metadata.publish.PublishFolderClassImpl;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.IdFilterSqlUtil;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class WCMTagParserClassDocuments
extends BaseTagParser4List {
    private static Logger logger = Logger.getLogger(WCMTagParserClassDocuments.class);
    private ClassInfo m_oCurrClassInfo = null;
    private TagItem m_oTagItem = null;
    private ClassInfoViewMgr m_oCurrClassInfoViewMgr = new ClassInfoViewMgr();
    private IMetaViewEmployerMgr m_oMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
    private static ArrayList FIELDS_DEFAULT_LIST_OF_DOCUMENT = new ArrayList(16);
    private static ArrayList FIELDS_DEFAULT_LIST_OF_METADATA;

    @Override
    protected CMSBaseObjs findObjects(PublishTagContext _context) throws WCMException {
        int nStartPos;
        int nMaxNum;
        this.makeCurrClassInfo(_context);
        int nChannelId = this.makeChannelId(_context);
        int nViewId = 0;
        if ("OWNER".equalsIgnoreCase(_context.getAttribute("ViewId"))) {
            Channel channel = Channel.findById(nChannelId);
            if (channel != null) {
                MetaView view = this.m_oMetaViewEmployerMgr.getViewOfEmployer(channel);
                nViewId = view.getId();
            }
        } else {
            nViewId = _context.getAttribute("ViewId", 0);
        }
        if (nViewId > 0) {
            return this.queryViewDatas(_context, nViewId, nChannelId);
        }
        String sViewIds = _context.getAttribute("ViewIds");
        if (!CMyString.isEmpty(sViewIds)) {
            return this.queryViewDatas(_context, sViewIds, nChannelId);
        }
        String sSelectFields = this.getSelectFields("WCMDOCUMENT", "TRS_DOCUMENT", _context);
        WCMFilter filter = new WCMFilter("", "", "DocId Desc", sSelectFields);
        StringBuffer whereBuff = new StringBuffer(128);
        if (_context.isPreview()) {
            whereBuff.append("DocStatus>=1");
        } else {
            whereBuff.append("DocStatus=?");
            filter.addSearchValues(10);
        }
        if (_context.getAttribute("CHNLSELF", false) || !_context.getAttribute("All", false) && _context.getAttribute("SiteId", 0) <= 0) {
            whereBuff.append(" and DOCCHANNEL=?");
            filter.addSearchValues(nChannelId);
        }
        filter.setWhere(whereBuff.toString());
        whereBuff.setLength(0);
        boolean bOnlyLeaf = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("CLASS_DOCUMENTS_ONLY_LEAF", "true"));
        ClassInfos classInfos = new ClassInfos(null);
        if (this.m_oCurrClassInfo != null) {
            if (_context.getAttribute("ContainsChildren", false)) {
                this.makeAllChildren(this.m_oCurrClassInfo, classInfos, bOnlyLeaf);
            } else {
                classInfos.addElement(this.m_oCurrClassInfo);
            }
        }
        if ((nMaxNum = _context.getAttribute("NUM", -1)) == -1) {
            nMaxNum = 300;
            _context.getTagItem().setAttribute("NUM", nMaxNum);
        }
        if ((nStartPos = _context.getAttribute("StartPos", 0)) > 0) {
            nMaxNum += nStartPos;
        }
        int nPageSize = _context.getAttribute("PageSize", nMaxNum);
        filter.setPageSize(nPageSize);
        filter.setMaxRowNumber(nMaxNum);
        DebugTimer timer = new DebugTimer();
        timer.start();
        Documents documents = this.m_oCurrClassInfoViewMgr.queryDocuments(null, classInfos, filter);
        timer.stop();
        if (timer.getTime() >= 1000L && logger.isDebugEnabled()) {
            logger.debug((Object)("========Query documents of classinfos use[" + timer.getTime() + "]ms!========="));
            logger.debug((Object)documents.getFilter());
            logger.debug((Object)"========PageElement Info=========");
            logger.debug((Object)_context.getPageContext().getPageElement().getInfo());
            logger.debug((Object)"========Template Info=========");
            logger.debug((Object)_context.getPageContext().getTemplate());
            logger.debug((Object)"========TagItem Info=========");
            logger.debug((Object)_context.getTagItem());
        }
        return documents;
    }

    private void makeAllChildren(ClassInfo _parentClassInfo, ClassInfos _recordClassInfos, boolean _bOnlyLeaf) throws WCMException {
        ClassInfos children = _parentClassInfo.getChildren(true);
        int nSize = children.size();
        int nChildSize = 0;
        for (int nIndex = 0; nIndex < nSize; ++nIndex) {
            ClassInfo child = (ClassInfo)children.getAt(nIndex);
            if (child == null) continue;
            ++nChildSize;
            this.makeAllChildren(child, _recordClassInfos, _bOnlyLeaf);
        }
        if (_bOnlyLeaf) {
            if (nChildSize == 0) {
                _recordClassInfos.addElement(_parentClassInfo);
            }
        } else {
            _recordClassInfos.addElement(_parentClassInfo);
        }
    }

    private CMSBaseObjs queryViewDatas(PublishTagContext _context, String _sViewIds, int _nChannelId) throws WCMException {
        int nDataCount;
        int nStartPos;
        String sOrderBy;
        int[] aViewIds = CMyString.splitToInt(_sViewIds, ",");
        MetaView view = MetaView.findById(aViewIds[0]);
        if (view == null) {
            throw new WCMException(I18NMessage.get(WCMTagParserClassDocuments.class, "WCMTagParserClassDocuments.label9", "\u6307\u5b9a\u7684\u89c6\u56fe\u4e0d\u5b58\u5728\uff01[\u89c6\u56feId=") + aViewIds[0] + "]");
        }
        String sTableName = view.getTrueTableName();
        ClassInfos classInfos = this.makeClassInfos(_context);
        String sChnlDocTimeLimitWhere = "";
        int nPublishDay = _context.getAttribute("QUERYDAY", -1);
        int nTimeRange = _context.getAttribute("TimeRange", -1);
        CMyDateTime dtStartTime = null;
        CMyDateTime dtEndTime = null;
        try {
            if (nPublishDay >= 0) {
                String sDate = CMyDateTime.now().dateAdd(3, -nPublishDay).toString("yyyy-MM-dd");
                dtEndTime = new CMyDateTime();
                dtEndTime.setDateTimeWithString(sDate + " 23:59:59", "yyyy-MM-dd HH:mm:ss");
                dtStartTime = new CMyDateTime();
                dtStartTime.setDateTimeWithString(sDate + " 00:00:00", "yyyy-MM-dd HH:mm:ss");
                sChnlDocTimeLimitWhere = " and (WCMChnlDoc.CrTime>=? and WCMChnlDoc.CrTime<=?)";
            } else if (nTimeRange >= 0) {
                dtStartTime = CMyDateTime.now().dateAdd(3, -nTimeRange);
                sChnlDocTimeLimitWhere = " and WCMChnlDoc.CrTime>=?";
            }
        }
        catch (Exception sDate) {
            // empty catch block
        }
        String sClassWhere = "select 1 from XWCMClassInfoView where XWCMClassInfoView.ViewId in (" + _sViewIds + ")" + this.appendClassInfos(classInfos);
        String sChnlDocWhere = "select 1 from WCMChnlDoc where WCMChnlDoc.DocStatus" + (_context.isPreview() ? ">0" : "=?") + sChnlDocTimeLimitWhere + (_nChannelId > 0 ? " and WCMChnlDoc.ChnlId=?" : " and exists(select 1 from WCMChannel where WCMChannel.SiteId=? and WCMChnlDoc.ChnlId=WCMChannel.ChannelId)");
        String sGetMetaViewDatasWhere = "exists(" + sChnlDocWhere + " and " + sTableName + ".MetaDataId=WCMChnlDoc.DocId) and exists(" + sClassWhere + " and " + sTableName + ".MetaDataId = XWCMClassInfoView.MetaDataId)";
        String sExtraWhere = _context.getAttribute("Where");
        if (!CMyString.isEmpty(sExtraWhere)) {
            sGetMetaViewDatasWhere = sGetMetaViewDatasWhere + " and (" + sExtraWhere + ")";
        }
        if (CMyString.isEmpty(sOrderBy = _context.getAttribute("Order"))) {
            sOrderBy = "MetaDataId desc";
        }
        WCMFilter filter = new WCMFilter(view.getTrueTableName(), sGetMetaViewDatasWhere, sOrderBy);
        if (!_context.isPreview()) {
            filter.addSearchValues(10);
        }
        if (_nChannelId > 0) {
            filter.addSearchValues(_nChannelId);
        } else {
            int nSiteId = WCMTagParserClassDocuments.makeRootId(_context);
            filter.addSearchValues(nSiteId);
        }
        logger.debug((Object)filter);
        MetaViewDatas viewdatas = new MetaViewDatas(view);
        String sSelectFields = this.getSelectFields(sTableName.toUpperCase(), "TRS_VIEWDATA", _context);
        viewdatas.setSelectFieldsOfMetaTable(sSelectFields);
        int nMaxNum = _context.getAttribute("NUM", -1);
        if (nMaxNum == -1) {
            nMaxNum = 300;
            _context.getTagItem().setAttribute("NUM", nMaxNum);
        }
        if ((nStartPos = _context.getAttribute("StartPos", 0)) > 0) {
            nMaxNum += nStartPos;
        }
        viewdatas.setPageSize(nMaxNum);
        viewdatas.setMaxBufferSize(nMaxNum);
        int nPageSize = _context.getAttribute("PageSize", 0);
        WCMFilter countFilter = null;
        if (sChnlDocTimeLimitWhere.length() > 5 && nPageSize > 0 && viewdatas.size() > nPageSize) {
            countFilter = new WCMFilter();
            String sCountWhere = filter.getWhere();
            sCountWhere = CMyString.replaceStr(sCountWhere, sChnlDocTimeLimitWhere, "");
            countFilter.setWhere(sCountWhere);
            countFilter.setFrom(filter.getFrom());
            countFilter.addSearchValues(0);
            countFilter.getSearchValues().remove(0);
            List lSearchValues = filter.getSearchValues();
            int nSize = lSearchValues.size();
            for (int i = 0; i < nSize; ++i) {
                Object oValue = lSearchValues.get(i);
                if (oValue instanceof CMyDateTime) continue;
                countFilter.getSearchValues().add(oValue);
            }
        }
        if (CMyString.isEmpty(sExtraWhere) && (nDataCount = this.makeRecordCount(_context, _nChannelId)) >= 0) {
            viewdatas.setRecCount(nDataCount);
            if (nDataCount == 0) {
                return viewdatas;
            }
        }
        viewdatas.open(filter, countFilter);
        return viewdatas;
    }

    private String appendClassInfos(ClassInfos classInfos) {
        if (classInfos == null || classInfos.isEmpty()) {
            return "";
        }
        return " and " + IdFilterSqlUtil.makeAsString("XWCMClassInfoView.ClassInfoId", classInfos.getIdListAsString());
    }

    private static int makeRootId(PublishTagContext _context) throws WCMException {
        int nSiteId = _context.getAttribute("SiteId", 0);
        if (nSiteId <= 0) {
            nSiteId = _context.getRoot().getId();
        }
        return nSiteId;
    }

    private int makeRecordCount(PublishTagContext _context, int _nChannelId) throws WCMException {
        boolean bMultClassInfoInOneField = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("MULT_CLASSINFO_IN_ONEFIELD", "false"));
        if (bMultClassInfoInOneField) {
            return -1;
        }
        if (_nChannelId == 0 && _context.getAttribute("IgnoreSite", false)) {
            return -1;
        }
        String sKey = "IClassInfoCountCacheForPublish";
        IClassInfoCountCacheForPublish dataCacheMgr = (IClassInfoCountCacheForPublish)_context.getPageContext().getTaskContext().getCachObject(sKey);
        if (dataCacheMgr == null) {
            dataCacheMgr = (IClassInfoCountCacheForPublish)DreamFactory.createObjectById(sKey);
            _context.getPageContext().getTaskContext().putInCache(sKey, dataCacheMgr);
        }
        if (this.m_oCurrClassInfo == null || !this.m_oCurrClassInfo.isLeaf() && _context.getAttribute("ContainsChildren", false)) {
            return -1;
        }
        int nDataCount = 0;
        if (_nChannelId == 0) {
            int nSiteId = WCMTagParserClassDocuments.makeRootId(_context);
            nDataCount = dataCacheMgr.getClassInfoDataCountOfSite(nSiteId, this.m_oCurrClassInfo.getId());
        } else {
            nDataCount = dataCacheMgr.getClassInfoDataCountOfChannel(_nChannelId, this.m_oCurrClassInfo.getId());
        }
        return nDataCount;
    }

    private CMSBaseObjs queryViewDatas(PublishTagContext _context, int _nViewId, int _nChannelId) throws WCMException {
        int nDataCount;
        int nStartPos;
        MetaView view = MetaView.findById(_nViewId);
        if (view == null) {
            throw new WCMException(I18NMessage.get(WCMTagParserClassDocuments.class, "WCMTagParserClassDocuments.label1", "\u6307\u5b9a\u7684\u89c6\u56fe\u4e0d\u5b58\u5728\uff01[\u89c6\u56feId=") + _nViewId + "]");
        }
        ClassInfos classInfos = this.makeClassInfos(_context);
        ClassInfos extraClassInfos = this.makeExtraFilterClassInfos(_context);
        WCMFilter[] pFilter = this.makeFilter(_context, view, _nChannelId, classInfos, extraClassInfos);
        MetaViewDatas viewdatas = new MetaViewDatas(view);
        String sSelectFields = this.getSelectFields(view.getTrueTableName().toUpperCase(), "TRS_VIEWDATA", _context);
        viewdatas.setSelectFieldsOfMetaTable(sSelectFields);
        int nMaxNum = _context.getAttribute("NUM", -1);
        if (nMaxNum == -1) {
            nMaxNum = 300;
            _context.getTagItem().setAttribute("NUM", nMaxNum);
        }
        if ((nStartPos = _context.getAttribute("StartPos", 0)) > 0) {
            nMaxNum += nStartPos;
        }
        viewdatas.setPageSize(nMaxNum);
        viewdatas.setMaxBufferSize(nMaxNum);
        String sExtraWhere = _context.getAttribute("Where");
        if (CMyString.isEmpty(sExtraWhere) && extraClassInfos.isEmpty() && CMyString.isEmpty(_context.getAttribute("FilterByType")) && (nDataCount = this.makeRecordCount(_context, _nChannelId)) >= 0) {
            viewdatas.setRecCount(nDataCount);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(":::::::::nDataCount:" + nDataCount));
            }
            if (nDataCount == 0) {
                return viewdatas;
            }
        }
        try {
            boolean debug = logger.isDebugEnabled();
            DebugTimer timer = null;
            if (debug) {
                timer = new DebugTimer();
                timer.start();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("pFilter[0]:" + pFilter[0]));
                logger.debug((Object)("pFilter[1]:" + pFilter[1]));
            }
            viewdatas.open(pFilter[0], pFilter[1]);
            if (debug && timer != null) {
                timer.stop();
                logger.debug((Object)("Query Data of " + this.m_oCurrClassInfo + "[ViewId=" + _nViewId + "] use[" + timer.getTime() + "]ms"));
            }
        }
        catch (Exception e) {
            logger.error((Object)(I18NMessage.get(WCMTagParserClassDocuments.class, "WCMTagParserClassDocuments.label2", "\u83b7\u53d6\u6570\u636e\u5931\u8d25\uff01[size=") + viewdatas.size() + "][CurrClassInfo:" + this.m_oCurrClassInfo + "]\n[First Filter: " + pFilter[0] + "]\n[Second Filter: " + pFilter[1] + "]"), (Throwable)e);
            throw new WCMException(I18NMessage.get(WCMTagParserClassDocuments.class, "WCMTagParserClassDocuments.label3", "\u83b7\u53d6\u6570\u636e\u5931\u8d25\uff01[CurrClassInfo:") + this.m_oCurrClassInfo + "]\n[First Filter: " + pFilter[0] + "]\n[Second Filter: " + pFilter[1] + "]", e);
        }
        return viewdatas;
    }

    private int makeChannelId(PublishTagContext _context) throws WCMException {
        int nChannelId = 0;
        IPublishElement pageElement = _context.getPageElement();
        IPublishElement upperHost = _context.getUpperHost();
        if (upperHost instanceof PublishFolderClassImpl) {
            upperHost = ((PublishFolderClassImpl)upperHost).getHost();
        }
        if (pageElement.getType() == 101) {
            nChannelId = pageElement.getId();
        } else if (pageElement.getType() == 694710472 && upperHost.getType() == 101) {
            nChannelId = upperHost.getId();
        }
        int nChannelIdOfTag = _context.getAttribute("ChannelId", 0);
        if (nChannelIdOfTag != 0) {
            nChannelId = nChannelIdOfTag;
        }
        if (_context.getAttribute("All", false) || _context.getAttribute("SiteId", 0) > 0) {
            nChannelId = 0;
        }
        if (nChannelId > 0) {
            this.m_oCurrFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(Channel.findById(nChannelId));
        }
        return nChannelId;
    }

    private ClassInfos makeClassInfos(PublishTagContext _context) throws WCMException {
        ClassInfos classInfos = new ClassInfos(null);
        if (this.m_oCurrClassInfo == null) {
            return classInfos;
        }
        if (!_context.getAttribute("ContainsChildren", false)) {
            classInfos.addElement(this.m_oCurrClassInfo);
            return classInfos;
        }
        boolean bOnlyLeaf = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("CLASS_DOCUMENTS_ONLY_LEAF", "true"));
        if (!bOnlyLeaf) {
            classInfos.addElement(this.m_oCurrClassInfo);
        }
        this.makeAllChildren(this.m_oCurrClassInfo, classInfos, bOnlyLeaf);
        return classInfos;
    }

    private ClassInfos makeExtraFilterClassInfos(PublishTagContext _context) throws WCMException {
        ClassInfos classInfos = new ClassInfos(null);
        if (!(_context.getPageElement().getSubstance() instanceof ClassInfo)) {
            return classInfos;
        }
        if (!_context.getAttribute("FilterByPage", false)) {
            return classInfos;
        }
        ClassInfo pageClassInfo = (ClassInfo)_context.getPageElement().getSubstance();
        if (this.m_oCurrClassInfo != null && pageClassInfo.getId() == this.m_oCurrClassInfo.getId()) {
            return classInfos;
        }
        if (!_context.getAttribute("ContainsChildren", false)) {
            classInfos.addElement(pageClassInfo);
            return classInfos;
        }
        boolean bOnlyLeaf = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("CLASS_DOCUMENTS_ONLY_LEAF", "true"));
        if (!bOnlyLeaf) {
            classInfos.addElement(pageClassInfo);
        }
        this.makeAllChildren(pageClassInfo, classInfos, bOnlyLeaf);
        return classInfos;
    }

    private WCMFilter[] makeFilter(PublishTagContext _context, MetaView _view, int _nChannelId, ClassInfos _classInfos, ClassInfos _extraClassInfos) throws WCMException {
        String sOrderBy;
        String sExtraWhere;
        String sTableName = _view.getTrueTableName();
        String sChnlDocTimeLimitWhere = "";
        int nPublishDay = _context.getAttribute("QUERYDAY", -1);
        int nTimeRange = _context.getAttribute("TimeRange", -1);
        CMyDateTime dtStartTime = null;
        CMyDateTime dtEndTime = null;
        try {
            if (nPublishDay >= 0) {
                String sDate = CMyDateTime.now().dateAdd(3, -nPublishDay).toString("yyyy-MM-dd");
                dtEndTime = new CMyDateTime();
                dtEndTime.setDateTimeWithString(sDate + " 23:59:59", "yyyy-MM-dd HH:mm:ss");
                dtStartTime = new CMyDateTime();
                dtStartTime.setDateTimeWithString(sDate + " 00:00:00", "yyyy-MM-dd HH:mm:ss");
                sChnlDocTimeLimitWhere = " and (WCMChnlDoc.CrTime>=? and WCMChnlDoc.CrTime<=?)";
            } else if (nTimeRange >= 0) {
                dtStartTime = CMyDateTime.now().dateAdd(3, -nTimeRange);
                sChnlDocTimeLimitWhere = " and WCMChnlDoc.CrTime>=?";
            }
        }
        catch (Exception sDate) {
            // empty catch block
        }
        boolean bIgnoreSite = _context.getAttribute("ignoreSite", false);
        String sClassWhere = "select 1 from XWCMClassInfoView where XWCMClassInfoView.ViewId=?" + this.appendClassInfos(_classInfos);
        String sExtraClassWhere = null;
        if (!_extraClassInfos.isEmpty()) {
            sExtraClassWhere = "select 1 from XWCMClassInfoView where XWCMClassInfoView.ViewId=?" + this.appendClassInfos(_extraClassInfos);
        }
        String sChnlDocWhere = "select 1 from WCMChnlDoc where WCMChnlDoc.DocStatus" + (_context.isPreview() ? ">0" : "=?") + sChnlDocTimeLimitWhere + (_nChannelId == 0 ? " and WCMCHNLDOC.CHNLID>=1 and WCMCHNLDOC.DOCCHANNEL>=1" : " and WCMChnlDoc.ChnlId=?") + (_nChannelId > 0 || bIgnoreSite ? "" : " and exists(select 1 from WCMChannel where WCMChannel.SiteId=? and WCMChnlDoc.ChnlId=WCMChannel.ChannelId)");
        String sGetMetaViewDatasWhere = "exists(" + sChnlDocWhere + " and " + sTableName + ".MetaDataId=WCMChnlDoc.DocId)";
        sGetMetaViewDatasWhere = sGetMetaViewDatasWhere + " and exists(" + sClassWhere + " and " + sTableName + ".MetaDataId=XWCMClassInfoView.MetaDataId)";
        if (sExtraClassWhere != null) {
            sGetMetaViewDatasWhere = sGetMetaViewDatasWhere + " and exists(" + sExtraClassWhere + " and " + sTableName + ".MetaDataId=XWCMClassInfoView.MetaDataId)";
        }
        if (!CMyString.isEmpty(sExtraWhere = _context.getAttribute("Where"))) {
            sGetMetaViewDatasWhere = sGetMetaViewDatasWhere + " and (" + sExtraWhere + ")";
        }
        if (CMyString.isEmpty(sOrderBy = _context.getAttribute("Order"))) {
            sOrderBy = "MetaDataId desc";
        }
        WCMFilter filter = new WCMFilter(_view.getTrueTableName(), sGetMetaViewDatasWhere, sOrderBy);
        if (!_context.isPreview()) {
            filter.addSearchValues(10);
        }
        if (sChnlDocTimeLimitWhere.length() > 5) {
            if (dtStartTime != null) {
                filter.addSearchValues(dtStartTime);
            }
            if (dtEndTime != null) {
                filter.addSearchValues(dtEndTime);
            }
        }
        if (_nChannelId > 0) {
            filter.addSearchValues(_nChannelId);
        }
        if (!bIgnoreSite && _nChannelId == 0) {
            if (_nChannelId != 0) {
                filter.addSearchValues(Channel.findById(_nChannelId).getSiteId());
            } else {
                filter.addSearchValues(WCMTagParserClassDocuments.makeRootId(_context));
            }
        }
        filter.addSearchValues(_view.getId());
        if (sExtraClassWhere != null) {
            filter.addSearchValues(_view.getId());
        }
        if (_context.getAttribute("isdebug", false) || logger.isDebugEnabled()) {
            logger.info((Object)("debug filter: \n" + filter));
        }
        WCMFilter countFilter = null;
        if (sChnlDocTimeLimitWhere.length() > 5) {
            countFilter = new WCMFilter();
            String sCountWhere = filter.getWhere();
            sCountWhere = CMyString.replaceStr(sCountWhere, sChnlDocTimeLimitWhere, "");
            countFilter.setWhere(sCountWhere);
            countFilter.setFrom(filter.getFrom());
            countFilter.addSearchValues(0);
            countFilter.getSearchValues().remove(0);
            List lSearchValues = filter.getSearchValues();
            int nSize = lSearchValues.size();
            for (int i = 0; i < nSize; ++i) {
                Object oValue = lSearchValues.get(i);
                if (oValue instanceof CMyDateTime) continue;
                countFilter.getSearchValues().add(oValue);
            }
        }
        return new WCMFilter[]{filter, countFilter};
    }

    @Override
    protected boolean isValidate(PublishTagContext _context) throws WCMException {
        this.makeCurrClassInfo(_context);
        return true;
    }

    private void makeCurrClassInfo(PublishTagContext _context) throws WCMException {
        ClassInfo classInfo = null;
        int nClassInfoId = 0;
        IPublishElement pageElement = _context.getPageElement();
        IPublishElement upperHost = _context.getUpperHost();
        int nClassInfoIdOfTag = _context.getAttribute("ClassInfoId", 0);
        if (nClassInfoIdOfTag > 0) {
            nClassInfoId = nClassInfoIdOfTag;
            classInfo = ClassInfo.findById(nClassInfoId);
            if (classInfo == null) {
                throw new WCMException(I18NMessage.get(WCMTagParserClassDocuments.class, "WCMTagParserClassDocuments.label4", "\u6307\u5b9a\u7684\u5206\u7c7b\u6cd5\u4e0d\u5b58\u5728\uff01[ID=") + nClassInfoId + "]");
            }
        } else if (upperHost instanceof PublishFolderClassImpl) {
            nClassInfoId = upperHost.getId();
            classInfo = (ClassInfo)upperHost.getSubstance();
        } else if (pageElement.getType() == 694710472) {
            nClassInfoId = pageElement.getId();
            classInfo = (ClassInfo)pageElement.getSubstance();
        }
        this.m_oCurrClassInfo = classInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSelectFields(String _sTableName, String _sElementTagName, PublishTagContext _tagContext) {
        String sKey = (_sTableName + ".SELECT").toUpperCase();
        String sSelectFields = _tagContext.getTagItem().getExtraAttributeValue(sKey);
        if (sSelectFields == null) {
            TagItem tagItem = _tagContext.getTagItem();
            synchronized (tagItem) {
                sSelectFields = _tagContext.getTagItem().getExtraAttributeValue(sKey);
                if (sSelectFields == null) {
                    sSelectFields = this.makeSelectFields(_sTableName, _sElementTagName, _tagContext);
                    _tagContext.getTagItem().setExtraAttribute(sKey, sSelectFields);
                }
            }
        }
        return sSelectFields;
    }

    private String makeSelectFields(String _sTableName, String _sTagName, PublishTagContext _tagContext) {
        ArrayList arDefaultFields = null;
        arDefaultFields = _sTableName.equalsIgnoreCase("WCMDOCUMENT") ? FIELDS_DEFAULT_LIST_OF_DOCUMENT : FIELDS_DEFAULT_LIST_OF_METADATA;
        String sSelectFields = (String)arDefaultFields.get(0);
        int nSize = arDefaultFields.size();
        for (int i = 1; i < nSize; ++i) {
            sSelectFields = sSelectFields + "," + arDefaultFields.get(i);
        }
        ArrayList listChildFields = TagParseHelper.makeSelectFields(_tagContext.getTagItem(), _sTagName);
        DBManager dbMgr = DBManager.getDBManager();
        int nSize2 = listChildFields.size();
        for (int i = 0; i < nSize2; ++i) {
            String sFieldName = (String)listChildFields.get(i);
            if (arDefaultFields.indexOf(sFieldName) >= 0) continue;
            try {
                if (dbMgr.getFieldInfo(_sTableName, sFieldName) == null) {
                    _tagContext.addWarning(I18NMessage.get(WCMTagParserClassDocuments.class, "WCMTagParserClassDocuments.label5", "TRS_DOCUMENT\u7f6e\u6807\u6307\u5b9a\u7684Field[") + sFieldName + I18NMessage.get(WCMTagParserClassDocuments.class, "WCMTagParserClassDocuments.label6", "]\u5728WCMDocument\u8868\u4e2d\u4e0d\u5b58\u5728\uff01"));
                    continue;
                }
            }
            catch (WCMException ex) {
                ex.printStackTrace();
                try {
                    _tagContext.addWarning(I18NMessage.get(WCMTagParserClassDocuments.class, "WCMTagParserClassDocuments.label7", "\u83b7\u53d6\u6307\u5b9a\u7684Field[") + sFieldName + I18NMessage.get(WCMTagParserClassDocuments.class, "WCMTagParserClassDocuments.label8", "]\u4eceWCMDocument\u8868\u4e2d\u53d1\u751f\u5f02\u5e38\uff01") + CMyException.getStackTraceText(ex));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            sSelectFields = sSelectFields + "," + sFieldName;
        }
        return sSelectFields;
    }

    @Override
    public void setTagItem(TagItem _item) {
        this.m_oTagItem = _item;
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) throws WCMException {
        String sChannelIds = this.m_oTagItem.getAttributeTrim("triggerChannelIds");
        if (CMyString.isEmpty(sChannelIds)) {
            sChannelIds = this.m_oTagItem.getAttribute("ChannelId");
        }
        if (!CMyString.isEmpty(sChannelIds)) {
            Channels oChannels = Channels.findByIds(null, sChannelIds);
            return this.makeQuotes(oChannels);
        }
        int nViewId = 0;
        try {
            nViewId = Integer.parseInt(this.m_oTagItem.getAttribute("ViewId"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (nViewId == 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer(128);
        sql.append("exists(");
        sql.append("select XWCMMetaViewEmployer.ChannelId");
        sql.append(" from XWCMMetaViewEmployer");
        sql.append(" where XWCMMetaViewEmployer.ViewId=? ");
        sql.append("and XWCMMetaViewEmployer.ChannelId=WCMChannel.ChannelId");
        sql.append(")");
        WCMFilter filter = new WCMFilter("WCMCHANNEL", "", "");
        filter.setWhere(sql.toString());
        filter.addSearchValues(nViewId);
        Channels channels = new Channels(User.getSystem());
        channels.open(filter);
        if (channels.isEmpty()) {
            return null;
        }
        return this.makeQuotes(channels);
    }

    private TemplateQuote[] makeQuotes(Channels oChannels) throws WCMException {
        TemplateQuote[] pTemplateQuote = new TemplateQuote[oChannels.size()];
        Channel oChannel = null;
        int nSize = oChannels.size();
        for (int i = 0; i < nSize; ++i) {
            oChannel = (Channel)oChannels.getAt(i);
            if (oChannel == null) continue;
            TemplateQuote aQuote = new TemplateQuote();
            aQuote.setQuoteType(1);
            aQuote.setQuotedFolder(oChannel.getWCMType(), oChannel.getId(), -1);
            pTemplateQuote[i] = aQuote;
        }
        return pTemplateQuote;
    }

    static {
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCID");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCCHANNEL");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCSTATUS");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCTITLE");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCKIND");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCVERSION");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCRELTIME");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCPUBTIME");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("CRTIME");
        FIELDS_DEFAULT_LIST_OF_METADATA = new ArrayList(4);
        FIELDS_DEFAULT_LIST_OF_METADATA.add("MetaDataId");
        FIELDS_DEFAULT_LIST_OF_METADATA.add("ChannelId");
        FIELDS_DEFAULT_LIST_OF_METADATA.add("CRTIME");
    }
}

