/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.MetaDBField;
import com.trs.components.metadata.definition.MetaDataType;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.util.HashMap;

public class MetaViewField
extends CMSObj {
    private static final long serialVersionUID = 1L;
    public static final int OBJ_TYPE = 1886731157;
    public static final String DB_TABLE_NAME = "XWCMVIEWFIELDINFO";
    public static final String DB_ID_NAME = "VIEWFIELDINFOID";
    public static final String DB_FIELD_DBTYPE_NAME = "DBTYPE";
    private MetaDBField m_oDBField = null;
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;
    private MetaDataType m_oMetaDataType = null;
    private MetaDataType m_oMetaDBDataType = null;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 1886731157;
    }

    public String getTableName() {
        return this.getPropertyAsString("TABLENAME");
    }

    public boolean setTableName(String _sTableName) throws WCMException {
        return this.setProperty("TABLENAME", _sTableName);
    }

    public int getTableId() {
        return this.getPropertyAsInt("TABLEID", 0);
    }

    public boolean setTableId(int _nTableId) throws WCMException {
        return this.setProperty("TABLEID", _nTableId);
    }

    public String getName() {
        return this.getPropertyAsString("FIELDNAME");
    }

    public boolean setName(String _sName) throws WCMException {
        return this.setProperty("FIELDNAME", _sName);
    }

    public String getDBName() {
        return this.getPropertyAsString("DBFIELDNAME");
    }

    public boolean setDBName(String _sName) throws WCMException {
        return this.setProperty("DBFIELDNAME", _sName);
    }

    public String getAnotherName() {
        return this.getPropertyAsString("ANOTHERNAME");
    }

    public boolean setAnotherName(String _sAnotherName) throws WCMException {
        return this.setProperty("ANOTHERNAME", _sAnotherName);
    }

    public int getType() {
        return this.getPropertyAsInt("FIELDTYPE", 0);
    }

    public boolean setType(int _nType) throws WCMException {
        return this.setProperty("FIELDTYPE", _nType);
    }

    public String getDefaultValue() {
        return this.getPropertyAsString("DEFAULTVALUE");
    }

    public boolean setDefaultValue(String _sDefaultValue) throws WCMException {
        return this.setProperty("DEFAULTVALUE", _sDefaultValue);
    }

    public String getEnmValue() {
        return this.getPropertyAsString("ENMVALUE", "");
    }

    public boolean setEnmValue(String _sEnmValue) throws WCMException {
        return this.setProperty("ENMVALUE", _sEnmValue);
    }

    public boolean isNotNull() {
        return this.getPropertyAsBoolean("NOTNULL", false);
    }

    public boolean setNotNull(boolean _bNotNull) throws WCMException {
        return this.setProperty("NOTNULL", _bNotNull);
    }

    public boolean isRadioOrCheck() {
        return this.getPropertyAsBoolean("Radorchk", false);
    }

    public boolean setRadioOrCheck(boolean bRadioOrCheck) throws WCMException {
        return this.setProperty("Radorchk", bRadioOrCheck);
    }

    public int getClassId() {
        return this.getPropertyAsInt("CLASSID", 0);
    }

    public boolean setClassId(int _nClassId) throws WCMException {
        return this.setProperty("CLASSID", _nClassId);
    }

    public int getViewId() {
        return this.getPropertyAsInt("ViewId", 0);
    }

    public boolean setView(int _nOwnerView) throws WCMException {
        return this.setProperty("ViewId", _nOwnerView);
    }

    public int getOrder() {
        return this.getPropertyAsInt("FIELDORDER", 0);
    }

    public boolean setOrder(int _nOrder) throws WCMException {
        return this.setProperty("FIELDORDER", _nOrder);
    }

    public boolean isInOutline() {
        return this.getPropertyAsBoolean("INOUTLINE", false);
    }

    public boolean setInOutline(boolean _bInOutline) throws WCMException {
        return this.setProperty("INOUTLINE", _bInOutline);
    }

    public boolean isInDetail() {
        return this.getPropertyAsBoolean("INDETAIL", true);
    }

    public boolean setInDetail(boolean _bInDetail) throws WCMException {
        return this.setProperty("INDETAIL", _bInDetail);
    }

    public boolean isSearchField() {
        return this.getPropertyAsBoolean("SEARCHFIELD", false);
    }

    public boolean setSearchField(boolean _bSearchField) throws WCMException {
        return this.setProperty("SEARCHFIELD", _bSearchField);
    }

    public boolean isTitleField() {
        return this.getPropertyAsBoolean("TITLEFIELD", false);
    }

    public boolean setTitleField(boolean _bTitleField) throws WCMException {
        return this.setProperty("TITLEFIELD", _bTitleField);
    }

    public boolean isIdentityField() {
        return this.getPropertyAsBoolean("IDENTITYFIELD", false);
    }

    public boolean setIdentityField(boolean _bIdentityField) throws WCMException {
        return this.setProperty("IDENTITYFIELD", _bIdentityField);
    }

    public int getDBFieldId() {
        return this.getPropertyAsInt("DBFIELD", 0);
    }

    public MetaDBField getDBField() throws WCMException {
        if (this.m_oDBField == null) {
            this.m_oDBField = MetaDBField.findById(this.getDBFieldId());
            if (this.m_oDBField == null) {
                throw new WCMException(I18NMessage.get(MetaViewField.class, "MetaViewField.label1", "\u76f8\u5173\u7684\u7269\u7406\u5b57\u6bb5\u4e0d\u5b58\u5728![ID=") + this.getDBFieldId() + "]");
            }
        }
        return this.m_oDBField;
    }

    public boolean setDBField(int _nDBField) throws WCMException {
        return this.setProperty("DBFIELD", _nDBField);
    }

    public String getValidator() {
        return this.getPropertyAsString("Validator");
    }

    public boolean setValidator(String _sValidatorExpress) throws WCMException {
        return this.setProperty("Validator", _sValidatorExpress);
    }

    public int getDBType() {
        return this.getPropertyAsInt(DB_FIELD_DBTYPE_NAME, 0);
    }

    public boolean setDBType(int _nDBType) throws WCMException {
        return this.setProperty(DB_FIELD_DBTYPE_NAME, _nDBType);
    }

    public int getLength() {
        return this.getPropertyAsInt("DBLENGTH", 0);
    }

    public boolean setLength(int _nLength) throws WCMException {
        return this.setProperty("DBLENGTH", _nLength);
    }

    public int getScale() {
        return this.getPropertyAsInt("DBSCALE", 0);
    }

    public boolean setScale(int _nScale) throws WCMException {
        return this.setProperty("DBSCALE", _nScale);
    }

    public boolean isFromMainTable() {
        return this.getPropertyAsBoolean("FromMainTable", false);
    }

    public boolean setFromMainTable(boolean _bFromMainTable) throws WCMException {
        return this.setProperty("FromMainTable", _bFromMainTable);
    }

    public int getFieldGroupId() {
        return this.getPropertyAsInt("FIELDGROUPID", 0);
    }

    public boolean setFieldGroupId(int _nFieldGroupId) throws WCMException {
        return this.setProperty("FIELDGROUPID", _nFieldGroupId);
    }

    public int getRelationViewId() {
        return this.getPropertyAsInt("RELATIONVIEWID", 0);
    }

    public boolean setRelationViewId(int _nRelationViewId) throws WCMException {
        return this.setProperty("RELATIONVIEWID", _nRelationViewId);
    }

    public void inheritDBFieldInfo(MetaDBField _dbField) throws WCMException {
        this.m_oDBField = _dbField;
        this.setTableName(this.m_oDBField.getTableName());
        this.setTableId(this.m_oDBField.getTableId());
        this.setDBField(this.m_oDBField.getId());
        this.setDBName(this.m_oDBField.getName());
        this.setDBType(this.m_oDBField.getDBType());
        this.setLength(this.m_oDBField.getLength());
        this.setScale(this.m_oDBField.getScale());
        if (this.getProperty("ANOTHERNAME") == null) {
            this.setAnotherName(this.m_oDBField.getAnotherName());
        }
        if (this.getProperty("FIELDTYPE") == null) {
            this.setType(this.m_oDBField.getType());
        }
        if (this.getProperty("DEFAULTVALUE") == null) {
            this.setDefaultValue(this.m_oDBField.getDefaultValue());
        }
        if (this.getProperty("ENMVALUE") == null) {
            this.setEnmValue(this.m_oDBField.getEnmValue());
        }
        if (this.getProperty("CLASSID") == null) {
            this.setClassId(this.m_oDBField.getClassId());
        }
        if (this.getProperty("FIELDNAME") == null) {
            this.setName(this.getDBName());
        }
        if (this.getProperty("NOTNULL") == null) {
            this.setNotNull(this.m_oDBField.getPropertyAsBoolean("NOTNULL", false));
        }
        if (this.getProperty("NOTEDIT") == null) {
            this.setEditable(!this.m_oDBField.getPropertyAsBoolean("NOTEDIT", false));
        }
        if (this.getProperty("HIDDENFIELD") == null) {
            this.setHidden(this.m_oDBField.getPropertyAsBoolean("HIDDENFIELD", false));
        }
        if (this.getProperty("Radorchk") == null) {
            this.setRadioOrCheck(this.m_oDBField.getPropertyAsBoolean("Radorchk", false));
        }
    }

    @Override
    public boolean isValid() throws WCMException {
        int fieldType = 0;
        if (this.isAddMode()) {
            if (this.getProperty("TABLENAME") == null) {
                throw new WCMException(1106, I18NMessage.get(MetaViewField.class, "MetaViewField.label2", "\u5c5e\u6027TableName\u6ca1\u6709\u8bbe\u7f6e(ViewFieldInfo.isValid)"));
            }
            if (this.getProperty("TABLEID") == null) {
                throw new WCMException(1106, I18NMessage.get(MetaViewField.class, "MetaViewField.label3", "\u5c5e\u6027TableId\u6ca1\u6709\u8bbe\u7f6e(ViewFieldInfo.isValid)"));
            }
            if (this.getProperty("DBFIELD") == null) {
                throw new WCMException(1106, I18NMessage.get(MetaViewField.class, "MetaViewField.label4", "\u5c5e\u6027DBField\u6ca1\u6709\u8bbe\u7f6e(ViewFieldInfo.isValid)"));
            }
            if (this.getProperty("ViewId") == null) {
                throw new WCMException(1106, I18NMessage.get(MetaViewField.class, "MetaViewField.label5", "\u5c5e\u6027OwnerView\u6ca1\u6709\u8bbe\u7f6e(ViewFieldInfo.isValid)"));
            }
            MetaDBField dbField = this.getDBField();
            if (this.getProperty("ANOTHERNAME") == null) {
                this.setAnotherName(dbField.getAnotherName());
            }
            if (this.getProperty("FIELDTYPE") == null) {
                this.setType(dbField.getType());
            }
            if (this.getProperty("DBFIELDNAME") == null) {
                this.setDBName(dbField.getName());
            }
            if (this.getProperty("DEFAULTVALUE") == null) {
                this.setDefaultValue(dbField.getDefaultValue());
            }
            if (this.getProperty("ENMVALUE") == null) {
                this.setEnmValue(dbField.getEnmValue());
            }
            if (this.getProperty("CLASSID") == null) {
                this.setClassId(dbField.getClassId());
            }
            if (this.getProperty("FIELDNAME") == null) {
                this.setName(this.getDBName());
            }
            if (this.getProperty("INDETAIL") == null) {
                this.setInDetail(true);
            }
            if (this.getProperty("TITLEFIELD") == null) {
                this.setTitleField(false);
            }
            if (this.getProperty("SearchField") == null) {
                this.setSearchField(false);
            }
            if (this.getProperty("IdentityField") == null) {
                this.setIdentityField(false);
            }
            if (this.getProperty("NotNull") == null) {
                this.setNotNull(false);
            }
            if (this.getProperty("InMultiTable") == null) {
                this.setInMultiTable(false);
            }
            fieldType = this.getType();
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(MetaViewField.class, "MetaViewField.label6", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(ViewFieldInfo.isValid)"));
            }
            fieldType = this.getNewPropertyAsInt("FIELDTYPE", 0);
        }
        if (fieldType != 0) {
            MetaDataType oCurrMetaDataType = null;
            oCurrMetaDataType = fieldType == 1 ? MetaDataConstants.DB_DATA_TYPES.getDataTypeById(this.getDBType()) : MetaDataConstants.DATA_TYPES.getDataTypeById(fieldType);
            if (this.isAddMode() && this.getProperty("DBLENGTH") == null) {
                this.setLength(oCurrMetaDataType.getMaxLength());
            } else if (!this.isAddMode() && this.getType() != fieldType && this.getNewProperty("DBLENGTH") == null) {
                this.setLength(oCurrMetaDataType.getMaxLength());
            }
            if (this.getDBType() == 2005 || this.getDBType() == 93 || this.getDBType() == 4) {
                this.setLength(0);
            }
        }
        String SQL_QUERY_SIMMILAR = "select VIEWFIELDINFOID from XWCMVIEWFIELDINFO where ViewId=? and DBField=? and VIEWFIELDINFOID<>?";
        int nExistsId = DBManager.getDBManager().sqlExecuteIntQuery("select VIEWFIELDINFOID from XWCMVIEWFIELDINFO where ViewId=? and DBField=? and VIEWFIELDINFOID<>?", new int[]{this.getViewId(), this.getDBFieldId(), this.getId()});
        if (nExistsId > 0) {
            throw new WCMException(I18NMessage.get(MetaViewField.class, "MetaViewField.label7", "\u89c6\u56fe\u4e2d\u5df2\u7ecf\u6709\u5b57\u6bb5\u548c\u6307\u5b9a\u7684\u7269\u7406\u5b57\u6bb5\u5173\u8054\uff01[ViewId=") + this.getViewId() + ", DBFieldId=" + this.getDBFieldId() + ", CurrId=" + this.getId() + "]");
        }
        this.changeOrder();
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            if (this.getProperty("ClassId") == null) {
                this.setClassId(0);
            }
            super.insert(_currUser);
        }
    }

    private void changeOrder() throws WCMException {
        int nMaxOrder;
        int nNewOrder;
        int nMoveBeginAt = 0;
        int nMoveEndAt = 0;
        int nMoveDirection = 0;
        if (this.isAddMode()) {
            nNewOrder = this.getOrder();
            nMaxOrder = this.getMaxOrder();
            if (nNewOrder == -1) {
                nNewOrder = nMaxOrder + 1;
                this.setOrder(nNewOrder);
                return;
            }
            nMoveDirection = 1;
            nMoveEndAt = nMaxOrder;
            nMoveBeginAt = nNewOrder;
        } else {
            if (!this.isChangeProperty("FIELDORDER")) {
                return;
            }
            nNewOrder = this.getNewPropertyAsInt("FIELDORDER", -1);
            if (nNewOrder == -1) {
                nMaxOrder = this.getMaxOrder();
                if (this.isChangeProperty("PARENTID")) {
                    nNewOrder = nMaxOrder + 1;
                } else if (nMaxOrder == this.getOrder()) {
                    nNewOrder = this.getOrder();
                } else {
                    nMoveDirection = -1;
                    nMoveEndAt = nMaxOrder;
                    nMoveBeginAt = this.getOrder() + 1;
                    nNewOrder = nMaxOrder;
                }
            } else if (nNewOrder > this.getOrder()) {
                nMoveDirection = -1;
                nMoveEndAt = --nNewOrder;
                nMoveBeginAt = this.getOrder() + 1;
            } else {
                nMoveDirection = 1;
                nMoveEndAt = this.getOrder() - 1;
                nMoveBeginAt = nNewOrder;
            }
        }
        String sRegionWhere = "FIELDORDER>=" + nMoveBeginAt + " AND FIELDORDER <= " + nMoveEndAt + " and ViewId=" + this.getViewId();
        String sMoveSql = "UPDATE XWCMVIEWFIELDINFO SET FIELDORDER = FIELDORDER+(" + nMoveDirection + ") WHERE " + sRegionWhere;
        DBManager.getDBManager().sqlExecuteUpdate(sMoveSql);
        this.setOrder(nNewOrder);
    }

    private int getMaxOrder() throws WCMException {
        String SQL_QUERY_MAX_ORDER = "select max(FIELDORDER) from XWCMVIEWFIELDINFO where ViewId=?";
        return DBManager.getDBManager().sqlExecuteIntQuery("select max(FIELDORDER) from XWCMVIEWFIELDINFO where ViewId=?", new int[]{this.getViewId()});
    }

    public String getClassName() {
        int nClassId = this.getClassId();
        if (nClassId == 0) {
            return "";
        }
        try {
            ClassInfo oClassInfo = ClassInfo.findById(this.getClassId());
            if (oClassInfo != null) {
                return oClassInfo.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public String getTypeDesc() {
        if (this.m_oMetaDataType == null) {
            this.m_oMetaDataType = MetaDataConstants.DATA_TYPES.getDataTypeById(this.getType());
        }
        return this.m_oMetaDataType.getDataTypeDesc();
    }

    public String getDBTypeDesc() {
        if (this.m_oMetaDBDataType == null) {
            this.m_oMetaDBDataType = MetaDataConstants.DB_DATA_TYPES.getDataTypeById(this.getDBType());
        }
        return this.m_oMetaDBDataType.getDataTypeDesc();
    }

    public HashMap getEnmValueMap(boolean valueAsKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        String enmValue = this.getEnmValue();
        String[] items = enmValue.split("~");
        for (int i = 0; i < items.length; ++i) {
            String[] item = items[i].split("`");
            if (valueAsKey) {
                map.put(item.length > 1 ? item[1] : item[0], item[0]);
                continue;
            }
            map.put(item[0], item.length > 1 ? item[1] : item[0]);
        }
        return map;
    }

    public String getValueFromLabel(String _sLabel) {
        String enmValue = this.getEnmValue();
        String[] items = enmValue.split("~");
        for (int i = 0; i < items.length; ++i) {
            String[] item = items[i].split("`");
            if (item[0].indexOf(_sLabel) < 0) continue;
            return item.length > 1 ? item[1] : item[0];
        }
        return null;
    }

    public String[] getValuesFromLabel(String _sLabel) {
        String enmValue = this.getEnmValue();
        if (CMyString.isEmpty(enmValue)) {
            return new String[0];
        }
        String[] items = enmValue.split("~");
        String[] aTemp = new String[items.length];
        int index = 0;
        for (int i = 0; i < items.length; ++i) {
            String[] item = items[i].split("`");
            if (item[0].indexOf(_sLabel) < 0) continue;
            aTemp[index++] = item.length > 1 ? item[1] : item[0];
        }
        String[] aResult = new String[index];
        System.arraycopy(aTemp, 0, aResult, 0, index);
        return aResult;
    }

    public static final MetaViewField findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (MetaViewField)BaseObj.findById(MetaViewField.class, _nId);
    }

    public static final MetaViewField createNewInstance() throws WCMException {
        return (MetaViewField)BaseObj.createNewInstance(MetaViewField.class);
    }

    public static final MetaViewField findByKey(Object _oKey) throws WCMException {
        return (MetaViewField)BaseObj.findByKey(MetaViewField.class, _oKey);
    }

    public boolean isHidden() {
        return this.getPropertyAsBoolean("HIDDENFIELD", false);
    }

    public boolean setHidden(boolean _zHidden) throws WCMException {
        return this.setProperty("HIDDENFIELD", _zHidden);
    }

    public boolean isEditable() {
        return !this.getPropertyAsBoolean("NOTEDIT", false);
    }

    public boolean setEditable(boolean _zEditable) throws WCMException {
        return this.setProperty("NOTEDIT", !_zEditable);
    }

    public boolean isInMultiTable() throws WCMException {
        return this.getPropertyAsBoolean("INMULTITABLE", false);
    }

    public boolean setInMultiTable(boolean _zInMultiTable) throws WCMException {
        return this.setProperty("INMULTITABLE", _zInMultiTable);
    }
}

