/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Stack;
import org.apache.log4j.Logger;

public class ClassInfoUtil {
    private static Logger logger = Logger.getLogger(ClassInfoUtil.class);
    private int m_nRootId = 0;
    private char m_cSplitChar = (char)9;
    private HashMap m_hClassInfoMap = new HashMap();
    private Stack m_ClassInfoStack = new Stack();
    private Stack m_ClassInfoStacktemp = new Stack();

    public boolean importClassInfos(String _sRootName, String _sFileName, boolean bContainCode, int _nImportType, int importrootid) throws Exception {
        if (bContainCode) {
            if (importrootid == 0) {
                return this.importFormFileByCode0(_sRootName, _sFileName, _nImportType);
            }
            return this.importFormFileByCodeInClassInfo(_sRootName, importrootid, _sFileName, _nImportType);
        }
        if (importrootid == 0) {
            return this.importFormFileByName0(_sRootName, _sFileName, _nImportType);
        }
        return this.importFormFileByNameInClassInfo(_sRootName, importrootid, _sFileName, _nImportType);
    }

    private ClassInfo createClassInfoRoot(String _sRootName) throws WCMException {
        ClassInfo oRootNode = new ClassInfo();
        oRootNode.setName(_sRootName);
        oRootNode.setRootId(0);
        oRootNode.insert(this.getLoginUser());
        return oRootNode;
    }

    private ClassInfo createClassInfoInRoot(String _sRootName, ClassInfo rootnode) throws WCMException {
        ClassInfo oRootNode = new ClassInfo();
        oRootNode.setName(_sRootName);
        oRootNode.setRootId(0);
        oRootNode.setParentId(rootnode.getId());
        oRootNode.insert(this.getLoginUser());
        return oRootNode;
    }

    public boolean importFormFileByCode0(String _sRootName, String _sFileName, int _nImportType) throws Exception {
        FileService file = new FileService(_sFileName);
        if (!file.exists()) {
            try {
                String sFilePath = FilesMan.getFilesMan().mapFilePath(_sFileName, 0);
                file = new FileService(sFilePath + _sFileName);
                if (!file.exists() || !file.isFile()) {
                    throw new WCMException(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label2", "\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + _sFileName + "]");
                }
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label2", "\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + _sFileName + "]");
            }
        }
        InputStreamReader fileReader = null;
        InputStream fis = null;
        BufferedReader buffReader = null;
        WCMFilter filter = new WCMFilter("", "CName=? and RootId=0", "");
        filter.addSearchValues(_sRootName);
        ClassInfos CurrentClassInfos = ClassInfos.openWCMObjs(null, filter);
        ClassInfo oRootNode = null;
        if (_nImportType == 0) {
            if (CurrentClassInfos.size() > 0) {
                return false;
            }
            oRootNode = this.createClassInfoRoot(_sRootName);
        } else {
            oRootNode = _nImportType == 1 ? (CurrentClassInfos.size() <= 0 ? this.createClassInfoRoot(_sRootName) : (ClassInfo)CurrentClassInfos.getAt(0)) : this.createClassInfoRoot(_sRootName);
        }
        this.m_nRootId = oRootNode.getId();
        int nLastParentId = 0;
        User loginuser = ContextHelper.getLoginUser();
        ClassInfo oCurrentNode = ClassInfo.findById(this.m_nRootId);
        ClassInfos oCurrentChildNodes = oCurrentNode.getChildren();
        if (oCurrentChildNodes == null) {
            oCurrentChildNodes = new ClassInfos(loginuser);
        }
        oCurrentChildNodes.setCurrUser(loginuser);
        ClassInfo lastNode = oCurrentNode;
        try {
            String sLine;
            fis = file.getInputStream();
            buffReader = new BufferedReader(new InputStreamReader(fis, "GBK"));
            while ((sLine = buffReader.readLine()) != null) {
                int nIndex;
                if ((sLine = sLine.trim()).length() == 0) continue;
                String cName = "";
                String cCode = "";
                String[] pValues = sLine.split(String.valueOf(this.m_cSplitChar));
                if (pValues.length < 2) continue;
                cCode = pValues[0];
                cName = pValues[1];
                int nPos = cName.lastIndexOf(92);
                if (nPos >= 0) {
                    cName = cName.substring(nPos + 1);
                }
                if (cCode.length() == 0) continue;
                int currParentId = this.makeParentId(cCode);
                if (nLastParentId != currParentId) {
                    if (lastNode.getId() == currParentId) {
                        this.m_ClassInfoStacktemp.push(new Object[]{oCurrentNode, oCurrentChildNodes});
                        oCurrentNode = lastNode;
                        oCurrentChildNodes = lastNode.getChildren();
                        oCurrentChildNodes.setCurrUser(loginuser);
                    } else {
                        oCurrentChildNodes.removeAll();
                        Object[] infos = (Object[])this.m_ClassInfoStacktemp.pop();
                        oCurrentNode = (ClassInfo)infos[0];
                        oCurrentChildNodes = (ClassInfos)infos[1];
                    }
                }
                if ((nIndex = this.indexOf(oCurrentChildNodes, cName)) < 0) {
                    ClassInfo classInfo = new ClassInfo();
                    classInfo.setRootId(this.m_nRootId);
                    classInfo.setParentId(oCurrentNode.getId());
                    classInfo.setCode(cCode);
                    classInfo.setName(cName);
                    if (pValues.length > 2) {
                        classInfo.setDesc(pValues[2]);
                    }
                    classInfo.insert(this.getLoginUser());
                    lastNode = classInfo;
                } else {
                    lastNode = (ClassInfo)oCurrentChildNodes.getAt(nIndex);
                    oCurrentChildNodes.removeAt(nIndex, false);
                }
                this.m_hClassInfoMap.put(lastNode.getCode(), lastNode.getKey());
                nLastParentId = currParentId;
            }
            if (oCurrentChildNodes != null) {
                oCurrentChildNodes.removeAll();
            }
        }
        catch (FileNotFoundException ex) {
            throw new Exception(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label3", "\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230[File=") + _sFileName + "]", ex);
        }
        catch (IOException ex) {
            throw new Exception(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label4", "\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef[File=") + _sFileName + "]", ex);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (buffReader != null) {
                    buffReader.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public boolean importFormFileByCode(String _sRootName, String _sFileName, int _nImportType) throws Exception {
        try {
            if (!this.assertClassInfoRoot(_sRootName, _nImportType)) {
                return false;
            }
            logger.debug((Object)(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label1", "\u5bfc\u5165\u5206\u7c7b\u6811\uff1a[id:") + this.m_nRootId + ",Name:" + _sRootName));
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage());
            throw e;
        }
        FileService file = new FileService(_sFileName);
        if (!file.exists()) {
            try {
                String sFilePath = FilesMan.getFilesMan().mapFilePath(_sFileName, 0);
                file = new FileService(sFilePath + _sFileName);
                if (!file.exists() || !file.isFile()) {
                    throw new WCMException(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label2", "\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + _sFileName + "]");
                }
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label2", "\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + _sFileName + "]");
            }
        }
        InputStreamReader fileReader = null;
        InputStream fis = null;
        BufferedReader buffReader = null;
        try {
            String sLine;
            fis = file.getInputStream();
            buffReader = new BufferedReader(new InputStreamReader(fis, "GBK"));
            while ((sLine = buffReader.readLine()) != null) {
                String[] pValues;
                if ((sLine = sLine.trim()).length() == 0 || (pValues = sLine.split(String.valueOf(this.m_cSplitChar))).length < 2) continue;
                int nPos = pValues[1].lastIndexOf(92);
                if (nPos >= 0) {
                    pValues[1] = pValues[1].substring(nPos + 1);
                }
                if (pValues[0].length() == 0) continue;
                int nParentId = this.makeParentId(pValues[0]);
                ClassInfo classInfo = new ClassInfo();
                classInfo.setRootId(this.m_nRootId);
                classInfo.setParentId(nParentId);
                classInfo.setCode(pValues[0]);
                classInfo.setName(pValues[1]);
                if (pValues.length > 2) {
                    classInfo.setDesc(pValues[2]);
                }
                classInfo.insert(this.getLoginUser());
                this.m_hClassInfoMap.put(pValues[0], classInfo.getKey());
            }
        }
        catch (FileNotFoundException ex) {
            throw new Exception(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label3", "\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230[File=") + _sFileName + "]", ex);
        }
        catch (IOException ex) {
            throw new Exception(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label4", "\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef[File=") + _sFileName + "]", ex);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (buffReader != null) {
                    buffReader.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    private boolean assertClassInfoRoot(String _sRootName, int _nImportType) throws WCMException {
        WCMFilter filter = new WCMFilter("", "CName=? and RootId=0", "");
        filter.addSearchValues(_sRootName);
        ClassInfos infos = ClassInfos.openWCMObjs(null, filter);
        if (!infos.isEmpty()) {
            if (_nImportType == 0) {
                return false;
            }
            if (_nImportType == 1) {
                try {
                    this.m_nRootId = infos.getIdAt(0);
                    ClassInfo oRoot = ClassInfo.findById(this.m_nRootId);
                    if (oRoot != null) {
                        oRoot.setProperty("CRUSER", this.getLoginUser().getName());
                        oRoot.setProperty("CRTIME", CMyDateTime.now());
                        oRoot.save(this.getLoginUser());
                    }
                    String deleteSQL = "delete from XWCMClassInfo where RootId=" + this.m_nRootId;
                    DBManager.getDBManager().sqlExecuteUpdate(deleteSQL);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
        }
        ClassInfo classInfo = new ClassInfo();
        classInfo.setName(_sRootName);
        classInfo.setRootId(0);
        classInfo.insert(this.getLoginUser());
        this.m_nRootId = classInfo.getId();
        return true;
    }

    public boolean importFormFileByNameInClassInfo(String sClassName, int nImportRootId, String _sFileName, int _nImportType) throws Exception {
        ClassInfo oLastNode;
        FileService file = new FileService(_sFileName);
        if (!file.exists()) {
            try {
                String sFilePath = FilesMan.getFilesMan().mapFilePath(_sFileName, 0);
                file = new FileService(sFilePath + _sFileName);
                if (!file.exists() || !file.isFile()) {
                    throw new WCMException(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label2", "\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + _sFileName + "]");
                }
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label2", "\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + _sFileName + "]");
            }
        }
        this.m_nRootId = nImportRootId;
        ClassInfo oRootNode = ClassInfo.findById(nImportRootId);
        ClassInfo oCurrNode = null;
        ClassInfos oCurrentClassInfos = null;
        WCMFilter filter = new WCMFilter("", "RootId=? and CName=?", "");
        filter.addSearchValues(nImportRootId);
        filter.addSearchValues(sClassName);
        oCurrentClassInfos = ClassInfos.openWCMObjs(null, filter);
        if (_nImportType == 0) {
            if (oCurrentClassInfos.size() > 0) {
                return false;
            }
            oCurrNode = this.createClassInfoInRoot(sClassName, oRootNode);
        } else {
            oCurrNode = _nImportType == 1 ? (oCurrentClassInfos.size() <= 0 ? this.createClassInfoInRoot(sClassName, oRootNode) : (ClassInfo)oCurrentClassInfos.getAt(0)) : this.createClassInfoInRoot(sClassName, oRootNode);
        }
        InputStreamReader fileReader = null;
        InputStream fis = null;
        BufferedReader buffReader = null;
        User loginuser = ContextHelper.getLoginUser();
        int nLastPosition = -1;
        ClassInfo oParentNode = oLastNode = oCurrNode;
        ClassInfos oParentChildNodes = oParentNode.getChildren();
        oParentChildNodes.setCurrUser(loginuser);
        try {
            String sLine;
            fis = file.getInputStream();
            buffReader = new BufferedReader(new InputStreamReader(fis, "GBK"));
            while ((sLine = buffReader.readLine()) != null) {
                ClassInfos oLastChildNodes;
                if (sLine.trim().length() == 0) continue;
                String cNameAndCode = sLine.trim();
                String[] aInfos = cNameAndCode.split(this.m_cSplitChar + "+");
                String cName = "";
                String cCode = "";
                if (aInfos.length > 1) {
                    cCode = aInfos[0];
                    cName = aInfos[1];
                } else if (aInfos.length > 0) {
                    cName = aInfos[0];
                }
                int nIndex = this.indexOf(oParentChildNodes, cName);
                int currPosition = this.getPosition(sLine, this.m_cSplitChar);
                if (nLastPosition != currPosition) {
                    if (nLastPosition < currPosition) {
                        oParentNode = oLastNode;
                        oParentChildNodes = oParentNode.getChildren();
                        oParentChildNodes.setCurrUser(loginuser);
                        this.m_ClassInfoStacktemp.push(new Object[]{oParentNode, oParentChildNodes});
                    } else if (nLastPosition > currPosition) {
                        oLastChildNodes = oLastNode.getChildren();
                        if (oLastChildNodes != null) {
                            oLastChildNodes.setCurrUser(loginuser);
                            oLastChildNodes.removeAll();
                        }
                        Object[] infos = null;
                        infos = (Object[])this.m_ClassInfoStacktemp.pop();
                        oParentNode = (ClassInfo)infos[0];
                        oParentChildNodes = (ClassInfos)infos[1];
                        for (int tmpPosition = nLastPosition; tmpPosition > currPosition; --tmpPosition) {
                            if (oParentChildNodes != null) {
                                oParentChildNodes.removeAll();
                            }
                            infos = (Object[])this.m_ClassInfoStacktemp.pop();
                            oParentNode = (ClassInfo)infos[0];
                            oParentChildNodes = (ClassInfos)infos[1];
                        }
                        this.m_ClassInfoStacktemp.push(new Object[]{oParentNode, oParentChildNodes});
                    }
                    nIndex = this.indexOf(oParentChildNodes, cName);
                } else {
                    oLastChildNodes = oLastNode.getChildren();
                    if (oLastChildNodes != null) {
                        oLastChildNodes.setCurrUser(loginuser);
                        oLastChildNodes.removeAll();
                    }
                }
                if (nIndex < 0) {
                    ClassInfo classInfo = new ClassInfo();
                    classInfo.setRootId(this.m_nRootId);
                    classInfo.setParentId(oParentNode.getId());
                    classInfo.setCode(cCode);
                    classInfo.setName(cName);
                    classInfo.insert(this.getLoginUser());
                    oLastNode = classInfo;
                } else {
                    oLastNode = (ClassInfo)oParentChildNodes.getAt(nIndex);
                    oParentChildNodes.removeAt(nIndex, false);
                }
                nLastPosition = currPosition;
            }
            ClassInfos oLastChildNodes = oLastNode.getChildren();
            if (oLastChildNodes != null) {
                oLastChildNodes.setCurrUser(loginuser);
                oLastChildNodes.removeAll();
            }
            if (oParentChildNodes != null) {
                oParentChildNodes.removeAll();
            }
            while (!this.m_ClassInfoStacktemp.isEmpty()) {
                Object[] infos = (Object[])this.m_ClassInfoStacktemp.pop();
                oParentChildNodes = (ClassInfos)infos[1];
                if (oParentChildNodes == null) continue;
                oParentChildNodes.removeAll();
            }
        }
        catch (FileNotFoundException ex) {
            throw new Exception(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label3", "\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230[File=") + _sFileName + "]", ex);
        }
        catch (IOException ex) {
            throw new Exception(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label4", "\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef[File=") + _sFileName + "]", ex);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (buffReader != null) {
                    buffReader.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public boolean importFormFileByCodeInClassInfo(String sClassName, int nImportRootId, String _sFileName, int _nImportType) throws Exception {
        FileService file = new FileService(_sFileName);
        if (!file.exists()) {
            try {
                String sFilePath = FilesMan.getFilesMan().mapFilePath(_sFileName, 0);
                file = new FileService(sFilePath + _sFileName);
                if (!file.exists() || !file.isFile()) {
                    throw new WCMException(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label2", "\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + _sFileName + "]");
                }
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label2", "\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + _sFileName + "]");
            }
        }
        this.m_nRootId = nImportRootId;
        ClassInfo oRootNode = ClassInfo.findById(nImportRootId);
        ClassInfo oCurrNode = null;
        ClassInfos oCurrentClassInfos = null;
        WCMFilter filter = new WCMFilter("", "RootId=? and CName=?", "");
        filter.addSearchValues(nImportRootId);
        filter.addSearchValues(sClassName);
        oCurrentClassInfos = ClassInfos.openWCMObjs(null, filter);
        if (_nImportType == 0) {
            if (oCurrentClassInfos.size() > 0) {
                return false;
            }
            oCurrNode = this.createClassInfoInRoot(sClassName, oRootNode);
        } else {
            oCurrNode = _nImportType == 1 ? (oCurrentClassInfos.size() <= 0 ? this.createClassInfoInRoot(sClassName, oRootNode) : (ClassInfo)oCurrentClassInfos.getAt(0)) : this.createClassInfoInRoot(sClassName, oRootNode);
        }
        InputStreamReader fileReader = null;
        InputStream fis = null;
        BufferedReader buffReader = null;
        int nLastParentId = 0;
        User loginuser = ContextHelper.getLoginUser();
        ClassInfo oCurrentNode = oCurrNode;
        ClassInfos oCurrentChildNodes = oCurrentNode.getChildren();
        if (oCurrentChildNodes == null) {
            oCurrentChildNodes = new ClassInfos(loginuser);
        }
        oCurrentChildNodes.setCurrUser(loginuser);
        ClassInfo lastNode = oCurrentNode;
        this.m_hClassInfoMap.put(oCurrentNode.getCode(), oCurrentNode.getKey());
        try {
            String sLine;
            fis = file.getInputStream();
            buffReader = new BufferedReader(new InputStreamReader(fis, "GBK"));
            while ((sLine = buffReader.readLine()) != null) {
                int nIndex;
                if ((sLine = sLine.trim()).length() == 0) continue;
                String cName = "";
                String cCode = "";
                String[] pValues = sLine.split(String.valueOf(this.m_cSplitChar));
                if (pValues.length < 2) continue;
                cCode = pValues[0];
                cName = pValues[1];
                int nPos = cName.lastIndexOf(92);
                if (nPos >= 0) {
                    cName = cName.substring(nPos + 1);
                }
                if (cCode.length() == 0) continue;
                int currParentId = this.makeParentId(cCode);
                if (nLastParentId != currParentId) {
                    if (lastNode.getId() == currParentId) {
                        this.m_ClassInfoStacktemp.push(new Object[]{oCurrentNode, oCurrentChildNodes});
                        oCurrentNode = lastNode;
                        oCurrentChildNodes = lastNode.getChildren();
                        oCurrentChildNodes.setCurrUser(loginuser);
                    } else {
                        oCurrentChildNodes.removeAll();
                        Object[] infos = (Object[])this.m_ClassInfoStacktemp.pop();
                        oCurrentNode = (ClassInfo)infos[0];
                        oCurrentChildNodes = (ClassInfos)infos[1];
                    }
                }
                if ((nIndex = this.indexOf(oCurrentChildNodes, cName)) < 0) {
                    ClassInfo classInfo = new ClassInfo();
                    classInfo.setRootId(this.m_nRootId);
                    classInfo.setParentId(oCurrentNode.getId());
                    classInfo.setCode(cCode);
                    classInfo.setName(cName);
                    if (pValues.length > 2) {
                        classInfo.setDesc(pValues[2]);
                    }
                    classInfo.insert(this.getLoginUser());
                    lastNode = classInfo;
                } else {
                    lastNode = (ClassInfo)oCurrentChildNodes.getAt(nIndex);
                    oCurrentChildNodes.removeAt(nIndex, false);
                }
                this.m_hClassInfoMap.put(lastNode.getCode(), lastNode.getKey());
                nLastParentId = currParentId;
            }
            if (oCurrentChildNodes != null) {
                oCurrentChildNodes.removeAll();
            }
        }
        catch (FileNotFoundException ex) {
            throw new Exception(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label3", "\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230[File=") + _sFileName + "]", ex);
        }
        catch (IOException ex) {
            throw new Exception(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label4", "\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef[File=") + _sFileName + "]", ex);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (buffReader != null) {
                    buffReader.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public boolean importFormFileByName0(String _sRootName, String _sFileName, int _nImportType) throws Exception {
        ClassInfo oLastNode;
        FileService file = new FileService(_sFileName);
        if (!file.exists()) {
            try {
                String sFilePath = FilesMan.getFilesMan().mapFilePath(_sFileName, 0);
                file = new FileService(sFilePath + _sFileName);
                if (!file.exists() || !file.isFile()) {
                    throw new WCMException(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label2", "\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + _sFileName + "]");
                }
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label2", "\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + _sFileName + "]");
            }
        }
        InputStreamReader fileReader = null;
        InputStream fis = null;
        BufferedReader buffReader = null;
        ClassInfos CurrentClassInfos = null;
        WCMFilter filter = new WCMFilter("", "CName=? and RootId=0", "");
        filter.addSearchValues(_sRootName);
        CurrentClassInfos = ClassInfos.openWCMObjs(null, filter);
        ClassInfo oRootNode = null;
        if (_nImportType == 0) {
            if (CurrentClassInfos.size() > 0) {
                return false;
            }
            oRootNode = this.createClassInfoRoot(_sRootName);
        } else {
            oRootNode = _nImportType == 1 ? (CurrentClassInfos.size() <= 0 ? this.createClassInfoRoot(_sRootName) : (ClassInfo)CurrentClassInfos.getAt(0)) : this.createClassInfoRoot(_sRootName);
        }
        this.m_nRootId = oRootNode.getId();
        User loginuser = ContextHelper.getLoginUser();
        int nLastPosition = -1;
        ClassInfo oParentNode = oLastNode = oRootNode;
        ClassInfos oParentChildNodes = oParentNode.getChildren();
        oParentChildNodes.setCurrUser(loginuser);
        try {
            String sLine;
            fis = file.getInputStream();
            buffReader = new BufferedReader(new InputStreamReader(fis, "GBK"));
            while ((sLine = buffReader.readLine()) != null) {
                ClassInfos oLastChildNodes;
                if (sLine.trim().length() == 0) continue;
                String cNameAndCode = sLine.trim();
                String[] aInfos = cNameAndCode.split(this.m_cSplitChar + "+");
                String cName = "";
                String cCode = "";
                if (aInfos.length > 1) {
                    cCode = aInfos[0];
                    cName = aInfos[1];
                } else if (aInfos.length > 0) {
                    cName = aInfos[0];
                }
                int nIndex = this.indexOf(oParentChildNodes, cName);
                int currPosition = this.getPosition(sLine, this.m_cSplitChar);
                if (nLastPosition != currPosition) {
                    if (nLastPosition < currPosition) {
                        oParentNode = oLastNode;
                        oParentChildNodes = oParentNode.getChildren();
                        oParentChildNodes.setCurrUser(loginuser);
                        this.m_ClassInfoStacktemp.push(new Object[]{oParentNode, oParentChildNodes});
                    } else if (nLastPosition > currPosition) {
                        oLastChildNodes = oLastNode.getChildren();
                        if (oLastChildNodes != null) {
                            oLastChildNodes.setCurrUser(loginuser);
                            oLastChildNodes.removeAll();
                        }
                        Object[] infos = null;
                        infos = (Object[])this.m_ClassInfoStacktemp.pop();
                        oParentNode = (ClassInfo)infos[0];
                        oParentChildNodes = (ClassInfos)infos[1];
                        for (int tmpPosition = nLastPosition; tmpPosition > currPosition; --tmpPosition) {
                            if (oParentChildNodes != null) {
                                oParentChildNodes.removeAll();
                            }
                            infos = (Object[])this.m_ClassInfoStacktemp.pop();
                            oParentNode = (ClassInfo)infos[0];
                            oParentChildNodes = (ClassInfos)infos[1];
                        }
                        this.m_ClassInfoStacktemp.push(new Object[]{oParentNode, oParentChildNodes});
                    }
                    nIndex = this.indexOf(oParentChildNodes, cName);
                } else {
                    oLastChildNodes = oLastNode.getChildren();
                    if (oLastChildNodes != null) {
                        oLastChildNodes.setCurrUser(loginuser);
                        oLastChildNodes.removeAll();
                    }
                }
                if (nIndex < 0) {
                    ClassInfo classInfo = new ClassInfo();
                    classInfo.setRootId(this.m_nRootId);
                    classInfo.setParentId(oParentNode.getId());
                    classInfo.setCode(cCode);
                    classInfo.setName(cName);
                    classInfo.insert(this.getLoginUser());
                    oLastNode = classInfo;
                } else {
                    oLastNode = (ClassInfo)oParentChildNodes.getAt(nIndex);
                    oParentChildNodes.removeAt(nIndex, false);
                }
                nLastPosition = currPosition;
            }
            ClassInfos oLastChildNodes = oLastNode.getChildren();
            if (oLastChildNodes != null) {
                oLastChildNodes.setCurrUser(loginuser);
                oLastChildNodes.removeAll();
            }
            if (oParentChildNodes != null) {
                oParentChildNodes.removeAll();
            }
            while (!this.m_ClassInfoStacktemp.isEmpty()) {
                Object[] infos = (Object[])this.m_ClassInfoStacktemp.pop();
                oParentChildNodes = (ClassInfos)infos[1];
                if (oParentChildNodes == null) continue;
                oParentChildNodes.removeAll();
            }
        }
        catch (FileNotFoundException ex) {
            throw new Exception(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label3", "\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230[File=") + _sFileName + "]", ex);
        }
        catch (IOException ex) {
            throw new Exception(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label4", "\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef[File=") + _sFileName + "]", ex);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (buffReader != null) {
                    buffReader.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public boolean importFormFileByName(String _sRootName, String _sFileName, int _nImportType) throws Exception {
        try {
            if (!this.assertClassInfoRoot(_sRootName, _nImportType)) {
                return false;
            }
            logger.debug((Object)(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label1", "\u5bfc\u5165\u5206\u7c7b\u6811\uff1a[id:") + this.m_nRootId + ",Name:" + _sRootName));
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage());
            throw e;
        }
        FileService file = new FileService(_sFileName);
        if (!file.exists()) {
            try {
                String sFilePath = FilesMan.getFilesMan().mapFilePath(_sFileName, 0);
                file = new FileService(sFilePath + _sFileName);
                if (!file.exists() || !file.isFile()) {
                    throw new WCMException(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label2", "\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + _sFileName + "]");
                }
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label2", "\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + _sFileName + "]");
            }
        }
        InputStreamReader fileReader = null;
        InputStream fis = null;
        BufferedReader buffReader = null;
        try {
            String sLine;
            fis = file.getInputStream();
            buffReader = new BufferedReader(new InputStreamReader(fis, "GBK"));
            while ((sLine = buffReader.readLine()) != null) {
                if (sLine.trim().length() == 0) continue;
                int currPosition = this.getPosition(sLine, this.m_cSplitChar);
                int nParentId = this.makeParentId(currPosition);
                String cNameAndCode = sLine.trim();
                String[] aInfos = cNameAndCode.split(this.m_cSplitChar + "+");
                String cName = "";
                String cCode = "";
                if (aInfos.length > 1) {
                    cCode = aInfos[0];
                    cName = aInfos[1];
                } else if (aInfos.length > 0) {
                    cName = aInfos[0];
                }
                ClassInfo classInfo = new ClassInfo();
                classInfo.setRootId(this.m_nRootId);
                classInfo.setParentId(nParentId);
                classInfo.setCode(cCode);
                classInfo.setName(cName);
                classInfo.insert(this.getLoginUser());
                this.m_ClassInfoStack.push(new int[]{currPosition, classInfo.getId()});
            }
        }
        catch (FileNotFoundException ex) {
            throw new Exception(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label3", "\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230[File=") + _sFileName + "]", ex);
        }
        catch (IOException ex) {
            throw new Exception(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label4", "\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef[File=") + _sFileName + "]", ex);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (buffReader != null) {
                    buffReader.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    private int indexOf(ClassInfos _CurrentChildNodes, String _Classinfoname) {
        if (_CurrentChildNodes == null) {
            return -1;
        }
        for (int i = _CurrentChildNodes.size() - 1; i >= 0; --i) {
            ClassInfo childnode = (ClassInfo)_CurrentChildNodes.getAt(i);
            if (childnode == null || !childnode.getName().equals(_Classinfoname)) continue;
            return i;
        }
        return -1;
    }

    private int getPosition(String _srcStr, char _cSplitChar) {
        if (_srcStr == null) {
            return -1;
        }
        int position = 0;
        for (int i = 0; i < _srcStr.length() && _srcStr.charAt(i) == _cSplitChar; ++i) {
            ++position;
        }
        return position;
    }

    private int makeParentId(int currPosition) {
        if (this.m_ClassInfoStack.isEmpty()) {
            return this.m_nRootId;
        }
        int[] aKeyInfo = (int[])this.m_ClassInfoStack.peek();
        int lastPosition = aKeyInfo[0];
        while (currPosition <= lastPosition) {
            this.m_ClassInfoStack.pop();
            if (this.m_ClassInfoStack.isEmpty()) {
                return this.m_nRootId;
            }
            aKeyInfo = (int[])this.m_ClassInfoStack.peek();
            lastPosition = aKeyInfo[0];
        }
        return aKeyInfo[1];
    }

    private int makeParentId(String _sCode) {
        String sParentCode;
        Integer iClassInfoKey = null;
        int[] aCodeLengths = new int[]{1, 2, 3, 4};
        for (int i = 0; i < aCodeLengths.length && _sCode.length() >= aCodeLengths[i] && (iClassInfoKey = (Integer)this.m_hClassInfoMap.get(sParentCode = _sCode.substring(0, _sCode.length() - aCodeLengths[i]))) == null; ++i) {
        }
        if (iClassInfoKey == null) {
            return this.m_nRootId;
        }
        return iClassInfoKey;
    }

    private User getLoginUser() {
        User loginUser = ContextHelper.getLoginUser();
        if (loginUser == null) {
            loginUser = User.findByName("admin");
        }
        return loginUser;
    }

    public static void main(String[] args) {
        String sPath = I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label5", "c:\\\u5206\u7c7b\u6cd5\\");
        try {
            FileService filePath = new FileService(sPath);
            FileStore[] pFiles = filePath.listFiles();
            for (int i = 0; i < pFiles.length; ++i) {
                int nStartPos;
                FileStore file = pFiles[i];
                String sFileName = file.getName();
                int nEndPos = sFileName.indexOf(46, nStartPos = sFileName.lastIndexOf(File.separatorChar));
                if (nEndPos < 0) continue;
                ClassInfoUtil util = new ClassInfoUtil();
                util.importClassInfos(sFileName.substring(nStartPos + 1, nEndPos), file.getAbsolutePath(), false, 0, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

