/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.center;

import com.trs.DreamFactory;
import com.trs.cms.auth.config.RightConfigServer;
import com.trs.cms.auth.domain.RightCacheMgr;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.CMSObjDefaultImpl;
import com.trs.cms.content.HTMLContent;
import com.trs.cms.content.Locker;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.center.DocumentFieldsSynFactory;
import com.trs.components.metadata.center.FieldValueCreatorFactory;
import com.trs.components.metadata.center.IClassInfoViewMgr;
import com.trs.components.metadata.center.IDocumentFieldsSyn;
import com.trs.components.metadata.center.IMetaDataFieldValueCreator;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.center.MetaDataCenterClassInfoHelper;
import com.trs.components.metadata.center.MetaDataCenterHelper;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.BizError;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.NullValue;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.AttributesString;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;
import com.trs.infra.util.database.DBTypes;
import com.trs.infra.util.database.FieldInfo;
import com.trs.infra.util.database.TableInfo;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class MetaViewData
extends CMSObj {
    private static Logger logger = Logger.getLogger(MetaViewData.class);
    public static final int OBJ_TYPE = 1936280531;
    public static final String METAVIEWDATA_OBJ_IN_PREVIEW = "o_MetaViewData";
    private String m_sDbTableName = null;
    private String m_sIdFieldname = "MetaDataId";
    private MetaView m_oMetaView = null;
    private Document m_oDocument = null;
    private boolean m_bSkipValid = false;
    private DocumentMgr m_oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
    private IMetaDataDefCacheMgr m_oDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
    private IClassInfoViewMgr m_oClassInfoViewMgr = (IClassInfoViewMgr)DreamFactory.createObjectById("IClassInfoViewMgr");
    private IMetaViewEmployerMgr m_oMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
    public static final Integer KEY_CURR_HOST = new Integer(1);
    public static final Integer KEY_CHANNEL_RIGHTVALUES = new Integer(2);
    private Hashtable<String, Object> m_hChnlDocProperties = new Hashtable(1);
    private HashMap m_hPublicCache = null;
    private RightValue m_oRightValue = null;
    private Channel m_oDocChannel = null;
    private Channel m_oChannel = null;
    private int m_nMetaDataId = 0;
    public static final String FIELDS_DEFAULT_CHNLDOC = "WCMCHNLDOC.RecId,WCMCHNLDOC.ChnlId,WCMCHNLDOC.DocId,WCMCHNLDOC.DocChannel,WCMCHNLDOC.DOCSTATUS,WCMChnlDoc.MODAL";

    public MetaViewData() {
        this.m_bCheckPropertyValid = false;
    }

    public MetaViewData(MetaView _view) {
        this.m_oMetaView = _view;
        this.m_sDbTableName = _view.getTrueTableName();
        this.m_bCheckPropertyValid = false;
    }

    public MetaViewData(String _sDbTableName) {
        this.m_sDbTableName = _sDbTableName;
        this.m_bCheckPropertyValid = false;
    }

    public MetaViewData(String _sDbTableName, String _sIdFieldName) {
        this.m_sDbTableName = _sDbTableName;
        this.m_sIdFieldname = _sIdFieldName;
        this.m_bCheckPropertyValid = false;
    }

    public void setView(MetaView _view) {
        this.m_oMetaView = _view;
        this.m_sDbTableName = _view.getTrueTableName();
    }

    @Override
    public String getDbTableName() {
        return this.m_sDbTableName;
    }

    public void setDbTableName(String dbTableName) {
        this.m_sDbTableName = dbTableName;
    }

    @Override
    public String getIdFieldName() {
        return this.m_sIdFieldname;
    }

    public void setIdFieldName(String idFieldname) {
        this.m_sIdFieldname = idFieldname;
    }

    public int getOriginMetaDataId() {
        return this.getPropertyAsInt("OriginMetaDataId", 0);
    }

    public void setOriginMetaDataId(int originMetaDataId) throws WCMException {
        this.setProperty("OriginMetaDataId", originMetaDataId);
    }

    @Override
    public int getWCMType() {
        return 1936280531;
    }

    @Override
    public void save(User _currUser) throws WCMException {
        super.save(_currUser);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.m_bSkipValid) {
            return true;
        }
        HashMap oViewFields = this.m_oDataDefCacheMgr.getMetaViewFields(this.m_oMetaView.getId());
        int nIdentytyField = 0;
        String sFieldAnotherName = "";
        ArrayList<Object> m_listSearchValues = new ArrayList<Object>();
        String sSql = "SELECT " + this.getDbTableName() + ".MetaDataId FROM " + this.getDbTableName() + " WHERE ";
        String sWhere = "";
        boolean bOnlyField = ConfigServer.getServer().getSysConfigValue("metadata_byIdentityField", "false").trim().equals("true");
        for (MetaViewField oViewField : oViewFields.values()) {
            String sValue;
            if (oViewField == null) continue;
            String sDBFieldName = oViewField.getDBName();
            String sFieldName = oViewField.getName();
            String sRealFieldName = sDBFieldName;
            int nFieldType = oViewField.getType();
            int nDBType = oViewField.getDBType();
            if (this.m_oMetaView.isMultiTable()) {
                sRealFieldName = sFieldName;
            }
            if (oViewField.isNotNull()) {
                if (!oViewField.isFromMainTable() || oViewField.isHidden()) continue;
                if (this.isAddMode()) {
                    sValue = this.getPropertyAsString(sRealFieldName);
                    if (CMyString.isEmpty(sValue)) {
                        throw new WCMException(I18NMessage.get(MetaViewData.class, "MetaViewData.label1", "\u5b57\u6bb5") + oViewField.getAnotherName() + I18NMessage.get(MetaViewData.class, "MetaViewData.label2", "\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
                    }
                } else {
                    sValue = this.getNewPropertyAsString(sRealFieldName);
                    if (this.isChangeProperty(sRealFieldName) && CMyString.isEmpty(sValue)) {
                        throw new WCMException(I18NMessage.get(MetaViewData.class, "MetaViewData.label1", "\u5b57\u6bb5") + oViewField.getAnotherName() + I18NMessage.get(MetaViewData.class, "MetaViewData.label2", "\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
                    }
                }
            }
            if (this.isAddMode()) {
                sValue = this.getPropertyAsString(sRealFieldName);
                if (CMyString.isEmpty(sValue)) continue;
                if (nFieldType == 4) {
                    sValue = sValue.replaceAll("\n", "");
                }
                if (oViewField.getLength() > 0 && sValue.length() > oViewField.getLength()) {
                    throw new WCMException(I18NMessage.get(MetaViewData.class, "MetaViewData.label1", "\u5b57\u6bb5") + oViewField.getAnotherName() + I18NMessage.get(MetaViewData.class, "MetaViewData.label19", "\u8d85\u957f!"));
                }
            } else {
                sValue = this.getNewPropertyAsString(sRealFieldName);
                if (CMyString.isEmpty(sValue)) continue;
                if (nFieldType == 4) {
                    sValue = sValue.replaceAll("\n", "");
                }
                if (oViewField.getLength() > 0 && sValue.length() > oViewField.getLength()) {
                    throw new WCMException(I18NMessage.get(MetaViewData.class, "MetaViewData.label1", "\u5b57\u6bb5") + oViewField.getAnotherName() + I18NMessage.get(MetaViewData.class, "MetaViewData.label19", "\u8d85\u957f!"));
                }
            }
            if (this.isAddMode()) {
                sValue = this.getPropertyAsString(sRealFieldName);
                if (CMyString.isEmpty(sValue)) continue;
                boolean bValueValid = true;
                String sRightFormat = "";
                switch (nFieldType) {
                    case 14: {
                        if (CMyString.isEmpty(sValue)) break;
                        String[] arr = sValue.split(",");
                        for (int i = 0; i < arr.length; ++i) {
                            try {
                                Integer.parseInt(arr[i]);
                                continue;
                            }
                            catch (Exception e) {
                                bValueValid = false;
                            }
                        }
                        break;
                    }
                    case 1: {
                        if (nDBType != 93) break;
                        SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy-mm-dd HH:mm:ss");
                        SimpleDateFormat fromatter2 = new SimpleDateFormat("yyyy-mm-dd HH:mm");
                        try {
                            formatter1.parse(sValue);
                        }
                        catch (ParseException e) {
                            try {
                                fromatter2.parse(sValue);
                            }
                            catch (ParseException e1) {
                                bValueValid = false;
                                sRightFormat = "yyyy-mm-dd HH:mm:ss or yyyy-mm-dd HH:mm";
                                e.printStackTrace();
                            }
                        }
                        break;
                    }
                    case 11: {
                        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-mm-dd");
                        try {
                            formatter.parse(sValue);
                            break;
                        }
                        catch (ParseException e) {
                            bValueValid = false;
                            sRightFormat = "yyyy-mm-dd";
                            e.printStackTrace();
                        }
                    }
                }
                if (!bValueValid) {
                    if (!CMyString.isEmpty(sRightFormat)) {
                        sRightFormat = I18NMessage.get(MetaViewData.class, "MetaViewData.label20", "\u6b63\u786e\u7684\u683c\u5f0f\u4e3a\uff1a") + sRightFormat;
                    }
                    throw new WCMException(I18NMessage.get(MetaViewData.class, "MetaViewData.label1", "\u5b57\u6bb5") + oViewField.getAnotherName() + I18NMessage.get(MetaViewData.class, "MetaViewData.label18", "\u683c\u5f0f\u4e0d\u6b63\u786e!") + sRightFormat);
                }
            }
            if (!bOnlyField || !oViewField.isIdentityField()) continue;
            sValue = "";
            sValue = this.isAddMode() ? this.getPropertyAsString(oViewField.getDBName()) : this.getNewPropertyAsString(oViewField.getDBName());
            if ("".equalsIgnoreCase(sValue)) continue;
            sFieldAnotherName = sFieldAnotherName + oViewField.getAnotherName() + ",";
            sWhere = sWhere == "" ? sWhere + oViewField.getDBName() + "=?" : sWhere + "and " + oViewField.getDBName() + "=?";
            int nFieldDBType = oViewField.getDBType();
            if (nFieldDBType == 4) {
                m_listSearchValues.add(nIdentytyField, new Integer(sValue));
            } else if (nFieldDBType == 93) {
                CMyDateTime dt = CMyDateTime.now();
                try {
                    dt.setDateTimeWithString(sValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                m_listSearchValues.add(nIdentytyField, dt);
            } else if (nFieldDBType == 8) {
                m_listSearchValues.add(nIdentytyField, new Double(sValue));
            } else if (nFieldDBType == 12) {
                m_listSearchValues.add(nIdentytyField, new String(sValue));
            } else if (nFieldDBType == 6) {
                m_listSearchValues.add(nIdentytyField, new Long(sValue));
            } else if (nFieldDBType == 2005) {
                m_listSearchValues.add(nIdentytyField, new CDBText(DBTypes.getDBType(nFieldDBType), sValue));
            }
            ++nIdentytyField;
        }
        if (!"".equals(sWhere) && bOnlyField) {
            sWhere = sWhere + " and MetaDataId <>" + this.getMetaDataId();
            DBManager currDBManager = DBManager.getDBManager();
            if (currDBManager == null) {
                throw new WCMException(10, I18NMessage.get(MetaViewData.class, "MetaViewData.label21", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
            }
            if (!currDBManager.isStarted()) {
                throw new WCMException(10, I18NMessage.get(MetaViewData.class, "MetaViewData.label22", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
            }
            int nCount = currDBManager.sqlExecuteIntQuery(sSql = sSql + sWhere, m_listSearchValues);
            if (nCount > 0) {
                sFieldAnotherName = sFieldAnotherName.substring(0, sFieldAnotherName.length() - 1);
                throw new WCMException(200006, I18NMessage.get(MetaViewData.class, "MetaViewData.label23", "\u8bbe\u4e3a\u552f\u4e00\u6807\u8bc6\u7684\u5b57\u6bb5[") + sFieldAnotherName + I18NMessage.get(MetaViewData.class, "MetaViewData.label24", "]\u7684\u503c\u76f8\u540c\uff0c\u76ee\u524d\u5df2\u5b58\u5728\u8fd9\u6837\u7684\u8bb0\u5f55\u3002"));
            }
        }
        return true;
    }

    public void setSkipValid(boolean _bSkipValid) {
        this.m_bSkipValid = _bSkipValid;
    }

    public static final MetaViewData findById(String _sTableName, int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        MetaViewData viewData = new MetaViewData(_sTableName);
        viewData.id = _nId;
        if (viewData.loadFromDB()) {
            return viewData;
        }
        return null;
    }

    public static final MetaViewData findById(MetaView _view, int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        MetaViewData viewData = new MetaViewData(_view);
        viewData.id = _nId;
        if (viewData.loadFromDB()) {
            return viewData;
        }
        return null;
    }

    public static final MetaViewData createNewInstance() throws WCMException {
        return (MetaViewData)BaseObj.createNewInstance(MetaViewData.class);
    }

    public static final MetaViewData findByKey(Object _oKey) throws WCMException {
        return (MetaViewData)BaseObj.findByKey(MetaViewData.class, _oKey);
    }

    public MetaView getMetaView() {
        if (this.m_oMetaView == null) {
            this.m_oMetaView = new MetaView();
        }
        return this.m_oMetaView;
    }

    public void setMetaView(MetaView metaView) {
        this.setView(metaView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(User _currUser) throws WCMException {
        int nMetaDataId;
        if (this.m_oMetaView == null) {
            throw new BizError(I18NMessage.get(MetaViewData.class, "MetaViewData.label3", "\u6ca1\u6709\u6307\u5b9a\u76f8\u5173\u89c6\u56fe"));
        }
        if (!this.isValid()) {
            throw new WCMException(1105, I18NMessage.get(MetaViewData.class, "MetaViewData.label4", "\u6dfb\u52a0\u7684\u5bf9\u8c61\u65e0\u6548\uff08") + this.getClass().getName() + ".insert\uff09");
        }
        Document newDocument = Document.createNewInstance();
        newDocument.setNextId();
        this.m_oDocument = newDocument;
        MetaDataCenterHelper.renderFields(this);
        MetaDataCenterClassInfoHelper.renderClassInfoFields(this);
        this.updateCrUserAndCrTime(newDocument);
        this.id = nMetaDataId = newDocument.getId();
        this.synFieldValue();
        newDocument.setChannel(this.getPropertyAsInt("ChannelId", 0));
        newDocument.setType(20);
        this.synDocumentFieldValueWithRule(newDocument);
        String sChangeStatus = ConfigServer.getServer().getSysConfigValue("CHANGENAME", "false");
        if ("true".equalsIgnoreCase(sChangeStatus)) {
            newDocument.setCrUser(_currUser.getName());
        }
        newDocument.setKind(this.m_oMetaView.getId());
        this.synDocumentFieldValue(newDocument);
        int nCurrDocStatus = this.getPropertyAsInt("DocStatus", 0);
        if (nCurrDocStatus == 1028) {
            newDocument.setStatus(nCurrDocStatus);
        }
        newDocument = this.m_oDocumentMgr.save(newDocument);
        this.setProperty("MetaDataId", nMetaDataId);
        this.dealWithFieldsOfEnumValue();
        if (40 == newDocument.getType()) {
            this.setProperty("DOCFILENAME", newDocument.getProperty("DOCFILENAME"));
        }
        CMSObjDefaultImpl oMainTablePO = null;
        try {
            oMainTablePO = this.saveMainTableData(_currUser, nMetaDataId);
            if (this.m_oMetaView.isMultiTable()) {
                this.createNewRelationData(_currUser, oMainTablePO);
            }
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(MetaViewData.class, "MetaViewData.label25", "\u65b0\u5efa\u5143\u6570\u636e\u8bb0\u5f55\u51fa\u73b0\u9519\u8bef"), (Throwable)e);
        }
        finally {
            if (oMainTablePO == null) {
                this.m_oDocumentMgr.delete(newDocument, null, true);
            }
        }
        if (oMainTablePO != null) {
            this.m_oClassInfoViewMgr.save(_currUser, this);
        }
    }

    private void updateCrUserAndCrTime(BaseObj _obj) throws WCMException {
        String sCrUser;
        String sCrTime = this.getPropertyAsString("CrTime");
        if (sCrTime != null) {
            _obj.setPropertyWithString("CrTime", sCrTime);
        }
        if ((sCrUser = this.getPropertyAsString("CrUser")) != null) {
            _obj.setPropertyWithString("CrUser", sCrUser);
        }
    }

    private void synFieldValue() throws WCMException {
        String sMainTableName = MetaDataConstants.makeTrueTableName(this.m_oMetaView.getMainTableName());
        List listCreator = FieldValueCreatorFactory.createValueCreator(sMainTableName);
        if (listCreator == null) {
            return;
        }
        int length = listCreator.size();
        for (int i = 0; i < length; ++i) {
            IMetaDataFieldValueCreator creator = (IMetaDataFieldValueCreator)listCreator.get(i);
            creator.setFieldValueBeforeSaveMetaData(this);
        }
    }

    private void synDocumentFieldValue(Document _document) throws WCMException {
        String sMainTableName = MetaDataConstants.makeTrueTableName(this.m_oMetaView.getMainTableName());
        List list = DocumentFieldsSynFactory.getDocumentFieldSyn(sMainTableName);
        if (list == null) {
            return;
        }
        int length = list.size();
        for (int i = 0; i < length; ++i) {
            IDocumentFieldsSyn oDocumentFieldsSyn = (IDocumentFieldsSyn)list.get(i);
            oDocumentFieldsSyn.setDocumentProperties(_document, this);
        }
    }

    public void synDocumentFieldValueWithRule(Document _document) throws WCMException {
        Hashtable<String, Object> hTemp;
        int nChannelId = this.getPropertyAsInt("channelId", 0);
        String _sMetaSynFields = Channel.findById(nChannelId).getMetaSynFields();
        if (_sMetaSynFields.equalsIgnoreCase("docTitle=&docContent=")) {
            _sMetaSynFields = this.m_oMetaView.getPropertyAsString("MetaSynFields", "docTitle=&docContent=");
        }
        HashMap ruleMap = new AttributesString(_sMetaSynFields).getAttributesMap();
        Hashtable<String, Object> properties = new Hashtable<String, Object>(this.getAllProperty());
        if (!this.isAddMode() && (hTemp = this.getNewProperties()) != null && !hTemp.isEmpty()) {
            properties.putAll(hTemp);
        }
        DBManager dbMgr = DBManager.getDBManager();
        Hashtable<String, Object> allProperties = new Hashtable<String, Object>();
        for (String fieldName : properties.keySet()) {
            String sValue = this.getRealProperty(fieldName);
            if (sValue == null) continue;
            allProperties.put(fieldName + "#VALUE", sValue);
            Object oTempValue = properties.get(fieldName);
            allProperties.put(fieldName, oTempValue);
        }
        for (Map.Entry entry : ruleMap.entrySet()) {
            String fieldName = (String)entry.getKey();
            String fieldValue = "";
            Object objectValue = entry.getValue();
            fieldValue = objectValue instanceof String[] ? ((String[])objectValue)[0] : (String)objectValue;
            String parsedFieldValue = CMyString.parsePageVariables(fieldValue, allProperties);
            boolean bDocContent = fieldName.equalsIgnoreCase("docContent");
            if (!CMyString.isEmpty(parsedFieldValue)) {
                FieldInfo fi = this.getDBManager().getFieldInfo("WCMDOCUMENT", fieldName);
                if (fi.getDataType().getType() == 12) {
                    int length = MetaDataConstants.getCompressLength(fi.getDataLength());
                    if (CMyString.getBytesLength(parsedFieldValue) > length) {
                        parsedFieldValue = CMyString.truncateStr(parsedFieldValue, length);
                    }
                }
            } else if (bDocContent) {
                parsedFieldValue = I18NMessage.get(MetaViewData.class, "MetaViewData.label6", "\u5728\u53e6\u5916\u6570\u636e\u8868\u4e2d");
            } else if (fieldName.equalsIgnoreCase("doctitle")) {
                parsedFieldValue = this.m_oMetaView.getDesc() + I18NMessage.get(MetaViewData.class, "MetaViewData.label5", "\u6570\u636e");
            }
            if (bDocContent) {
                _document.setHtmlContent(parsedFieldValue);
                _document.setContent(CMyString.innerText(parsedFieldValue));
                continue;
            }
            _document.setPropertyWithString(fieldName, parsedFieldValue);
        }
        if (!ruleMap.containsKey("DOCKEYWORDS")) {
            String sKeywords = (String)properties.get("DOCKEYWORDS");
            if (CMyString.isEmpty(sKeywords)) {
                sKeywords = (String)properties.get("KEYWORDS");
            }
            _document.setKeywords(CMyString.showNull(sKeywords));
        }
        for (String fieldName : properties.keySet()) {
            Object oTempValue = properties.get(fieldName);
            if (dbMgr.getFieldInfo("WCMDOCUMENT", fieldName) == null) continue;
            if (oTempValue instanceof String) {
                _document.setPropertyWithString(fieldName, oTempValue.toString());
                continue;
            }
            _document.setProperty(fieldName, oTempValue);
        }
    }

    public void dealWithFieldsOfEnumValue() throws WCMException {
        int nViewId = this.m_oMetaView.getId();
        HashMap viewFieldMap = this.m_oDataDefCacheMgr.getMetaViewFields(nViewId);
        Set fieldNames = viewFieldMap.keySet();
        for (String fieldName : fieldNames) {
            String currValue;
            MetaViewField viewField;
            if (!this.m_oDataDefCacheMgr.isFieldWithType(nViewId, fieldName, 15) && !this.m_oDataDefCacheMgr.isFieldWithType(nViewId, fieldName, 17) || (viewField = (MetaViewField)viewFieldMap.get(fieldName)) == null || !viewField.isFromMainTable()) continue;
            String sDBFieldName = viewField.getDBName();
            String enumValue = viewField.getEnmValue();
            if (enumValue == null) {
                enumValue = "";
            }
            String string = currValue = this.isAddMode() ? this.getPropertyAsString(sDBFieldName) : this.getNewPropertyAsString(sDBFieldName);
            if (currValue == null) continue;
            String regExpLabel = "(^|.+~)" + CMyString.encodeForRegExp(currValue) + "(~.+|$)";
            String regExpValue = ".+`" + CMyString.encodeForRegExp(currValue) + "(~.+|$)";
            if (enumValue.matches(regExpLabel) || enumValue.matches(regExpValue)) continue;
            TableInfo tableInfo = DBManager.getDBManager().getTableInfo("XWCMVIEWFIELDINFO");
            FieldInfo oFieldInfo = tableInfo.getFieldInfo("enmvalue");
            int nFieldLength = oFieldInfo.getDataLength();
            if (CMyString.isEmpty(enumValue)) {
                viewField.setEnmValue(currValue);
            } else if ("1".equals(viewField.getAttributeValue("SELTODATA")) && CMyString.getBytesLength(currValue + "~" + enumValue) <= nFieldLength) {
                viewField.setEnmValue(currValue + "~" + enumValue);
            }
            viewField.save();
        }
    }

    public String getTitle() throws WCMException {
        String sTitle;
        Hashtable<String, Object> hTemp;
        int nChannelId = this.getPropertyAsInt("channelId", 0);
        String _sMetaSynFields = Channel.findById(nChannelId).getMetaSynFields();
        String _sContent = new AttributesString(_sMetaSynFields).getAttributeValue("docTitle");
        Hashtable<String, Object> properties = new Hashtable<String, Object>(this.getProperties());
        if (!this.isAddMode() && (hTemp = this.getNewProperties()) != null && !hTemp.isEmpty()) {
            properties.putAll(hTemp);
        }
        if (!CMyString.isEmpty(sTitle = CMyString.parsePageVariables(_sContent, properties))) {
            FieldInfo fi = this.getDBManager().getFieldInfo("WCMDOCUMENT", "docTitle");
            int length = MetaDataConstants.getCompressLength(fi.getDataLength());
            if (CMyString.getBytesLength(sTitle) > length) {
                sTitle = CMyString.truncateStr(sTitle, length);
            }
            return sTitle;
        }
        return this.m_oMetaView.getDesc() + I18NMessage.get(MetaViewData.class, "MetaViewData.label5", "\u6570\u636e");
    }

    public String getContent() throws WCMException {
        String sContent;
        Hashtable<String, Object> hTemp;
        int nChannelId = this.getPropertyAsInt("channelId", 0);
        String _sMetaSynFields = Channel.findById(nChannelId).getMetaSynFields();
        String _sContent = new AttributesString(_sMetaSynFields).getAttributeValue("docContent");
        Hashtable<String, Object> properties = new Hashtable<String, Object>(this.getProperties());
        if (!this.isAddMode() && (hTemp = this.getNewProperties()) != null && !hTemp.isEmpty()) {
            properties.putAll(hTemp);
        }
        if (!CMyString.isEmpty(sContent = CMyString.parsePageVariables(_sContent, properties))) {
            return sContent;
        }
        return I18NMessage.get(MetaViewData.class, "MetaViewData.label6", "\u5728\u53e6\u5916\u6570\u636e\u8868\u4e2d");
    }

    @Override
    public synchronized void update(User _user) throws WCMException {
        try {
            Document document;
            int nMetaDataId;
            if (this.m_oMetaView == null) {
                throw new WCMException(I18NMessage.get(MetaViewData.class, "MetaViewData.label3", "\u6ca1\u6709\u6307\u5b9a\u76f8\u5173\u89c6\u56fe"));
            }
            if (!this.isValid()) {
                throw new WCMException(1105, I18NMessage.get(MetaViewData.class, "MetaViewData.label7", "\u4fee\u6539\u7684\u5bf9\u8c61\u65e0\u6548\uff08") + this.getClass().getName() + ".update\uff09");
            }
            MetaDataCenterHelper.renderFields(this);
            MetaDataCenterClassInfoHelper.renderClassInfoFields(this);
            this.id = nMetaDataId = this.getPropertyAsInt("MetaDataId", 0);
            this.synFieldValue();
            CMSObjDefaultImpl oMainTablePO = this.saveMainTableData(_user, nMetaDataId);
            if (this.m_oMetaView.isMultiTable()) {
                this.createNewRelationData(_user, oMainTablePO);
            }
            if ((document = Document.findById(nMetaDataId)) == null) {
                throw new WCMException(I18NMessage.get(MetaViewData.class, "MetaViewData.label8", "\u6307\u5b9a\u7684\u6570\u636e\u6ca1\u6709\u627e\u5230\uff01"));
            }
            if (this.isChangeProperty("ChannelId")) {
                document.validCanDeleteAndLock(_user);
                document.setChannel(this.getNewPropertyAsInt("ChannelId", 0));
            }
            this.synDocumentFieldValueWithRule(document);
            this.synDocumentFieldValue(document);
            this.m_oDocumentMgr.save(document);
            this.dealWithFieldsOfEnumValue();
            this.m_oClassInfoViewMgr.save(_user, this);
        }
        catch (WCMException e) {
            throw e;
        }
        finally {
            Locker locker = this.getLocker(false);
            if (locker != null && locker.isLocked() && locker.lockUserIs(_user)) {
                this.unlock();
            }
        }
    }

    @Override
    public synchronized void insert() throws WCMException {
        throw new WCMException(I18NMessage.get(MetaViewData.class, "MetaViewData.label9", "\u540c\u5b66\uff0c\u60a8\u4f7f\u7528\u9519\u63a5\u53e3\u4e86\uff0c\u8bf7\u4f7f\u7528insert(User)!"));
    }

    @Override
    public synchronized void update() throws WCMException {
        throw new WCMException(I18NMessage.get(MetaViewData.class, "MetaViewData.label10", "\u540c\u5b66\uff0c\u60a8\u4f7f\u7528\u9519\u63a5\u53e3\u4e86\uff0cupdate(User)!"));
    }

    @Override
    public void save() throws WCMException {
        throw new WCMException(I18NMessage.get(MetaViewData.class, "MetaViewData.label11", "\u540c\u5b66\uff0c\u60a8\u4f7f\u7528\u9519\u63a5\u53e3\u4e86\uff0csave(User)!"));
    }

    public int deleteViewDataAndDoc(User _currUser) throws WCMException {
        Document document = Document.findById(this.getId());
        this.m_oDocumentMgr.delete(document, null, true);
        String sSQLDeleteMainTableData = "delete from " + MetaDataConstants.makeTrueTableName(this.m_oMetaView.getMainTableName()) + " where " + "MetaDataId" + "=?";
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{sSQLDeleteMainTableData}, new int[]{this.getId()});
        if (this.m_oMetaView.isMultiTable()) {
            String sSQLDeleteRealtionTableData = "delete from WCMMetaRelation" + this.m_oMetaView.getId() + " where " + "MetaDataId" + "=?";
            DBManager.getDBManager().sqlExecuteUpdate(new String[]{sSQLDeleteRealtionTableData}, new int[]{this.getId()});
        }
        this.m_oClassInfoViewMgr.delete(_currUser, this);
        return 1;
    }

    @Override
    public int delete(User _currUser) throws WCMException {
        this.deleteAppendix();
        String sSQLDeleteMainTableData = "delete from " + MetaDataConstants.makeTrueTableName(this.m_oMetaView.getMainTableName()) + " where " + "MetaDataId" + "=?";
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{sSQLDeleteMainTableData}, new int[]{this.getId()});
        if (this.m_oMetaView.isMultiTable()) {
            String sSQLDeleteRealtionTableData = "delete from WCMMetaRelation" + this.m_oMetaView.getId() + " where " + "MetaDataId" + "=?";
            DBManager.getDBManager().sqlExecuteUpdate(new String[]{sSQLDeleteRealtionTableData}, new int[]{this.getId()});
        }
        this.m_oClassInfoViewMgr.delete(_currUser, this);
        return 1;
    }

    private void deleteAppendix() throws WCMException {
        Map hFields = this.m_oDataDefCacheMgr.getMetaViewFields(this.getMetaView().getId(), 8);
        if (hFields.size() <= 0) {
            return;
        }
        this.loadFromDB(this.getSelectFields());
        for (MetaViewField field : hFields.values()) {
            String sFileName;
            if (field == null || CMyString.isEmpty(sFileName = this.getPropertyAsString(field.getName()))) continue;
            FieldAppendix[] oFieldAppendixes = MetaViewData.getFieldAppendixes(sFileName);
            for (int i = 0; i < oFieldAppendixes.length; ++i) {
                String sTmpFileName = oFieldAppendixes[i].getName();
                FilesMan filesMan = FilesMan.getFilesMan();
                String sPath = filesMan.mapFilePath(sTmpFileName, 0);
                CMyFile.deleteFile(sPath + sTmpFileName);
            }
        }
    }

    public Document getDocumnent() throws WCMException {
        return Document.findById(this.getDocumentId());
    }

    public int getDocumentId() {
        return this.getPropertyAsInt("MetaDataId", 0);
    }

    public int getChnlDocId() {
        try {
            return Integer.parseInt(this.getChnlDocProperty("RECID"));
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public ChnlDoc getChnlDoc() throws WCMException {
        return ChnlDoc.findById(this.getChnlDocId());
    }

    public static MetaViewData findById(int _nMetaViewDataId) throws WCMException {
        Document document = Document.findById(_nMetaViewDataId);
        if (document == null) {
            return null;
        }
        MetaView view = MetaView.findById(document.getKindId());
        if (view == null) {
            throw new BizError(I18NMessage.get(MetaViewData.class, "MetaViewData.label12", "\u6240\u5c5e\u7684\u89c6\u56fe\u5df2\u7ecf\u88ab\u5220\u9664\uff01[ViewId=") + document.getKindId() + "]");
        }
        MetaViewData viewData = new MetaViewData(view);
        viewData.m_oDocument = document;
        viewData.m_oMetaView = view;
        viewData.id = _nMetaViewDataId;
        if (viewData.loadFromDB(viewData.getSelectFields())) {
            return viewData;
        }
        return viewData;
    }

    public Document getDocument() throws WCMException {
        if (this.m_oDocument == null) {
            this.m_oDocument = Document.findById(this.getDocumentId());
        }
        return this.m_oDocument;
    }

    public String getSelectFields() throws WCMException {
        HashMap hFields = this.m_oDataDefCacheMgr.getMetaViewFields(this.m_oMetaView.getId());
        boolean bMultiTable = this.m_oMetaView.isMultiTable();
        int nDefaultFieldsCount = MetaDataConstants.DEFAULT_FIELDS.getDataTypesCount();
        StringBuffer sbSelectFields = new StringBuffer((hFields.size() + nDefaultFieldsCount) * 10);
        sbSelectFields.append("MetaDataId");
        for (int i = 1; i < MetaDataConstants.DEFAULT_FIELDS.getDataTypesCount(); ++i) {
            sbSelectFields.append(",");
            sbSelectFields.append(MetaDataConstants.DEFAULT_FIELDS.getDataTypeAt(i).getKey());
        }
        for (MetaViewField field : hFields.values()) {
            if (field == null) continue;
            sbSelectFields.append(",");
            if (bMultiTable || field.getDBName().equalsIgnoreCase(field.getName())) {
                sbSelectFields.append(field.getName());
                continue;
            }
            sbSelectFields.append(field.getDBName() + " " + field.getName());
        }
        return sbSelectFields.toString();
    }

    private CMSObjDefaultImpl saveMainTableData(User _currUser, int _nMetaDataId) throws WCMException {
        String sMainTableName = MetaDataConstants.makeTrueTableName(this.m_oMetaView.getMainTableName());
        String sMainTableIdName = sMainTableName + "ID";
        int nMainTableId = this.getPropertyAsInt(sMainTableIdName, 0);
        CMSObjDefaultImpl oMainTablePO = new CMSObjDefaultImpl(sMainTableName, this.isAddMode() ? sMainTableIdName : "MetaDataId");
        oMainTablePO.setViewId(this.m_oMetaView.getId());
        if (!this.isAddMode()) {
            oMainTablePO.loadById(_nMetaDataId, "*");
            oMainTablePO.validCanEditAndLock(_currUser);
        }
        this.copyTo(oMainTablePO);
        if (nMainTableId == 0) {
            oMainTablePO.setProperty("MetaDataId", _nMetaDataId);
        }
        if (this.isAddMode() && oMainTablePO.getPropertyAsInt("OriginMetaDataId", 0) == 0) {
            oMainTablePO.setProperty("OriginMetaDataId", _nMetaDataId);
        }
        oMainTablePO.save(_currUser);
        return oMainTablePO;
    }

    private void createNewRelationData(User _currUser, CMSObjDefaultImpl _oMainTablePO) throws WCMException {
        String sTableName = "WCMMetaRelation" + this.m_oMetaView.getId();
        CMSObjDefaultImpl oRelationTablePO = new CMSObjDefaultImpl(sTableName, this.isAddMode() ? sTableName + "ID" : "MetaDataId");
        if (!this.isAddMode()) {
            oRelationTablePO.loadById(_oMainTablePO.getPropertyAsInt("MetaDataId", 0), null);
            oRelationTablePO.validCanEditAndLock(_currUser);
        }
        this.copyTo(oRelationTablePO);
        if (this.isAddMode()) {
            Object oMetaDataId = _oMainTablePO.getProperty("MetaDataId");
            oRelationTablePO.setProperty(_oMainTablePO.getIdFieldName(), oMetaDataId);
            oRelationTablePO.setProperty("MetaDataId", oMetaDataId);
        }
        oRelationTablePO.save(_currUser);
    }

    private void copyTo(CMSObjDefaultImpl _oDstPO) throws WCMException {
        Hashtable<String, Object> currProperties = null;
        currProperties = this.isAddMode() ? this.getProperties() : this.getNewProperties();
        TableInfo oTableInfo = this.getDBManager().getTableInfo(_oDstPO.getDbTableName());
        if (oTableInfo == null) {
            throw new WCMException(I18NMessage.get(MetaViewData.class, "MetaViewData.label13", "\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u8868\u627e\u4e0d\u5230\uff0c\u7cfb\u7edf\u6545\u969c\uff0c\u8bf7\u548c\u7814\u53d1\u4eba\u5458\u8054\u7cfb\uff01[TalbleName=") + _oDstPO.getDbTableName() + "]");
        }
        Enumeration<String> enPropertyKeys = currProperties.keys();
        while (enPropertyKeys.hasMoreElements()) {
            String sName = enPropertyKeys.nextElement();
            if (!oTableInfo.isField(sName)) {
                if (!sName.equals("OBJECTID") || !sName.equals("VIEWID")) continue;
                logger.warn((Object)("The field[" + oTableInfo.getTableName() + "." + sName + "] not exists! Ignore to set property!"));
                continue;
            }
            Object value = currProperties.get(sName);
            if (value instanceof String) {
                _oDstPO.setPropertyWithString(sName, (String)value);
                continue;
            }
            _oDstPO.setProperty(sName, value);
        }
    }

    public boolean setProperties(Map _properties) {
        if (_properties == null) {
            return false;
        }
        this.getProperties(true).putAll(_properties);
        return true;
    }

    public MetaViewData(MetaView _view, HashMap _hPublicCache) {
        this.m_hPublicCache = _hPublicCache;
        this.m_bCheckPropertyValid = false;
        this.m_oMetaView = _view;
        this.m_sDbTableName = _view.getTrueTableName();
    }

    @Override
    public void setId(int _nId) {
        this.id = _nId;
    }

    public final void readChnlDocPropertyFromRs(ResultSet _rsData, ResultSetMetaData _rsmdData) throws WCMException {
        try {
            if (_rsData == null) {
                return;
            }
            Object objValue = null;
            ResultSetMetaData rsmdData = _rsmdData != null ? _rsmdData : _rsData.getMetaData();
            int nColCount = rsmdData.getColumnCount();
            for (int i = 1; i <= nColCount; ++i) {
                String sFieldName = rsmdData.getColumnLabel(i).toUpperCase();
                if (sFieldName.equalsIgnoreCase("DOCID")) {
                    this.setMetaDataId(_rsData.getInt(i));
                    continue;
                }
                objValue = null;
                switch (rsmdData.getColumnType(i)) {
                    case 2: 
                    case 3: {
                        if (rsmdData.getScale(i) <= 0) {
                            long lValue = _rsData.getLong(i);
                            if (_rsData.wasNull()) break;
                            objValue = new Long(lValue);
                            break;
                        }
                        if (_rsData.wasNull()) break;
                        BigDecimal dValue = new BigDecimal(_rsData.getDouble(i));
                        dValue = dValue.setScale(rsmdData.getScale(i), 4);
                        if (_rsData.wasNull()) break;
                        objValue = dValue;
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        long lValue = _rsData.getLong(i);
                        if (_rsData.wasNull()) break;
                        objValue = new Long(lValue);
                        break;
                    }
                    case 12: {
                        objValue = _rsData.getString(i);
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        objValue = new CMyDateTime();
                        ((CMyDateTime)objValue).setDateTimeWithRs(_rsData, i);
                        break;
                    }
                    case -1: 
                    case 2005: {
                        objValue = new CDBText(this.getDBManager().getDBType());
                        ((CDBText)objValue).readFromRs(_rsData, i);
                        break;
                    }
                    case 8: {
                        double dValue = _rsData.getDouble(i);
                        if (_rsData.wasNull()) break;
                        objValue = new Double(dValue);
                        break;
                    }
                    default: {
                        objValue = _rsData.getObject(i);
                    }
                }
                if (objValue == null) continue;
                this.setChnlDocProperty(sFieldName, objValue);
            }
            this.id = this.getChnlDocProperty("RECID", 0);
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(MetaViewData.class, "MetaViewData.label14", "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519\uff08") + this.getClass().getName() + ".readChnlDocPropertyFromRs).", ex);
        }
        catch (CMyException ex) {
            throw new WCMException(1, I18NMessage.get(MetaViewData.class, "MetaViewData.label14", "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519\uff08") + this.getClass().getName() + ".readChnlDocPropertyFromRs).", ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(MetaViewData.class, "MetaViewData.label14", "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519\uff08") + this.getClass().getName() + ".readChnlDocPropertyFromRs).", ex);
        }
    }

    public void setChnlDocProperty(String _sFieldName, Object _value) {
        if (this.m_hChnlDocProperties == null) {
            this.m_hChnlDocProperties = new Hashtable();
        }
        this.m_hChnlDocProperties.put(_sFieldName.toUpperCase(), _value);
    }

    public void putAllChnlDocProperty(Map<String, Object> _shChnlDocProperties) {
        if (this.m_hChnlDocProperties == null) {
            this.m_hChnlDocProperties = new Hashtable();
        }
        this.m_hChnlDocProperties.putAll(_shChnlDocProperties);
    }

    public int getChnlDocProperty(String _sFieldName, int _nDefault) {
        Number value = (Number)this.m_hChnlDocProperties.get(_sFieldName.toUpperCase());
        if (value == null) {
            return _nDefault;
        }
        return value.intValue();
    }

    public String getChnlDocProperty(String _sFieldName) {
        Object value = this.m_hChnlDocProperties.get(_sFieldName.toUpperCase());
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public void cloneDocumentProperties(MetaViewData _viewData) {
        this.m_hProperties = _viewData.getProperties(false);
    }

    public Hashtable<String, Object> getChnlDocProperties() {
        return this.m_hChnlDocProperties;
    }

    public int getMetaDataId() {
        if (this.m_nMetaDataId != 0) {
            return this.m_nMetaDataId;
        }
        return this.getPropertyAsInt("MetaDataId", 0);
    }

    public void setMetaDataId(int docId) {
        this.m_nMetaDataId = docId;
    }

    public int getChannelId() {
        int nChannelId = Math.abs(this.getChnlDocProperty("CHNLID", 0));
        if (nChannelId == 0) {
            nChannelId = this.getPropertyAsInt("ChannelId", 0);
        }
        return nChannelId;
    }

    public Channel getChannel() throws WCMException {
        if (this.m_oChannel != null) {
            return this.m_oChannel;
        }
        int nChannelId = this.getChannelId();
        BaseChannel oChannelOrSite = this.getCurrChannelOrSite();
        if (oChannelOrSite != null && !oChannelOrSite.isSite() && oChannelOrSite.getId() == nChannelId) {
            this.m_oChannel = (Channel)oChannelOrSite;
            return this.m_oChannel;
        }
        int nModal = this.getChnlDocProperty("Modal", 1);
        if (nModal == 1 && this.getDocChannelId() == nChannelId) {
            this.m_oChannel = this.getDocChannel();
            return this.m_oChannel;
        }
        this.m_oChannel = Channel.findById(nChannelId);
        if (this.m_oChannel == null) {
            this.m_oChannel = Channel.findById(this.getPropertyAsInt("ChannelId", 0));
        }
        return this.m_oChannel;
    }

    public int getDocChannelId() {
        int nDocChannelId = Math.abs(this.getChnlDocProperty("DocChannel", 0));
        if (nDocChannelId <= 0) {
            nDocChannelId = Math.abs(this.getPropertyAsInt("ChannelId", 0));
        }
        return nDocChannelId;
    }

    public Channel getDocChannel() throws WCMException {
        if (this.m_oDocChannel == null) {
            this.m_oDocChannel = Channel.findById(this.getDocChannelId());
        }
        return this.m_oDocChannel;
    }

    public int getStatusId() {
        return this.getChnlDocProperty("DOCSTATUS", 0);
    }

    public Status getStatus() throws WCMException {
        return Status.findById(Math.abs(this.getStatusId()));
    }

    public boolean isTopped() {
        BaseChannel host = this.getCurrChannelOrSite();
        if (host == null) {
            return false;
        }
        if (host.isSite()) {
            return false;
        }
        Channel channel = (Channel)host;
        if (channel.isOnlySearch()) {
            return false;
        }
        String sOrderBy = channel.getOrderBy();
        if (sOrderBy != null && (sOrderBy = sOrderBy.trim()).length() > 0 && sOrderBy.toUpperCase().indexOf("DOCORDERPRI") < 0) {
            return false;
        }
        return this.getChnlDocProperty("DOCORDERPRI", 0) > 0;
    }

    public HashMap getPublicCache() {
        if (this.m_hPublicCache == null) {
            this.m_hPublicCache = new HashMap(1);
        }
        return this.m_hPublicCache;
    }

    public void setPublicCache(HashMap publicCache) {
        this.m_hPublicCache = publicCache;
    }

    public BaseChannel getCurrChannelOrSite() {
        return (BaseChannel)this.getPublicCache().get(KEY_CURR_HOST);
    }

    public RightValue getRightValue(User _currUser) throws WCMException {
        if (this.m_oRightValue != null) {
            return this.m_oRightValue;
        }
        this.m_oRightValue = this.makeRightValue(_currUser);
        return this.m_oRightValue;
    }

    private RightValue makeRightValue(User _currUser) throws WCMException {
        if (this.isRightDefined()) {
            try {
                RightValue rightValue = new RightValue();
                rightValue.load(_currUser, 605, this.getMetaDataId(), true);
                if (_currUser.getName().equalsIgnoreCase(this.getCrUserName())) {
                    int[] pRightIndexesOnOwner = DocumentAuthServer.INDEXES_OWNER_HAS;
                    for (int i = 0; i < pRightIndexesOnOwner.length; ++i) {
                        int nRightIndex = pRightIndexesOnOwner[i];
                        rightValue.setBit(nRightIndex, true);
                    }
                }
                return rightValue;
            }
            catch (WCMException ex) {
                throw new WCMException(1100, I18NMessage.get(MetaViewData.class, "MetaViewData.label15", "\u83b7\u53d6\u6307\u5b9a\u5bf9\u8c61\u7684\u6743\u9650\u503c\u65f6\u5931\u8d25(") + this.getClass().getName() + ".getRightValue)", ex);
            }
        }
        if (_currUser.isAdministrator()) {
            return RightValue.getAdministratorRightValue();
        }
        BaseChannel host = this.getCurrChannelOrSite();
        Channel currChannel = null;
        currChannel = host != null && !host.isSite() && host.getId() == this.getChannelId() ? (Channel)host : this.getChannel();
        RightValue newRightValue = new RightValue();
        RightValue currChannelRightValue = this.getChannelRightValueFromCache(_currUser, currChannel);
        if (this.getDocChannelId() > 0 && currChannel.getId() != this.getDocChannelId()) {
            RightValue docChannelRightValue = this.getChannelRightValueFromCache(_currUser, this.getDocChannel());
            newRightValue.copy(docChannelRightValue);
            int[] pRightIndexesOnChannel = RightConfigServer.getInstance().getRightIndexDefineOnCurrChannel(currChannel.getSiteId());
            for (int i = 0; i < pRightIndexesOnChannel.length; ++i) {
                int nRightIndex = pRightIndexesOnChannel[i];
                newRightValue.setBit(nRightIndex, currChannelRightValue.getBit(nRightIndex));
            }
        } else {
            newRightValue.copy(currChannelRightValue);
        }
        if (_currUser.getName().equalsIgnoreCase(this.getCrUserName())) {
            int[] pRightIndexesOnOwner = DocumentAuthServer.INDEXES_OWNER_HAS;
            for (int i = 0; i < pRightIndexesOnOwner.length; ++i) {
                int nRightIndex = pRightIndexesOnOwner[i];
                newRightValue.setBit(nRightIndex, true);
            }
        }
        return newRightValue;
    }

    private RightValue getChannelRightValueFromCache(User _currUser, Channel _channel) throws WCMException {
        RightValue rightValue;
        Integer iKey = _channel.getKey();
        HashMap<Integer, RightValue> hChannelRightValue = (HashMap<Integer, RightValue>)this.getPublicCache().get(KEY_CHANNEL_RIGHTVALUES);
        if (hChannelRightValue == null) {
            hChannelRightValue = new HashMap<Integer, RightValue>(1);
            this.getPublicCache().put(KEY_CHANNEL_RIGHTVALUES, hChannelRightValue);
        }
        if ((rightValue = (RightValue)hChannelRightValue.get(iKey)) == null) {
            if (_currUser.isAdministrator() || _currUser.getName().equalsIgnoreCase(_channel.getCrUserName())) {
                rightValue = RightValue.getAdministratorRightValue();
            } else {
                rightValue = new RightValue();
                rightValue.load(_currUser, 101, _channel.getId(), true);
                hChannelRightValue.put(iKey, rightValue);
            }
        }
        return rightValue;
    }

    public boolean isRightDefined() throws WCMException {
        RightCacheMgr oRightCacheMgr = (RightCacheMgr)DreamFactory.createObjectById("RightCacheMgr");
        return oRightCacheMgr.isExistsRight(605, this.getMetaDataId());
    }

    public boolean hasRight(User _loginUser, int _nRightIndex) throws WCMException {
        RightValue rightValue = this.getRightValue(_loginUser);
        if (_nRightIndex == 64) {
            return rightValue.getValue() > 0L;
        }
        return rightValue.isHasRight(_nRightIndex);
    }

    @Override
    public String toString() {
        try {
            return this.getTitle() + "[ViewId=" + (this.m_oMetaView == null ? 0 : this.m_oMetaView.getId()) + ",Id=" + this.getId() + "]";
        }
        catch (Exception e) {
            return I18NMessage.get(MetaViewData.class, "MetaViewData.label16", "\u8d44\u6e90\u5e93\u6570\u636e");
        }
    }

    public String getRealProperty(String _sPropertyName) throws WCMException {
        return this.getRealProperty(_sPropertyName, ",");
    }

    public String getRealProperty(String _sPropertyName, String _sDelim) throws WCMException {
        MetaView oMetaView = new MetaView();
        oMetaView = this.m_oMetaView == null ? this.m_oMetaViewEmployerMgr.getViewOfEmployer(this.getChannel()) : this.m_oMetaView;
        if (oMetaView == null || oMetaView.getId() == 0) {
            return "";
        }
        MetaViewField viewField = this.m_oDataDefCacheMgr.getMetaViewField(oMetaView.getId(), _sPropertyName);
        if (viewField == null) {
            return CMyString.showNull(this.getPropertyAsString(_sPropertyName));
        }
        Object value = this.getProperty(_sPropertyName);
        if (value == null) {
            return "";
        }
        try {
            int nCurrNewType = MetaDataConstants.formatOfEnumValue(viewField.getType());
            switch (nCurrNewType) {
                case -1: {
                    return this.convertoDesc(value.toString(), viewField.getEnmValue(), _sDelim);
                }
                case 11: {
                    if (value instanceof CMyDateTime) {
                        CMyDateTime dtDate = (CMyDateTime)value;
                        return dtDate.toString("yyyy-MM-dd");
                    }
                    return value.toString();
                }
                case 5: {
                    switch (this.getPropertyAsInt(_sPropertyName, -1)) {
                        case 0: {
                            return I18NMessage.get(MetaViewData.class, "MetaViewData.label26", "\u5426");
                        }
                        case 1: {
                            return I18NMessage.get(MetaViewData.class, "MetaViewData.label27", "\u662f");
                        }
                        case -1: {
                            return "";
                        }
                    }
                    return I18NMessage.get(MetaViewData.class, "MetaViewData.label28", "\u672a\u77e5[") + value + "]";
                }
                case 10: {
                    ClassInfos classInfos = ClassInfos.findByIds(null, this.getPropertyAsString(_sPropertyName));
                    StringBuffer sbResult = new StringBuffer(classInfos.size() * 20);
                    int nSize = classInfos.size();
                    for (int i = 0; i < nSize; ++i) {
                        ClassInfo classInfo = (ClassInfo)classInfos.getAt(i);
                        if (classInfo == null) continue;
                        sbResult.append(classInfo.getName());
                        sbResult.append(",");
                    }
                    if (sbResult.length() > 0) {
                        sbResult.setLength(sbResult.length() - 1);
                    }
                    return sbResult.toString();
                }
            }
            if (value instanceof Double || value instanceof Float) {
                DecimalFormat df = new DecimalFormat("###.###");
                return df.format(value);
            }
            return value.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return value.toString();
        }
    }

    public String getAppendixProperty(String _sPropertyName, int _nPathType) throws WCMException {
        MetaViewField viewField = this.m_oDataDefCacheMgr.getMetaViewField(this.m_oMetaView.getId(), _sPropertyName);
        String sFieldValue = this.getPropertyAsString(_sPropertyName);
        if (viewField.getType() != 8) {
            return sFieldValue;
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        return filesMan.mapFilePath(sFieldValue, _nPathType);
    }

    private String convertoDesc(String _sValue, String _sEnmValue, String _sDelim) {
        if (CMyString.isEmpty(_sValue)) {
            return _sValue;
        }
        if (CMyString.isEmpty(_sEnmValue) || _sEnmValue.indexOf(96) < 0) {
            if (_sValue.equals("-1")) {
                return "";
            }
            return _sValue;
        }
        if (_sDelim == null || (_sDelim = _sDelim.trim()).length() == 0) {
            _sDelim = ",";
        }
        StringBuffer buff = new StringBuffer(128);
        List<String> values = Arrays.asList(_sValue.toLowerCase().split(","));
        StringTokenizer st = new StringTokenizer(_sEnmValue, "~");
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            String[] aItem = item.split("`");
            if (aItem.length < 1) continue;
            if (aItem.length == 1 && values.contains(aItem[0].toLowerCase())) {
                if (buff.length() > 0) {
                    buff.append(_sDelim);
                }
                buff.append(aItem[0]);
                continue;
            }
            if (aItem.length <= 1 || !values.contains(aItem[1].toLowerCase())) continue;
            if (buff.length() > 0) {
                buff.append(_sDelim);
            }
            buff.append(aItem[0]);
        }
        if (buff.length() > 0) {
            return buff.toString();
        }
        if (_sValue.equals("-1")) {
            return "";
        }
        return _sValue;
    }

    @Override
    public synchronized BaseObj cloneToNewObj() throws WCMException {
        MetaViewData oViewData = (MetaViewData)super.cloneToNewObj();
        oViewData.setMetaView(this.getMetaView());
        oViewData.translateFields();
        oViewData.cloneFields();
        return oViewData;
    }

    private void cloneFields() throws WCMException {
        HashMap hFields = this.m_oDataDefCacheMgr.getMetaViewFields(this.getMetaView().getId());
        for (MetaViewField field : hFields.values()) {
            if (field == null || !field.isFromMainTable()) continue;
            switch (field.getType()) {
                case 12: 
                case 16: {
                    String sFieldName = field.getName();
                    String sFieldValue = this.getFinalPropertyAsString(sFieldName);
                    if (CMyString.isEmpty(sFieldValue)) break;
                    sFieldValue = HTMLContent.saveHtmlContent(sFieldValue, true, true);
                    this.setProperty(sFieldName, sFieldValue);
                    break;
                }
                case 8: {
                    String sFieldName = field.getName();
                    String sFieldValue = this.getFinalPropertyAsString(sFieldName);
                    if (CMyString.isEmpty(sFieldValue)) break;
                    String[] sAppendixFileAllNames = sFieldValue.split(";");
                    StringBuffer sbNewValue = new StringBuffer();
                    for (int i = 0; i < sAppendixFileAllNames.length; ++i) {
                        String sAppendixFileAllName = sAppendixFileAllNames[i];
                        String sAppendixName = sAppendixFileAllName.split(",")[0];
                        if (!FilesMan.isValidFile(sAppendixName, "P0") && !FilesMan.isValidFile(sAppendixName, "W0")) {
                            sbNewValue.append(sAppendixFileAllName).append(";");
                            continue;
                        }
                        String sNewValue = FilesMan.getFilesMan().copyWCMFile(sAppendixName, "P0");
                        sAppendixFileAllName = sAppendixFileAllName.replaceAll(sAppendixName, sNewValue);
                        sbNewValue.append(sAppendixFileAllName).append(";");
                    }
                    String sNewValues = sbNewValue.toString();
                    sNewValues = sNewValues.substring(0, sNewValues.lastIndexOf(";"));
                    this.setProperty(sFieldName, sNewValues);
                    break;
                }
            }
        }
    }

    public void translateFields() throws WCMException {
        HashMap hFields = this.m_oDataDefCacheMgr.getMetaViewFields(this.m_oMetaView.getId());
        for (MetaViewField field : hFields.values()) {
            Object oFieldValue;
            if (field == null) continue;
            String sViewFieldName = field.getName();
            if (!field.isFromMainTable()) {
                String sIdentifyFieldName = field.getTableName() + "ID";
                if (sViewFieldName.equalsIgnoreCase(sIdentifyFieldName)) continue;
                this.removeProperty(sViewFieldName);
                continue;
            }
            String sDBFieldName = field.getDBName();
            if (sViewFieldName.equalsIgnoreCase(sDBFieldName) || (oFieldValue = this.getProperty(sViewFieldName)) == null) continue;
            this.setProperty(sDBFieldName, oFieldValue);
            this.removeProperty(sViewFieldName);
        }
    }

    @Override
    public String getFinalPropertyAsString(String _sName) {
        return this.getFinalPropertyAsString(_sName, null);
    }

    @Override
    public String getFinalPropertyAsString(String _sName, String _sDefaultValue) {
        if (this.isAddMode()) {
            return this.getPropertyAsString(_sName, _sDefaultValue);
        }
        return CMyString.showNull(this.getNewPropertyAsString(_sName), _sDefaultValue);
    }

    public String abstractPicSrc(String _htmlContent) throws WCMException {
        FilesMan aFilesMan = FilesMan.getFilesMan();
        String temp_htmlContent = _htmlContent;
        int startPos = 0;
        int endPos = 0;
        String startTag = " src=";
        String endTag = ".bmp";
        String oldFile = "";
        String newFile = "";
        int len = _htmlContent.length();
        while (startPos < len && _htmlContent.indexOf(startTag, startPos) > 0) {
            startPos = _htmlContent.indexOf(startTag, startPos) + 5;
            endPos = _htmlContent.indexOf(endTag, startPos) + 4;
            oldFile = _htmlContent.substring(startPos, endPos);
            newFile = aFilesMan.mapFilePath(oldFile, 1) + oldFile;
            temp_htmlContent = temp_htmlContent.replaceAll(oldFile, newFile);
            startPos = endPos;
        }
        return temp_htmlContent;
    }

    @Override
    public int getPropertyAsInt(String _sName, int _nDefault) {
        Object objValue = this.getProperty(_sName);
        if (this.isNullValue(objValue)) {
            return _nDefault;
        }
        if (objValue instanceof Number) {
            return ((Number)objValue).intValue();
        }
        if (CMyString.isEmpty(objValue.toString())) {
            return _nDefault;
        }
        return Integer.parseInt(objValue.toString());
    }

    public static FieldAppendix[] getFieldAppendixes(String sFieldValue) {
        String[] sAppendixFileAllNames = sFieldValue.split(";");
        FieldAppendix[] result = new FieldAppendix[sAppendixFileAllNames.length];
        for (int i = 0; i < sAppendixFileAllNames.length; ++i) {
            FieldAppendix oFieldAppendix;
            String sAppendixFileAllName = sAppendixFileAllNames[i];
            String[] oAppendixInfos = sAppendixFileAllName.split(",");
            String sAppendixName = oAppendixInfos[0];
            String sOriginalName = oAppendixInfos.length > 1 ? oAppendixInfos[1] : oAppendixInfos[0];
            result[i] = oFieldAppendix = new FieldAppendix(sAppendixName, sOriginalName);
        }
        return result;
    }

    public static String getTransformFieldAppendixes(FieldAppendix[] oFieldAppendixes) {
        if (oFieldAppendixes == null) {
            return "";
        }
        StringBuffer sbResult = new StringBuffer();
        for (int i = 0; i < oFieldAppendixes.length; ++i) {
            if (CMyString.isEmpty(oFieldAppendixes[i].getName())) continue;
            sbResult.append(oFieldAppendixes[i].getName());
            sbResult.append(",");
            sbResult.append(oFieldAppendixes[i].getOriginalName());
            sbResult.append(";");
        }
        if (sbResult.length() > 0) {
            sbResult.setLength(sbResult.length() - 1);
        }
        return sbResult.toString();
    }

    private boolean isNullValue(Object objValue) {
        return objValue == null || objValue instanceof NullValue;
    }

    @Override
    public Map<String, Object> getExtProperties() {
        return this.m_hChnlDocProperties;
    }

    @Override
    public void setExtProperty(String _sName, Object _oValue) {
        if (CMyString.isEmpty(_sName)) {
            return;
        }
        this.m_hChnlDocProperties.put(_sName.toUpperCase(), _oValue);
    }

    @Override
    public Object getExtProperty(String _sName) {
        if (CMyString.isEmpty(_sName)) {
            return null;
        }
        return this.m_hChnlDocProperties.get(_sName.toUpperCase());
    }

    public static void main(String[] args) {
        String sValue = "~!@#$%^&*()_+|}{\":?><,./;'\\[\\]\\=-`";
        String regExpLabel = "(^|.+~)" + sValue + "(~.+|$)";
        System.out.println("sdfsdf.sdf".matches(regExpLabel));
    }

    public static class FieldAppendix {
        private String name;
        private String originalName;

        public FieldAppendix(String sName, String sOriginalName) {
            this.name = sName;
            this.originalName = sOriginalName;
        }

        public void setName(String sName) {
            this.name = sName;
        }

        public void setOriginalName(String sOriginalName) {
            this.originalName = sOriginalName;
        }

        public String getName() {
            return this.name;
        }

        public String getOriginalName() {
            return this.originalName;
        }
    }
}

