/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.center;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObjDefaultImpl;
import com.trs.components.metadata.center.ClassInfoView;
import com.trs.components.metadata.center.IClassInfoViewMgr;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.center.MetaViewDatas;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IClassInfoMgr;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.IMetaDataDefMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFields;
import com.trs.components.metadata.definition.MetaViews;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ClassInfoViewMgr
implements IClassInfoViewMgr {
    private static Logger logger = Logger.getLogger(ClassInfoViewMgr.class);
    private IClassInfoMgr m_oClassInfoMgr = null;
    private IMetaDataDefMgr m_oMetaDataDefMgr = null;
    private IMetaDataDefCacheMgr m_oMetaDataDefCacheMgr = null;
    String SQL_CLEAR_BY_DOCID = "delete from XWCMClassInfoView where MetaDataId = ?";
    String SQL_CLEAR_BY_CLASSINFOID = "delete from XWCMClassInfoView where ClassInfoId = ?";

    public IClassInfoMgr getClassInfoMgr() {
        if (this.m_oClassInfoMgr == null) {
            this.m_oClassInfoMgr = (IClassInfoMgr)DreamFactory.createObjectById("IClassInfoMgr");
        }
        return this.m_oClassInfoMgr;
    }

    public IMetaDataDefMgr getMetaDataDefMgr() {
        if (this.m_oMetaDataDefMgr == null) {
            this.m_oMetaDataDefMgr = (IMetaDataDefMgr)DreamFactory.createObjectById("IMetaDataDefMgr");
        }
        return this.m_oMetaDataDefMgr;
    }

    public IMetaDataDefCacheMgr getMetaDataDefCacheMgr() {
        if (this.m_oMetaDataDefCacheMgr == null) {
            this.m_oMetaDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
        }
        return this.m_oMetaDataDefCacheMgr;
    }

    @Override
    public void save(User _currUser, MetaViewData _oMetaViewData) throws WCMException {
        if (!_oMetaViewData.isAddMode()) {
            this.delete(_currUser, _oMetaViewData);
        }
        int nMetaDataId = _oMetaViewData.getId();
        MetaView oMetaView = _oMetaViewData.getMetaView();
        int nViewId = oMetaView.getId();
        WCMFilter filter = new WCMFilter("", "FieldType = ?", "");
        filter.addSearchValues(10);
        MetaViewFields oMetaViewFields = oMetaView.getViewFields(_currUser, filter);
        int nSize = oMetaViewFields.size();
        for (int i = 0; i < nSize; ++i) {
            MetaViewField oMetaViewField = (MetaViewField)oMetaViewFields.getAt(i);
            if (oMetaViewField == null) continue;
            String sClassInfoIds = null;
            sClassInfoIds = _oMetaViewData.isAddMode() || !_oMetaViewData.isChangeProperty(oMetaViewField.getName()) ? _oMetaViewData.getPropertyAsString(oMetaViewField.getName()) : _oMetaViewData.getNewPropertyAsString(oMetaViewField.getName());
            if (!oMetaViewField.isFromMainTable()) {
                String sTableName = "WCMMetaRelation" + oMetaView.getId();
                CMSObjDefaultImpl oRelationTablePO = new CMSObjDefaultImpl(sTableName, "MetaDataId");
                oRelationTablePO.loadById(nMetaDataId, null);
                oRelationTablePO.validCanEditAndLock(_currUser);
                int otherId = oRelationTablePO.getPropertyAsInt("WCMMetaTable" + oMetaViewField.getTableName() + "id", 0);
                MetaViewData oMetaViewData4OtherTable = MetaViewData.findById(otherId);
                if (oMetaViewData4OtherTable == null) continue;
                sClassInfoIds = oMetaViewData4OtherTable.getPropertyAsString(oMetaViewField.getName());
            }
            this.insertClassInfoView(_currUser, nMetaDataId, nViewId, sClassInfoIds);
        }
    }

    private void insertClassInfoView(User _currUser, int _nMetaDataId, int _nViewId, String _sClassInfoIds) throws WCMException {
        if (CMyString.isEmpty(_sClassInfoIds)) {
            return;
        }
        StringTokenizer stringTokener = new StringTokenizer(_sClassInfoIds, ",");
        while (stringTokener.hasMoreElements()) {
            int nClassInfoId = Integer.parseInt((String)stringTokener.nextElement());
            if (nClassInfoId == 0) continue;
            ClassInfoView oClassInfoView = new ClassInfoView();
            oClassInfoView.setClassInfoId(nClassInfoId);
            oClassInfoView.setMetaDataID(_nMetaDataId);
            oClassInfoView.setViewID(_nViewId);
            oClassInfoView.save(_currUser);
        }
    }

    @Override
    public void delete(User _currUser, MetaViewData oMetaViewData) throws WCMException {
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{this.SQL_CLEAR_BY_DOCID}, new int[]{oMetaViewData.getId()});
    }

    @Override
    public Documents queryDocuments(User _currUser, ClassInfo _oClassInfo, WCMFilter _filter) throws WCMException {
        if (_oClassInfo == null) {
            return this.queryAllDocuments(_currUser, _filter);
        }
        if (_oClassInfo.isRoot()) {
            return this.queryAllDocumentsInRoot(_currUser, _oClassInfo, _filter);
        }
        ClassInfos oClassInfos = new ClassInfos(_currUser);
        oClassInfos.addElement(_oClassInfo);
        return this.queryDocuments(_currUser, oClassInfos, _filter);
    }

    @Override
    public Documents queryDocuments(User _currUser, ClassInfos oClassInfos, WCMFilter _filter) throws WCMException {
        if (oClassInfos == null || oClassInfos.isEmpty()) {
            return this.queryAllDocuments(_currUser, _filter);
        }
        WCMFilter filter = new WCMFilter("", "", "");
        StringBuffer sbClassInfos = new StringBuffer(oClassInfos.size() * 2 + 300);
        sbClassInfos.append("exists(select 1");
        sbClassInfos.append(" from XWCMClassInfoView");
        sbClassInfos.append(" where XWCMClassInfoView.ClassInfoId in(");
        sbClassInfos.append(oClassInfos.getIdListAsString());
        sbClassInfos.append(")");
        sbClassInfos.append(" and XWCMClassInfoView.MetaDataId=WCMDocument.docId)");
        sbClassInfos.append(" and WCMDocument.DocChannel>0 and WCMDocument.DocStatus>0");
        filter.setWhere(sbClassInfos.toString());
        filter.mergeWith(_filter);
        logger.debug((Object)filter);
        return Documents.openWCMObjs(_currUser, filter);
    }

    private Documents queryAllDocuments(User _currUser, WCMFilter _filter) throws WCMException {
        WCMFilter filter = new WCMFilter("", "", "");
        String sWhere = "docId in (select distinct(XWCMClassInfoView.MetaDataId) from XWCMClassInfoView)";
        filter.setWhere(sWhere);
        filter.mergeWith(_filter);
        logger.debug((Object)filter);
        return Documents.openWCMObjs(_currUser, filter);
    }

    private Documents queryAllDocumentsInRoot(User _currUser, ClassInfo _oClassInfo, WCMFilter _filter) throws WCMException {
        WCMFilter filter = new WCMFilter("", "", "");
        String sWhere = "DocId in (select metadataid from xwcmclassinfoview where ClassInfoId in (select classinfoid from xwcmclassinfo where rootid=?))";
        filter.setWhere(sWhere);
        filter.addSearchValues(_oClassInfo.getId());
        filter.mergeWith(_filter);
        logger.debug((Object)filter);
        return Documents.openWCMObjs(_currUser, filter);
    }

    @Override
    public MetaViews queryViews(User _currUser, ClassInfos oClassInfos, WCMFilter _filter) throws WCMException {
        ClassInfo oClassInfo;
        if (oClassInfos == null || oClassInfos.isEmpty()) {
            return this.queryAllViews(_currUser, _filter);
        }
        if (oClassInfos.size() == 1 && (oClassInfo = (ClassInfo)oClassInfos.getAt(0)).isRoot()) {
            return this.queryAllViewsInRoot(_currUser, oClassInfo, _filter);
        }
        WCMFilter filter = new WCMFilter("", "", "");
        StringBuffer sbClassInfos = new StringBuffer(oClassInfos.size() * 2 + 300);
        sbClassInfos.append("exists(select XWCMClassInfoView.ViewId");
        sbClassInfos.append(" from XWCMClassInfoView");
        sbClassInfos.append(" where XWCMClassInfoView.ClassInfoId in(");
        int nSize = oClassInfos.size();
        for (int i = 0; i < nSize; ++i) {
            int iId = oClassInfos.getIdAt(i);
            if (iId == 0) continue;
            sbClassInfos.append("?,");
            filter.addSearchValues(iId);
        }
        sbClassInfos.setCharAt(sbClassInfos.length() - 1, ')');
        sbClassInfos.append(" and XWCMClassInfoView.ViewId=XWCMViewInfo.viewInfoId)");
        filter.setWhere(sbClassInfos.toString());
        filter.mergeWith(_filter);
        logger.debug((Object)filter);
        return MetaViews.openWCMObjs(_currUser, filter);
    }

    private MetaViews queryAllViews(User _currUser, WCMFilter _filter) throws WCMException {
        WCMFilter filter = new WCMFilter("", "", "");
        String sWhere = "viewInfoId in (select distinct(XWCMClassInfoView.ViewId) from XWCMClassInfoView)";
        filter.setWhere(sWhere);
        filter.mergeWith(_filter);
        logger.debug((Object)filter);
        return MetaViews.openWCMObjs(_currUser, filter);
    }

    private MetaViews queryAllViewsInRoot(User _currUser, ClassInfo _oClassInfo, WCMFilter _filter) throws WCMException {
        WCMFilter filter = new WCMFilter("", "", "");
        String sWhere = "viewInfoId in (select viewId from xwcmclassinfoview where ClassInfoId in (select classinfoid from xwcmclassinfo where rootid=?))";
        filter.setWhere(sWhere);
        filter.addSearchValues(_oClassInfo.getId());
        filter.mergeWith(_filter);
        logger.debug((Object)filter);
        return MetaViews.openWCMObjs(_currUser, filter);
    }

    @Override
    public ClassInfos queryClassInfos(User _currUser, Document oDocument, WCMFilter _filter) throws WCMException {
        if (oDocument == null) {
            return null;
        }
        WCMFilter filter = new WCMFilter("", "", "");
        String sWhere = "ClassInfoId in(select XWCMClassInfoView.ClassInfoId from XWCMClassInfoView where XWCMClassInfoView.MetaDataId = ?)";
        filter.setWhere(sWhere.toString());
        filter.addSearchValues(oDocument.getDocId());
        filter.mergeWith(_filter);
        logger.debug((Object)filter);
        return ClassInfos.openWCMObjs(_currUser, filter);
    }

    @Override
    public int queryDocumentNum(User _currUser, ClassInfo _classInfo) throws WCMException {
        if (_classInfo == null) {
            String sSQL = "Select count(distinct MetaDataId) from XWCMClassInfoView";
            return DBManager.getDBManager().sqlExecuteIntQuery(sSQL);
        }
        if (_classInfo.isRoot()) {
            String sSQL = "Select count(distinct MetaDataId) from XWCMClassInfoView where ClassInfoId in (select ClassInfoId from XWCMClassInfo where RootId=?)";
            return DBManager.getDBManager().sqlExecuteIntQuery(sSQL, new int[]{_classInfo.getId()});
        }
        String _sClassInfoIds = String.valueOf(_classInfo.getId());
        String sClassInfoIds = this.getClassInfoMgr().queryChildrenWithAllLevel(_currUser, _classInfo, null);
        if (sClassInfoIds != null && sClassInfoIds.length() > 0) {
            _sClassInfoIds = _sClassInfoIds + "," + sClassInfoIds;
        }
        StringBuffer sSQL = new StringBuffer(300);
        sSQL.append("Select count(distinct MetaDataId) from XWCMClassInfoView");
        sSQL.append(" where XWCMClassInfoView.ClassInfoId in(");
        int nSize = _sClassInfoIds.split(",").length;
        for (int i = 0; i < nSize; ++i) {
            sSQL.append("?,");
        }
        sSQL.setCharAt(sSQL.length() - 1, ')');
        return DBManager.getDBManager().sqlExecuteIntQuery(sSQL.toString(), CMyString.splitToInt(_sClassInfoIds, ","));
    }

    @Override
    public int queryDocumentNum(User _currUser, ClassInfo _classInfo, WCMFilter _filter) throws WCMException {
        WCMFilter filter = new WCMFilter("XWCMClassInfoView", "", "", "count(distinct MetaDataId)");
        if (_classInfo != null) {
            if (_classInfo.isRoot()) {
                String sWhere = "ClassInfoId in (select ClassInfoId from XWCMClassInfo where RootId=?)";
                filter.setWhere(sWhere);
                filter.addSearchValues(_classInfo.getId());
            } else {
                String _sClassInfoIds = String.valueOf(_classInfo.getId());
                String sClassInfoIds = this.getClassInfoMgr().queryChildrenWithAllLevel(_currUser, _classInfo, null);
                if (sClassInfoIds != null && sClassInfoIds.length() > 0) {
                    _sClassInfoIds = _sClassInfoIds + "," + sClassInfoIds;
                }
                String[] aClassInfoIds = _sClassInfoIds.split(",");
                StringBuffer sbWhere = new StringBuffer(300);
                sbWhere.append("XWCMClassInfoView.ClassInfoId in(");
                int nSize = aClassInfoIds.length;
                for (int i = 0; i < nSize; ++i) {
                    sbWhere.append("?,");
                    filter.addSearchValues(aClassInfoIds[i]);
                }
                sbWhere.setCharAt(sbWhere.length() - 1, ')');
                filter.setWhere(sbWhere.toString());
            }
        }
        filter.mergeWith(_filter);
        return DBManager.getDBManager().sqlExecuteIntQuery(filter);
    }

    @Override
    public void delete(User user, ClassInfo _oClassInfo) throws WCMException {
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{this.SQL_CLEAR_BY_CLASSINFOID}, new int[]{_oClassInfo.getId()});
    }

    @Override
    public MetaViewDatas queryViewDatas(User user, ClassInfo classInfo, MetaView metaView) throws WCMException {
        MetaViewDatas oViewDatas = new MetaViewDatas(metaView);
        StringBuffer sbWhere = new StringBuffer(200);
        sbWhere.append("MetaDataId in(");
        sbWhere.append(" Select MetaDataId from XWCMClassInfoView Where");
        sbWhere.append(" ViewId = ");
        sbWhere.append(metaView.getId());
        sbWhere.append(" and ");
        sbWhere.append(" ClassInfoId = ");
        sbWhere.append(classInfo.getId());
        sbWhere.append(")");
        oViewDatas.open(new WCMFilter("", sbWhere.toString(), ""));
        return oViewDatas;
    }

    @Override
    public void moveViewDatasByClassInfo(User user, ClassInfo srcClassInfo, int destClassInfoId) throws WCMException {
        String sDestClassInfo = null;
        if (destClassInfoId != 0) {
            sDestClassInfo = String.valueOf(destClassInfoId);
        }
        this.moveViewDatasByClassInfo(user, srcClassInfo, sDestClassInfo);
    }

    @Override
    public void moveViewDatasByClassInfo(User user, ClassInfo oClassInfo, String _sDestClassInfoId) throws WCMException {
        if (oClassInfo == null) {
            return;
        }
        int nSrcClassInfoId = oClassInfo.getId();
        int nSrcClassInfoRootId = oClassInfo.getRootId();
        ClassInfos oSrcClassInfos = ClassInfos.createNewInstance(user);
        oSrcClassInfos.addElement(oClassInfo);
        MetaViews oMetaViews = this.queryViews(user, oSrcClassInfos, null);
        int nSize = oMetaViews.size();
        for (int i = 0; i < nSize; ++i) {
            MetaView oMetaView = (MetaView)oMetaViews.getAt(i);
            if (oMetaView == null) continue;
            WCMFilter fieldType = new WCMFilter("", "fieldType=10", "");
            MetaViewFields oViewFields = this.getMetaDataDefMgr().getViewFields(user, oMetaView, fieldType);
            String sClassInfoViewFieldName = null;
            String sClassInfoDBFieldName = null;
            int nSizej = oViewFields.size();
            for (int j = 0; j < nSizej; ++j) {
                MetaViewField oViewField = (MetaViewField)oViewFields.getAt(j);
                if (oViewField == null || oViewField.getClassId() != nSrcClassInfoRootId) continue;
                sClassInfoViewFieldName = oViewField.getName();
                sClassInfoDBFieldName = oViewField.getDBName();
                break;
            }
            if (sClassInfoDBFieldName == null) continue;
            MetaViewDatas oViewDatas = this.queryViewDatas(user, oClassInfo, oMetaView);
            int nSizej2 = oViewDatas.size();
            for (int j = 0; j < nSizej2; ++j) {
                MetaViewData oViewData = (MetaViewData)oViewDatas.getAt(j);
                if (oViewData == null) continue;
                String sClassInfoFieldValue = oViewData.getPropertyAsString(sClassInfoViewFieldName);
                if (CMyString.isEmpty(sClassInfoFieldValue)) {
                    if (CMyString.isEmpty(_sDestClassInfoId)) continue;
                    sClassInfoFieldValue = String.valueOf(oClassInfo.getId());
                }
                boolean isDeleted = CMyString.isEmpty(_sDestClassInfoId) || sClassInfoFieldValue.matches(".*(^|,)" + _sDestClassInfoId + "($|,).*");
                String sNewClassInfoFieldValue = null;
                if (isDeleted) {
                    sNewClassInfoFieldValue = sClassInfoFieldValue.replaceFirst("(^|,)" + nSrcClassInfoId + "($|,)", "$1$2");
                    int length = sNewClassInfoFieldValue.length();
                    if (length > 1) {
                        if (sNewClassInfoFieldValue.charAt(0) == ',') {
                            sNewClassInfoFieldValue = sNewClassInfoFieldValue.substring(1);
                        }
                        if (sNewClassInfoFieldValue.charAt((length = sNewClassInfoFieldValue.length()) - 1) == ',') {
                            sNewClassInfoFieldValue = sNewClassInfoFieldValue.substring(0, length - 1);
                        }
                    }
                } else {
                    sNewClassInfoFieldValue = sClassInfoFieldValue.replaceFirst("(^|,)" + nSrcClassInfoId + "($|,)", "$1" + _sDestClassInfoId + "$2");
                }
                if (sNewClassInfoFieldValue == null || sNewClassInfoFieldValue.equalsIgnoreCase(sClassInfoFieldValue)) continue;
                oViewData.setPropertyWithString(sClassInfoDBFieldName, sNewClassInfoFieldValue);
                oViewData.setSkipValid(true);
                oViewData.save(user);
            }
        }
    }

    @Override
    public void moveViewDatasByClassInfo(MetaViewData oViewData, ClassInfo oSrcClassInfo, ClassInfo oDestClassInfo, User currUser) throws WCMException {
        if (oViewData == null || oSrcClassInfo == null || oSrcClassInfo.equals(oDestClassInfo)) {
            return;
        }
        MetaViewFields oViewFields = this.getViewFields(oViewData.getMetaView(), oSrcClassInfo, currUser);
        if (oViewFields == null || oViewFields.isEmpty()) {
            return;
        }
        int nSize = oViewFields.size();
        for (int i = 0; i < nSize; ++i) {
            MetaViewField oViewField = (MetaViewField)oViewFields.getAt(i);
            if (oViewField == null) continue;
            this.moveViewDatasByClassInfo(oViewData, oViewField, oSrcClassInfo, oDestClassInfo, currUser);
        }
    }

    @Override
    public void moveViewDatasByClassInfo(MetaViewDatas oViewDatas, ClassInfo oSrcClassInfo, ClassInfo oDestClassInfo, User currUser) throws WCMException {
        if (oViewDatas == null || oSrcClassInfo == null || oSrcClassInfo.equals(oDestClassInfo)) {
            return;
        }
        int nSize = oViewDatas.size();
        for (int i = 0; i < nSize; ++i) {
            MetaViewData oViewData = (MetaViewData)oViewDatas.getAt(i);
            if (oViewData == null) continue;
            if (oViewData.getMetaView() == null) {
                oViewData.setMetaView(oViewDatas.getMetaView());
            }
            this.moveViewDatasByClassInfo(oViewData, oSrcClassInfo, oDestClassInfo, currUser);
        }
    }

    @Override
    public void moveViewDatasByClassInfo(MetaViewData oViewData, MetaViewField oViewField, ClassInfo oSrcClassInfo, ClassInfo oDestClassInfo, User oCurrUser) throws WCMException {
        if (oViewData == null || oSrcClassInfo == null || oSrcClassInfo.equals(oDestClassInfo)) {
            return;
        }
        String sViewFieldName = oViewField.getName();
        String sFieldValue = oViewData.getPropertyAsString(sViewFieldName);
        if (CMyString.isEmpty(sFieldValue)) {
            return;
        }
        String sSrcClassInfoId = String.valueOf(oSrcClassInfo.getId());
        if (sFieldValue.indexOf(sSrcClassInfoId) < 0) {
            return;
        }
        String sDestClassInfoId = null;
        if (oDestClassInfo != null) {
            sDestClassInfoId = String.valueOf(oDestClassInfo.getId());
        }
        boolean isDeleted = CMyString.isEmpty(sDestClassInfoId) || sFieldValue.matches(".*(^|,)" + sDestClassInfoId + "($|,).*");
        String sNewFieldValue = null;
        if (isDeleted) {
            sNewFieldValue = sFieldValue.replaceFirst("(^|,)" + sSrcClassInfoId + "($|,)", "$1$2");
            int length = sNewFieldValue.length();
            if (length > 1) {
                if (sNewFieldValue.charAt(0) == ',') {
                    sNewFieldValue = sNewFieldValue.substring(1);
                }
                if (sNewFieldValue.charAt((length = sNewFieldValue.length()) - 1) == ',') {
                    sNewFieldValue = sNewFieldValue.substring(0, length - 1);
                }
            }
        } else {
            sNewFieldValue = sFieldValue.replaceFirst("(^|,)" + sSrcClassInfoId + "($|,)", "$1" + sDestClassInfoId + "$2");
        }
        if (sFieldValue.equalsIgnoreCase(sNewFieldValue)) {
            return;
        }
        oViewData.setPropertyWithString(oViewField.getDBName(), sNewFieldValue);
        oViewData.save(oCurrUser);
    }

    private MetaViewFields getViewFields(MetaView oMetaView, ClassInfo oClassInfo, User currUser) throws WCMException {
        if (oClassInfo == null) {
            return MetaViewFields.createNewInstance(currUser);
        }
        String sWhere = "FieldType=10 and CLASSID=" + oClassInfo.getRootId();
        WCMFilter oFilter = new WCMFilter();
        oFilter.setWhere(sWhere);
        return this.getMetaDataDefMgr().getViewFields(currUser, oMetaView, oFilter);
    }

    @Override
    public ClassInfos queryClassInfos(User user, Documents documents, WCMFilter _filter) throws WCMException {
        if (documents == null) {
            return null;
        }
        WCMFilter filter = new WCMFilter();
        StringBuffer sbDocumentIdsWhere = new StringBuffer(300);
        int nSize = documents.size();
        for (int i = 0; i < nSize; ++i) {
            Document document = (Document)documents.getAt(i);
            if (document == null) continue;
            sbDocumentIdsWhere.append("?,");
            filter.addSearchValues(document.getId());
        }
        if (sbDocumentIdsWhere.length() <= 0) {
            return null;
        }
        sbDocumentIdsWhere.setLength(sbDocumentIdsWhere.length() - 1);
        StringBuffer sbWhere = new StringBuffer(350);
        sbWhere.append("ClassInfoId in (");
        sbWhere.append("select ClassInfoId from XWCMClassInfoView Where MetaDataId in(");
        sbWhere.append(sbDocumentIdsWhere);
        sbWhere.append("))");
        filter.setWhere(sbWhere.toString());
        filter.mergeWith(_filter);
        logger.debug((Object)filter);
        return ClassInfos.openWCMObjs(user, filter);
    }

    @Override
    public void moveViewDatasByClassInfos(MetaViewDatas viewDatas, ClassInfos srcClassInfos, ClassInfo destClassInfo, User currUser) throws WCMException {
        if (viewDatas == null || viewDatas.isEmpty()) {
            return;
        }
        if (srcClassInfos == null || srcClassInfos.isEmpty()) {
            return;
        }
        int nSize = viewDatas.size();
        for (int i = 0; i < nSize; ++i) {
            MetaViewData oViewData = (MetaViewData)viewDatas.getAt(i);
            if (oViewData == null) continue;
            if (oViewData.getMetaView() == null) {
                oViewData.setMetaView(viewDatas.getMetaView());
            }
            this.moveViewDataByClassInfos(oViewData, srcClassInfos, destClassInfo, currUser);
        }
    }

    @Override
    public void moveViewDataByClassInfos(MetaViewData viewData, ClassInfos srcClassInfos, ClassInfo destClassInfo, User currUser) throws WCMException {
        if (viewData == null) {
            return;
        }
        if (srcClassInfos == null || srcClassInfos.isEmpty()) {
            return;
        }
        boolean isChange = false;
        MetaView oMetaView = viewData.getMetaView();
        if (oMetaView == null) {
            throw new WCMException(I18NMessage.get(ClassInfoViewMgr.class, "ClassInfoViewMgr.label1", "\u5f53\u524d\u64cd\u4f5c\u7684\u8bb0\u5f55\u6ca1\u6709\u89c6\u56fe\u4fe1\u606f"));
        }
        Map mViewFields = this.getMetaDataDefCacheMgr().getMetaViewFields(oMetaView.getId(), 10);
        for (MetaViewField oViewField : mViewFields.values()) {
            if (!this.moveViewDataByClassInfos0(viewData, oViewField, srcClassInfos, destClassInfo, currUser)) continue;
            isChange = true;
        }
        if (isChange) {
            viewData.save(currUser);
        }
    }

    @Override
    public void moveViewDatasByClassInfos(MetaViewDatas viewDatas, MetaViewField viewField, ClassInfos srcClassInfos, ClassInfo destClassInfo, User currUser) throws WCMException {
        if (viewDatas == null || viewDatas.isEmpty()) {
            return;
        }
        if (viewField == null || viewField.getType() != 10) {
            return;
        }
        if (srcClassInfos == null || srcClassInfos.isEmpty()) {
            return;
        }
        int nSize = viewDatas.size();
        for (int i = 0; i < nSize; ++i) {
            MetaViewData oViewData = (MetaViewData)viewDatas.getAt(i);
            if (oViewData == null) continue;
            this.moveViewDataByClassInfos(oViewData, viewField, srcClassInfos, destClassInfo, currUser);
        }
    }

    @Override
    public void moveViewDataByClassInfos(MetaViewData viewData, MetaViewField viewField, ClassInfos srcClassInfos, ClassInfo destClassInfo, User currUser) throws WCMException {
        if (viewData == null) {
            return;
        }
        if (viewField == null || viewField.getType() != 10) {
            return;
        }
        if (srcClassInfos == null || srcClassInfos.isEmpty()) {
            return;
        }
        if (this.moveViewDataByClassInfos0(viewData, viewField, srcClassInfos, destClassInfo, currUser)) {
            viewData.save(currUser);
        }
    }

    private boolean moveViewDataByClassInfos0(MetaViewData viewData, MetaViewField viewField, ClassInfos srcClassInfos, ClassInfo destClassInfo, User currUser) throws WCMException {
        String sSrcClassInfoId;
        int[] aSrcClassInfoId;
        if (viewData == null) {
            return false;
        }
        if (viewField == null || viewField.getType() != 10) {
            return false;
        }
        if (srcClassInfos == null || srcClassInfos.isEmpty()) {
            return false;
        }
        if (destClassInfo != null && viewField.getClassId() != destClassInfo.getRootId()) {
            return false;
        }
        String sFieldValue = viewData.getPropertyAsString(viewField.getName());
        if (CMyString.isEmpty(sFieldValue)) {
            return false;
        }
        int[] aClassInfoValue = ArrayUtil.split(sFieldValue, ",");
        if (!ArrayUtil.containAny(aClassInfoValue, aSrcClassInfoId = ArrayUtil.split(sSrcClassInfoId = srcClassInfos.getIdListAsString(), ","))) {
            return false;
        }
        int[] aNewClassInfoValue = ArrayUtil.removeAll(aClassInfoValue, aSrcClassInfoId);
        if (destClassInfo != null) {
            aNewClassInfoValue = ArrayUtil.addAll(aNewClassInfoValue, new int[]{destClassInfo.getId()});
        }
        if (ArrayUtil.equals(aClassInfoValue, aNewClassInfoValue)) {
            return false;
        }
        String sNewFieldValue = ArrayUtil.join(aNewClassInfoValue, ",");
        viewData.setPropertyWithString(viewField.getDBName(), sNewFieldValue);
        return true;
    }

    @Override
    public void copyViewDatasByClassInfos(MetaViewDatas viewDatas, ClassInfos destClassInfos, User currUser) throws WCMException {
        if (viewDatas == null || viewDatas.isEmpty()) {
            return;
        }
        if (destClassInfos == null || destClassInfos.isEmpty()) {
            return;
        }
        int nSize = viewDatas.size();
        for (int i = 0; i < nSize; ++i) {
            MetaViewData oViewData = (MetaViewData)viewDatas.getAt(i);
            if (oViewData == null) continue;
            if (oViewData.getMetaView() == null) {
                oViewData.setMetaView(viewDatas.getMetaView());
            }
            this.copyViewDataByClassInfos(oViewData, destClassInfos, currUser);
        }
    }

    @Override
    public void copyViewDatasByClassInfos(MetaViewDatas viewDatas, MetaViewField viewField, ClassInfos destClassInfos, User currUser) throws WCMException {
        if (viewDatas == null || viewDatas.isEmpty()) {
            return;
        }
        if (viewField == null || viewField.getType() != 10) {
            return;
        }
        if (destClassInfos == null || destClassInfos.isEmpty()) {
            return;
        }
        int nSize = viewDatas.size();
        for (int i = 0; i < nSize; ++i) {
            MetaViewData oViewData = (MetaViewData)viewDatas.getAt(i);
            if (oViewData == null) continue;
            this.copyViewDataByClassInfos(oViewData, viewField, destClassInfos, currUser);
        }
    }

    @Override
    public void copyViewDataByClassInfos(MetaViewData viewData, ClassInfos destClassInfos, User currUser) throws WCMException {
        if (viewData == null) {
            return;
        }
        if (destClassInfos == null || destClassInfos.isEmpty()) {
            return;
        }
        boolean isChange = false;
        MetaView oMetaView = viewData.getMetaView();
        if (oMetaView == null) {
            throw new WCMException(I18NMessage.get(ClassInfoViewMgr.class, "ClassInfoViewMgr.label2", "\u89c6\u56fe\u8bb0\u5f55\u7adf\u7136\u6ca1\u6709\u89c6\u56fe\u4fe1\u606f"));
        }
        Map mViewFields = this.getMetaDataDefCacheMgr().getMetaViewFields(oMetaView.getId(), 10);
        for (MetaViewField oViewField : mViewFields.values()) {
            if (!this.copyViewDataByClassInfos0(viewData, oViewField, destClassInfos, currUser)) continue;
            isChange = true;
        }
        if (isChange) {
            viewData.save(currUser);
        }
    }

    @Override
    public void copyViewDataByClassInfos(MetaViewData viewData, MetaViewField viewField, ClassInfos destClassInfos, User currUser) throws WCMException {
        if (viewData == null) {
            return;
        }
        if (viewField == null || viewField.getType() != 10) {
            return;
        }
        if (destClassInfos == null || destClassInfos.isEmpty()) {
            return;
        }
        if (this.copyViewDataByClassInfos0(viewData, viewField, destClassInfos, currUser)) {
            viewData.save(currUser);
        }
    }

    private boolean copyViewDataByClassInfos0(MetaViewData viewData, MetaViewField viewField, ClassInfos destClassInfos, User currUser) throws WCMException {
        if (viewData == null) {
            return false;
        }
        if (viewField == null || viewField.getType() != 10) {
            return false;
        }
        if (destClassInfos == null || destClassInfos.isEmpty()) {
            return false;
        }
        int nClassId = viewField.getClassId();
        int index = 0;
        int[] aAppendClassInfo = new int[destClassInfos.size()];
        int nSize = destClassInfos.size();
        for (int i = 0; i < nSize; ++i) {
            int nClassInfoId;
            ClassInfo oClassInfo = (ClassInfo)destClassInfos.getAt(i);
            if (oClassInfo == null || nClassId != oClassInfo.getRootId() || ArrayUtil.indexOf(aAppendClassInfo, nClassInfoId = oClassInfo.getId(), 0, index) >= 0) continue;
            aAppendClassInfo[index++] = nClassInfoId;
        }
        int[] aNewClassInfoValue = new int[index];
        System.arraycopy(aAppendClassInfo, 0, aNewClassInfoValue, 0, aNewClassInfoValue.length);
        String sFieldValue = viewData.getPropertyAsString(viewField.getName());
        int[] aClassInfoValue = ArrayUtil.split(sFieldValue, ",");
        aNewClassInfoValue = ArrayUtil.addAll(aClassInfoValue, aNewClassInfoValue);
        if (ArrayUtil.equals(aClassInfoValue, aNewClassInfoValue)) {
            return false;
        }
        String sNewFieldValue = ArrayUtil.join(aNewClassInfoValue, null);
        viewData.setPropertyWithString(viewField.getDBName(), sNewFieldValue);
        return true;
    }

    private static class ArrayUtil {
        private ArrayUtil() {
        }

        public static int[] removeAll(int[] array, int[] aRemoveArray) {
            int[] result = null;
            if (aRemoveArray == null || aRemoveArray.length <= 0) {
                result = new int[array.length];
                System.arraycopy(array, 0, result, 0, result.length);
                return result;
            }
            int index = 0;
            int[] include = new int[array.length];
            for (int i = 0; i < array.length; ++i) {
                if (ArrayUtil.indexOf(aRemoveArray, array[i]) >= 0) continue;
                include[index++] = array[i];
            }
            result = new int[index];
            System.arraycopy(include, 0, result, 0, result.length);
            return result;
        }

        public static int[] addAll(int[] array, int[] aAddArray) {
            int[] result = null;
            if (aAddArray == null || aAddArray.length <= 0) {
                result = new int[array.length];
                System.arraycopy(array, 0, result, 0, result.length);
                return result;
            }
            int[] include = new int[array.length + aAddArray.length];
            System.arraycopy(array, 0, include, 0, array.length);
            int index = 0;
            for (int i = 0; i < aAddArray.length; ++i) {
                if (ArrayUtil.indexOf(array, aAddArray[i]) >= 0) continue;
                include[array.length + index++] = aAddArray[i];
            }
            result = new int[index + array.length];
            System.arraycopy(include, 0, result, 0, result.length);
            return result;
        }

        public static String join(int[] array, String sDelim) {
            if (array == null || array.length <= 0) {
                return new String();
            }
            return ArrayUtil.join(array, 0, array.length, sDelim);
        }

        public static String join(int[] array, int nStartPos, int nEndPos, String sDelim) {
            if (array == null || array.length <= nStartPos || nEndPos < 0 || nStartPos >= nEndPos) {
                return new String();
            }
            if (sDelim == null) {
                sDelim = ",";
            }
            StringBuffer sb = new StringBuffer(array.length * 3);
            for (int i = nStartPos; i < nEndPos; ++i) {
                sb.append(array[i]).append(sDelim);
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - sDelim.length());
            }
            return sb.toString();
        }

        public static int[] split(String string, String sDelim) {
            if (string == null || string.length() <= 0) {
                return new int[0];
            }
            if (sDelim == null) {
                sDelim = ",";
            }
            StringTokenizer stTemp = new StringTokenizer(string, sDelim);
            int[] arInt = new int[stTemp.countTokens()];
            int nIndex = 0;
            while (stTemp.hasMoreElements()) {
                String sValue = (String)stTemp.nextElement();
                arInt[nIndex] = Integer.parseInt(sValue.trim());
                ++nIndex;
            }
            return arInt;
        }

        public static boolean equals(int[] array1, int[] array2) {
            return ArrayUtil.containAll(array1, array2) && ArrayUtil.containAll(array2, array1);
        }

        public static boolean containAll(int[] array1, int[] array2) {
            if (array2 == null) {
                return true;
            }
            for (int i = 0; i < array2.length; ++i) {
                if (ArrayUtil.indexOf(array1, array2[i]) >= 0) continue;
                return false;
            }
            return true;
        }

        public static boolean containAny(int[] array1, int[] array2) {
            if (array2 == null) {
                return true;
            }
            for (int i = 0; i < array2.length; ++i) {
                if (ArrayUtil.indexOf(array1, array2[i]) < 0) continue;
                return true;
            }
            return false;
        }

        public static int indexOf(int[] array, int nTarget) {
            if (array == null || array.length == 0) {
                return -1;
            }
            return ArrayUtil.indexOf(array, nTarget, 0, array.length);
        }

        public static int indexOf(int[] array, int nTarget, int nStartPos, int nEndPos) {
            if (array == null || array.length <= nStartPos || nEndPos < 0 || nStartPos >= nEndPos) {
                return -1;
            }
            if (nEndPos > array.length) {
                nEndPos = array.length;
            }
            for (int i = nStartPos; i < nEndPos; ++i) {
                if (array[i] != nTarget) continue;
                return i;
            }
            return -1;
        }
    }
}

