/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.infoview.InfoViewMgr;
import com.trs.components.infoview.config.EnumsConfig;
import com.trs.components.infoview.config.InfoViewEnumHelper;
import com.trs.components.infoview.config.LinkedEnumCreator;
import com.trs.components.infoview.helper.InfoViewTemplateHelper;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.infoview.publish.tagparser.InfoviewSpecailTagParseHelper;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TagParserInfoViewHelper
implements ITagParser {
    private static TagBeanInfo s_TagBeanInfo = null;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_INFOVIEWHELPER");
            tbi.setDesc("TRS_INFOVIEWHELPER");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FIELD");
            tbai.setDesc("FIELD");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setRequired(true);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TYPE");
            tbai.setDesc("TYPE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("DEFAULT");
            tbai.setDesc("DEFAULT");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("SPLITBY");
            tbai.setDesc("SPLITBY");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("VALUESPLITBY");
            tbai.setDesc("VALUESPLITBY");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("KEY");
            tbai.setDesc("KEY");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FILE");
            tbai.setDesc("FILE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ENCODING");
            tbai.setDesc("ENCODING");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public void setTagItem(TagItem _item) {
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) throws WCMException {
        return null;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        String sFieldName = CMyString.showNull(_context.getAttribute("FIELD"), "RESOURCE").toUpperCase();
        if (sFieldName.equals("RESOURCE")) {
            return this.parseResource(_context);
        }
        if (sFieldName.equals("ENUM")) {
            return this.parseEnum(_context);
        }
        if (sFieldName.equals("LINKEDENUM")) {
            return this.parseLinkedEnum(_context);
        }
        if (sFieldName.equals("ACTIONS")) {
            return this.parseActions(_context);
        }
        if (sFieldName.equals("ACTION")) {
            return this.parseAction(_context);
        }
        if (sFieldName.equals("VALID")) {
            return new String[]{"validMessageContainer"};
        }
        if (sFieldName.equalsIgnoreCase("CHNL_RELATED_ENUM")) {
            String[] str = this.parseChnlRelatedEnum(_context);
            return str;
        }
        return null;
    }

    private String[] parseChnlRelatedEnum(PublishTagContext _context) {
        return InfoviewSpecailTagParseHelper.parseChnlRelatedEnum(_context);
    }

    private String[] parseLinkedEnum(PublishTagContext _context) throws WCMException {
        List lstChildren = _context.getTagItem().getChildren();
        String[] aParseValues = TagParseHelper.parseItems(lstChildren, _context);
        String[] aResults = null;
        String sTemplateContent = null;
        if (aParseValues != null && aParseValues.length > 0) {
            sTemplateContent = aParseValues[0];
        }
        if (CMyString.isEmpty(sTemplateContent)) {
            LinkedEnumCreator arrLinkedCreator;
            InfoViewMgr oInfoViewMgr = (InfoViewMgr)DreamFactory.createObjectById("InfoViewMgr");
            EnumsConfig oEnumsConfig = oInfoViewMgr.getInfoViewConfig().getEnumsConfig();
            Map upperHostExtra = _context.getExtraAttributes();
            int nHostId = 0;
            int nInfoViewID = 0;
            if (upperHostExtra != null) {
                Integer oHostId = (Integer)upperHostExtra.get("InfoViews.HostId");
                nHostId = oHostId;
                InfoView infoview = (InfoView)upperHostExtra.get("InfoViews.InfoView");
                nInfoViewID = infoview.getId();
            }
            if ((arrLinkedCreator = oEnumsConfig.getLinkedEnums(nInfoViewID)) != null) {
                sTemplateContent = InfoViewTemplateHelper.getContent(nHostId, arrLinkedCreator.getTemplateContent(), arrLinkedCreator.getCacheKey());
            }
        }
        if (sTemplateContent != null) {
            aResults = new String[]{InfoViewEnumHelper.parseChains2Script(sTemplateContent)};
        }
        return aResults;
    }

    private String[] parseEnum(PublishTagContext _context) throws WCMException {
        String sKey = _context.getAttribute("KEY");
        if (CMyString.isEmpty(sKey)) {
            return null;
        }
        String sSplitBy = CMyString.showNull(_context.getAttribute("SPLITBY"), ",");
        String sValueSplitBy = CMyString.showNull(_context.getAttribute("VALUESPLITBY"), "~");
        List lstChildren = _context.getTagItem().getChildren();
        String[] aParseValues = TagParseHelper.parseItems(lstChildren, _context);
        String[] aResults = null;
        if (aParseValues != null && aParseValues.length > 0) {
            if (aParseValues[0] == null) {
                return null;
            }
            aResults = new String[]{InfoViewEnumHelper.split2Options(sKey, aParseValues[0], sSplitBy, sValueSplitBy)};
        }
        return aResults;
    }

    private String[] parseResource(PublishTagContext _context) {
        Map upperHostExtra = _context.getExtraAttributes();
        if (upperHostExtra != null) {
            HashMap hsMap = (HashMap)upperHostExtra.get("InfoViews.Resource");
            if (hsMap == null) {
                return null;
            }
            String sType = CMyString.showNull(_context.getAttribute("TYPE"), "js,css,form").toLowerCase();
            StringBuffer sbResult = new StringBuffer();
            String[] aTypes = sType.split(",");
            HashMap<String, String> hsAppended = new HashMap<String, String>(3);
            for (int i = 0; i < aTypes.length; ++i) {
                String sTmp = aTypes[i];
                Object oAppended = hsAppended.get(sTmp);
                if (oAppended != null) continue;
                hsAppended.put(sTmp, "");
                String sValue = (String)hsMap.get(sTmp);
                if (sValue == null) continue;
                sbResult.append(sValue);
            }
            return new String[]{sbResult.toString()};
        }
        return null;
    }

    private String[] parseAction(PublishTagContext _context) {
        String sType = CMyString.showNull(_context.getAttribute("TYPE"), "submit").toUpperCase();
        String sResult = null;
        if (sType.equals("SUBMIT")) {
            sResult = "onSubmit()";
        } else if (sType.equals("RESET")) {
            sResult = "onReset()";
        } else if (sType.equals("CANCEL")) {
            sResult = "onCancel()";
        }
        return new String[]{sResult};
    }

    private String[] parseActions(PublishTagContext _context) {
        String sDefault = CMyString.showNull(_context.getAttribute("DEFAULT"), "submit,reset,cancel").toUpperCase();
        String[] aDefaults = sDefault.split(",");
        StringBuffer sbResult = new StringBuffer();
        sbResult.append("<div id=\"Infoview_PubPage_Actions\"><script>\n");
        sbResult.append("var oTRSButtons = new CTRSButtons();\n");
        sbResult.append("oTRSButtons.cellSpacing = 0;\n");
        sbResult.append("oTRSButtons.nType = TYPE_ROMANTIC_BUTTON;\n");
        HashMap<String, String> hsAppended = new HashMap<String, String>(3);
        for (int i = 0; i < aDefaults.length; ++i) {
            String sTmp = aDefaults[i];
            Object oAppended = hsAppended.get(sTmp);
            if (oAppended != null) continue;
            hsAppended.put(sTmp, "");
            if (sTmp.equals("SUBMIT")) {
                sbResult.append("oTRSButtons.addTRSButton(\"" + I18NMessage.get(TagParserInfoViewHelper.class, "TagParserInfoViewHelper.label1", "\u786e\u5b9a") + "\", \"onSubmit()\");\n");
                continue;
            }
            if (sTmp.equals("RESET")) {
                sbResult.append("oTRSButtons.addTRSButton(\"" + I18NMessage.get(TagParserInfoViewHelper.class, "TagParserInfoViewHelper.label2", "\u91cd\u7f6e") + "\", \"onReset()\");\n");
                continue;
            }
            if (!sTmp.equals("CANCEL")) continue;
            sbResult.append("oTRSButtons.addTRSButton(\"" + I18NMessage.get(TagParserInfoViewHelper.class, "TagParserInfoViewHelper.label3", "\u53d6\u6d88") + "\", \"onCancel()\");\n");
        }
        sbResult.append("oTRSButtons.draw();\n");
        sbResult.append("</script></div>\n");
        return new String[]{sbResult.toString()};
    }

    public void clear() {
    }
}

