/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.infoview.InfoViewEmployMgr;
import com.trs.components.infoview.InfoViewMgr;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.infoview.persistent.InfoViewView;
import com.trs.components.infoview.publish.tagparser.FormProperty;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TagParserInfoView
implements ITagParser {
    private static Logger s_logger = Logger.getLogger(TagParserInfoView.class);
    private static TagBeanInfo s_TagBeanInfo = null;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_INFOVIEW");
            tbi.setDesc("TRS_INFOVIEW");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("INFOVIEWID");
            tbai.setDesc("INFOVIEWID");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("POSTACTION");
            tbai.setDesc("POSTACTION");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FILEACTION");
            tbai.setDesc("FILEACTION");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("VERIFYCODE");
            tbai.setDesc("VERIFYCODE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("VERIFYCODEURL");
            tbai.setDesc("VERIFYCODEURL");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("READFILEURL");
            tbai.setDesc("READFILEURL");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("RESETBUTTON");
            tbai.setDesc("RESETBUTTON");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ONLYCHACHED");
            tbai.setDesc("ONLYCHACHED");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TOPDOMAIN");
            tbai.setDesc("TOPDOMAIN");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FORMEXTRA");
            tbai.setDesc("FORMEXTRA");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("REFORMHTML");
            tbai.setDesc("REFORMHTML");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("SELECTFIELDS");
            tbai.setDesc("SELECTFIELDS");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public void setTagItem(TagItem _item) {
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) throws WCMException {
        return null;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        Map upperHostExtra = _context.getExtraAttributes();
        InfoView oCurrInfoView = null;
        InfoViewView oCurrInfoViewView = null;
        int nHostId = 0;
        if (upperHostExtra != null) {
            oCurrInfoView = (InfoView)upperHostExtra.get("InfoViews.InfoView");
            oCurrInfoViewView = (InfoViewView)upperHostExtra.get("InfoViews.InfoViewView");
            Integer oHostId = (Integer)upperHostExtra.get("InfoViews.HostId");
            if (oHostId != null) {
                nHostId = oHostId;
            }
        }
        if (oCurrInfoView == null) {
            InfoViewEmployMgr m_oIVEmployMgr = null;
            m_oIVEmployMgr = (InfoViewEmployMgr)DreamFactory.createObjectById("InfoViewEmployMgr");
            CMSObj obj = _context.getUpperHost().getSubstance();
            int iInfiViewID = _context.getAttribute("INFOVIEWID", 0);
            if (iInfiViewID > 0) {
                oCurrInfoView = InfoView.findById(iInfiViewID);
                if (oCurrInfoView == null) {
                    throw new WCMException(I18NMessage.get(TagParserInfoView.class, "TagParserInfoView.label1", "\u6307\u5b9a\u7684InfoView[Id=") + iInfiViewID + I18NMessage.get(TagParserInfoView.class, "TagParserInfoView.label2", "]\u65e0\u6548!"));
                }
            } else {
                List list = m_oIVEmployMgr.getEmployedInfoViews(obj);
                if (list != null && list.size() > 0) {
                    oCurrInfoView = (InfoView)list.get(0);
                }
                if (oCurrInfoView == null) {
                    throw new WCMException(I18NMessage.get(TagParserInfoView.class, "TagParserInfoView.label3", "\u5f53\u524d\u680f\u76ee\u6ca1\u6709\u914d\u7f6e\u6b63\u786e\u7684\u81ea\u5b9a\u4e49\u8868\u5355!"));
                }
            }
            nHostId = obj.getId();
        }
        InfoViewMgr ivManager = (InfoViewMgr)DreamFactory.createObjectById("InfoViewMgr");
        FormProperty oProperty = new FormProperty();
        oProperty.setSelfURL(_context.getPageHttpPath());
        oProperty.setGateWayInitPage(_context.getAttribute("INITPAGE"));
        oProperty.setChannelID(nHostId);
        oProperty.setSiteID(_context.getRoot().getId());
        String sInfoviewTitle = _context.getAttribute("INFOVIEWTITLE");
        if (CMyString.isEmpty(sInfoviewTitle)) {
            sInfoviewTitle = oCurrInfoView.getName();
        }
        oProperty.setInfoviewTitle(sInfoviewTitle);
        oProperty.setFileAction(_context.getAttribute("FILEACTION"));
        oProperty.setFormEncoding(_context.getPageElement().getEncoding());
        oProperty.setVerifyCodeEnable(_context.getAttribute("VERIFYCODE", false));
        oProperty.setVerifyCodeURL(_context.getAttribute("VERIFYCODEURL"));
        oProperty.setValidVerifycodeUrl(_context.getAttribute("VALIDVERIFYCODEURL"));
        oProperty.setReadFileURL(_context.getAttribute("READFILEURL"));
        oProperty.setResetButton(_context.getAttribute("RESETBUTTON", false));
        oProperty.setOnlyCached(_context.getAttribute("ONLYCACHED", false));
        oProperty.setSelectFields(_context.getAttribute("SELECTFIELDS"));
        oProperty.setFormExtra(_context.getAttribute("FormExtra"));
        List children = _context.getTagItem().getChildren();
        if (children != null && children.size() > 0) {
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                TagItem subItem;
                String tagName;
                Object child = children.get(i);
                if (child == null || !(child instanceof TagItem) || !(tagName = (subItem = (TagItem)child).getName().toUpperCase()).equals("TRS_INFOVIEWSUBMIT")) continue;
                oProperty.setSubmitButtonHTML(subItem.getText());
                break;
            }
        }
        ArrayList fileList = new ArrayList();
        String[] saResult = new String[1];
        if (_context.isPreview()) {
            saResult[0] = ivManager.forPreviewMultiView(oCurrInfoView, oCurrInfoViewView, oProperty, fileList);
            saResult[0] = ivManager.appendJsAndCsses(saResult[0]);
        } else {
            oProperty.setFormAction(_context.getAttribute("POSTACTION"));
            saResult[0] = ivManager.forPublishMultiView(oCurrInfoView, oCurrInfoViewView, oProperty, fileList);
            saResult[0] = ivManager.appendJsAndCsses(saResult[0]);
            if (_context.getAttribute("REFORMHTML", false)) {
                saResult[0] = this.reformHtml(saResult[0]);
            }
        }
        this.distributeInfoViewFiles(fileList, _context);
        return saResult;
    }

    private String reformHtml(String html) {
        int nHeadStart = html.indexOf("<head>");
        int nHeadEnd = html.indexOf("</head>", nHeadStart);
        int nBodyStart = html.indexOf("<body>");
        int nBodyEnd = html.indexOf("</body>", nBodyStart);
        if (nHeadStart == -1 || nHeadEnd == -1 || nBodyStart == -1 || nBodyEnd == -1) {
            return html;
        }
        StringBuffer rst = new StringBuffer();
        rst.append(html.substring(nHeadStart + "<head>".length(), nHeadEnd));
        rst.append(html.substring(nBodyStart + "<body>".length(), nBodyEnd));
        return rst.toString();
    }

    public void clear() {
    }

    private void distributeInfoViewFiles(List _fileList, PublishTagContext _context) {
        if (_fileList == null || _fileList.size() <= 0) {
            return;
        }
        try {
            boolean bPreview = _context.isPreview();
            PublishPathCompass compass = _context.getPathCompass();
            IPublishElement publishElement = _context.getPageElement();
            for (int i = _fileList.size() - 1; i >= 0; --i) {
                String sFullName = (String)_fileList.get(i);
                if (sFullName == null || !CMyFile.fileExists(sFullName)) continue;
                String sFileName = CMyFile.extractFileName(sFullName);
                String sLocalPath = compass.getLocalPath(publishElement, bPreview);
                PublishSyncGlobalTuner.insureLocalPathExists(sLocalPath);
                CMyFile.copyFile(sFullName, sLocalPath + sFileName);
                if (bPreview) continue;
                _context.getFileDistributeShip().distributeFile(sFullName, publishElement, null, true);
            }
        }
        catch (Exception ex) {
            s_logger.error((Object)I18NMessage.get(TagParserInfoView.class, "TagParserInfoView.label4", "\u53d1\u5e03\u81ea\u5b9a\u4e49\u8868\u5355\u4e2d\u7684\u56fe\u7247\u5931\u8d25\uff01"), (Throwable)ex);
        }
    }
}

