/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.persistent;

import com.trs.components.infoview.persistent.InfoViewSerial;
import com.trs.infra.common.WCMException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class InfoViewSerialGenerator {
    private Map m_oSerialMaps = new HashMap(10);
    private static final InfoViewSerialGenerator m_oInstance = new InfoViewSerialGenerator();

    private InfoViewSerialGenerator() {
    }

    public static InfoViewSerialGenerator getInstance() {
        return m_oInstance;
    }

    public Object[] getNextSerial(int nInfoViewId, int nSerialPeriod, int nBaseSerial) throws WCMException {
        InfoViewSerial serialNum = this.getSerial(nInfoViewId, nSerialPeriod, nBaseSerial);
        Object[] result = new Object[]{Calendar.getInstance().getTime(), serialNum.getNextSerial()};
        return result;
    }

    private InfoViewSerial getSerial(int nInfoViewId, int nSerialPeriod, int nBaseSerial) {
        String serialKey = this.makeSerialkey(nInfoViewId, nSerialPeriod);
        InfoViewSerial serial = (InfoViewSerial)this.m_oSerialMaps.get(serialKey);
        if (serial == null) {
            serial = new InfoViewSerial(nInfoViewId, nSerialPeriod, nBaseSerial);
            this.m_oSerialMaps.put(serialKey, serial);
        }
        return serial;
    }

    private String makeSerialkey(int nInfoViewId, int nSerialPeriod) {
        return "IV" + nInfoViewId + "_" + nSerialPeriod;
    }

    public static void main(String[] args) {
    }
}

