/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.extract.manifest;

import com.trs.components.infoview.extract.manifest.CalculatedField;
import com.trs.components.infoview.extract.manifest.DocumentSchema;
import com.trs.components.infoview.extract.manifest.FileProperty;
import com.trs.components.infoview.extract.manifest.PackageFile;
import com.trs.components.infoview.extract.manifest.View;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class Manifest {
    private Element m_oRootElement;
    private HashMap m_oAllViews;
    private List m_oAllViewsInOrder;
    private View m_oDefaultView;
    private HashMap m_oAllFiles;
    private HashMap m_oCalculations;
    private HashMap m_oSchemaMapURI;
    private DocumentSchema m_oRootSchema;
    private String m_sFileNewCaption;
    private String m_sFileNewTemplate;

    private void prepare(Document document) {
        this.m_oRootElement = document.getRootElement();
    }

    public void build(Document document) {
        this.prepare(document);
        this.buildPackage();
        this.buildViews();
        this.buildCalculations();
        this.buildDocumentSchemas();
        this.buildCaptionTemplate();
    }

    private void buildViews() {
        this.m_oAllViews = new HashMap();
        this.m_oAllViewsInOrder = new ArrayList();
        Element elViews = this.m_oRootElement.element("views");
        String sDefault = elViews.attributeValue("default");
        Iterator itr = elViews.elementIterator("view");
        while (itr.hasNext()) {
            View view = new View().build((Element)itr.next());
            this.m_oAllViews.put(view.getName(), view);
            this.m_oAllViewsInOrder.add(view);
            String filename = view.getTransform();
            PackageFile file = (PackageFile)this.m_oAllFiles.get(filename);
            FileProperty prop = file.getFileProperty("viewWidth");
            if (prop == null) continue;
            view.setViewWidth(prop.getValue());
        }
        this.m_oDefaultView = (View)this.m_oAllViews.get(sDefault);
        this.m_oDefaultView.setDefaultView(true);
    }

    public HashMap getAllViews() {
        return this.m_oAllViews;
    }

    public List getAllViewsInOrder() {
        return this.m_oAllViewsInOrder;
    }

    public View getDefaultView() {
        return this.m_oDefaultView;
    }

    private void buildCalculations() {
        Element elCalcu = this.m_oRootElement.element("calculations");
        if (elCalcu == null) {
            return;
        }
        this.m_oCalculations = new HashMap();
        Iterator itr = elCalcu.elementIterator("calculatedField");
        while (itr.hasNext()) {
            Element element = (Element)itr.next();
            CalculatedField cfield = new CalculatedField().build(element);
            this.m_oCalculations.put(cfield.getTarget(), cfield);
            this.m_oCalculations.put(cfield.getRelativeTarget(), cfield);
        }
    }

    public CalculatedField getCalculatedField(String sTarget) {
        if (this.m_oCalculations == null) {
            return null;
        }
        return (CalculatedField)this.m_oCalculations.get(sTarget);
    }

    private void buildPackage() {
        Element elPackage = this.m_oRootElement.element("package");
        if (elPackage == null) {
            return;
        }
        Element elFiles = elPackage.element("files");
        if (elFiles == null) {
            return;
        }
        this.m_oAllFiles = new HashMap();
        Iterator itr = elFiles.elementIterator();
        while (itr.hasNext()) {
            PackageFile file = new PackageFile().build((Element)itr.next());
            this.m_oAllFiles.put(file.getName(), file);
        }
    }

    private void buildDocumentSchemas() {
        Element elSchemas = this.m_oRootElement.element("documentSchemas");
        if (elSchemas == null) {
            return;
        }
        DocumentSchema schema = null;
        this.m_oSchemaMapURI = new HashMap();
        Iterator itr = elSchemas.elementIterator();
        while (itr.hasNext()) {
            String filename;
            PackageFile file;
            FileProperty prop;
            Element element = (Element)itr.next();
            schema = new DocumentSchema().build(element);
            this.m_oSchemaMapURI.put(schema.getXSDFile(), schema);
            if (schema.isRootSchema()) {
                this.m_oRootSchema = schema;
            }
            if ((prop = (file = (PackageFile)this.m_oAllFiles.get(filename = schema.getXSDFile())).getFileProperty("rootElement")) != null) {
                schema.setRootElement(prop.getValue());
            }
            if ((prop = file.getFileProperty("namespace")) == null) continue;
            schema.setNamespace(prop.getValue());
        }
        if (this.m_oRootSchema == null && this.m_oSchemaMapURI.size() == 1) {
            this.m_oRootSchema = schema;
        }
    }

    public HashMap getAllSchemas() {
        return this.m_oSchemaMapURI;
    }

    public DocumentSchema getRootSchema() {
        return this.m_oRootSchema;
    }

    public String getRootSchemaURI() {
        return this.m_oRootSchema.getXSDURI();
    }

    private void buildCaptionTemplate() {
        Element elFileNew = this.m_oRootElement.element("fileNew");
        if (elFileNew == null) {
            return;
        }
        Element elInitial = elFileNew.element("initialXmlDocument");
        if (elInitial == null) {
            return;
        }
        this.m_sFileNewCaption = elInitial.attributeValue("caption");
        this.m_sFileNewTemplate = elInitial.attributeValue("href");
    }

    public String getFileNewCaption() {
        return this.m_sFileNewCaption;
    }

    public String getFileNewTemplate() {
        return this.m_sFileNewTemplate;
    }
}

