/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.extract;

import com.trs.components.infoview.CABFileExtractor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;

public class WinCABFileExtractor
extends CABFileExtractor {
    private static final String EXTRACTING_FLAG = "Extracting ";
    private static final int EXTRACTING_FLAG_LENGTH = "Extracting ".length();
    private static final String ERROR_MSG_FLAG = "ERROR: ";
    private static final int ERROR_MSG_FLAG_LENGTH = "ERROR: ".length();
    private static final String OVERWRITE_FLAG = "/Y";
    private static final String EXTRACT_ALL_FLAG = "/E";
    private static final String TARGET_LOCATION_FLAG = "/L";

    @Override
    public HashMap extract(String sCABFile, String sTargetDiretory) throws IOException {
        StringBuffer sbError = new StringBuffer();
        HashMap map = new HashMap();
        String[] sCommandLines = new String[]{this.m_oConfig.getExtractProgram(), OVERWRITE_FLAG, EXTRACT_ALL_FLAG, TARGET_LOCATION_FLAG, sTargetDiretory, sCABFile};
        String sLine = null;
        Process oProcess = Runtime.getRuntime().exec(sCommandLines);
        InputStream stdout = oProcess.getInputStream();
        InputStreamReader reader = new InputStreamReader(stdout);
        BufferedReader oStdouReader = new BufferedReader(reader);
        while ((sLine = oStdouReader.readLine()) != null) {
            if (sLine.startsWith(EXTRACTING_FLAG)) {
                this.extractFileName(map, sLine.substring(EXTRACTING_FLAG_LENGTH));
                continue;
            }
            if (!sLine.startsWith(ERROR_MSG_FLAG)) continue;
            sbError.append(sLine.substring(ERROR_MSG_FLAG_LENGTH));
        }
        if (oProcess.exitValue() != 0) {
            throw new IOException(sbError.toString());
        }
        return map;
    }

    private void extractFileName(HashMap map, String file) {
        int iSplitIndex = file.lastIndexOf(92) + 1;
        String sFileName = file.substring(iSplitIndex);
        map.put(sFileName, file);
    }
}

