/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.extract;

import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.Iterator;
import org.dom4j.Element;

public class DataType
implements Cloneable {
    private String m_sName;
    private String m_sTypeName;
    private String m_sDataName;
    private DataType m_oDataType;
    private String m_sBaseName;
    private DataType m_oBaseType;
    private String m_sRefName;
    private DataType m_oRefType;
    private boolean m_zInnerType;
    private boolean m_zSimpleType;
    private boolean m_zComplexType;
    private ArrayList m_oChildren;
    private String m_sBindName;
    private String m_sNewBindName;
    private String m_sDisplayName;
    private String m_sNillable;
    private int m_iMaxLength;
    private int m_iMinLength;
    private String m_sDisplayFieldType;
    private Element m_oBindElement;

    public static final DataType getInnerType() {
        DataType dataType = new DataType();
        dataType.setInnerType(true);
        return dataType;
    }

    public static final DataType getSimpleType() {
        DataType dataType = new DataType();
        dataType.setSimpleType(true);
        return dataType;
    }

    public static final DataType getComplexType() {
        DataType dataType = new DataType();
        dataType.setComplexType(true);
        return dataType;
    }

    private DataType() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[DataType,");
        sb.append("BindName:").append(this.m_sBindName).append(',');
        sb.append("NewBindName:").append(this.m_sNewBindName).append(',');
        sb.append("DisplayName:").append(this.m_sDisplayName).append(',');
        sb.append("Name:").append(this.m_sName).append(',');
        sb.append("TypeName:").append(this.m_sTypeName).append(',');
        sb.append("DataName:").append(this.m_sDataName).append(',');
        sb.append("DataType:").append(this.m_oDataType).append(',');
        sb.append("BaseName:").append(this.m_sBaseName).append(',');
        sb.append("BaseType:").append(this.m_oBaseType).append(',');
        sb.append("RefName:").append(this.m_sRefName).append(',');
        sb.append("InnerType:").append(this.m_zInnerType).append(',');
        sb.append("SimpleType:").append(this.m_zSimpleType).append(',');
        sb.append("ComplexType:").append(this.m_zComplexType).append(',');
        sb.append("isInnerType():").append(this.isInnerType());
        sb.append(",");
        sb.append("getXSDTypeName():").append(this.getXSDTypeName());
        sb.append(",");
        sb.append("isNillable():").append(this.isNillable());
        sb.append(",");
        sb.append("isDefaultNotNullType():").append(this.isDefaultNotNullType());
        sb.append(",");
        sb.append("m_sNillable:").append(this.m_sNillable);
        sb.append(']');
        return sb.toString();
    }

    protected DataType cloneOne() {
        try {
            return (DataType)this.clone();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getXSDTypeName() {
        if (this.m_zInnerType) {
            return this.m_sBaseName;
        }
        if (this.m_zSimpleType && this.m_oDataType != null) {
            return this.m_oDataType.getBaseName();
        }
        return "any";
    }

    public String getTRSTypeName() {
        String sXSDType = this.getXSDTypeName();
        if (sXSDType == null) {
            return "string";
        }
        if ("integer".equals(sXSDType)) {
            return "integer";
        }
        return "string";
    }

    private int getDefaultLength() {
        String sXsdTypeName = this.getXSDTypeName();
        String sDisplayFieldType = this.getDisplayFieldType();
        if ("RichText".equalsIgnoreCase(sDisplayFieldType)) {
            return 0;
        }
        if ("boolean".equalsIgnoreCase(sXsdTypeName)) {
            return 50;
        }
        if ("integer".equalsIgnoreCase(sXsdTypeName) || "double".equalsIgnoreCase(sXsdTypeName) || "date".equalsIgnoreCase(sXsdTypeName) || "datetime".equalsIgnoreCase(sXsdTypeName)) {
            return 0;
        }
        int nDbType = DBManager.getDBManager().getDBTypeAsInt();
        if (nDbType == 5 || nDbType == 6 || nDbType == 3 || nDbType == 7) {
            return this.isTextArea() ? 1000 : 300;
        }
        return this.isTextArea() ? 2000 : 500;
    }

    private boolean isTextArea() throws NumberFormatException {
        String sDisplayFieldType = this.getDisplayFieldType();
        if ("PlainText".equalsIgnoreCase(sDisplayFieldType)) {
            Element oElement = this.getBindElement();
            String sCssText = CMyString.showNull(oElement.attributeValue("style"), "");
            String[] cssAttrs = sCssText.split(";");
            for (int i = 0; i < cssAttrs.length; ++i) {
                String sHeight;
                float fHeight;
                String[] arrCssAttr;
                if (!cssAttrs[i].trim().toUpperCase().startsWith("HEIGHT") || (arrCssAttr = cssAttrs[i].split(":")).length <= 1 || !((fHeight = Float.parseFloat(sHeight = arrCssAttr[1].replaceAll("[^\\d\\.]", ""))) > 30.0f)) continue;
                return true;
            }
        }
        return false;
    }

    public int getDataTypeAsInt() {
        String sXsdTypeName = this.getXSDTypeName();
        if ("integer".equalsIgnoreCase(sXsdTypeName)) {
            return 4;
        }
        if ("double".equalsIgnoreCase(sXsdTypeName)) {
            return 8;
        }
        if ("boolean".equalsIgnoreCase(sXsdTypeName)) {
            return 12;
        }
        if ("date".equalsIgnoreCase(sXsdTypeName)) {
            return 91;
        }
        if ("datetime".equalsIgnoreCase(sXsdTypeName)) {
            return 93;
        }
        if ("base64Binary".equalsIgnoreCase(sXsdTypeName)) {
            return 12;
        }
        String sDisplayFieldType = this.getDisplayFieldType();
        if ("RichText".equalsIgnoreCase(sDisplayFieldType)) {
            return 2005;
        }
        return 12;
    }

    private String[] splitPath(String sPath, String sPrefix) {
        sPrefix = sPrefix + ':';
        String[] sResult = sPath.split("/");
        int iCount = sResult.length;
        int i = 0;
        while (i < iCount) {
            int j;
            String s = sResult[i];
            if (s.startsWith(sPrefix)) {
                sResult[i] = s = s.substring(sPrefix.length());
            }
            if (s.length() <= 0 || ".".equals(s) || s.equals(this.m_sName)) {
                --iCount;
                for (j = i; j < iCount; ++j) {
                    sResult[j] = sResult[j + 1];
                }
                continue;
            }
            if ("..".equals(s)) {
                if (--i < 0) {
                    i = 0;
                }
                --iCount;
                --iCount;
                for (j = i; j < iCount; ++j) {
                    sResult[j] = sResult[j + 2];
                }
                continue;
            }
            ++i;
        }
        if (sResult.length == iCount) {
            return sResult;
        }
        String[] sa = new String[iCount];
        System.arraycopy(sResult, 0, sa, 0, iCount);
        return sa;
    }

    public DataType findDataType(String sPath, String sPrefix) {
        String[] sResult = this.splitPath(sPath, sPrefix);
        DataType dataType = this.findDataType(sResult);
        if (dataType != null) {
            dataType.setBindName(sPath);
        }
        return dataType;
    }

    private DataType findDataType(String[] sTypePath) {
        DataType dataType = this.findDataType(sTypePath, 0);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < sTypePath.length; ++i) {
            if (sb.length() > 0) {
                sb.append('_');
            }
            sb.append(sTypePath[i]);
        }
        if (dataType != null) {
            dataType.setNewBindName(sb.toString());
        }
        return dataType;
    }

    private DataType findDataType(String[] sTypePath, int iLevel) {
        DataType dataType = this.findDataType(sTypePath[iLevel++]);
        if (iLevel < sTypePath.length) {
            return dataType.findDataType(sTypePath, iLevel);
        }
        return dataType;
    }

    private DataType findDataType(String sTypeName) {
        DataType dataType = this.findChild(this, sTypeName);
        if (dataType != null) {
            return dataType;
        }
        if (this.m_oDataType != null) {
            dataType = this.findChild(this.m_oDataType, sTypeName);
            if (dataType != null) {
                return dataType;
            }
            dataType = this.findDataTypeFromBase(this.m_oDataType.m_oBaseType, sTypeName);
            if (dataType != null) {
                return dataType;
            }
        }
        if (this.m_oBaseType != null) {
            dataType = this.findChild(this.m_oBaseType, sTypeName);
            if (dataType != null) {
                return dataType;
            }
            dataType = this.findDataTypeFromBase(this.m_oBaseType.m_oBaseType, sTypeName);
            if (dataType != null) {
                return dataType;
            }
        }
        return null;
    }

    private DataType findDataTypeFromBase(DataType baseType, String sTypeName) {
        if (baseType == null) {
            return null;
        }
        DataType dataType = this.findChild(baseType, sTypeName);
        if (dataType != null) {
            return dataType;
        }
        return this.findDataTypeFromBase(baseType.m_oBaseType, sTypeName);
    }

    private DataType findChild(DataType dataType, String sTypeName) {
        dataType = this.findRefSrc(dataType);
        if (dataType.m_oChildren != null) {
            Iterator subTypes = dataType.m_oChildren.iterator();
            while (subTypes.hasNext()) {
                dataType = this.findRefSrc((DataType)subTypes.next());
                if (!sTypeName.equals(dataType.getName())) continue;
                return dataType.cloneOne();
            }
        }
        return null;
    }

    private DataType findRefSrc(DataType dataType) {
        while (dataType.getRefType() != null) {
            dataType = dataType.getRefType();
        }
        return dataType;
    }

    public void addChild(DataType oChildDataType) {
        if (this.m_oChildren == null) {
            this.m_oChildren = new ArrayList();
        }
        this.m_oChildren.add(oChildDataType);
    }

    public ArrayList getChildren() {
        return this.m_oChildren;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String name) {
        this.m_sName = name;
    }

    public String getTypeName() {
        return this.m_sTypeName;
    }

    public void setTypeName(String typeName) {
        this.m_sTypeName = typeName;
    }

    public String getDataName() {
        return this.m_sDataName;
    }

    public void setDataName(String dataName) {
        this.m_sDataName = dataName;
    }

    public DataType getDataType() {
        return this.m_oDataType;
    }

    public void setDataType(DataType dataType) {
        this.m_oDataType = dataType;
    }

    public String getBaseName() {
        return this.m_sBaseName;
    }

    public void setBaseName(String baseName) {
        this.m_sBaseName = baseName;
    }

    public DataType getBaseType() {
        return this.m_oBaseType;
    }

    public void setBaseType(DataType baseType) {
        this.m_oBaseType = baseType;
    }

    public String getRefName() {
        return this.m_sRefName;
    }

    public void setRefName(String refName) {
        this.m_sRefName = refName;
    }

    public DataType getRefType() {
        return this.m_oRefType;
    }

    public void setRefType(DataType refType) {
        this.m_oRefType = refType;
    }

    public boolean isInnerType() {
        if (this.m_zInnerType) {
            return true;
        }
        if (this.m_zSimpleType) {
            if (this.m_oDataType != null) {
                return this.m_oDataType.isInnerType();
            }
            if (this.m_oBaseType != null) {
                return this.m_oBaseType.isInnerType();
            }
        }
        return false;
    }

    public void setInnerType(boolean innerType) {
        this.m_zInnerType = innerType;
    }

    public boolean isSimpleType() {
        return this.m_zSimpleType;
    }

    public void setSimpleType(boolean simpleType) {
        this.m_zSimpleType = simpleType;
    }

    public boolean isComplexType() {
        return this.m_zComplexType;
    }

    public void setComplexType(boolean complexType) {
        this.m_zComplexType = complexType;
    }

    public String getBindName() {
        return this.m_sBindName;
    }

    public void setBindName(String bindName) {
        this.m_sBindName = bindName;
    }

    public String getNewBindName() {
        return this.m_sNewBindName;
    }

    public void setNewBindName(String newBindName) {
        this.m_sNewBindName = newBindName;
    }

    public String getDisplayName() {
        if (this.m_sDisplayName != null && this.m_sDisplayName.length() > 0) {
            return this.m_sDisplayName;
        }
        return this.m_sName;
    }

    public void setDisplayName(String displayName) {
        this.m_sDisplayName = displayName;
    }

    public boolean isDefaultNotNullType() {
        String sXsdTypeName = this.getXSDTypeName();
        return "integer".equalsIgnoreCase(sXsdTypeName) || "double".equalsIgnoreCase(sXsdTypeName) || "boolean".equalsIgnoreCase(sXsdTypeName) || "date".equalsIgnoreCase(sXsdTypeName) || "datetime".equalsIgnoreCase(sXsdTypeName);
    }

    public boolean isNillable() {
        if (this.m_sNillable != null) {
            return "true".equalsIgnoreCase(this.m_sNillable);
        }
        if (this.isDefaultNotNullType()) {
            return "true".equalsIgnoreCase(this.m_sNillable);
        }
        return this.getMinLength() <= 0;
    }

    public String getNillable() {
        return this.m_sNillable;
    }

    public void setNillable(String nillable) {
        this.m_sNillable = nillable;
    }

    public int getMaxLength() {
        int nResult = this.m_iMaxLength;
        if (this.m_zSimpleType && this.m_oDataType != null) {
            nResult = this.m_oDataType.getMaxLength();
        }
        if (nResult <= 0) {
            nResult = this.getDefaultLength();
        }
        return nResult;
    }

    public void setMaxLength(int maxLength) {
        this.m_iMaxLength = maxLength;
    }

    public int getMinLength() {
        if (this.m_zSimpleType && this.m_oDataType != null) {
            return this.m_oDataType.getMinLength();
        }
        if (this.m_zSimpleType && this.m_oBaseType != null) {
            return this.m_oBaseType.getMinLength();
        }
        return this.m_iMinLength;
    }

    public void setMinLength(int minLength) {
        this.m_iMinLength = minLength;
    }

    public Element getBindElement() {
        return this.m_oBindElement;
    }

    void setBindElement(Element bindElement) {
        this.m_oBindElement = bindElement;
    }

    public void setTRSObjectID(int id) {
        String sId = String.valueOf(id);
        this.m_oBindElement.addAttribute("trs_obj_id", sId);
    }

    public void setDisplayFieldType(String _sType) {
        this.m_sDisplayFieldType = _sType;
    }

    public String getDisplayFieldType() {
        return this.m_sDisplayFieldType;
    }
}

