/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.config;

import com.trs.components.infoview.InfoViewHelper;
import com.trs.components.infoview.config.EnumCreator;
import com.trs.components.infoview.config.LinkedEnumCreator;
import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Loader;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;

public class EnumsConfig {
    private static final Logger s_logger = Logger.getLogger(EnumsConfig.class);
    private HashMap m_hmCachedEnumCreators = new HashMap();
    private HashMap m_hmCachedLinkedEnums = new HashMap();
    public static final int ENUM_TYPE_NORMAL = 0;
    public static final int ENUM_TYPE_LINKED = 1;

    private EnumsConfig() {
    }

    public static EnumsConfig build(String _sFileName) {
        EnumsConfig oEnumsConfig = new EnumsConfig();
        URL url = null;
        try {
            url = Loader.getResource(_sFileName);
        }
        catch (Exception ex) {
            url = null;
        }
        if (url == null) {
            s_logger.warn((Object)(I18NMessage.get(EnumsConfig.class, "EnumsConfig.label1", "\u6307\u5b9a\u5e94\u7528\u7684\u6839\u76ee\u5f55\u4e0b\u7528\u4e8e\u89e3\u6790\u7684\u6587\u4ef6\u8def\u5f84[") + _sFileName + I18NMessage.get(EnumsConfig.class, "EnumsConfig.label2", "]\u4e0d\u5b58\u5728\uff01")));
            return oEnumsConfig;
        }
        _sFileName = url.getFile();
        try {
            String sInfoViewId;
            Document oXmlDocument = InfoViewHelper.buildDOM4JDocument(_sFileName);
            List lstCreators = oXmlDocument.selectNodes("//infoview-enumsconfig/enum-creator");
            for (Element element : lstCreators) {
                String sKey = element.attributeValue("key");
                sInfoViewId = element.attributeValue("infoviewid");
                String sSplitBy = CMyString.showNull(element.attributeValue("split-by"), ",");
                String sValueSplitBy = CMyString.showNull(element.attributeValue("value-split-by"), "~");
                String sValue = element.getTextTrim();
                EnumCreator oEnumCreator = new EnumCreator();
                oEnumCreator.setInfoViewId(Integer.parseInt(sInfoViewId));
                oEnumCreator.setKey(sKey);
                oEnumCreator.setSplitBy(sSplitBy);
                oEnumCreator.setTemplateContent(sValue);
                oEnumCreator.setValueSplitBy(sValueSplitBy);
                oEnumsConfig.addEnumItem(Integer.parseInt(sInfoViewId), sKey, oEnumCreator, 0);
            }
            List lstLinkeds = oXmlDocument.selectNodes("//infoview-enumsconfig/enum-linked");
            for (Element element : lstLinkeds) {
                sInfoViewId = element.attributeValue("infoviewid");
                String sValue = element.getTextTrim();
                LinkedEnumCreator oLinkedEnumCreator = new LinkedEnumCreator();
                oLinkedEnumCreator.setInfoViewId(Integer.parseInt(sInfoViewId));
                oLinkedEnumCreator.setTemplateContent(sValue);
                oEnumsConfig.addEnumItem(Integer.parseInt(sInfoViewId), null, oLinkedEnumCreator, 1);
            }
        }
        catch (Exception ex) {
            s_logger.warn((Object)(I18NMessage.get(EnumsConfig.class, "EnumsConfig.label3", "\u81ea\u5b9a\u4e49\u8868\u5355\u9009\u62e9\u9879\u914d\u7f6e\u6587\u4ef6[") + _sFileName + I18NMessage.get(EnumsConfig.class, "EnumsConfig.label4", "]\u6709\u8bef\uff0e") + ex.getMessage()));
        }
        return oEnumsConfig;
    }

    public void addEnumItem(int nInfoViewId, String sKey, Object oValue, int nType) {
        Integer oInfoViewKey = new Integer(nInfoViewId);
        HashMap<String, Object> hmEnumKeys = null;
        switch (nType) {
            case 0: {
                hmEnumKeys = (HashMap<String, Object>)this.m_hmCachedEnumCreators.get(oInfoViewKey);
                if (hmEnumKeys == null) {
                    hmEnumKeys = new HashMap<String, Object>();
                    this.m_hmCachedEnumCreators.put(oInfoViewKey, hmEnumKeys);
                }
                hmEnumKeys.put(sKey, oValue);
                break;
            }
            case 1: {
                this.m_hmCachedLinkedEnums.put(oInfoViewKey, oValue);
                break;
            }
        }
    }

    public EnumCreator[] getEnumCreators(int nInfoViewId) {
        Integer oInfoViewKey = new Integer(nInfoViewId);
        HashMap hmEnumKeys = (HashMap)this.m_hmCachedEnumCreators.get(oInfoViewKey);
        if (hmEnumKeys == null) {
            return new EnumCreator[0];
        }
        Collection collection = hmEnumKeys.values();
        EnumCreator[] arrResult = new EnumCreator[collection.size()];
        collection.toArray(arrResult);
        return arrResult;
    }

    public EnumCreator getEnumCreator(int nInfoViewId, String sKey) {
        Integer oInfoViewKey = new Integer(nInfoViewId);
        HashMap hmEnumKeys = (HashMap)this.m_hmCachedEnumCreators.get(oInfoViewKey);
        if (hmEnumKeys == null) {
            return null;
        }
        return (EnumCreator)hmEnumKeys.get(sKey);
    }

    public LinkedEnumCreator getLinkedEnums(int nInfoViewId) {
        Integer oInfoViewKey = new Integer(nInfoViewId);
        return (LinkedEnumCreator)this.m_hmCachedLinkedEnums.get(oInfoViewKey);
    }
}

