/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview;

import com.trs.cms.auth.persistent.User;
import com.trs.components.common.message.Message;
import com.trs.components.common.message.MessageServer;
import com.trs.components.infoview.PatternAnalyzer;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.wcm.content.persistent.DocReply;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.email.CMyEmail;
import com.trs.infra.util.email.TRSMailer;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;

public class InfoViewReplyNoticeSender {
    private static Logger s_logger = Logger.getLogger(InfoViewReplyNoticeSender.class);
    private InfoView m_oInfoView;
    private com.trs.components.wcm.content.persistent.Document m_oDocument;
    private DocReply m_oDocReply;
    private boolean m_zSendEmail;
    private boolean m_zSendMessage;
    private Document m_oXmlDocument;

    public InfoViewReplyNoticeSender(InfoView _oInfoView, com.trs.components.wcm.content.persistent.Document _oDocument, DocReply _oInfoViewReply) throws WCMException {
        if (_oInfoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewReplyNoticeSender.class, "InfoViewReplyNoticeSender.label1", "\u65e0\u6548\u7684\u8868\u5355\u5bf9\u8c61[null]!"));
        }
        if (_oDocument == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewReplyNoticeSender.class, "InfoViewReplyNoticeSender.label2", "\u65e0\u6548\u7684\u8868\u5355\u6587\u6863\u5bf9\u8c61[null]!"));
        }
        if (_oInfoViewReply == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewReplyNoticeSender.class, "InfoViewReplyNoticeSender.label3", "\u65e0\u6548\u7684\u8868\u5355\u56de\u590d\u5bf9\u8c61[null]!"));
        }
        this.m_oInfoView = _oInfoView;
        this.m_oDocument = _oDocument;
        this.m_oDocReply = _oInfoViewReply;
    }

    public void sendNotice() throws WCMException {
        if (!this.m_oInfoView.isReplyNoticeRequired()) {
            return;
        }
        String noticeTo = this.m_oInfoView.getNoticeRelatedField();
        if (CMyString.isEmpty(noticeTo)) {
            return;
        }
        try {
            this.m_oXmlDocument = DocumentHelper.parseText((String)this.m_oDocument.getContent());
        }
        catch (Exception e) {
            throw new WCMException(154, I18NMessage.get(InfoViewReplyNoticeSender.class, "InfoViewReplyNoticeSender.label4", "\u83b7\u53d6\u8868\u5355\u6587\u6863\u5185\u5bb9\u5931\u8d25!"));
        }
        User currUser = this.m_oDocument.getCrUser();
        String noticeContent = this.m_oDocReply.getContent();
        String subject = this.m_oDocReply.getTitle();
        String subjectPattern = this.m_oInfoView.getNoticeSubjectPattern();
        if (!CMyString.isEmpty(subjectPattern)) {
            PatternAnalyzer analyzer = new PatternAnalyzer(subjectPattern);
            analyzer.setDocument(this.m_oXmlDocument);
            analyzer.setCurrentUser(currUser);
            String result = analyzer.getAnalyzedResult();
            if (!CMyString.isEmpty(result)) {
                subject = result;
            }
        }
        if (this.isSendEmail()) {
            this.sendEmail(noticeTo, noticeContent, subject);
        }
        if (this.isSendMessage()) {
            this.sendMessage(currUser, subject, noticeContent);
        }
    }

    private void sendMessage(User messageReciver, String subject, String noticeContent) throws WCMException {
        if (messageReciver == null) {
            return;
        }
        Message message = new Message();
        message.setTitle(subject);
        message.setBody(noticeContent);
        message.setReceivers(204, String.valueOf(messageReciver.getId()));
        message.setSendTypes("Message");
        MessageServer.send(message);
    }

    private void sendEmail(String noticeTo, String mailContent, String mailSubject) throws WCMException {
        User currUser = this.m_oDocument.getCrUser();
        if ("${::user}".equals(noticeTo)) {
            if (currUser == null) {
                return;
            }
            noticeTo = currUser.getEmail();
        } else {
            Node relatedNode = this.m_oXmlDocument.selectSingleNode("//" + noticeTo);
            if (relatedNode == null) {
                return;
            }
            noticeTo = relatedNode.getText();
        }
        String mailContentPattern = this.m_oInfoView.getNoticeContentPattern();
        if (!CMyString.isEmpty(mailContentPattern)) {
            mailContent = CMyString.replaceStr(mailContentPattern, "${mailcontent}", CMyString.transDisplay(mailContent));
        }
        String mailFrom = "";
        try {
            mailFrom = ConfigServer.getServer().getSysConfigValue("MAIL_SENDER", "");
        }
        catch (Exception e) {
            s_logger.error((Object)"failed to get mail sender config!", (Throwable)e);
        }
        CMyEmail email = new CMyEmail();
        email.setFrom(mailFrom);
        email.setTo(noticeTo);
        email.setSubject(mailSubject);
        email.setBody(mailContent);
        email.setMailFormat(1);
        TRSMailer mailer = new TRSMailer();
        try {
            mailer.send(email);
        }
        catch (CMyException e) {
            throw new WCMException(1100, I18NMessage.get(InfoViewReplyNoticeSender.class, "InfoViewReplyNoticeSender.label5", "\u53d1\u9001\u90ae\u4ef6\u5931\u8d25!"), e);
        }
    }

    public static void main(String[] args) {
    }

    public final boolean isSendEmail() {
        return this.m_zSendEmail;
    }

    public final void setSendEmail(boolean sendEmail) {
        this.m_zSendEmail = sendEmail;
    }

    public final boolean isSendMessage() {
        return this.m_zSendMessage;
    }

    public final void setSendMessage(boolean sendMessage) {
        this.m_zSendMessage = sendMessage;
    }
}

