/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.gkml.sqgk;

import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SqgkFileUtil {
    private static String ENCODING = "GBK";
    private static final char BLANK = ' ';
    private static final String FAKE_HEAD = "wen.yehui@trs.com.cn";
    private static final String SEP = "--leafgray--";

    public static String makeQuery(int applyid, String filename) throws Exception {
        StringBuffer buff = new StringBuffer(256);
        buff.append(FAKE_HEAD);
        buff.append(SEP);
        buff.append(applyid);
        buff.append(SEP);
        buff.append(filename);
        return CMyString.URLEncode(SqgkFileUtil.encode(buff.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushData(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String query = req.getParameter("query");
        String queryString = SqgkFileUtil.decode(query);
        String[] params = queryString.split(SEP);
        if (params.length != 3 && !FAKE_HEAD.equals(params[0])) {
            throw new IllegalArgumentException("Invalid request.");
        }
        int id = Integer.parseInt(params[1]);
        String appfile = params[2];
        WCMFilter filter = new WCMFilter("", "AppDocId=? AND AppFile=?", "");
        filter.addSearchValues(0, -id);
        filter.addSearchValues(appfile);
        String sql = "select appendixid from wcmappendix where appdocid=? and appfile=?";
        Connection conn = null;
        DBManager dbman = DBManager.getDBManager();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean zHasFile = false;
        try {
            conn = dbman.getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, -id);
            pstmt.setString(2, appfile);
            rs = pstmt.executeQuery();
            zHasFile = rs.next() && rs.getInt(1) > 0;
        }
        catch (Exception exception) {}
        if (!zHasFile) {
            throw new Exception("Invalid request.");
        }
        FilesMan fileman = FilesMan.getFilesMan();
        String path = fileman.mapFilePath(appfile, 0);
        resp.reset();
        resp.setContentType("APPLICATION/OCTET-STREAM");
        ServletOutputStream outx = resp.getOutputStream();
        InputStream fins = null;
        try {
            fins = new FileService(path + appfile).getInputStream();
            byte[] buff = new byte[10240];
            int len = -1;
            while ((len = fins.read(buff)) != -1) {
                outx.write(buff, 0, len);
            }
        }
        catch (Exception e) {
            throw new Exception("Internal error: " + e);
        }
        finally {
            if (fins != null) {
                try {
                    fins.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    static String encode(String source) throws Exception {
        if (source == null || source.trim().length() == 0) {
            throw new IllegalArgumentException("no need to encode an empty string?");
        }
        byte[] data = source.getBytes(ENCODING);
        StringBuffer buff = new StringBuffer(data.length * 2);
        byte[] byteBuff = new byte[3];
        int len = data.length;
        for (int i = 0; i < len; i += 3) {
            for (int j = 0; j < 3 && i + j < len; ++j) {
                byteBuff[j] = data[i + j];
            }
            int a = (byteBuff[0] >>> 2 & 0x3F) + 32;
            int b = (byteBuff[0] << 4 & 0x30 | byteBuff[1] >>> 4 & 0xF) + 32;
            int c = (byteBuff[1] << 2 & 0x3C | byteBuff[2] >>> 6 & 3) + 32;
            int d = (byteBuff[2] & 0x3F) + 32;
            buff.append((char)a);
            buff.append((char)b);
            buff.append((char)c);
            buff.append((char)d);
            for (int j = 0; j < 3; ++j) {
                byteBuff[j] = 0;
            }
        }
        return buff.toString();
    }

    String standardEncode(String source) {
        byte[] data = source.getBytes();
        StringBuffer buff = new StringBuffer(data.length * 5);
        int pos = 0;
        int len = data.length;
        for (int i = 0; i < len; i += 45) {
            int j = 0;
            j = i + 45 > len ? len - i : 45;
            buff.append((char)(j + 32));
            for (int k = 0; k < j && pos < len; k += 3) {
                byte a = 0;
                byte b = 0;
                byte c = 0;
                a = data[pos++];
                if (pos < len) {
                    b = data[pos++];
                }
                if (pos < len) {
                    c = data[pos++];
                }
                int c1 = a >>> 2 & 0x3F;
                int c2 = a << 4 & 0x30 | b >>> 4 & 0xF;
                int c3 = b << 2 & 0x3C | c >>> 6 & 3;
                int c4 = c & 0x3F;
                buff.append((char)(c1 + 32));
                buff.append((char)(c2 + 32));
                buff.append((char)(c3 + 32));
                buff.append((char)(c4 + 32));
            }
            buff.append('\n');
        }
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String decode(String source) throws Exception {
        if (source == null || source.trim().length() == 0) {
            throw new IllegalArgumentException("no need to decode an empty string?");
        }
        byte[] data = source.getBytes();
        if (data.length % 4 > 0) {
            throw new IllegalArgumentException("Bad data!");
        }
        byte[] buff = new byte[4];
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            int len = data.length;
            for (int i = 0; i < len; i += 4) {
                for (int j = 0; j < 4; ++j) {
                    buff[j] = (byte)(data[i + j] - 32);
                }
                int a = (buff[0] << 2 & 0xFC | buff[1] >>> 4 & 3) & 0xFF;
                int b = (buff[1] << 4 & 0xF0 | buff[2] >>> 2 & 0xF) & 0xFF;
                int c = (buff[2] << 6 & 0xC0 | buff[3] & 0x3F) & 0xFF;
                baos.write(a);
                if (b > 0) {
                    baos.write(b);
                }
                if (c <= 0) continue;
                baos.write(c);
            }
            baos.flush();
            String string = new String(baos.toByteArray(), ENCODING);
            return string;
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

