/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget.tagparser;

import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.log4j.Logger;

public class WCMTagParserResources
extends BaseTagParser {
    private static Logger logger = Logger.getLogger(WCMTagParserResources.class);
    private static String[] designResources = new String[]{"layout/default.css", "css/widget4common.css", "css/widget4design.css", "css/common.css", "../js/easyversion/lightbase.js", "../js/easyversion/extrender.js", "../js/easyversion/elementmore.js", "js/adapter4Top.js", "js/data.js", "dataopers4chnl.js", "dataopers4doc.js", "js/state.js", "js/widget.js", "js/drag.js", "js/layout.js", "js/column.js", "page.js"};
    private static String[] publishResources = new String[]{"layout/default.css", "css/widget4common.css", "css/common.css", "../js/easyversion/lightbase.js"};
    private static final String DESIGN_RESOURCE_DIR = WCMTagParserResources.getLocalFormatPath("ext-res/design/");
    private static String PUBLISH_RESOURCE_DIR = WCMTagParserResources.getLocalFormatPath("ext-res/publish/");
    private static String COMMON_RESOURCE_DIR = WCMTagParserResources.getLocalFormatPath("ext-res/common/");
    private String sourceLocalBasePath = "D:/workspace/TRS.WCM.V6.1.Std/SourceCode/WebApp/app/special/";
    private String publishLocalBasePath;
    private String publishHttpBasePath;
    private String publishResourceDir = "images/resources";
    private IPublishFolder folder;
    private PublishTagContext context;
    private boolean isVisualParseMode;
    private Comparator compartor = new Comparator(){

        public int compare(Object o1, Object o2) {
            File file1 = (File)o1;
            File file2 = (File)o2;
            return file1.getName().compareTo(file2.getName());
        }
    };
    private static TagBeanInfo s_TagBeanInfo = null;

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        this.context = _context;
        this.folder = this.context.getRoot();
        this.isVisualParseMode = TagParseHelper.isVisualParseMode(this.context);
        StringBuffer sbHtml = new StringBuffer(300);
        this.initSourceLocalBasePath();
        this.initPublishBasePath();
        if (this.isVisualParseMode) {
            this.addResources(this.sourceLocalBasePath, designResources, sbHtml);
            this.addResources(this.sourceLocalBasePath + COMMON_RESOURCE_DIR, sbHtml);
            this.addResources(this.sourceLocalBasePath + DESIGN_RESOURCE_DIR, sbHtml);
        } else {
            this.addResources(this.sourceLocalBasePath, publishResources, sbHtml);
            this.addResources(this.sourceLocalBasePath + COMMON_RESOURCE_DIR, sbHtml);
            this.addResources(this.sourceLocalBasePath + PUBLISH_RESOURCE_DIR, sbHtml);
        }
        return new String[]{sbHtml.toString()};
    }

    private void initSourceLocalBasePath() throws WCMException {
        this.sourceLocalBasePath = ConfigServer.getServer().getInitProperty("WCM_PATH");
        this.sourceLocalBasePath = WCMTagParserResources.getLocalFormatPath(this.sourceLocalBasePath);
        this.sourceLocalBasePath = CMyString.setStrEndWith(this.sourceLocalBasePath, File.separatorChar) + WCMTagParserResources.getLocalFormatPath("app/special/");
    }

    private static String getLocalFormatPath(String sPath) {
        String dest;
        String source;
        if (CMyString.isEmpty(sPath)) {
            return "";
        }
        if (File.separatorChar == '/') {
            source = "\\\\";
            dest = "/";
        } else {
            source = "/";
            dest = "\\\\";
        }
        return sPath.replaceAll(source, dest);
    }

    private void initPublishBasePath() throws WCMException {
        if (this.publishLocalBasePath != null) {
            return;
        }
        PublishPathCompass compass = this.context.getPathCompass();
        this.publishLocalBasePath = this.context.isPreview() ? compass.getPreviewLocalPath(this.folder) : compass.getPublishLocalPath(this.folder);
        this.publishLocalBasePath = this.publishLocalBasePath + this.publishResourceDir + File.separator;
        this.publishLocalBasePath = this.publishLocalBasePath.replaceAll("//", "/");
        boolean bUrlIsAbs = this.context.getAttribute("UrlIsAbs", false);
        this.publishHttpBasePath = bUrlIsAbs ? (this.context.isPreview() ? compass.getPreviewHttpPath(this.folder) : compass.getAbsoluteHttpPath(this.folder)) : HtmlUtil.calRelativePath(compass.getAbsoluteHttpPath(this.folder), this.context.getPageHttpPath());
        this.publishHttpBasePath = this.publishHttpBasePath + this.publishResourceDir + File.separator;
    }

    private void addResources(String sDir, StringBuffer sbHtml) throws WCMException {
        FileService dir = new FileService(sDir);
        if (!(dir.exists() && dir.canRead() && dir.isDirectory())) {
            return;
        }
        FileStore[] files = dir.listFiles();
        Arrays.sort(files, this.compartor);
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.addResources(files[i].getAbsolutePath(), sbHtml);
                continue;
            }
            this.addResource0(files[i], sbHtml);
        }
    }

    private void addResources(String sBasePath, String[] resourceFiles, StringBuffer sbHtml) throws WCMException {
        for (int i = 0; i < resourceFiles.length; ++i) {
            this.addResource0(new FileService(sBasePath + resourceFiles[i]), sbHtml);
        }
    }

    private void addResource0(FileStore file, StringBuffer sbHtml) throws WCMException {
        if (!(file.exists() && file.isFile() && file.canRead())) {
            return;
        }
        String sDstFileName = this.copyToPublishResourceDirectory(file);
        if (sDstFileName == null) {
            return;
        }
        if (sDstFileName.endsWith(".js")) {
            sbHtml.append("<script language=\"javascript\" src=\"");
            sbHtml.append(this.getDstResourcePath(new FileService(sDstFileName)));
            sbHtml.append("\" commonresource=\"1\"");
            sbHtml.append(" charset=\"utf-8\"");
            sbHtml.append(" type=\"text/javascript\"></script>");
            sbHtml.append("\n");
        } else if (sDstFileName.endsWith(".css")) {
            sbHtml.append("<link href=\"");
            sbHtml.append(this.getDstResourcePath(new FileService(sDstFileName)));
            sbHtml.append("\" commonresource=\"1\"");
            sbHtml.append(" charset=\"utf-8\"");
            sbHtml.append(" rel=\"stylesheet\" type=\"text/css\" />");
            sbHtml.append("\n");
        }
    }

    private String getDstResourcePath(FileStore file) throws WCMException {
        if (this.isVisualParseMode) {
            return file.getPath().replaceAll("\\\\", "/").substring(this.sourceLocalBasePath.length());
        }
        String sAbsPath = file.getAbsolutePath();
        return (this.publishHttpBasePath + sAbsPath.substring(this.publishLocalBasePath.length())).replaceAll("\\\\", "/");
    }

    private String copyToPublishResourceDirectory(FileStore file) throws WCMException {
        long targetFileTime;
        long srcFileTime;
        if (!file.exists()) {
            return null;
        }
        if (this.isVisualParseMode) {
            return file.getAbsolutePath();
        }
        String sDstPath = this.extractDirectoryStructure(file);
        FileService dstFile = new FileService(sDstPath + file.getName());
        if (dstFile.exists() && (srcFileTime = file.lastModified()) <= (targetFileTime = dstFile.lastModified())) {
            return dstFile.getAbsolutePath();
        }
        PublishSyncGlobalTuner.insureLocalPathExists(sDstPath);
        try {
            CMyFile.copyFile(file.getAbsolutePath(), dstFile.getAbsolutePath());
        }
        catch (CMyException e) {
            logger.warn((Object)("\u62f7\u8d1d\u6587\u4ef6[" + file.getAbsolutePath() + "]\u51fa\u73b0\u5f02\u5e38"), (Throwable)e);
            this.context.addWarning("\u62f7\u8d1d\u6587\u4ef6[" + file.getAbsolutePath() + "]\u53d1\u751f\u5f02\u5e38:" + CMyException.getStackTraceText(e));
        }
        if (!this.context.isPreview()) {
            String sRelativePath = sDstPath.substring(this.publishLocalBasePath.length());
            this.context.getFileDistributeShip().distributeFile(file.getAbsolutePath(), this.folder, this.publishResourceDir + "/" + sRelativePath, false);
        }
        return dstFile.getAbsolutePath();
    }

    private String extractDirectoryStructure(FileStore file) {
        String sAbsSrcFilePath = file.getAbsolutePath();
        String[] dirs = new String[]{COMMON_RESOURCE_DIR, DESIGN_RESOURCE_DIR, PUBLISH_RESOURCE_DIR};
        String path = this.publishLocalBasePath;
        for (int i = 0; i < dirs.length; ++i) {
            String sPrefix = this.sourceLocalBasePath + dirs[i];
            if (!sAbsSrcFilePath.startsWith(sPrefix)) continue;
            path = path + CMyFile.extractFilePath(sAbsSrcFilePath).substring(sPrefix.length());
            break;
        }
        return path;
    }

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TBI tbi = new TBI();
            tbai = new TagBeanAttrInfo();
            tbai.setName("URLISABS");
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    private class TBI
    extends TagBeanInfo {
        @Override
        public void checkSemantic(IPublishFolder _folder, TagItem _tagItem, StringBuffer _sbResult) {
        }
    }
}

