/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.IWidgetParameterMgr;
import com.trs.components.common.publish.widget.Widget;
import com.trs.components.common.publish.widget.WidgetInstParameter;
import com.trs.components.common.publish.widget.WidgetInstance;
import com.trs.components.common.publish.widget.WidgetParameter;
import com.trs.components.common.publish.widget.WidgetParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;

public class WidgetParameterMgr
implements IWidgetParameterMgr {
    @Override
    public WidgetParameter saveWidgetParameter(User _oCurrUser, WidgetParameter _oCurrWidgetParameter) throws WCMException {
        if (_oCurrWidgetParameter == null) {
            throw new WCMException(20, "\u65e0\u6548\u7684WidgetParameter\u5bf9\u8c61\uff0c\u65e0\u6cd5\u4fdd\u5b58.");
        }
        int nWidgetId = _oCurrWidgetParameter.getWidgetId();
        Widget currWidget = Widget.findById(nWidgetId);
        if (currWidget == null) {
            throw new WCMException(20, "\u6ca1\u6709\u627e\u5230\u8d44\u6e90\u53d8\u91cf\u6240\u5c5e\u7684\u8d44\u6e90.");
        }
        String sWidgetParaName = _oCurrWidgetParameter.getFinalPropertyAsString("WIDGETPARAMNAME");
        if (this.existWidgetParameter(currWidget, _oCurrWidgetParameter)) {
            throw new WCMException(1008, "\u5df2\u7ecf\u5b58\u5728\u540d\u79f0\u4e3a[" + sWidgetParaName + "]\u7684\u8d44\u6e90\u53d8\u91cf.");
        }
        _oCurrWidgetParameter.save(_oCurrUser);
        return _oCurrWidgetParameter;
    }

    @Override
    public boolean delete(User _oCurrUser, WidgetParameter _oCurrWidgetParameter) throws WCMException {
        if (_oCurrWidgetParameter == null) {
            throw new WCMException(20, "\u65e0\u6548\u7684WidgetParameter\u5bf9\u8c61\uff0c\u65e0\u6cd5\u5220\u9664.");
        }
        return _oCurrWidgetParameter.delete(_oCurrUser) == 1;
    }

    @Override
    public WidgetParameters query(User _oCurrUser, WCMFilter _oFilter) throws WCMException {
        WidgetParameters oWidgetParameters = WidgetParameters.openWCMObjs(_oCurrUser, _oFilter);
        return oWidgetParameters;
    }

    @Override
    public boolean existWidgetParameter(Widget _oCurrWidget, WidgetParameter _oCurrWidgetParameter) throws WCMException {
        WidgetParameters oWidgetParameters;
        boolean bAddMode = _oCurrWidgetParameter.isAddMode();
        String sWidgetParaName = null;
        sWidgetParaName = bAddMode ? _oCurrWidgetParameter.getPropertyAsString("WIDGETPARAMNAME") : _oCurrWidgetParameter.getNewPropertyAsString("WIDGETPARAMNAME");
        if (CMyString.isEmpty(sWidgetParaName)) {
            return false;
        }
        String sWhere = "WIDGETID=? AND WIDGETPARAMNAME=?";
        if (!bAddMode) {
            sWhere = sWhere + " AND WIDGETPARAMETERID<>?";
        }
        WCMFilter oFilter = new WCMFilter("XWCMWIDGETPARAMETER", sWhere, "", "WIDGETPARAMETERID");
        int nWidgetId = _oCurrWidget.getId();
        oFilter.addSearchValues(nWidgetId);
        oFilter.addSearchValues(sWidgetParaName.toUpperCase());
        if (!bAddMode) {
            oFilter.addSearchValues(_oCurrWidgetParameter.getId());
        }
        return (oWidgetParameters = WidgetParameters.openWCMObjs(ContextHelper.getLoginUser(), oFilter)).size() > 0;
    }

    @Override
    public WidgetParameters query(Widget _oCurrWidget) throws WCMException {
        if (_oCurrWidget == null) {
            throw new WCMException(20, "\u65e0\u6548\u7684widget\u5bf9\u8c61.");
        }
        int nWidgetId = _oCurrWidget.getId();
        String sWhere = "WIDGETID=?";
        WCMFilter oFilter = new WCMFilter("XWCMWIDGETPARAMETER", sWhere, "");
        oFilter.addSearchValues(nWidgetId);
        WidgetParameters oWidgetParameters = WidgetParameters.openWCMObjs(ContextHelper.getLoginUser(), oFilter);
        return oWidgetParameters;
    }

    @Override
    public WidgetParameter findParameterByName(Widget _oCurrWidget, String sParameterName) throws WCMException {
        String sWhere = "WIDGETID=? AND WIDGETPARAMNAME=?";
        WCMFilter oFilter = new WCMFilter("XWCMWIDGETPARAMETER", sWhere, "");
        oFilter.addSearchValues(_oCurrWidget.getId());
        oFilter.addSearchValues(sParameterName);
        WidgetParameters oParameters = WidgetParameters.openWCMObjs(ContextHelper.getLoginUser(), oFilter);
        return oParameters.size() > 0 ? (WidgetParameter)oParameters.getAt(0) : null;
    }

    @Override
    public WidgetParameter findParameter(WidgetInstParameter widgetInstParameter) throws WCMException {
        int nWidgetInstId = widgetInstParameter.getWidgetInstId();
        WidgetInstance widgetInstance = WidgetInstance.findById(nWidgetInstId);
        return this.findParameterByName(widgetInstance.getWidget(), widgetInstParameter.getParamName());
    }
}

