/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.template.TemplateMgr;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.widget.IWidgetInstParameterMgr;
import com.trs.components.common.publish.widget.IWidgetParameterMgr;
import com.trs.components.common.publish.widget.Widget;
import com.trs.components.common.publish.widget.WidgetInstParameter;
import com.trs.components.common.publish.widget.WidgetInstParameters;
import com.trs.components.common.publish.widget.WidgetInstance;
import com.trs.components.common.publish.widget.WidgetParameter;
import com.trs.components.common.publish.widget.WidgetParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.Map;

public class WidgetInstParameterMgr
implements IWidgetInstParameterMgr {
    IWidgetParameterMgr m_oWidgetParameterMgr = (IWidgetParameterMgr)DreamFactory.createObjectById("IWidgetParameterMgr");

    @Override
    public Map getParameters(WidgetInstance widgetInstance) throws WCMException {
        String sParamName;
        int i;
        WidgetInstParameters widgetInstParameters = this.getWidgetInstParameters(widgetInstance, null);
        WidgetParameters oWidgetParameters = this.m_oWidgetParameterMgr.query(widgetInstance.getWidget());
        HashMap<String, String> parameters = new HashMap<String, String>();
        int nSize = oWidgetParameters.size();
        for (i = 0; i < nSize; ++i) {
            WidgetParameter oWidgetParam = (WidgetParameter)oWidgetParameters.getAt(i);
            if (oWidgetParam == null) continue;
            sParamName = oWidgetParam.getWidgetParamName().toUpperCase();
            parameters.put(sParamName, CMyString.showNull(oWidgetParam.getDefaultValue()));
        }
        nSize = widgetInstParameters.size();
        for (i = 0; i < nSize; ++i) {
            WidgetInstParameter widgetInstParameter = (WidgetInstParameter)widgetInstParameters.getAt(i);
            if (widgetInstParameter == null) continue;
            sParamName = widgetInstParameter.getParamName().toUpperCase();
            parameters.put(sParamName, widgetInstParameter.getParamValue());
        }
        parameters.put("#WIDGETINSTID", String.valueOf(widgetInstance.getId()));
        return parameters;
    }

    @Override
    public Map getParameters(WidgetInstance widgetInstance, String selectFields) throws WCMException {
        String sTargetSelectFields = "," + selectFields.toUpperCase() + ",";
        WidgetInstParameters widgetInstParameters = this.getWidgetInstParameters(widgetInstance, null);
        HashMap<String, String> parameters = new HashMap<String, String>();
        int nSize = widgetInstParameters.size();
        for (int i = 0; i < nSize; ++i) {
            String sParamName;
            WidgetInstParameter widgetInstParameter = (WidgetInstParameter)widgetInstParameters.getAt(i);
            if (widgetInstParameter == null || sTargetSelectFields.indexOf(sParamName = widgetInstParameter.getParamName().toUpperCase()) < 0) continue;
            parameters.put(sParamName, widgetInstParameter.getParamValue());
        }
        return parameters;
    }

    @Override
    public WidgetInstParameters getWidgetInstParameters(WidgetInstance widgetInstance, WCMFilter filter) throws WCMException {
        WCMFilter oFilter = new WCMFilter(null, "WidgetInstId=?", null);
        oFilter.addSearchValues(widgetInstance.getId());
        oFilter = oFilter.mergeWith(filter);
        return WidgetInstParameters.openWCMObjs(ContextHelper.getLoginUser(), oFilter);
    }

    @Override
    public WidgetInstParameter getWidgetInstParameter(WidgetInstance widgetInstance, String paraName) throws WCMException {
        WCMFilter oFilter = new WCMFilter(null, "ParamName=?", null);
        oFilter.addSearchValues(paraName);
        WidgetInstParameters widgetInstParameters = this.getWidgetInstParameters(widgetInstance, oFilter);
        int nSize = widgetInstParameters.size();
        for (int i = 0; i < nSize; ++i) {
            WidgetInstParameter oWidgetInstParameter = (WidgetInstParameter)widgetInstParameters.getAt(i);
            if (oWidgetInstParameter == null) continue;
            return oWidgetInstParameter;
        }
        return null;
    }

    @Override
    public WidgetInstParameters saveParameters(WidgetInstance oWidgetInstance, Map parameters) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        WidgetInstParameters oWidgetInstParameters = WidgetInstParameters.createNewInstance(loginUser);
        Widget oWidget = oWidgetInstance.getWidget();
        WidgetParameters oWidgetParameters = this.m_oWidgetParameterMgr.query(oWidget);
        int nSize = oWidgetParameters.size();
        for (int i = 0; i < nSize; ++i) {
            WidgetParameter oWidgetParameter = (WidgetParameter)oWidgetParameters.getAt(i);
            if (oWidgetParameter == null) continue;
            String sParaName = oWidgetParameter.getWidgetParamName();
            String sParamValue = (String)parameters.get(sParaName.toUpperCase());
            WidgetInstParameter oWidgetInstParameter = this.saveParameter(oWidgetInstance, oWidgetParameter, sParamValue);
            oWidgetInstParameters.addElement(oWidgetInstParameter);
        }
        return oWidgetInstParameters;
    }

    private String renderHtmlValue(Template template, WidgetParameter oWidgetParameter, String sHtmlValue) throws WCMException {
        if (template == null) {
            return CMyString.unfilterForHTMLValue(sHtmlValue);
        }
        int nType = oWidgetParameter.getWidgetParamType();
        if (nType != 12 && nType != 16) {
            return sHtmlValue;
        }
        TemplateMgr oTemplateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
        try {
            String sHtml = oTemplateMgr.processTemplateAppendixes(template, sHtmlValue, 2);
            return oTemplateMgr.getTextWithImgFilter(template, sHtml, false);
        }
        catch (Exception e) {
            throw new WCMException("\u5904\u7406\u5927\u5b57\u6bb5\u7684\u6a21\u677f\u9644\u4ef6\u65f6\u51fa\u73b0\u9519\u8bef", e);
        }
    }

    @Override
    public WidgetInstParameters addParameters(WidgetInstance oWidgetInstance, Map parameters) throws WCMException {
        return this.saveParameters(oWidgetInstance, parameters);
    }

    @Override
    public WidgetInstParameter saveParameter(WidgetInstance oWidgetInstance, WidgetParameter oWidgetParameter, String sParamValue) throws WCMException {
        WidgetInstParameter oWidgetInstParameter = this.getWidgetInstParameter(oWidgetInstance, oWidgetParameter.getWidgetParamName());
        if (oWidgetInstParameter == null) {
            oWidgetInstParameter = WidgetInstParameter.createNewInstance();
            oWidgetInstParameter.setWidgetInstId(oWidgetInstance.getId());
            String sParaName = oWidgetParameter.getWidgetParamName();
            oWidgetInstParameter.setParamName(sParaName);
            sParamValue = CMyString.showNull(sParamValue, oWidgetParameter.getDefaultValue());
        } else {
            sParamValue = CMyString.showNull(sParamValue, oWidgetInstParameter.getParamValue());
        }
        sParamValue = CMyString.showNull(sParamValue, oWidgetParameter.getDefaultValue());
        Template template = Template.findById(oWidgetInstance.getTemplateId());
        sParamValue = this.renderHtmlValue(template, oWidgetParameter, sParamValue);
        oWidgetInstParameter.setParamValue(sParamValue);
        oWidgetInstParameter.save(ContextHelper.getLoginUser());
        return oWidgetInstParameter;
    }

    @Override
    public void delete(WidgetInstance oWidgetInstance) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        WidgetInstParameters oParameters = this.getWidgetInstParameters(oWidgetInstance, null);
        int nSize = oParameters.size();
        for (int i = 0; i < nSize; ++i) {
            WidgetInstParameter oParameter = (WidgetInstParameter)oParameters.getAt(i);
            if (oParameter == null) continue;
            oParameter.delete(loginUser);
        }
    }
}

