/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.common.publish.widget.BaseStyle;
import com.trs.components.common.publish.widget.ContentStyle;
import com.trs.components.common.publish.widget.ContentStyleMgr;
import com.trs.components.common.publish.widget.ContentStyles;
import com.trs.components.common.publish.widget.IContentStyleMgr;
import com.trs.components.common.publish.widget.IPageStyleMgr;
import com.trs.components.common.publish.widget.IResourceStyleMgr;
import com.trs.components.common.publish.widget.IStyleCenterMgr;
import com.trs.components.common.publish.widget.IStyleItemMgr;
import com.trs.components.common.publish.widget.ISystemContentStyleMgr;
import com.trs.components.common.publish.widget.ISystemResourceStyleMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.PageStyles;
import com.trs.components.common.publish.widget.ResourceStyle;
import com.trs.components.common.publish.widget.ResourceStyleMgr;
import com.trs.components.common.publish.widget.ResourceStyles;
import com.trs.components.common.publish.widget.StyleHelper;
import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StyleItems;
import com.trs.components.common.publish.widget.StylePathHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class StyleCenterMgr
implements IStyleCenterMgr {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final int STYLE_IS_PRIVATE = 1;
    public static final int STYLE_NOT_IS_PRIVATE = 0;
    public static final int PAGE_OTHERSTYLE_WCMTYPE = 1;
    private static final String CSSFLAG = "$CssFlag$";
    private static final String SEP_RESOURCESTYLE_START = "/*============ \u8d44\u6e90\u53ef\u9009\u98ce\u683c $CssFlag$ start =========*/";
    private static final String SEP_RESOURCESTYLE_END = "/*============ \u8d44\u6e90\u53ef\u9009\u98ce\u683c   $CssFlag$ end =========*/";
    private static final String SEP_CONTENTSTYLE_START = "/*============ \u5185\u5bb9\u53ef\u9009\u98ce\u683c   $CssFlag$ start =========*/";
    private static final String SEP_CONTENTSTYLE_END = "/*============ \u5185\u5bb9\u53ef\u9009\u98ce\u683c   $CssFlag$ end =========*/";
    private static final String SEP_CUSTOMSTYLE = "/*============ \u81ea\u5b9a\u4e49\u98ce\u683c  =========*/";
    private IPageStyleMgr m_oPageStyleMgr = (IPageStyleMgr)DreamFactory.createObjectById("IPageStyleMgr");
    private IResourceStyleMgr m_oResourceStyleMgr = (IResourceStyleMgr)DreamFactory.createObjectById("IResourceStyleMgr");
    private IContentStyleMgr m_oContentStyleMgr = (IContentStyleMgr)DreamFactory.createObjectById("IContentStyleMgr");
    private IStyleItemMgr m_oStyleItemMgr = (IStyleItemMgr)DreamFactory.createObjectById("IStyleItemMgr");

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    @Override
    public File getStyleFile(PageStyle pageStyle) throws WCMException {
        return null;
    }

    @Override
    public String findStyleImageDir(PageStyle _pageStyle) throws WCMException {
        if (_pageStyle == null) {
            return StylePathHelper.getStyleCommonDir() + "default" + File.separator;
        }
        return StylePathHelper.getStyleCommonDir() + _pageStyle.getStyleName() + File.separator;
    }

    @Override
    public String createStyleFile(User _currUser, PageStyle _pageStyle) throws Exception {
        if (_pageStyle == null) {
            return "";
        }
        if (_currUser == null) {
            _currUser = this.getLoginUser();
        }
        String sStyleName = _pageStyle.getStyleName();
        String sStyleCssPathDir = StylePathHelper.getStyleCssDir();
        if (!new FileService(sStyleCssPathDir).exists()) {
            CMyFile.makeDir(sStyleCssPathDir, true);
        }
        String sCssFile = sStyleCssPathDir + sStyleName + ".css";
        String sCompositeCssFile = sStyleCssPathDir + sStyleName + "_composite.css";
        if (new FileService(sCssFile).exists()) {
            String sBakCssFile = sStyleCssPathDir + sStyleName + "bak.css";
            CMyFile.copyFile(sCssFile, sBakCssFile, true);
        }
        if (new FileService(sCompositeCssFile).exists()) {
            String sBakCompositeCssFile = sStyleCssPathDir + sStyleName + "_compositebak.css";
            CMyFile.copyFile(sCompositeCssFile, sBakCompositeCssFile, true);
        }
        this.writeCssFile(_pageStyle, sCssFile);
        long lTimelnMillis = System.currentTimeMillis();
        _pageStyle.setCssVersion(lTimelnMillis);
        this.m_oPageStyleMgr.save(_currUser, _pageStyle);
        return sStyleName + ".css";
    }

    private void writeCssFile(PageStyle _pageStyle, String _dstFile) {
        try {
            this.makeCssContent(_pageStyle, _dstFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void makeCssContent(PageStyle _pageStyle, String _pageStyleFileName) throws IOException, CMyException {
        StringBuffer sbResourceStylesCompositeCss = new StringBuffer();
        StringBuffer sbResourceStylesCss = new StringBuffer();
        sbResourceStylesCss.append(this.m_oPageStyleMgr.makeBaseStyleContent(_pageStyle));
        ResourceStyles resourceStyles = this.m_oResourceStyleMgr.query(_pageStyle, null);
        for (int i = 0; i < resourceStyles.size(); ++i) {
            ResourceStyle resourceStyle = (ResourceStyle)resourceStyles.getAt(i);
            if (resourceStyle == null) continue;
            StringBuffer sbResourceStyleCss = new StringBuffer();
            sbResourceStyleCss.append(CMyString.replaceStr(SEP_RESOURCESTYLE_START, CSSFLAG, resourceStyle.getCssFlag()) + LINE_SEPARATOR);
            sbResourceStyleCss.append(this.m_oResourceStyleMgr.makeCssContent(resourceStyle));
            sbResourceStyleCss.append(CMyString.replaceStr(SEP_RESOURCESTYLE_END, CSSFLAG, resourceStyle.getCssFlag()) + LINE_SEPARATOR);
            sbResourceStylesCss.append(sbResourceStyleCss);
            String sResourceStyleCss = sbResourceStyleCss.toString();
            sbResourceStylesCompositeCss.append(sResourceStyleCss.replaceAll("\\." + resourceStyle.getCssFlag(), "\\." + resourceStyle.getCssFlag() + "-composite"));
        }
        int nDotPos = _pageStyleFileName.lastIndexOf(".");
        String sCompositePageStyleFileName = "";
        if (nDotPos != -1) {
            sCompositePageStyleFileName = _pageStyleFileName.substring(0, nDotPos) + "_composite.css";
        }
        CMyFile.writeFile(sCompositePageStyleFileName, sbResourceStylesCompositeCss.toString(), "utf-8");
        ContentStyles contentStyles = this.m_oContentStyleMgr.query(_pageStyle, null);
        for (int i = 0; i < contentStyles.size(); ++i) {
            ContentStyle contentStyle = (ContentStyle)contentStyles.getAt(i);
            if (contentStyle == null) continue;
            sbResourceStylesCss.append(CMyString.replaceStr(SEP_CONTENTSTYLE_START, CSSFLAG, contentStyle.getCssFlag()) + LINE_SEPARATOR);
            sbResourceStylesCss.append(this.m_oContentStyleMgr.makeCssContent(contentStyle));
            sbResourceStylesCss.append(CMyString.replaceStr(SEP_CONTENTSTYLE_END, CSSFLAG, contentStyle.getCssFlag()) + LINE_SEPARATOR);
        }
        sbResourceStylesCss.append(this.m_oPageStyleMgr.makePageOtherStyleContent(_pageStyle));
        sbResourceStylesCss.append(LINE_SEPARATOR + SEP_CUSTOMSTYLE + LINE_SEPARATOR);
        sbResourceStylesCss.append(_pageStyle.getCustomStyle());
        CMyFile.writeFile(_pageStyleFileName, sbResourceStylesCss.toString(), "utf-8");
    }

    @Override
    public String export(PageStyle _pageStyle) throws Exception {
        if (_pageStyle == null) {
            return "";
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String sCssFile = filesMan.getNextFileName("ST", "css");
        String sCssFilePath = filesMan.mapFilePath(sCssFile, 0);
        String sDestCssFile = sCssFilePath + sCssFile;
        String sStyleName = _pageStyle.getStyleName();
        String sPortalViewPathDir = StylePathHelper.getStyleCssDir();
        String sSourceCssFile = sPortalViewPathDir + sStyleName + ".css";
        if (!new FileService(sSourceCssFile).exists()) {
            this.createStyleFile(this.getLoginUser(), _pageStyle);
        }
        CMyFile.copyFile(sSourceCssFile, sCssFilePath, false);
        FileService renameFile = new FileService(sCssFilePath + sStyleName + ".css");
        FileService realFile = new FileService(sDestCssFile);
        if (realFile.exists()) {
            realFile.delete();
        }
        renameFile.renameTo(realFile);
        return sCssFile;
    }

    @Override
    public void importCssFile(PageStyle _pageStyle, String _sUploadCssFile) throws Exception {
        if (_pageStyle == null || CMyString.isEmpty(_sUploadCssFile)) {
            return;
        }
        FilesMan currMan = FilesMan.getFilesMan();
        String sSourceCssDir = currMan.mapFilePath(_sUploadCssFile, 0);
        String sSourceCssFile = sSourceCssDir + _sUploadCssFile;
        String sRealSourceFile = sSourceCssDir + _pageStyle.getStyleName() + ".css";
        FileService realFile = new FileService(sRealSourceFile);
        if (realFile.exists()) {
            realFile.delete();
        }
        FileService renameFile = new FileService(sSourceCssFile);
        renameFile.renameTo(realFile);
        String sDestDir = StylePathHelper.getStyleCssDir();
        if (!new FileService(sDestDir).exists()) {
            CMyFile.makeDir(sDestDir, true);
        }
        CMyFile.copyFile(realFile.getAbsolutePath(), sDestDir, false);
        _pageStyle.setIsImport(1);
        this.m_oPageStyleMgr.save(this.getLoginUser(), _pageStyle);
    }

    @Override
    public void createImgesDir(PageStyle _pageStyle) throws WCMException {
        String sDir = this.findStyleImageDir(_pageStyle);
        if (new FileService(sDir).exists()) {
            return;
        }
        if (!sDir.equals("")) {
            CMyFile.makeDir(sDir, false);
        }
    }

    @Override
    public void copySystemStyle(User _currUser, PageStyle _targetPageStyle) throws Exception {
        ISystemResourceStyleMgr systemResourceStyleMgr = (ISystemResourceStyleMgr)DreamFactory.createObjectById("ISystemResourceStyleMgr");
        systemResourceStyleMgr.copyFor(_currUser, _targetPageStyle);
        ISystemContentStyleMgr systemContentStyleMgr = (ISystemContentStyleMgr)DreamFactory.createObjectById("ISystemContentStyleMgr");
        systemContentStyleMgr.copyFor(_currUser, _targetPageStyle);
    }

    @Override
    public void saveStyleThumb(String _styleThumb) throws Exception {
    }

    @Override
    public void delStyleThumb(String _styleThumb) throws Exception {
        if (_styleThumb == null || "".equals(_styleThumb.trim())) {
            return;
        }
        FilesMan currMan = FilesMan.getFilesMan();
        String sDstPath = currMan.mapFilePath(_styleThumb, 0) + _styleThumb;
        CMyFile.deleteFile(sDstPath);
    }

    @Override
    public void copyToAllPageSylte(ResourceStyle _resourceStyle) throws WCMException {
        WCMFilter filter = new WCMFilter("", "PageStyleId>0", "");
        PageStyles pageStyles = this.m_oPageStyleMgr.query(filter);
        for (int i = 0; i < pageStyles.size(); ++i) {
            PageStyle pageStyle = (PageStyle)pageStyles.getAt(i);
            if (pageStyle == null) continue;
            this.m_oResourceStyleMgr.copy(this.getLoginUser(), pageStyle, _resourceStyle);
            try {
                this.createStyleFile(this.getLoginUser(), pageStyle);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void copyToAllPageSylte(ContentStyle _contentStyle) throws WCMException {
        WCMFilter filter = new WCMFilter("", "PageStyleId>0", "");
        PageStyles pageStyles = this.m_oPageStyleMgr.query(filter);
        for (int i = 0; i < pageStyles.size(); ++i) {
            PageStyle pageStyle = (PageStyle)pageStyles.getAt(i);
            if (pageStyle == null) continue;
            this.m_oContentStyleMgr.copy(this.getLoginUser(), pageStyle, _contentStyle);
            try {
                this.createStyleFile(this.getLoginUser(), pageStyle);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String makePreviewCssContent(ContentStyle _contentStyle) throws WCMException {
        if (_contentStyle == null) {
            return "";
        }
        int nPageStyleId = _contentStyle.getPageStyleId();
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_oPageStyleMgr.makeBaseStyleContent(pageStyle));
        sb.append(this.m_oPageStyleMgr.makePageOtherStyleContent(pageStyle));
        if (pageStyle != null) {
            sb.append(CMyString.showNull(pageStyle.getCustomStyle()));
        }
        sb.append(this.m_oContentStyleMgr.makeCssContent(_contentStyle));
        return sb.toString();
    }

    @Override
    public String makePreviewCssContent(ResourceStyle _resourceStyle) throws WCMException {
        if (_resourceStyle == null) {
            return "";
        }
        int nPageStyleId = _resourceStyle.getPageStyleId();
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_oPageStyleMgr.makeBaseStyleContent(pageStyle));
        sb.append(this.m_oPageStyleMgr.makePageOtherStyleContent(pageStyle));
        if (pageStyle != null) {
            sb.append(CMyString.showNull(pageStyle.getCustomStyle()));
        }
        sb.append(this.m_oResourceStyleMgr.makeCssContent(_resourceStyle));
        return sb.toString();
    }

    @Override
    public String previewStyle(PageStyle _pageStyle, String sCssFlag, String sTemplateName, StyleItems _styleItems, String _customStyle) throws WCMException {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_oPageStyleMgr.makeBaseStyleContent(_pageStyle));
        if (_pageStyle != null) {
            sb.append(this.m_oPageStyleMgr.makePageOtherStyleContent(_pageStyle));
            sb.append(_pageStyle.getCustomStyle());
        }
        if (_customStyle != null && !_customStyle.trim().equals("")) {
            sb.append(StyleHelper.makeCustomCssContent(sCssFlag, _customStyle));
        } else {
            String sCSSTemplateFile = StyleHelper.getCssTemplateFilePath() + sTemplateName;
            String sCSSTemplateContent = "";
            try {
                sCSSTemplateContent = CMyFile.readFile(sCSSTemplateFile, "utf-8");
            }
            catch (CMyException e) {
                e.printStackTrace();
            }
            if (sCSSTemplateContent == null) {
                throw new WCMException("\u83b7\u53d6\u6a21\u677f\u5931\u8d25\uff01" + sTemplateName);
            }
            if (sCSSTemplateContent.trim().equals("")) {
                return "";
            }
            sb.append(StyleHelper.makeCSSContent(sCssFlag, sCSSTemplateContent, _styleItems));
        }
        return sb.toString();
    }

    @Override
    public HashMap findCssFlagUsedStyles(PageStyle _oPageStyle, BaseStyle _oCurrBaseStyle, String _sCssFlag) throws WCMException {
        ResourceStyleMgr oResourceStyleMgr = new ResourceStyleMgr();
        ResourceStyles oResourceStyles = oResourceStyleMgr.findByCssFlagAndPageStyle(_sCssFlag, _oPageStyle);
        ContentStyleMgr oContentStyleMgr = new ContentStyleMgr();
        ContentStyles oContentStyles = oContentStyleMgr.findByCssFlagAndPageStyle(_sCssFlag, _oPageStyle);
        if (_oCurrBaseStyle != null) {
            if (_oPageStyle == null) {
                HashMap<String, CMSBaseObjs> hmStylesOfCssFlag = new HashMap<String, CMSBaseObjs>();
                hmStylesOfCssFlag.put("ResourceStyles", new ResourceStyles(this.getLoginUser()));
                hmStylesOfCssFlag.put("ContentStyles", new ContentStyles(this.getLoginUser()));
                return hmStylesOfCssFlag;
            }
            if (_oCurrBaseStyle instanceof ResourceStyle) {
                oResourceStyles.remove(_oCurrBaseStyle, false);
            }
            if (_oCurrBaseStyle instanceof ContentStyle) {
                oContentStyles.remove(_oCurrBaseStyle, false);
            }
        }
        HashMap<String, CMSBaseObjs> hmStylesOfCssFlag = new HashMap<String, CMSBaseObjs>();
        hmStylesOfCssFlag.put("ResourceStyles", oResourceStyles);
        hmStylesOfCssFlag.put("ContentStyles", oContentStyles);
        return hmStylesOfCssFlag;
    }

    @Override
    public HashMap findStyleNameUsedStyles(PageStyle _oPageStyle, BaseStyle _oCurrBaseStyle, String _sStyleName) throws WCMException {
        ResourceStyleMgr oResourceStyleMgr = new ResourceStyleMgr();
        ResourceStyles oResourceStyles = oResourceStyleMgr.findByStyleNameAndPageStyle(_sStyleName, _oPageStyle);
        ContentStyleMgr oContentStyleMgr = new ContentStyleMgr();
        ContentStyles oContentStyles = oContentStyleMgr.findByStyleNameAndPageStyle(_sStyleName, _oPageStyle);
        if (_oCurrBaseStyle != null) {
            if (_oPageStyle == null) {
                HashMap<String, CMSBaseObjs> hmStylesOfCssFlag = new HashMap<String, CMSBaseObjs>();
                hmStylesOfCssFlag.put("ResourceStyles", new ResourceStyles(this.getLoginUser()));
                hmStylesOfCssFlag.put("ContentStyles", new ContentStyles(this.getLoginUser()));
                return hmStylesOfCssFlag;
            }
            if (_oCurrBaseStyle instanceof ResourceStyle) {
                oResourceStyles.remove(_oCurrBaseStyle, false);
            }
            if (_oCurrBaseStyle instanceof ContentStyle) {
                oContentStyles.remove(_oCurrBaseStyle, false);
            }
        }
        HashMap<String, CMSBaseObjs> hmStylesOfCssFlag = new HashMap<String, CMSBaseObjs>();
        hmStylesOfCssFlag.put("ResourceStyles", oResourceStyles);
        hmStylesOfCssFlag.put("ContentStyles", oContentStyles);
        return hmStylesOfCssFlag;
    }

    @Override
    public void resetStyle(BaseStyle _oCurrBaseStyle) throws WCMException {
        if (_oCurrBaseStyle == null) {
            throw new WCMException("\u4f20\u9012\u7684\u98ce\u683c\u5bf9\u8c61\u4e3a\u7a7a\uff01");
        }
        int nPageStyleId = 0;
        BaseStyle oSrcBaseStyle = null;
        if (_oCurrBaseStyle instanceof ResourceStyle) {
            ResourceStyle oCurrResourceStyle = (ResourceStyle)_oCurrBaseStyle;
            nPageStyleId = oCurrResourceStyle.getPageStyleId();
            int nSrcResourceStyleId = oCurrResourceStyle.getSrcResourceStyleId();
            oSrcBaseStyle = ResourceStyle.findById(nSrcResourceStyleId);
        }
        if (_oCurrBaseStyle instanceof ContentStyle) {
            ContentStyle oCurrContentStyle = (ContentStyle)_oCurrBaseStyle;
            nPageStyleId = oCurrContentStyle.getPageStyleId();
            int nSrcContentStyleId = oCurrContentStyle.getSrcContentStyleId();
            oSrcBaseStyle = ContentStyle.findById(nSrcContentStyleId);
        }
        if (oSrcBaseStyle == null) {
            throw new WCMException("\u83b7\u53d6\u5f53\u524d\u98ce\u683c[id\uff1a" + _oCurrBaseStyle.getId() + "\uff1btype\uff1a" + (_oCurrBaseStyle.getWCMType() == 1004807208 ? "\u8d44\u6e90\u98ce\u683c" : "\u5185\u5bb9\u98ce\u683c") + "]\u5bf9\u5e94\u7684\u7cfb\u7edf\u7ea7\u522b\u7684\u98ce\u683c\u5931\u8d25\uff01");
        }
        this.m_oStyleItemMgr.delete(this.getLoginUser(), _oCurrBaseStyle);
        StyleItems styleItems = this.m_oStyleItemMgr.queryStyleItems(oSrcBaseStyle, null);
        for (int i = 0; i < styleItems.size(); ++i) {
            StyleItem styleItem = (StyleItem)styleItems.getAt(i);
            if (styleItem == null) continue;
            StyleItem copyStyleItem = (StyleItem)styleItem.cloneToNewObj();
            this.m_oStyleItemMgr.save(this.getLoginUser(), _oCurrBaseStyle, copyStyleItem);
        }
        _oCurrBaseStyle.setStyleThumb(oSrcBaseStyle.getStyleThumb());
        _oCurrBaseStyle.setTemplate(oSrcBaseStyle.getTemplate());
        if (_oCurrBaseStyle instanceof ResourceStyle) {
            ((ResourceStyle)_oCurrBaseStyle).setCustomStyle(((ResourceStyle)oSrcBaseStyle).getCustomStyle());
        }
        if (_oCurrBaseStyle instanceof ContentStyle) {
            ((ContentStyle)_oCurrBaseStyle).setCustomStyle(((ContentStyle)oSrcBaseStyle).getCustomStyle());
        }
        _oCurrBaseStyle.save(this.getLoginUser());
        PageStyle oPageStyle = PageStyle.findById(nPageStyleId);
        try {
            if (nPageStyleId > 0 && oPageStyle != null) {
                this.createStyleFile(this.getLoginUser(), oPageStyle);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setResourceStylePrivate(ResourceStyle _resourceStyle) throws WCMException {
        if (_resourceStyle == null) {
            return;
        }
        if (_resourceStyle.getPageStyleId() != 0) {
            return;
        }
        User loginUser = this.getLoginUser();
        WCMFilter filter = new WCMFilter("", "SRCRESOURCESTYLEID=?", "");
        filter.addSearchValues(_resourceStyle.getId());
        ResourceStyles resourceStyles = ResourceStyles.openWCMObjs(loginUser, filter);
        for (int i = 0; i < resourceStyles.size(); ++i) {
            ResourceStyle resourceStyle = (ResourceStyle)resourceStyles.getAt(i);
            if (resourceStyle == null || resourceStyle.getIsPrivate() == 1) continue;
            resourceStyle.setIsPrivate(1);
            resourceStyle.save(loginUser);
        }
    }

    @Override
    public void setResoruceStylePrivate(ContentStyle _contentStyle) throws WCMException {
        if (_contentStyle == null) {
            return;
        }
        if (_contentStyle.getPageStyleId() != 0) {
            return;
        }
        User loginUser = this.getLoginUser();
        WCMFilter filter = new WCMFilter("", "SRCCONTENTSTYLEID=?", "");
        filter.addSearchValues(_contentStyle.getId());
        ContentStyles contentStyles = ContentStyles.openWCMObjs(loginUser, filter);
        for (int i = 0; i < contentStyles.size(); ++i) {
            ContentStyle contentStyle = (ContentStyle)contentStyles.getAt(i);
            if (contentStyle == null || contentStyle.getIsPrivate() == 1) continue;
            contentStyle.setIsPrivate(0);
            contentStyle.save(loginUser);
        }
    }
}

