/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.ContentStyle;
import com.trs.components.common.publish.widget.ContentStyleExporter;
import com.trs.components.common.publish.widget.ContentStyles;
import com.trs.components.common.publish.widget.IContentStyleMgr;
import com.trs.components.common.publish.widget.IResourceStyleMgr;
import com.trs.components.common.publish.widget.IStyleCenterMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.PageStyleXmlConverter;
import com.trs.components.common.publish.widget.PageStyles;
import com.trs.components.common.publish.widget.ResourceStyle;
import com.trs.components.common.publish.widget.ResourceStyleExporter;
import com.trs.components.common.publish.widget.ResourceStyles;
import com.trs.components.common.publish.widget.StylePathHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyZip;
import com.trs.infra.util.store.FileService;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PageStyleExporter {
    private static Logger logger = Logger.getLogger(PageStyleExporter.class);
    private String m_sXMLEncoding = "utf-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String export(PageStyles _currPageStyles, boolean _bReturnXMLContent) throws Exception {
        if (_currPageStyles == null) {
            throw new WCMException("\u5bfc\u51fa\u7684PageStyle\u5bf9\u8c61\u4e3anull!");
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String sXmlFile = filesMan.getNextFileName("ST", "xml", null, true);
        PageStyleXmlConverter pageStyleXmlConvertor = new PageStyleXmlConverter();
        pageStyleXmlConvertor.setXmlEncoding(this.m_sXMLEncoding);
        String sZipFile = null;
        try {
            if (_bReturnXMLContent) {
                String string = pageStyleXmlConvertor.toXMLString(_currPageStyles);
                return string;
            }
            pageStyleXmlConvertor.toXMLFile(_currPageStyles, sXmlFile);
            sZipFile = filesMan.getNextFileName("ST", "zip", null, true);
            CMyZip myZip = new CMyZip();
            try {
                myZip.setZipFileName(sZipFile);
                myZip.addToZip(sXmlFile, false);
                for (int i = 0; i < _currPageStyles.size(); ++i) {
                    PageStyle currPageStyle = (PageStyle)_currPageStyles.getAt(i);
                    if (currPageStyle == null) continue;
                    String sStyleThumbDirPath = filesMan.getPathConfigValue("W0", 0);
                    List[] bThumbAndResourceList = this.getPageStyleThumbAndResourceFilePath(currPageStyle);
                    CMyDateTime nowDateTime = CMyDateTime.now();
                    String sTempPath = sStyleThumbDirPath + nowDateTime.toString("yyyy-MM-dd") + "_" + System.currentTimeMillis() + "_temp";
                    String sTempViewThumbPath = sTempPath + File.separator + "thumb" + File.separator;
                    CMyFile.makeDir(sTempViewThumbPath, true);
                    List thumbList = bThumbAndResourceList[0];
                    for (int k = 0; k < thumbList.size(); ++k) {
                        FileService oFile;
                        String sThumbFilePath = (String)thumbList.get(k);
                        if (sThumbFilePath == null || "".equals(sThumbFilePath) || !(oFile = new FileService(sThumbFilePath)).exists()) continue;
                        CMyFile.copyFile(sThumbFilePath, sTempViewThumbPath + oFile.getName(), false);
                    }
                    myZip.addToZip(sTempViewThumbPath, true);
                    IStyleCenterMgr styleCenterMgr = (IStyleCenterMgr)DreamFactory.createObjectById("IStyleCenterMgr");
                    String sStyleImagePath = styleCenterMgr.findStyleImageDir(currPageStyle);
                    if (sStyleImagePath != null && new FileService(sStyleImagePath).exists()) {
                        myZip.addToZip(sStyleImagePath, true);
                    }
                    String sTempResourcePath = sTempPath + File.separator + "default" + File.separator;
                    CMyFile.makeDir(sTempResourcePath, true);
                    List resourceList = bThumbAndResourceList[1];
                    for (int k = 0; k < resourceList.size(); ++k) {
                        int nLastIndex;
                        FileService oFile;
                        String sResourceFilePath = (String)resourceList.get(k);
                        if (sResourceFilePath == null || "".equals(sResourceFilePath) || !(oFile = new FileService(sResourceFilePath)).exists()) continue;
                        String sFilePath = CMyFile.extractFilePath(sResourceFilePath);
                        String sLastFileName = (sFilePath = sFilePath.substring(0, sFilePath.length() - 1)).substring((nLastIndex = sFilePath.lastIndexOf(File.separatorChar)) + 1);
                        if (!"default".equalsIgnoreCase(sLastFileName)) continue;
                        CMyFile.copyFile(sResourceFilePath, sTempResourcePath + oFile.getName(), false);
                    }
                    myZip.addToZip(sTempResourcePath, true);
                    CMyFile.deleteDir(sTempPath);
                }
                myZip.done();
            }
            catch (CMyException e) {
                logger.error((Object)"failed to zip files!", (Throwable)e);
                CMyFile.deleteFile(sZipFile);
                throw new WCMException(1100, "\u538b\u7f29\u6587\u4ef6\u5931\u8d25!", e);
            }
        }
        finally {
            CMyFile.deleteFile(sXmlFile);
        }
        return CMyFile.extractFileName(sZipFile);
    }

    private List[] getPageStyleThumbAndResourceFilePath(PageStyle _currPageStyle) throws WCMException {
        if (_currPageStyle == null) {
            throw new WCMException("\u4f20\u5165\u7684\u9875\u9762\u6837\u5f0f\u5bf9\u8c61\u4e3anull\uff01");
        }
        List[] thumbAndResourceList = new List[2];
        ArrayList<String> thumbFilesList = new ArrayList<String>();
        ArrayList resourceFilesList = new ArrayList();
        FilesMan filesMan = FilesMan.getFilesMan();
        String sStyleThumb = _currPageStyle.getStyleThumb();
        if (!CMyString.isEmpty(sStyleThumb)) {
            String sPageStyleThumb = filesMan.mapFilePath(sStyleThumb, 0);
            thumbFilesList.add(sPageStyleThumb + sStyleThumb);
        }
        IResourceStyleMgr resourceStyleMgr = (IResourceStyleMgr)DreamFactory.createObjectById("IResourceStyleMgr");
        ResourceStyles resourceStyles = resourceStyleMgr.query(_currPageStyle, null);
        ResourceStyle aResourceStyle = null;
        ResourceStyleExporter resourceStyleExporter = (ResourceStyleExporter)DreamFactory.createObjectById("ResourceStyleExporter");
        String sStyleCommonDir = StylePathHelper.getStyleCommonDir();
        for (int i = 0; i < resourceStyles.size(); ++i) {
            String sResourceStyleThumb;
            aResourceStyle = (ResourceStyle)resourceStyles.getAt(i);
            if (aResourceStyle == null || CMyString.isEmpty(sResourceStyleThumb = aResourceStyle.getStyleThumb())) continue;
            String sThumbPath = filesMan.mapFilePath(sResourceStyleThumb, 0);
            thumbFilesList.add(sThumbPath + sResourceStyleThumb);
            resourceFilesList.addAll(resourceStyleExporter.getResourceStyleItemImages(aResourceStyle, sStyleCommonDir));
        }
        IContentStyleMgr contentStyleMgr = (IContentStyleMgr)DreamFactory.createObjectById("IContentStyleMgr");
        ContentStyles contentStyles = contentStyleMgr.query(_currPageStyle, null);
        ContentStyle aContentStyle = null;
        ContentStyleExporter contentStyleExporter = (ContentStyleExporter)DreamFactory.createObjectById("ContentStyleExporter");
        for (int i = 0; i < contentStyles.size(); ++i) {
            String sContentStyleThumb;
            aContentStyle = (ContentStyle)contentStyles.getAt(i);
            if (aContentStyle == null || CMyString.isEmpty(sContentStyleThumb = aContentStyle.getStyleThumb())) continue;
            String sThumbPath = filesMan.mapFilePath(sContentStyleThumb, 0);
            thumbFilesList.add(sThumbPath + sContentStyleThumb);
            resourceFilesList.addAll(contentStyleExporter.getContentStyleItemImages(aContentStyle, sStyleCommonDir));
        }
        thumbAndResourceList[0] = thumbFilesList;
        thumbAndResourceList[1] = resourceFilesList;
        return thumbAndResourceList;
    }

    public void setXMLEncoding(String _sXMLEncoding) {
        this.m_sXMLEncoding = _sXMLEncoding;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public static void main(String[] args) throws Exception {
        ContextHelper.initContext(User.findByName("admin"));
        PageStyleExporter export = new PageStyleExporter();
        PageStyles styles = PageStyles.findByIds(ContextHelper.getLoginUser(), "69");
        String spath = export.export(styles, false);
        System.out.println("------------" + spath);
    }
}

