/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.ILayoutGenerator;
import com.trs.components.common.publish.widget.ILayoutMgr;
import com.trs.components.common.publish.widget.Layout;
import com.trs.components.common.publish.widget.Layouts;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;

public class LayoutMgr
implements ILayoutMgr {
    private static ILayoutGenerator m_oLayoutGenerator = (ILayoutGenerator)DreamFactory.createObjectById("ILayoutGenerator");

    @Override
    public Layout save(User _oCurrUser, Layout _currLayout) throws WCMException {
        this.validate(_currLayout);
        m_oLayoutGenerator.generateHtml(_currLayout, false);
        _currLayout.save(_oCurrUser);
        return _currLayout;
    }

    public boolean delete(User _oCurrUser, Layout _currLayout) throws WCMException {
        if (_currLayout == null) {
            throw new WCMException(I18NMessage.get(LayoutMgr.class, "LayoutMgr.label1", "\u6b32\u5220\u9664\u7684\u5e03\u5c40\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01"));
        }
        if (!_currLayout.canEdit(_oCurrUser)) {
            throw new WCMException(CMyString.format(I18NMessage.get(LayoutMgr.class, "LayoutMgr.label2", "ID\u4e3a[{0}]\u7684\u5e03\u5c40\u5df2\u7ecf\u88ab\u5176\u5b83\u7528\u6237\u9501\u5b9a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"), new String[]{String.valueOf(_currLayout.getId())}));
        }
        _currLayout.delete(_oCurrUser);
        m_oLayoutGenerator.deleteCss(_currLayout);
        return true;
    }

    @Override
    public boolean delete(User _oCurrUser, Layouts _oLayouts) throws WCMException {
        if (_oLayouts == null) {
            throw new WCMException(I18NMessage.get(LayoutMgr.class, "LayoutMgr.label1", "\u6b32\u5220\u9664\u7684\u5e03\u5c40\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01"));
        }
        for (int i = 0; i < _oLayouts.size(); ++i) {
            this.delete(_oCurrUser, (Layout)_oLayouts.getAt(i));
        }
        return true;
    }

    public boolean validateRatio(Layout _currLayout) throws WCMException {
        int nRatioType = _currLayout.getRatioType();
        if (nRatioType != Layout.RATIO_TYPE_FIXED && nRatioType != Layout.RATIO_TYPE_PERCENTAGE) {
            throw new WCMException(I18NMessage.get(LayoutMgr.class, "LayoutMgr.label3", "\u5e03\u5c40\u6bd4\u4f8b\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303\uff01"));
        }
        int nColumns = _currLayout.getColumns();
        if (nColumns > Layout.MAX_COLUMNS) {
            throw new WCMException(CMyString.format(I18NMessage.get(LayoutMgr.class, "LayoutMgr.label4", "\u5e03\u5c40\u7684\u5217\u6570\u8d85\u8fc7\u4e86\u7cfb\u7edf\u5141\u8bb8\u7684\u6700\u5927\u5217\u6570[{0}]\uff01"), new String[]{String.valueOf(Layout.MAX_COLUMNS)}));
        }
        String sRatio = _currLayout.getRatio();
        if (String.valueOf(sRatio.charAt(0)).equals(Layout.RATIO_SEPERATE) || sRatio.endsWith(Layout.RATIO_SEPERATE)) {
            throw new WCMException(CMyString.format(I18NMessage.get(LayoutMgr.class, "LayoutMgr.label10", "\u5e03\u5c40\u6bd4\u4f8b\u503c\u4e0d\u80fd\u4ee5\u6570\u503c\u5206\u9694\u7b26 {0} \u5f00\u5934\u6216\u8005\u7ed3\u5c3e\uff01"), new String[]{Layout.RATIO_SEPERATE}));
        }
        String[] values = sRatio.split(Layout.RATIO_SEPERATE);
        if (values.length != nColumns) {
            throw new WCMException(I18NMessage.get(LayoutMgr.class, "LayoutMgr.label5", "\u5e03\u5c40\u6bd4\u4f8b\u4e0d\u7b26\u5408\u89c4\u8303[\u4e0e\u5e03\u5c40\u7684\u5217\u6570\u4e0d\u76f8\u7b49]\uff01"));
        }
        int iNum = 0;
        try {
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].trim().equals(Layout.ADAPTIVE_CHAR)) {
                    if (Integer.parseInt(values[i]) > 0) continue;
                    throw new WCMException(I18NMessage.get(LayoutMgr.class, "LayoutMgr.label6", "\u5e03\u5c40\u6bd4\u4f8b\u503c\u4e0d\u80fd\u4e3a\u8d1f\u6570\u548c\u96f6\uff01"));
                }
                ++iNum;
            }
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(LayoutMgr.class, "LayoutMgr.label7", "\u5e03\u5c40\u6bd4\u4f8b\u503c\u4e0d\u7b26\u5408\u89c4\u8303[\u6bd4\u4f8b\u503c\u53ea\u80fd\u4e3a\u6b63\u6574\u6570\u6216\u8005\u5b57\u7b26*]\uff01"));
        }
        if (iNum > 1) {
            throw new WCMException(I18NMessage.get(LayoutMgr.class, "LayoutMgr.label8", "\u5e03\u5c40\u6bd4\u4f8b\u503c\u4e0d\u6b63\u786e[\u81f3\u591a\u53ea\u80fd\u6709\u4e00\u4e2a\u4e3a*\u7684\u503c]\uff01"));
        }
        return true;
    }

    @Override
    public boolean validate(Layout _currLayout) throws WCMException {
        try {
            this.validateRatio(_currLayout);
        }
        catch (Exception ex) {
            throw new WCMException(I18NMessage.get(LayoutMgr.class, "LayoutMgr.label11", "\u6821\u9a8c\u5e03\u5c40\u4fe1\u606f\u65f6\u51fa\u73b0\u9519\u8bef\uff01"), ex);
        }
        return true;
    }

    @Override
    public Layouts query(User _currUser, WCMFilter _filter) throws WCMException {
        return Layouts.openWCMObjs(_currUser, _filter);
    }

    @Override
    public Layout findLayoutByName(User _currUser, String sLayoutName) throws WCMException {
        WCMFilter filter = new WCMFilter(null, "LAYOUTNAME=?", "LAYOUTID desc");
        filter.addSearchValues(sLayoutName);
        Layouts oLayouts = Layouts.openWCMObjs(_currUser, filter);
        return oLayouts.size() > 0 ? (Layout)oLayouts.getAt(0) : null;
    }
}

