/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.ajaxservice.xmlconvertors.XMLToCMSObj;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.ContentStyle;
import com.trs.components.common.publish.widget.ContentStyleExporter;
import com.trs.components.common.publish.widget.ContentStyleImporter;
import com.trs.components.common.publish.widget.ContentStyles;
import com.trs.components.common.publish.widget.IContentStyleMgr;
import com.trs.components.common.publish.widget.IContentStyleServiceProvider;
import com.trs.components.common.publish.widget.IStyleCenterMgr;
import com.trs.components.common.publish.widget.IStyleItemMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.PageStyleServiceProvider;
import com.trs.components.common.publish.widget.SpecialAuthServer;
import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StyleItems;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class ContentStyleServiceProvider
implements IContentStyleServiceProvider {
    private static transient Logger mLogger = Logger.getLogger(PageStyleServiceProvider.class);
    private IContentStyleMgr m_oContentStyleMgr = (IContentStyleMgr)DreamFactory.createObjectById("IContentStyleMgr");
    private IStyleItemMgr m_oStyleItemMgr = (IStyleItemMgr)DreamFactory.createObjectById("IStyleItemMgr");
    private IStyleCenterMgr m_oStyleCenterMgr = (IStyleCenterMgr)DreamFactory.createObjectById("IStyleCenterMgr");
    private Reports m_copyReports;
    public static final int SYSTEMPAGESTYLEID = 0;
    public static final int PAGESTYLECOUNTONLY = 2;

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    @Override
    public void delete(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        String sContentStyleIds = context.getObjectIds();
        ContentStyles contentStyles = ContentStyles.findByIds(loginUser, sContentStyleIds);
        HttpServletRequest oRequest = context.getServiceContext().getRequest();
        HttpSession hsSession = null;
        if (oRequest != null) {
            hsSession = oRequest.getSession();
        }
        for (int i = 0; i < contentStyles.size(); ++i) {
            ContentStyle contentStyle = (ContentStyle)contentStyles.getAt(i);
            if (contentStyle == null) continue;
            boolean bHasRight = SpecialAuthServer.hasRight(loginUser, contentStyle, 13);
            if (!bHasRight) {
                throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u98ce\u683c\u3010" + contentStyle.getStyleDesc() + "\u3011\uff01");
            }
            if (contentStyle.getPageStyleId() == 0) {
                this.m_oStyleCenterMgr.setResoruceStylePrivate(contentStyle);
            }
            String sContentStyleName = contentStyle.getStyleName();
            WCMFilter filter = new WCMFilter("", "StyleName=?", " PageStyleId desc");
            filter.addSearchValues(sContentStyleName);
            ContentStyles currentConentStyles = ContentStyles.openWCMObjs(loginUser, filter);
            if (currentConentStyles.size() == 2 && ((ContentStyle)currentConentStyles.getAt(1)).getPageStyleId() == 0) {
                this.m_oContentStyleMgr.delete(loginUser, (ContentStyle)currentConentStyles.getAt(1));
            }
            if (hsSession != null) {
                hsSession.setAttribute("currentPageStyle", (Object)("\u5220\u9664\u5185\u5bb9\u98ce\u683c\u3010" + contentStyle.getProperty("STYLENAME") + "\u3011\uff0c"));
            }
            try {
                this.m_oContentStyleMgr.delete(loginUser, contentStyle);
                continue;
            }
            catch (Exception e) {
                if (hsSession == null) continue;
                hsSession.setAttribute("ErrorInfo", (Object)e.getStackTrace());
            }
        }
    }

    @Override
    public Object query(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nPageStyleId = context.getValue("PageStyleId", -1);
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        if (nPageStyleId > 0 && pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + nPageStyleId + "]");
        }
        WCMFilter extraFilter = new WCMFilter(context.getQueryFilter());
        ContentStyles contentStyles = this.m_oContentStyleMgr.query(pageStyle, extraFilter);
        for (int i = contentStyles.size() - 1; i >= 0; --i) {
            boolean bHasRight;
            ContentStyle contentStyle = (ContentStyle)contentStyles.getAt(i);
            if (contentStyle == null || (bHasRight = SpecialAuthServer.hasRight(loginUser, contentStyle, 4))) continue;
            contentStyles.removeAt(i, false);
        }
        return contentStyles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int save(MethodContext context) throws Throwable {
        String sCssFlag;
        PageStyle oPageStyle;
        int nRightIndex;
        boolean bHasRight;
        User loginUser = this.getLoginUser();
        int nContentStyleId = context.getObjectId();
        int nPageStyleId = context.getValue("PageStyleId", -1);
        ContentStyle contentStyle = null;
        if (nContentStyleId > 0) {
            contentStyle = ContentStyle.findById(nContentStyleId);
            if (contentStyle == null) {
                throw new WCMException("\u83b7\u53d6\u5185\u5bb9\u53ef\u7528\u98ce\u683c\u5931\u8d25\uff01ContentStyleId=[" + nContentStyleId + "]");
            }
        } else {
            contentStyle = new ContentStyle();
        }
        if (!(bHasRight = SpecialAuthServer.hasRight(loginUser, contentStyle, nRightIndex = nContentStyleId > 0 ? 12 : 11))) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650" + (nContentStyleId > 0 ? "\u4fee\u6539\u98ce\u683c\u3010" + contentStyle.getStyleDesc() + "\u3011\uff01" : "\u65b0\u5efa\u98ce\u683c\uff01"));
        }
        String[] pLogicFields = new String[]{"ObjectId", "StyleItemXML"};
        contentStyle = (ContentStyle)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, context, contentStyle, pLogicFields);
        if (nContentStyleId == 0) {
            if (nPageStyleId == 0) {
                contentStyle.setIsPrivate(0);
            } else {
                contentStyle.setIsPrivate(1);
            }
        }
        if (!this.m_oContentStyleMgr.checkCssFlag(oPageStyle = PageStyle.findById(nPageStyleId), contentStyle, sCssFlag = contentStyle.getPropertyAsString("CssFlag"))) {
            throw new WCMException(1008, "\u5728\u5f53\u524d\u9875\u9762\u98ce\u683c\u4e0b\u5df2\u7ecf\u5b58\u5728\u98ce\u683c\u6807\u8bc6\u4e3a[" + sCssFlag + "]\u7684\u5185\u5bb9\u98ce\u683c.");
        }
        String sStyleName = contentStyle.getPropertyAsString("StyleName");
        if (!this.m_oContentStyleMgr.checkStyleName(oPageStyle, contentStyle, sStyleName)) {
            throw new WCMException(1008, "\u5728\u5f53\u524d\u9875\u9762\u98ce\u683c\u4e0b\u5df2\u7ecf\u5b58\u5728\u98ce\u683c\u540d\u79f0\u4e3a[" + sStyleName + "]\u7684\u5185\u5bb9\u98ce\u683c.");
        }
        this.m_oContentStyleMgr.save(loginUser, contentStyle);
        XMLToCMSObj xmlToCMSObj = new XMLToCMSObj(loginUser, new StyleItem());
        xmlToCMSObj.parse(context.getValue("StyleItemXML"));
        this.m_oStyleItemMgr.deleteUnuseStyleItems(contentStyle, xmlToCMSObj.getObjectIds());
        boolean bException = true;
        try {
            int nSize = xmlToCMSObj.getCMSObjs().length;
            for (int i = 0; i < nSize; ++i) {
                StyleItem styleItem = (StyleItem)xmlToCMSObj.getCMSObjs()[i];
                if (styleItem == null) continue;
                this.m_oStyleItemMgr.save(loginUser, contentStyle, styleItem);
            }
            bException = false;
        }
        finally {
            if (bException) {
                xmlToCMSObj.cancelUpdate();
            }
        }
        if (nContentStyleId == 0 && nPageStyleId != 0) {
            this.m_oContentStyleMgr.copy(this.getLoginUser(), null, contentStyle);
        }
        if (nPageStyleId == 0 && nContentStyleId == 0) {
            this.m_oStyleCenterMgr.copyToAllPageSylte(contentStyle);
        }
        try {
            if (nPageStyleId != 0) {
                this.m_oStyleCenterMgr.createStyleFile(this.getLoginUser(), PageStyle.findById(nPageStyleId));
            }
        }
        catch (WCMException ex) {
            mLogger.error((Object)("\u81ea\u52a8\u751f\u6210\u6837\u5f0f\u6587\u4ef6\u51fa\u9519\uff1a" + ex));
        }
        return contentStyle.getId();
    }

    public int saveStyleThumb(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nContentStyleId = context.getObjectId();
        String sStyleThumb = context.getValue("StyleThumb");
        ContentStyle contentStyle = ContentStyle.findById(nContentStyleId);
        if (contentStyle == null) {
            throw new WCMException("\u83b7\u53d6\u5185\u5bb9\u53ef\u7528\u98ce\u683c\u5931\u8d25\uff01ContentStyle=[" + nContentStyleId + "]");
        }
        boolean bHasRight = SpecialAuthServer.hasRight(loginUser, contentStyle, 12);
        if (!bHasRight) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u4fee\u6539\u98ce\u683c\u3010" + contentStyle.getStyleDesc() + "\u3011\uff01");
        }
        contentStyle.setStyleThumb(sStyleThumb);
        this.m_oContentStyleMgr.save(this.getLoginUser(), contentStyle);
        this.m_oStyleCenterMgr.saveStyleThumb(sStyleThumb);
        WCMFilter aFilter = new WCMFilter("", "PAGESTYLEID=0 AND CSSFLAG=?", "");
        aFilter.addSearchValues(contentStyle.getCssFlag());
        ContentStyles oContentStyles = ContentStyles.openWCMObjs(loginUser, aFilter);
        if (oContentStyles.size() > 0) {
            ContentStyle oSysContentStyle = (ContentStyle)oContentStyles.getAt(0);
            oSysContentStyle.setStyleThumb(sStyleThumb);
            oSysContentStyle.save(this.getLoginUser());
        }
        return contentStyle.getId();
    }

    @Override
    public Object findById(MethodContext context) throws Throwable {
        return ContentStyle.findById(context.getObjectId());
    }

    @Override
    public Object findByIds(MethodContext context) throws Throwable {
        return ContentStyles.findByIds(this.getLoginUser(), context.getObjectIds());
    }

    @Override
    public String copy(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nSourceContentStyleId = context.getValue("SourceContentStyleId", -1);
        String sTargetPageStyleIds = context.getValue("TargetPageStyleIds");
        int nCopyMode = context.getValue("CopyMode", 1);
        ContentStyle sourceContentStyle = ContentStyle.findById(nSourceContentStyleId);
        if (sourceContentStyle == null) {
            throw new WCMException("\u83b7\u53d6\u5185\u5bb9\u53ef\u7528\u98ce\u683c\u5931\u8d25\uff01SourceContentStyleId=[" + nSourceContentStyleId + "]");
        }
        this.m_copyReports = new Reports("");
        int[] arId = CMyString.splitToInt(sTargetPageStyleIds, ",");
        int nCount = arId.length;
        int[] copyIds = new int[nCount];
        for (int i = 0; i < nCount; ++i) {
            boolean bHasRight;
            int nTargetPageStyleId = arId[i];
            PageStyle targetPageStyle = PageStyle.findById(nTargetPageStyleId);
            if (nTargetPageStyleId > 0 && targetPageStyle == null || !(bHasRight = SpecialAuthServer.hasRight(loginUser, sourceContentStyle, 11))) continue;
            ContentStyle copyContentStyle = this.m_oContentStyleMgr.copy(this.getLoginUser(), targetPageStyle, sourceContentStyle, nCopyMode, this.m_copyReports);
            try {
                if (nTargetPageStyleId > 0 && targetPageStyle != null) {
                    this.m_oStyleCenterMgr.createStyleFile(this.getLoginUser(), targetPageStyle);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            copyIds[i] = copyContentStyle == null ? 0 : copyContentStyle.getId();
        }
        this.setReportsTitle();
        return this.m_copyReports.toJSONXML();
    }

    public boolean checkCssFlag(MethodContext _context) throws Throwable {
        int nPageStyleId = _context.getValue("PageStyleId", -1);
        String sCssFlag = _context.getValue("CssFlag");
        int nCurrContentStyleId = _context.getValue("CurrContentStyleId", -1);
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        if (nPageStyleId > 0 && pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + nPageStyleId + "]");
        }
        ContentStyle contentStyle = ContentStyle.findById(nCurrContentStyleId);
        if (sCssFlag.startsWith(".")) {
            sCssFlag = sCssFlag.substring(1);
        }
        return this.m_oContentStyleMgr.checkCssFlag(pageStyle, contentStyle, sCssFlag);
    }

    public String makePreviewCssContent(MethodContext _context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nContentStyleId = _context.getObjectId();
        ContentStyle contentStyle = ContentStyle.findById(nContentStyleId);
        if (contentStyle == null) {
            throw new WCMException("\u83b7\u53d6\u8d44\u6e90\u53ef\u7528\u98ce\u683c\u5931\u8d25\uff01ContentStyleId=[" + nContentStyleId + "]");
        }
        boolean bHasRight = SpecialAuthServer.hasRight(loginUser, contentStyle, 14);
        if (!bHasRight) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u9884\u89c8\u98ce\u683c\u3010" + contentStyle.getStyleDesc() + "\u3011\uff01");
        }
        return this.m_oStyleCenterMgr.makePreviewCssContent(contentStyle);
    }

    public ContentStyles queryContentStyles(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nPageStyleId = context.getValue("PageStyleId", -1);
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        if (nPageStyleId > 0 && pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + nPageStyleId + "]");
        }
        WCMFilter extraFilter = new WCMFilter(context.getQueryFilter());
        ContentStyles contentStyles = this.m_oContentStyleMgr.query(pageStyle, extraFilter);
        for (int i = contentStyles.size() - 1; i >= 0; --i) {
            boolean bHasRight;
            ContentStyle contentStyle = (ContentStyle)contentStyles.getAt(i);
            if (contentStyle == null || (bHasRight = SpecialAuthServer.hasRight(loginUser, contentStyle, 4))) continue;
            contentStyles.removeAt(i, false);
        }
        return contentStyles;
    }

    public String previewStyle(MethodContext _context) throws Throwable {
        boolean bHasRight;
        User loginUser = this.getLoginUser();
        int nContentStyleId = _context.getObjectId();
        String sCssFlag = _context.getValue("CssFlag");
        String sTemplateName = _context.getValue("Template");
        int nPageStyleId = _context.getValue("PageStyleId", -1);
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        ContentStyle contentStyle = ContentStyle.findById(nContentStyleId);
        if (contentStyle != null && !(bHasRight = SpecialAuthServer.hasRight(loginUser, contentStyle, 14))) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u9884\u89c8\u98ce\u683c\u3010" + contentStyle.getStyleDesc() + "\u3011\uff01");
        }
        String sCustomStyle = _context.getValue("CustomStyle");
        XMLToCMSObj xmlToCMSObj = new XMLToCMSObj(loginUser, new StyleItem());
        xmlToCMSObj.parse(_context.getValue("StyleItemXML"));
        StyleItems styleItems = StyleItems.createNewInstance(loginUser);
        int nSize = xmlToCMSObj.getCMSObjs().length;
        for (int i = 0; i < nSize; ++i) {
            StyleItem styleItem = (StyleItem)xmlToCMSObj.getCMSObjs()[i];
            if (styleItem == null) continue;
            styleItem.setId(i + 1);
            styleItem.setAddMode(false);
            styleItem.setStyleObjId(nContentStyleId);
            styleItem.setStyleObjType(1791765043);
            styleItems.addElement(styleItem);
        }
        return this.m_oStyleCenterMgr.previewStyle(pageStyle, sCssFlag, sTemplateName, styleItems, sCustomStyle);
    }

    public HashMap findCssFlagUsedInfo(MethodContext _context) throws Throwable {
        int nPageStyleId = _context.getValue("PageStyleId", -1);
        String sCssFlag = _context.getValue("CssFlag");
        int nCurrContentStyleId = _context.getValue("CurrContentStyleId", -1);
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        if (nPageStyleId > 0 && pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + nPageStyleId + "]");
        }
        ContentStyle contentStyle = ContentStyle.findById(nCurrContentStyleId);
        if (nCurrContentStyleId > 0 && contentStyle == null) {
            throw new WCMException("\u83b7\u53d6\u8d44\u6e90\u5185\u5bb9\u5931\u8d25\uff01ContentStyleId=[" + nCurrContentStyleId + "]");
        }
        if (sCssFlag.startsWith(".")) {
            sCssFlag = sCssFlag.substring(1);
        }
        HashMap hmStylesOfCssFlag = this.m_oStyleCenterMgr.findCssFlagUsedStyles(pageStyle, contentStyle, sCssFlag);
        return hmStylesOfCssFlag;
    }

    public HashMap findStyleNameUsedInfo(MethodContext _context) throws Throwable {
        int nPageStyleId = _context.getValue("PageStyleId", -1);
        String sCssFlag = _context.getValue("StyleName");
        int nCurrContentStyleId = _context.getValue("CurrContentStyleId", -1);
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        if (nPageStyleId > 0 && pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u9875\u9762\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + nPageStyleId + "]");
        }
        ContentStyle contentStyle = ContentStyle.findById(nCurrContentStyleId);
        if (nCurrContentStyleId > 0 && contentStyle == null) {
            throw new WCMException("\u83b7\u53d6\u5185\u5bb9\u98ce\u683c\u5931\u8d25\uff01ResourceStyleId=[" + nCurrContentStyleId + "]");
        }
        if (sCssFlag.startsWith(".")) {
            sCssFlag = sCssFlag.substring(1);
        }
        HashMap hmStylesOfCssFlag = this.m_oStyleCenterMgr.findStyleNameUsedStyles(pageStyle, contentStyle, sCssFlag);
        return hmStylesOfCssFlag;
    }

    public boolean checkCssFlagOrNameCanUse(MethodContext _context) throws WCMException {
        int nPageStyleId = _context.getValue("PageStyleId", 0);
        PageStyle oPageStyle = PageStyle.findById(nPageStyleId);
        if (nPageStyleId > 0 && oPageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u9875\u9762\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + nPageStyleId + "]");
        }
        String sCssFlag = _context.getValue("CssFlag");
        String sStyleName = _context.getValue("StyleName");
        if (CMyString.isEmpty(sCssFlag) && CMyString.isEmpty(sStyleName)) {
            throw new WCMException("\u98ce\u683c\u6807\u8bc6\u3010CssFlag\u3011\u548c\u98ce\u683c\u540d\u79f0\u3010StyleName\u3011\u5fc5\u987b\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\uff01");
        }
        HashMap hmStylesOfCssFlag = this.m_oStyleCenterMgr.findCssFlagUsedStyles(oPageStyle, null, sCssFlag);
        ContentStyles contentStyles = (ContentStyles)hmStylesOfCssFlag.get("ContentStyles");
        if (contentStyles.size() > 0) {
            return false;
        }
        HashMap hmStylesOfStyleName = this.m_oStyleCenterMgr.findStyleNameUsedStyles(oPageStyle, null, sStyleName);
        contentStyles = (ContentStyles)hmStylesOfStyleName.get("ContentStyles");
        return contentStyles.size() <= 0;
    }

    public void resetContentStyle(MethodContext _oContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nCurrContentStyleId = _oContext.getValue("ContentStyleId", 0);
        if (nCurrContentStyleId <= 0) {
            throw new WCMException("\u4f20\u5165\u7684ContentStyleId[" + nCurrContentStyleId + "]\u5e94\u8be5\u5927\u4e8e0\uff01");
        }
        ContentStyle oCurrContentStyle = ContentStyle.findById(nCurrContentStyleId);
        if (oCurrContentStyle == null) {
            throw new WCMException("\u83b7\u53d6\u5185\u5bb9\u98ce\u683c[id\uff1a" + nCurrContentStyleId + "]\u5931\u8d25\uff01");
        }
        boolean bHasRight = SpecialAuthServer.hasRight(loginUser, oCurrContentStyle, 12);
        if (!bHasRight) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u4fee\u6539\u98ce\u683c\u3010" + oCurrContentStyle.getStyleDesc() + "\u3011\uff01");
        }
        this.m_oStyleCenterMgr.resetStyle(oCurrContentStyle);
    }

    public String exportContentStyleZip(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        String sContentStyleIds = context.getObjectIds();
        int nPageStyleId = context.getValue("PageStyleId", 0);
        ContentStyles contentStyles = ContentStyles.findByIds(loginUser, sContentStyleIds);
        for (int i = contentStyles.size() - 1; i >= 0; --i) {
            boolean bHasRight;
            ContentStyle contentStyle = (ContentStyle)contentStyles.getAt(i);
            if (contentStyle == null || (bHasRight = SpecialAuthServer.hasRight(loginUser, contentStyle, 4))) continue;
            contentStyles.removeAt(i, false);
        }
        ContentStyleExporter contentStyleExporter = (ContentStyleExporter)DreamFactory.createObjectById("ContentStyleExporter");
        return contentStyleExporter.export(contentStyles, nPageStyleId);
    }

    public Reports importContentStyleZip(MethodContext context) throws Throwable {
        String sContentStyleZipFile = context.getValue("ContentStyleZipFile");
        if (sContentStyleZipFile == null) {
            throw new WCMException("\u8981\u5bfc\u5165\u7684\u6587\u4ef6\u4e3anull!");
        }
        int nImportMode = context.getValue("ImportMode", 1);
        int nPageStyleId = context.getValue("PageStyleId", 0);
        ContentStyleImporter contentStyleImporter = (ContentStyleImporter)DreamFactory.createObjectById("ContentStyleImporter");
        Reports importReports = contentStyleImporter.importFromFile(sContentStyleZipFile, nImportMode, nPageStyleId);
        return importReports;
    }

    private void setReportsTitle() {
        int nSuccessed = this.m_copyReports.getSucessedReporter().size();
        this.m_copyReports.setTitle(CMyString.format("\u5171\u5904\u7406{0}\u4e2a\u98ce\u683c.", new int[]{nSuccessed}));
    }
}

