/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.template;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;

public class TempAppendix
extends CMSObj {
    public static final int OBJ_TYPE = 104;
    public static final String DB_TABLE_NAME = "WCMTEMPAPPENDIX";
    public static final String DB_ID_NAME = "TEMPAPPENDIXID";
    public static final int FLAG_NEW = 0;
    public static final int FLAG_DELETED = 1;
    public static final int FLAG_UPDATED = 2;
    public static final int FLAG_PUBLISHED = 3;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 104;
    }

    public int getRootType() {
        return this.getPropertyAsInt("ROOTTYPE", 0);
    }

    public int getRootId() {
        return this.getPropertyAsInt("ROOTID", 0);
    }

    public IPublishFolder getRoot() throws Exception {
        return (IPublishFolder)PublishElementFactory.lookupElement(this.getRootType(), this.getRootId());
    }

    public boolean setRoot(int _nType, int _nId) throws WCMException {
        return this.setProperty("ROOTTYPE", _nType) && this.setProperty("ROOTID", _nId);
    }

    public boolean setRoot(IPublishFolder _root) throws WCMException {
        if (_root == null) {
            throw new WCMException(10, I18NMessage.get(TempAppendix.class, "TempAppendix.label1", "\u65e0\u6548\u7684\u6587\u4ef6\u5939\u6839\u76ee\u5f55\u5bf9\u8c61"));
        }
        return this.setRoot(_root.getType(), _root.getId());
    }

    public int getFlag() {
        return this.getPropertyAsInt("APDFLAG", 0);
    }

    public boolean setFlag(int _nFlag) throws WCMException {
        if (_nFlag != 0 && _nFlag != 1 && _nFlag != 2 && _nFlag != 3) {
            throw new WCMException(10, I18NMessage.get(TempAppendix.class, "TempAppendix.label2", "\u65e0\u6548\u7684\u9644\u4ef6\u6807\u8bc6\uff1a") + _nFlag);
        }
        return this.setProperty("APDFLAG", _nFlag);
    }

    public String getFile() {
        return (String)this.getProperty("APDFILE");
    }

    public boolean setFile(String _sFile) throws WCMException {
        return this.setProperty("APDFILE", _sFile);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("ROOTID") == null) {
                throw new WCMException(1106, I18NMessage.get(TempAppendix.class, "TempAppendix.label3", "\u5c5e\u6027WebSite\u6ca1\u6709\u8bbe\u7f6e(TempAppendix.isValid)"));
            }
            if (this.getProperty("APDFILE") == null) {
                throw new WCMException(1106, I18NMessage.get(TempAppendix.class, "TempAppendix.label4", "\u5c5e\u6027File\u6ca1\u6709\u8bbe\u7f6e(TempAppendix.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(TempAppendix.class, "TempAppendix.label5", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(TempAppendix.isValid)"));
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            super.insert(_currUser);
        }
    }

    public boolean addRelation(int _templateId) throws WCMException {
        Template template = Template.findById(_templateId);
        return this.addRelation(template);
    }

    public boolean addRelation(Template _template) throws WCMException {
        if (_template == null || !_template.isValidInstance()) {
            throw new WCMException(1100, I18NMessage.get(TempAppendix.class, "TempAppendix.label6", "\u6307\u5b9a\u7684\u6a21\u677f\u5bf9\u8c61\u65e0\u6548\uff08TempAppendix.addRelation\uff09"));
        }
        try {
            String[] strSQLs = new String[]{"insert into wcmTempApdRel(TempId,AppendixId) values(" + _template.getId() + "," + this.getId() + ")"};
            this.getDBManager().sqlExecuteUpdate(strSQLs);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(TempAppendix.class, "TempAppendix.label7", "\u6dfb\u52a0\u6a21\u677f\u9644\u4ef6\u5173\u8054\u65f6\u51fa\u9519\uff08TemplateAppendix.deleteRelation\uff09"), ex);
        }
        return true;
    }

    public boolean deleteRelation(Template _template) throws WCMException {
        if (_template == null || !_template.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(TempAppendix.class, "TempAppendix.label8", "\u6307\u5b9a\u6a21\u677f\u5bf9\u8c61\u65e0\u6548\uff08TempAppendix.deleteRelation\uff09"));
        }
        return this.deleteRelation(_template.getId());
    }

    public boolean deleteRelation(int _templateId) throws WCMException {
        try {
            String[] strSQLs = new String[]{"delete from wcmTempApdRel where TempId=" + _templateId + " and AppendixId=" + this.getId()};
            this.getDBManager().sqlExecuteUpdate(strSQLs);
            return true;
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(TempAppendix.class, "TempAppendix.label9", "\u5220\u9664\u6a21\u677f\u9644\u4ef6\u5173\u8054\u5931\u8d25\uff08TemplateAppendix.deleteRelation\uff09"), ex);
        }
    }

    public static final TempAppendix findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (TempAppendix)BaseObj.findById(TempAppendix.class, _nId);
    }

    public static final TempAppendix createNewInstance() throws WCMException {
        return (TempAppendix)BaseObj.createNewInstance(TempAppendix.class);
    }

    public static final TempAppendix findByKey(Object _oKey) throws WCMException {
        return (TempAppendix)BaseObj.findByKey(TempAppendix.class, _oKey);
    }
}

