/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.widget.IWidgetInstParameterMgr;
import com.trs.components.common.publish.widget.IWidgetInstanceMgr;
import com.trs.components.common.publish.widget.WidgetInstParameter;
import com.trs.components.common.publish.widget.WidgetInstParameters;
import com.trs.components.common.publish.widget.WidgetInstance;
import com.trs.components.common.publish.widget.WidgetInstances;
import com.trs.components.wcm.content.service.portervisitors.IPorterVisitor;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjToXmlConverter;
import com.trs.infra.persistent.ObjToXmlConverter;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class VisualTemplatePorterVistor
implements IPorterVisitor {
    private static Logger logger = Logger.getLogger(VisualTemplatePorterVistor.class);
    private IWidgetInstanceMgr m_oWidgetInstanceMgr = (IWidgetInstanceMgr)DreamFactory.createObjectById("IWidgetInstanceMgr");
    private IWidgetInstParameterMgr m_oWidgetInstParameterMgr = (IWidgetInstParameterMgr)DreamFactory.createObjectById("IWidgetInstParameterMgr");
    private Map m_oInstanceIdMapping;
    private static Pattern m_oInstancePattern = Pattern.compile("(?im)(<trs_widget[^>]+)id=[\"'](\\d+)[\"']([^>]*>)");

    @Override
    public void doExport(BaseObj obj, Object args) throws Exception {
        logger.debug((Object)"\u5f00\u59cb\u5904\u7406\u6a21\u677f\u7684Porter");
        if (!(obj instanceof Template)) {
            return;
        }
        Template oTemplate = (Template)obj;
        if (!oTemplate.getPropertyAsBoolean("VISUAL", false)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u5df2\u7ecf\u8bc6\u522b\u4e3a\u53ef\u89c6\u5316\u6a21\u677f" + oTemplate));
        }
        ObjToXmlConverter objToXmlConverter = new ObjToXmlConverter();
        Object[] objs = (Object[])args;
        BaseObjToXmlConverter converter = (BaseObjToXmlConverter)objs[0];
        Element templateEl = (Element)objs[1];
        WidgetInstances instances = this.m_oWidgetInstanceMgr.getWidgetInstances(oTemplate);
        templateEl = templateEl.addElement("XWCMWIDGETINSTANCES");
        int nSize = instances.size();
        for (int i = 0; i < nSize; ++i) {
            WidgetInstance instance = (WidgetInstance)instances.getAt(i);
            if (instance == null) continue;
            Element el = objToXmlConverter.toXmlElement(instance);
            templateEl.add(el);
            WidgetInstParameters parameters = this.m_oWidgetInstParameterMgr.getWidgetInstParameters(instance, null);
            converter.addChildElements(el, new Element[]{converter.toXmlElement(parameters, null)});
        }
    }

    @Override
    public void doImport(BaseObj obj, XmlObject obj2, Object args) throws Exception {
        logger.debug((Object)"into template doimport...");
        Template currTemplate = (Template)obj;
        if (!currTemplate.getPropertyAsBoolean("VISUAL", false)) {
            return;
        }
        boolean isFound = false;
        XmlObject xmlObj = null;
        XmlObject[] xmlObjects = (XmlObject[])args;
        for (int i = 0; i < xmlObjects.length; ++i) {
            xmlObj = xmlObjects[i];
            Template template = (Template)xmlObj.getCurrentObj();
            if (!this.isEquals(currTemplate, template)) continue;
            isFound = true;
            break;
        }
        if (!isFound || xmlObj == null) {
            return;
        }
        XmlObject[] instances = xmlObj.getChild("XWCMWIDGETINSTANCES");
        if (instances.length <= 0) {
            return;
        }
        if (currTemplate.getId() == 0) {
            currTemplate.setNextId();
        }
        logger.debug((Object)"\u5f00\u59cb\u53ef\u89c6\u5316\u6a21\u677f\u7684\u5bfc\u5165\u5904\u7406...");
        this.m_oInstanceIdMapping = new HashMap();
        for (int i = 0; i < instances.length; ++i) {
            WidgetInstance instance = (WidgetInstance)instances[i].getCurrentObj();
            String sOldInstanceId = String.valueOf(instance.getId());
            instance = this.saveNewWidgetInstance(currTemplate, instance);
            this.m_oInstanceIdMapping.put(sOldInstanceId, String.valueOf(instance.getId()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"\u8bb0\u5f55\u7684\u8d44\u6e90\u5b9e\u4f8bid\u6620\u5c04\u5173\u7cfb\u4e3a:");
            logger.debug((Object)this.m_oInstanceIdMapping);
        }
        String sText = this.replaceWidgetInstId(currTemplate.getText(), this.m_oInstanceIdMapping);
        currTemplate.setText(sText);
    }

    private boolean isEquals(Template one, Template another) {
        if (one == another) {
            return true;
        }
        if (one.getId() == another.getId()) {
            return true;
        }
        return one.getName().equals(another.getName()) && one.getFolderId() == another.getFolderId() && one.getFolderType() == another.getFolderType();
    }

    private WidgetInstance saveNewWidgetInstance(Template template, WidgetInstance instance) throws WCMException {
        WidgetInstance widgetInstance = this.m_oWidgetInstanceMgr.clone(instance);
        widgetInstance.setTemplateId(template.getId());
        widgetInstance.save(ContextHelper.getLoginUser());
        return widgetInstance;
    }

    private WidgetInstParameter saveWidgetInstParameters(WidgetInstance instance, WidgetInstParameter parameter) throws WCMException {
        parameter.setWidgetInstId(instance.getId());
        parameter.save(ContextHelper.getLoginUser());
        return parameter;
    }

    private String replaceWidgetInstId(String sVisualHtml, Map widgetInstIdMapping) {
        if (CMyString.isEmpty(sVisualHtml)) {
            return "";
        }
        StringBuffer sbVisualHtml = new StringBuffer(sVisualHtml.length());
        Matcher matcher = m_oInstancePattern.matcher(sVisualHtml);
        int nStartIndex = 0;
        int nEndIndex = 0;
        while (matcher.find()) {
            nStartIndex = matcher.start();
            sbVisualHtml.append(sVisualHtml.substring(nEndIndex, nStartIndex));
            nEndIndex = matcher.end();
            sbVisualHtml.append(matcher.group(1));
            String sInstanceId = matcher.group(2);
            sbVisualHtml.append("id=\"").append((String)widgetInstIdMapping.get(sInstanceId)).append("\"");
            sbVisualHtml.append(matcher.group(3));
        }
        if (nEndIndex < sVisualHtml.length()) {
            sbVisualHtml.append(sVisualHtml.substring(nEndIndex));
        }
        return sbVisualHtml.toString();
    }

    @Override
    public String[] registerTargetClassName() {
        return new String[]{Template.class.getName()};
    }
}

