/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.components.common.publish.domain.template.TemplateImporter;
import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.PinyinHelper;
import com.trs.infra.util.jazzlib.ZipEntry;
import com.trs.infra.util.jazzlib.ZipInputStream;
import com.trs.infra.util.store.FileService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

class UnZipFile4Template
extends CMyUnZipFile {
    private Hashtable m_hAllFileNameIndex = null;

    public UnZipFile4Template(String _sZipFile, String _sUnZipPath) {
        super(_sZipFile, _sUnZipPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUnZipAnd() throws CMyException {
        String fn = this.getZipFile();
        if (!CMyFile.fileExists(fn)) {
            throw new CMyException(55, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label33", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u538b\u7f29\u6587\u4ef6[") + fn + "]");
        }
        String destDir = this.getUnZipPath();
        if (!CMyFile.fileExists(destDir)) {
            CMyFile.makeDir(destDir, true);
        }
        InputStream fis = null;
        BufferedInputStream bis = null;
        ZipInputStream zis = null;
        try {
            boolean zFileSeperatorSalsh = '/' != File.pathSeparatorChar;
            byte[] buff = new byte[1024];
            int chunk = 0;
            OutputStream fos = null;
            String sWritedFn = null;
            String sFnEncoding = this.getFileNameEncoding();
            this.m_hAllFileNameIndex = new Hashtable(10, 1.0f);
            fis = new FileService(fn).getInputStream();
            bis = new BufferedInputStream(fis);
            zis = new ZipInputStream(bis);
            ZipEntry entry = zis.getNextEntry(sFnEncoding);
            boolean zTypeInfo = false;
            while (entry != null) {
                if (!entry.isDirectory()) {
                    fn = entry.getName();
                    if (zFileSeperatorSalsh) {
                        fn = fn.replace('/', File.separatorChar);
                    }
                    zTypeInfo = fn.endsWith("TemplateTypeInfos.xml");
                    fn = destDir + fn;
                    sWritedFn = PinyinHelper.convert(fn);
                    String sPath = CMyFile.extractFilePath(sWritedFn);
                    if (!CMyFile.pathExists(sPath)) {
                        CMyFile.makeDir(sPath, true);
                    }
                    try {
                        fos = new FileService(sWritedFn).getOutputStream();
                        while ((chunk = zis.read(buff, 0, buff.length)) != -1) {
                            fos.write(buff, 0, chunk);
                        }
                    }
                    finally {
                        if (fos != null) {
                            try {
                                fos.flush();
                            }
                            catch (Exception exception) {}
                            try {
                                fos.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (zTypeInfo) {
                        this.m_hAllFileNameIndex.put("TemplateTypeInfos.xml", sWritedFn);
                    } else {
                        this.m_hAllFileNameIndex.put(fn, sWritedFn);
                    }
                }
                entry = zis.getNextEntry(sFnEncoding);
            }
        }
        catch (Exception ex) {
            throw new CMyException(200, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label34", "\u89e3\u538b\u6587\u4ef6\u3010") + this.getZipFile() + I18NMessage.get(TemplateImporter.class, "TemplateImporter.label35", "\u3011\u5230\u76ee\u5f55\u3010") + this.getUnZipPath() + I18NMessage.get(TemplateImporter.class, "TemplateImporter.label36", "\u3011\u5931\u8d25\uff01"), ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
            }
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (Exception exception) {}
            }
            try {
                CMyFile.deleteFile(this.getZipFile());
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Hashtable getAllFileNameIndex() {
        return this.m_hAllFileNameIndex;
    }
}

