/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.message.notify.NotificationServer;
import com.trs.components.common.message.notify.Notifier;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.config.persistent.TemplateParseConfig;
import com.trs.components.common.publish.domain.distribute.FileDistributeShip;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagDocumentReader;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.tagparser.TagParserFactory;
import com.trs.components.common.publish.domain.tagparser.TemplateParameter;
import com.trs.components.common.publish.domain.tagparser.TemplateParameterList;
import com.trs.components.common.publish.domain.template.TemplateNestMgr;
import com.trs.components.common.publish.domain.template.TemplateParseAngel;
import com.trs.components.common.publish.domain.template.TemplateQuoteMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TempAppendix;
import com.trs.components.common.publish.persistent.template.TempAppendixes;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateArgument;
import com.trs.components.common.publish.persistent.template.TemplateArguments;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.infra.I18NMessage;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Report;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class TemplateParseMgr
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    private Logger logger = Logger.getLogger((String)TemplateParseMgr.class.getName());
    private static final List DATEREL_ATTRS = Arrays.asList("LOCALE", "TIMEZONE", "INMILLIS", "ONLYTEMPLATENAME");
    public static long LRU_CACHE_EXPIRES = 3600000L;
    private static Cache cache = (Cache)DreamFactory.createObjectById("lruCache");
    private TemplateNestMgr m_templateNestMgr = (TemplateNestMgr)DreamFactory.createObjectById("TemplateNestMgr");
    private TemplateQuoteMgr m_templateQuoteMgr = (TemplateQuoteMgr)DreamFactory.createObjectById("TemplateQuoteMgr");

    public TemplateParseMgr() {
        try {
            TemplateParseConfig myConfig = PublishServerConfigMapper.getTemplateParseConfig();
            cache.setMaxSize(myConfig.getDomCacheMaxSize());
            this.logger.info((Object)("Template name cache maximum size: " + myConfig.getDomCacheMaxSize()));
        }
        catch (Exception ex) {
            this.logger.error((Object)"Failed to load configuration from publish server config!", (Throwable)ex);
        }
        TemplateParseAngel.scanAll();
    }

    public void setCacheMaxSize(int _nMaxSize) {
        cache.setMaxSize(_nMaxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TagDocument parse(Template _template) throws Exception {
        if (_template == null) {
            throw new WCMException(10, "Template required!");
        }
        Integer key = new Integer(_template.getId());
        TagDocument result = (TagDocument)cache.get(this.getKey(key));
        if (result != null) {
            return result;
        }
        Template template = _template;
        synchronized (template) {
            result = (TagDocument)cache.get(this.getKey(key));
            if (result != null) {
                return result;
            }
            String sText = _template.getPubText();
            try {
                result = TagDocumentReader.read(sText, _template);
            }
            catch (Throwable ex) {
                this.logger.error((Object)("Failed to read DOM of the template [" + _template.getId() + "]"), ex);
                throw new WCMException(220, "Failed to read DOM of the template [" + _template.getId() + "](" + _template.getName() + ")", ex);
            }
            if (!_template.isParsed()) {
                this.logger.debug((Object)("to analyze semantic rules in template [" + _template.getId() + "] "));
                this.clearSemanticRules(_template);
                this.buildSemanticRules(_template, result);
                this.updateTemplateParsedFlag(_template);
                this.uploadAppendixes(_template, false);
            }
            this.uploadParameters(_template, result);
            _template.refreshProperty("ISPARSED", true);
            cache.set(this.getKey(key), result);
            cache.pexpire(this.getKey(key), LRU_CACHE_EXPIRES);
        }
        return result;
    }

    public void notifyTemplateAdded(Template _template) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("notifyTemplateAdded: " + _template.getInfo()));
        }
        TemplateParseAngel.scan(_template);
    }

    public void notifyTemplateModified(Template _template) throws WCMException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("notifyTemplateModified: " + _template.getInfo()));
        }
        this.clearSemanticRules(_template);
        this.removeCache(_template);
        TemplateParseAngel.scan(_template);
    }

    public void notifyTemplateDeleted(Template _template) throws WCMException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("notifyTemplateDeleted: " + _template.getInfo()));
        }
        this.clearSemanticRules(_template);
        this.removeCache(_template);
    }

    private void removeCache(Template _template) {
        Integer key = new Integer(_template.getId());
        cache.clear(this.getKey(key));
    }

    private void clearSemanticRules(Template _template) throws WCMException {
        try {
            this.m_templateNestMgr.clearNestRecordsOf(_template);
            this.m_templateQuoteMgr.clearQuotesOfTemplate(_template);
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to clear the old result before analyzing template semantic rules!", ex);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildSemanticRules(Template _template, TagDocument _tagDoc) throws WCMException {
        List<String> buildedTemplates = null;
        try {
            IPublishFolder root = _template.getRoot();
            if (root == null) {
                throw new WCMException("Root of " + _template.getInfo() + " not exist: type=" + _template.getRootType() + ",id=" + _template.getRootId());
            }
            int nTemplateType = _template.getType();
            int nTemplateId = _template.getId();
            for (int nTagItemIndex = 0; nTagItemIndex < _tagDoc.getItemCount(); ++nTagItemIndex) {
                Object item = _tagDoc.getItemAt(nTagItemIndex);
                if (item instanceof String) continue;
                TagItem tag = (TagItem)item;
                String sName = tag.getName();
                if (TagParserFactory.isNestedTemplateTag(sName)) {
                    String sTempName = tag.getAttribute("TEMPNAME");
                    if (TagItem.isVariableParameter(sTempName)) continue;
                    Template nestedTemplate = null;
                    try {
                        nestedTemplate = TagParseHelper.findNestedTemplate(sTempName, root);
                    }
                    catch (Exception ignore) {
                        ignore.printStackTrace();
                    }
                    if (nestedTemplate == null) continue;
                    this.m_templateNestMgr.addNestRecord(nTemplateId, nestedTemplate.getId());
                    if (nestedTemplate.isParsed()) continue;
                    int ix = 8;
                    buildedTemplates = (List)ContextParameters.get(ix, true);
                    if (buildedTemplates == null) {
                        buildedTemplates = new ArrayList<String>(4);
                        ContextParameters.set(ix, buildedTemplates);
                    } else if (buildedTemplates.contains(sTempName)) {
                        throw new WCMException(234, I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label1", "\u5d4c\u5957\u6a21\u677f\u5b58\u5728\u5d4c\u5957\u73af\u8def") + buildedTemplates + ":" + sTempName);
                    }
                    buildedTemplates.add(sTempName);
                    this.parse(nestedTemplate);
                    continue;
                }
                ITagParser parser = TagParserFactory.createParserByName(sName);
                if (parser == null) {
                    throw new WCMException(10, "Unsupported tag <" + sName + ">");
                }
                try {
                    parser.setTagItem(tag);
                    TemplateQuote[] quotes = parser.analyzeQuotes(root);
                    if (quotes == null) continue;
                    for (int index = 0; index < quotes.length; ++index) {
                        TemplateQuote aQuote = quotes[index];
                        if (aQuote == null) continue;
                        aQuote.setTemplate(nTemplateId, nTemplateType);
                        this.m_templateQuoteMgr.save(aQuote);
                    }
                    continue;
                }
                catch (Exception ex) {
                    throw new WCMException(234, "Failed to analyze the quoting relations in tag: " + tag.toString(), ex);
                }
            }
        }
        catch (WCMException ex) {
            try {
                throw ex;
                catch (Exception ex2) {
                    throw new WCMException(233, "Failed to analyze the semantic rules for " + _template.getInfo(), ex2);
                }
            }
            catch (Throwable throwable) {
                buildedTemplates = (ArrayList<String>)ContextParameters.get(8);
                if (buildedTemplates != null) {
                    buildedTemplates.clear();
                    buildedTemplates = null;
                }
                throw throwable;
            }
        }
        buildedTemplates = (List)ContextParameters.get(8);
        if (buildedTemplates != null) {
            buildedTemplates.clear();
            return;
        }
    }

    private void updateTemplateParsedFlag(Template _template) throws WCMException {
        try {
            String sSql = "UPDATE WCMTEMPLATE SET IsParsed=1 WHERE TEMPID=" + _template.getId();
            DBManager.getDBManager().sqlExecuteUpdate(sSql);
            _template.refreshProperty("ISPARSED", true);
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to update the template parsed flag!", ex);
        }
    }

    public void uploadAppendixes(Template _template, boolean _bForceAll) throws WCMException {
        if (_template == null || !_bForceAll && !_template.isApdModified()) {
            return;
        }
        int[] arrFlags = null;
        if (!_bForceAll) {
            arrFlags = new int[]{0, 2};
        }
        TempAppendixes appendixes = null;
        TempAppendix anAppendix = null;
        IPublishFolder root = null;
        String sSourcePath = null;
        String sLocalPublishPath = null;
        String sLocalPreviewPath = null;
        String sFileName = null;
        String sFilePathName = null;
        StringBuffer buffWarnings = new StringBuffer();
        FileDistributeShip ship = null;
        PublishPathCompass compass = null;
        try {
            User currUser = ContextHelper.getLoginUser();
            appendixes = _template.getAppendixes(currUser, arrFlags);
            for (int index = 0; index < appendixes.size(); ++index) {
                anAppendix = (TempAppendix)appendixes.getAt(index);
                if (anAppendix == null) continue;
                if (root == null) {
                    root = _template.getRoot();
                    sSourcePath = FilesMan.getFilesMan().getTemplateAppendixPath(root.getType(), root.getId(), 0, true);
                    compass = new PublishPathCompass();
                    sLocalPublishPath = compass.getLocalPath(root, false) + "images/";
                    sLocalPreviewPath = compass.getLocalPath(root, true) + "images/";
                    PublishSyncGlobalTuner.insureLocalPathExists(sLocalPublishPath);
                    PublishSyncGlobalTuner.insureLocalPathExists(sLocalPreviewPath);
                }
                sFileName = CMyFile.extractFileName(anAppendix.getFile());
                sFilePathName = sSourcePath + sFileName;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("to copy template appendix file [" + sFilePathName + "] to [" + sLocalPublishPath + "] and [" + sLocalPreviewPath + "]"));
                }
                if (CMyFile.fileExists(sFilePathName)) {
                    CMyFile.copyFile(sFilePathName, sLocalPublishPath + sFileName);
                    CMyFile.copyFile(sFilePathName, sLocalPreviewPath + sFileName);
                    if (ship == null) {
                        ship = new FileDistributeShip(compass);
                        ship.setBatchMode(true);
                    }
                    ship.distributeFile(sFilePathName, root, "images/");
                } else {
                    String sMessage = "Appendix file of " + _template.getInfo() + " missing: " + sFilePathName;
                    this.logger.error((Object)sMessage);
                    buffWarnings.append("\n").append(sMessage);
                }
                if (anAppendix.getFlag() == 3) continue;
                anAppendix.canEdit(currUser);
                try {
                    anAppendix.setFlag(3);
                    anAppendix.update(currUser);
                    continue;
                }
                catch (Exception ex) {
                    anAppendix.cancelUpdate(currUser);
                    throw ex;
                }
            }
            if (_template.isApdModified()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"to update template ApdModified = false ...");
                }
                _template.canEdit(currUser);
                try {
                    _template.setApdModified(false);
                    _template.update(currUser);
                }
                catch (Exception ex) {
                    _template.cancelUpdate(currUser);
                    throw ex;
                }
            }
            String EVENT = "Publish.WhenTemplateAppendixNotFound";
            if (buffWarnings.length() > 0 && NotificationServer.getInstance().needNotifyForEvent("Publish.WhenTemplateAppendixNotFound")) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"to send notification on event Publish.WhenTemplateAppendixNotFound");
                }
                Notifier notifier = new Notifier();
                notifier.setParameter("TemplateInfo", _template.getInfo());
                notifier.setParameter("Message", buffWarnings.toString());
                notifier.executeOnEvent("Publish.WhenTemplateAppendixNotFound");
            }
        }
        catch (Exception ex) {
            throw new WCMException(220, "Failed to upload the appendixes of " + _template.getInfo(), ex);
        }
        finally {
            buffWarnings.setLength(0);
            if (appendixes != null) {
                appendixes.clear();
            }
            if (compass != null) {
                compass.clear();
            }
            if (ship != null) {
                ship.clear();
            }
        }
    }

    private void uploadParameters(Template _template, TagDocument _document) throws WCMException {
        TagItem tagItem;
        TemplateParameterList newList = new TemplateParameterList();
        TemplateParameterList oldList = _template.getTemplateParameters();
        HashMap oldMaps = oldList != null ? oldList.getNameMaps() : null;
        Iterator itr = _document.findItems(null);
        while (itr.hasNext() && (tagItem = (TagItem)itr.next()) != null) {
            Iterator itrVariables;
            HashMap allVariables = tagItem.getVariableParameters();
            if (allVariables == null || (itrVariables = allVariables.values().iterator()) == null) continue;
            while (itrVariables.hasNext()) {
                TemplateParameter aParameter = (TemplateParameter)itrVariables.next();
                aParameter.setTemplateId(_template.getId());
                aParameter.setTemplateName(_template.getName());
                newList.addParameter(aParameter);
                if (oldMaps == null) continue;
                oldMaps.remove(aParameter.getParameterName());
            }
        }
        _template.setTemplateParameters(newList);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("template arguments :" + newList));
        }
        if (oldMaps != null && oldMaps.size() > 0) {
            WCMFilter filter = new WCMFilter("", "TEMPLATEID=" + _template.getId(), "");
            TemplateArguments tas = TemplateArguments.createNewInstance(User.getSystem());
            tas.open(filter);
            for (int i = tas.size() - 1; i >= 0; --i) {
                TemplateArgument ta = (TemplateArgument)tas.getAt(i);
                if (ta == null || oldMaps.get(ta.getArgumentName()) == null) continue;
                ta.delete();
            }
            tas.clear();
        }
    }

    public Report checkTemplate(Template _template) {
        return this.checkTemplate(_template, true);
    }

    public Report checkTemplate(Template _template, boolean bCanEdit) {
        StringBuffer sbPrefix = new StringBuffer(1024);
        if (_template.getId() > 0) {
            sbPrefix.append(_template.getInfo());
        }
        String sTempInfo = _template.getName() + CMyString.showNull(_template.getAttributeValue("tempId"));
        String sLocation = "";
        String sFolderInfo = "";
        try {
            IPublishFolder folder = _template.getFolder();
            if (folder == null) {
                sLocation = I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label3", "\u4e0d\u5b58\u5728");
            } else {
                String sObjDesc = WCMTypes.getLowerObjName(folder.getSubstance().getWCMType());
                sLocation = I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label2", " \u5b58\u653e\u4f4d\u7f6e:") + sObjDesc;
                sFolderInfo = folder.getInfo();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            sLocation = sLocation + I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label4", " \u5b58\u653e\u4f4d\u7f6e\u83b7\u53d6\u5931\u8d25!");
        }
        if (_template.getId() > 0 && bCanEdit) {
            sLocation = sLocation + "~Edit-" + _template.getId() + "~";
        }
        Report report = new Report("");
        report.setRelateObject(_template);
        TagDocument tagDoc = this.checkLexical(_template, report);
        if (tagDoc == null) {
            report.setType(5);
            report.setRportTitle(CMyString.format(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label5", " {0}{1}, \u5f53\u524d\u7f16\u8f91\u7684\u6a21\u677f\u5b58\u5728\u6587\u6cd5\u9519\u8bef\uff01"), new Object[]{sTempInfo, sLocation, sFolderInfo}));
            return report;
        }
        if (!this.checkGrammar(tagDoc, report)) {
            report.setType(5);
            report.setRportTitle(CMyString.format(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label6", "{0}{1}, \u5f53\u524d\u7f16\u8f91\u7684\u6a21\u677f\u5b58\u5728\u8bed\u6cd5\u9519\u8bef\uff01"), new Object[]{sTempInfo, sLocation, sFolderInfo}));
            return report;
        }
        if (!this.checkSemantic(_template, tagDoc, report)) {
            report.setType(5);
            report.setRportTitle(CMyString.format(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label7", " {0}{1}, \u5f53\u524d\u7f16\u8f91\u7684\u6a21\u677f\u5b58\u5728\u8bed\u4e49\u9519\u8bef\uff01"), new Object[]{sTempInfo, sLocation, sFolderInfo}));
            return report;
        }
        report.setRportTitle(CMyString.format(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label8", " {0}{1}, \u5f53\u524d\u7f16\u8f91\u7684\u6a21\u677f\u8bed\u6cd5\u6b63\u786e\uff01"), new Object[]{sTempInfo, sLocation, sFolderInfo}));
        return report;
    }

    public TagDocument checkLexical(Template _template, Report _report) {
        try {
            return TagDocumentReader.read(_template.getPubText());
        }
        catch (Throwable ex) {
            _report.setType(5);
            _report.setRportDetail(ex.getMessage());
            return null;
        }
    }

    public boolean checkGrammar(TagDocument _tagDoc, Report _report) {
        TagItem tagItem;
        StringBuffer sbResult = new StringBuffer();
        Iterator itr = _tagDoc.findItems(null);
        while (itr.hasNext() && (tagItem = (TagItem)itr.next()) != null) {
            this.checkTagItem(tagItem, sbResult);
        }
        if (sbResult.length() > 0) {
            _report.setRportDetail(sbResult.toString());
            return false;
        }
        return true;
    }

    private void checkTagItem(TagItem _tagItem, StringBuffer _sbResult) {
        TagBeanInfo.BodyType type;
        TagBeanAttrInfo[] requiredAttr;
        Iterator itr;
        ITagParser tarParser = null;
        if ("TRS_RECORD".equals(_tagItem.getName())) {
            return;
        }
        try {
            tarParser = TagParserFactory.createParserByName(_tagItem.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tarParser == null) {
            _sbResult.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label9", "\u7f6e\u6807"));
            _sbResult.append(_tagItem.getDescWithPos());
            _sbResult.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label10", "\u4e0d\u53ef\u8bc6\u522b\u7684"));
            _sbResult.append("\n");
            return;
        }
        TagBeanInfo tagInfo = null;
        try {
            tagInfo = tarParser.getBeanInfo();
        }
        catch (Throwable e) {
            this.logger.error((Object)(_tagItem.getDescWithPos() + tarParser.getClass().toString()), e);
        }
        if (tagInfo == null) {
            return;
        }
        HashMap existAtrrs = _tagItem.getAttributes();
        if (existAtrrs != null && (itr = existAtrrs.keySet().iterator()) != null) {
            while (itr.hasNext()) {
                String sKey = (String)itr.next();
                if (DATEREL_ATTRS.contains(sKey.toUpperCase())) continue;
                String sVal = _tagItem.getAttribute(sKey);
                TagBeanAttrInfo attrInfo = tagInfo.getAttrInfo(sKey);
                if (attrInfo == null) {
                    _sbResult.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label9", "\u7f6e\u6807"));
                    _sbResult.append(_tagItem.getDescWithPos());
                    _sbResult.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label11", "\u7684\u5c5e\u6027["));
                    _sbResult.append(sKey);
                    _sbResult.append("=");
                    _sbResult.append(sVal);
                    _sbResult.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label12", "]\u65e0\u6548\n"));
                    continue;
                }
                String[] aFormatType = CMyString.split(sVal, ",");
                for (int i = 0; i < aFormatType.length; ++i) {
                    this.checkTagAttr(_tagItem, attrInfo, aFormatType[i], _sbResult);
                }
            }
        }
        if ((requiredAttr = tagInfo.getRequiredAttr()) != null && requiredAttr.length > 0) {
            for (int i = requiredAttr.length - 1; i >= 0; --i) {
                TagBeanAttrInfo attr = requiredAttr[i];
                String attrValue = _tagItem.getAttribute(attr.getName());
                if (attrValue != null && attrValue.length() != 0) continue;
                _sbResult.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label9", "\u7f6e\u6807"));
                _sbResult.append(_tagItem.getDescWithPos());
                _sbResult.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label11", "\u7684\u5c5e\u6027["));
                _sbResult.append(attr.getDesc());
                _sbResult.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label13", "]\u662f\u5fc5\u987b\u7684\n"));
            }
        }
        if ((type = tagInfo.getType()) == TagBeanInfo.BodyType.ARGUMENT && _tagItem.getText() == null) {
            _sbResult.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label9", "\u7f6e\u6807"));
            _sbResult.append(_tagItem.getDescWithPos());
            _sbResult.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label14", "\u7684\u53c2\u6570\u662f\u5fc5\u987b\u7684\n"));
        }
    }

    private void checkTagAttr(TagItem _tagItem, TagBeanAttrInfo _attrInfo, String _value, StringBuffer _sbResult) {
        String[] sValids;
        TagBeanAttrInfo.Type type = _attrInfo.getType();
        if (TagItem.isVariableParameter(_value)) {
            if (!_attrInfo.getVariable()) {
                _sbResult.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label9", "\u7f6e\u6807"));
                _sbResult.append(_tagItem.getDescWithPos());
                _sbResult.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label11", "\u7684\u5c5e\u6027["));
                _sbResult.append(_attrInfo.getName());
                _sbResult.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label15", "]\u7684\u503c\u4e0d\u5141\u8bb8\u4e3a\u53d8\u91cf:"));
                _sbResult.append(_value);
                _sbResult.append("\n");
            }
            return;
        }
        if (type == TagBeanAttrInfo.Type.INTEGER) {
            // empty if block
        }
        if ((sValids = _attrInfo.getEnumValue()) != null && sValids.length > 0) {
            boolean found = false;
            for (int i = sValids.length - 1; i >= 0; --i) {
                if (!sValids[i].equalsIgnoreCase(_value)) continue;
                found = true;
            }
            if (!found) {
                _sbResult.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label9", "\u7f6e\u6807"));
                _sbResult.append(_tagItem.getDescWithPos());
                _sbResult.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label11", "\u7684\u5c5e\u6027["));
                _sbResult.append(_attrInfo.getName());
                _sbResult.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label16", "]\u7684\u503c<"));
                _sbResult.append(_value);
                _sbResult.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label17", ">\u5fc5\u987b\u5728\u5217\u8868"));
                _sbResult.append(_attrInfo.getEnumValueString());
                _sbResult.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label18", "\u4e2d\n"));
            }
        }
    }

    private boolean checkSemantic(Template _template, TagDocument _tagDoc, Report _report) {
        StringBuffer sbResult = new StringBuffer();
        IPublishFolder root = null;
        try {
            root = _template.getRoot();
            if (root == null) {
                sbResult.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label19", "\u83b7\u53d6\u6a21\u677f["));
                sbResult.append(_template);
                sbResult.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label20", "]\u7684\u6839\u76ee\u5f55\u5931\u8d25\n"));
            }
        }
        catch (Exception e) {
            sbResult.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label19", "\u83b7\u53d6\u6a21\u677f["));
            sbResult.append(_template);
            sbResult.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label21", "]\u7684\u6839\u76ee\u5f55\u51fa\u9519:"));
            sbResult.append(e.getMessage());
            sbResult.append("\n");
        }
        if (root != null) {
            TagItem tagItem;
            Iterator itr = _tagDoc.findItems(null);
            while (itr.hasNext() && (tagItem = (TagItem)itr.next()) != null) {
                TagBeanInfo tagInfo = this.getTagBeanInfo(tagItem);
                if (tagInfo == null) continue;
                tagInfo.checkSemantic(root, tagItem, sbResult, _template.getName());
            }
        }
        if (sbResult.length() > 0) {
            _report.setRportDetail(sbResult.toString());
            return false;
        }
        return true;
    }

    private TagBeanInfo getTagBeanInfo(TagItem _tagItem) {
        ITagParser tarParser = null;
        if ("TRS_RECORD".equals(_tagItem.getName())) {
            return null;
        }
        try {
            tarParser = TagParserFactory.createParserByName(_tagItem.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tarParser == null) {
            return null;
        }
        try {
            return tarParser.getBeanInfo();
        }
        catch (Throwable e) {
            this.logger.error((Object)(_tagItem.getDescWithPos() + tarParser.getClass().toString()), e);
            return null;
        }
    }

    private boolean isListening(BaseObj object) {
        return object != null && object.getWCMType() == 102;
    }

    @Override
    public void notifyOnAddObj(BaseObj objAdded) throws WCMException {
        if (this.isListening(objAdded)) {
            this.parseForCluster((Template)objAdded);
        }
    }

    @Override
    public void notifyOnDelObj(BaseObj objDeleted, int eventType) throws WCMException {
        if (this.isListening(objDeleted)) {
            this.removeCache((Template)objDeleted);
        }
    }

    @Override
    public void notifyOnModifyObj(BaseObj objModified, int eventType) throws WCMException {
        if (this.isListening(objModified)) {
            this.removeCache((Template)objModified);
            Hashtable<String, Object> oldProps = objModified.getProperties();
            Hashtable<String, Object> temp = new Hashtable<String, Object>(oldProps.size());
            temp.putAll(oldProps);
            oldProps.putAll(objModified.getNewProperties());
            this.parseForCluster((Template)objModified);
            oldProps.clear();
            oldProps.putAll(temp);
            temp.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseForCluster(Template template) throws WCMException {
        try {
            Integer key = new Integer(template.getId());
            TagDocument result = (TagDocument)cache.get(this.getKey(key));
            if (result != null) {
                return;
            }
            Template template2 = template;
            synchronized (template2) {
                TagItem tagItem;
                result = (TagDocument)cache.get(this.getKey(key));
                if (result != null) {
                    return;
                }
                String sText = template.getPubText();
                try {
                    result = TagDocumentReader.read(sText);
                }
                catch (Exception ex) {
                    this.logger.error((Object)("Failed to read DOM of the template [" + template.getId() + "]"), (Throwable)ex);
                    throw new WCMException(220, "Failed to read DOM of the template [" + template.getId() + "](" + template.getName() + ")", ex);
                }
                TemplateParameterList newList = new TemplateParameterList();
                Iterator itr = result.findItems(null);
                while (itr.hasNext() && (tagItem = (TagItem)itr.next()) != null) {
                    Iterator itrVariables;
                    HashMap allVariables = tagItem.getVariableParameters();
                    if (allVariables == null || (itrVariables = allVariables.values().iterator()) == null) continue;
                    while (itrVariables.hasNext()) {
                        TemplateParameter aParameter = (TemplateParameter)itrVariables.next();
                        aParameter.setTemplateId(template.getId());
                        aParameter.setTemplateName(template.getName());
                        newList.addParameter(aParameter);
                    }
                }
                template.setTemplateParameters(newList);
                cache.set(this.getKey(key), result);
                cache.pexpire(this.getKey(key), LRU_CACHE_EXPIRES);
            }
        }
        catch (Exception ex) {
            WCMException wcmEx = null;
            wcmEx = ex instanceof WCMException ? (WCMException)ex : new WCMException(1100, "\u89e3\u91ca\u6a21\u677f\u5931\u8d25", ex);
            throw wcmEx;
        }
    }

    private String getKey() {
        return this.getClass().getName();
    }

    private String getKey(int i) {
        return this.getKey() + "." + i;
    }
}

