/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.HTMLContent;
import com.trs.cms.content.ImgRec;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagDocumentReader;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.template.CSSResourceProcessor;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.domain.template.TemplateParseMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.TempApdRel;
import com.trs.components.common.publish.persistent.template.TempAppendix;
import com.trs.components.common.publish.persistent.template.TempAppendixes;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.common.publish.widget.IWidgetInstParameterMgr;
import com.trs.components.common.publish.widget.WidgetInstance;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.BizError;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.cache.ICacheMgr;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FileHelper;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMy3WLib;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.Reports;
import com.trs.infra.util.database.CDBText;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import com.trs.infra.util.store.FileService;
import com.trs.mlf.log.LogUserUtil;
import com.trs.mlf.simplelog.LogConstant;
import com.trs.mlf.simplelog.SimpleLogServer;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.log4j.Logger;

public class TemplateMgr {
    private static final String ATTRIBUTE_IGNOREAPD = "IGNOREAPD";
    private static final String ATTRIBUTE_RELATED = "RELATED";
    private static final String ATTRIBUTE_OLDID = "OLDID";
    private static final String ATTRIBUTE_OLDSRC = "OLDSRC";
    private static final char CHAR_QUOTE = '\"';
    private static Logger s_logger = Logger.getLogger(TemplateMgr.class);
    private TemplateParseMgr m_parseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
    private Reports m_oReports;

    public Template save(Template _currTemplate, String _sTempApdPath, boolean _bDowithAppendix, int _nPicMode) throws WCMException {
        return this.save(_currTemplate, new HashMap(), _bDowithAppendix, _nPicMode, true);
    }

    public Template save(Template _currTemplate, HashMap _tempapds, boolean _bDowithAppendix, int _nPicMode, boolean _zParseIfNecessary) throws WCMException {
        if (_currTemplate == null) {
            throw new WCMException(10, I18NMessage.get(TemplateMgr.class, "TemplateMgr.label1", "\u5f53\u524d\u6a21\u677f\u4e3a\u7a7a,\u65e0\u6cd5\u8fdb\u884c\u4fdd\u5b58!"));
        }
        this.validate(_currTemplate);
        try {
            boolean bAddMode = _currTemplate.isAddMode();
            boolean bContentModifiied = !bAddMode && _currTemplate.isChangeProperty("TEMPTEXT");
            this.prepareSave(_currTemplate, _tempapds, _bDowithAppendix, _nPicMode);
            if (bContentModifiied) {
                _currTemplate.setParsed(false);
            }
            _currTemplate.save(ContextHelper.getLoginUser());
            if (_zParseIfNecessary) {
                if (bAddMode) {
                    this.m_parseMgr.notifyTemplateAdded(_currTemplate);
                } else if (bContentModifiied) {
                    this.m_parseMgr.notifyTemplateModified(_currTemplate);
                }
            }
        }
        catch (BizError bizError) {
            throw bizError;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(TemplateMgr.class, "TemplateMgr.label22", "\u4fdd\u5b58\u6a21\u677f\u5931\u8d25."), ex);
        }
        return _currTemplate;
    }

    public boolean delete(Template _templateToDelete) throws WCMException {
        if (_templateToDelete == null) {
            throw new WCMException(10, "Valid template required!");
        }
        _templateToDelete.clearAppendixes();
        TemplateEmployMgr employMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
        employMgr.clearEmploysOfTemplate(_templateToDelete);
        TemplateParseMgr parseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
        parseMgr.notifyTemplateDeleted(_templateToDelete);
        ICacheMgr cacheMgr = (ICacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
        cacheMgr.notifyOnDelObj(_templateToDelete, 3);
        return _templateToDelete.delete(ContextHelper.getLoginUser()) == 1;
    }

    public String preview(Template _currTemplate) throws WCMException {
        if (_currTemplate == null) {
            throw new WCMException(10, I18NMessage.get(TemplateMgr.class, "TemplateMgr.label2", "\u65e0\u6548\u7684\u6a21\u677f\u5bf9\u8c61,\u65e0\u6cd5\u9884\u89c8!"));
        }
        String sAppendixPath = FilesMan.getFilesMan().getTemplateAppendixPath(_currTemplate.getRootType(), _currTemplate.getRootId(), 1, true);
        return _currTemplate.getTextWithImgFilter(sAppendixPath, true);
    }

    public TempAppendixes getTempAppendixesInRoot(int _nRootType, int _nRootId, WCMFilter _filter) throws WCMException {
        try {
            String sWhere = "ROOTID=" + _nRootId + " AND ROOTTYPE=" + _nRootType;
            WCMFilter filter = new WCMFilter("", sWhere, "");
            if (_filter != null) {
                filter.mergeWith(_filter);
            }
            TempAppendixes appendixes = new TempAppendixes(ContextHelper.getLoginUser());
            appendixes.open(filter);
            return appendixes;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to query and fetch template appendixes in the folder root!", ex);
        }
    }

    public Templates getManagedTemplates(IPublishFolder _folder, int _nTemplateType, WCMFilter _filter, boolean _bIncludingThoseInChildren) throws WCMException {
        if (_folder == null) {
            throw new WCMException(10, "Valid folder required!");
        }
        try {
            IPublishElements children;
            StringBuffer buff = new StringBuffer();
            int nType = _folder.getType();
            int nId = _folder.getId();
            if (_folder.isRoot() && _bIncludingThoseInChildren) {
                buff.append("ROOTTYPE= ?");
                buff.append(" AND ROOTID= ?");
            } else {
                buff.append("FOLDERTYPE= ?");
                buff.append(" AND FOLDERID= ?");
            }
            if (_nTemplateType != -1) {
                buff.append(" AND TEMPTYPE= ?");
            }
            WCMFilter filter = new WCMFilter("", buff.toString(), "");
            filter.addSearchValues(nType);
            filter.addSearchValues(nId);
            if (_nTemplateType != -1) {
                filter.addSearchValues(_nTemplateType);
            }
            buff.setLength(0);
            if (_filter != null) {
                filter.mergeWith(_filter);
            }
            Templates templates = new Templates(ContextHelper.getLoginUser());
            templates.open(filter);
            if (_bIncludingThoseInChildren && !_folder.isRoot() && (children = _folder.getChildren()) != null) {
                for (int i = 0; i < children.size(); ++i) {
                    Templates childTemplates;
                    IPublishFolder child = (IPublishFolder)children.get(i);
                    if (child.isDeleted() || (childTemplates = this.getManagedTemplates(child, _nTemplateType, _filter, true)) == null || childTemplates.isEmpty()) continue;
                    templates.addWith(childTemplates);
                    childTemplates.clear();
                }
            }
            if (_folder.isRoot() && _bIncludingThoseInChildren) {
                for (int i = templates.size() - 1; i >= 0; --i) {
                    Template template = (Template)templates.getAt(i);
                    if (template == null) {
                        templates.removeAt(i, false);
                        continue;
                    }
                    IPublishFolder host = template.getFolder();
                    if (host != null && !host.isDeleted()) continue;
                    templates.removeAt(i, false);
                }
            }
            return templates;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to query and fetch the managed templates in folder!", ex);
        }
    }

    public Templates getOptionalTemplates(IPublishFolder _folder, int _nTemplateType, WCMFilter _filter, boolean _bIncludingThoseInParent) throws WCMException {
        if (_folder == null) {
            throw new WCMException(10, "Valid folder required!");
        }
        try {
            Templates templates = this.getManagedTemplates(_folder, _nTemplateType, _filter, false);
            if (_bIncludingThoseInParent && !_folder.isRoot()) {
                for (IPublishFolder parent = _folder.getParent(); parent != null; parent = parent.getParent()) {
                    Templates parentTemplates = this.getManagedTemplates(parent, _nTemplateType, _filter, false);
                    if (parentTemplates == null || parentTemplates.isEmpty()) continue;
                    templates.addWith(parentTemplates);
                    parentTemplates.clear();
                }
            }
            return templates;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to query and fetch the optional templates in folder!", ex);
        }
    }

    public Reports redistributeAppendixes(IPublishFolder _folder, boolean _zRecursive) throws WCMException {
        int iType = -1;
        Templates templates = this.getManagedTemplates(_folder, iType, null, _zRecursive);
        return this.redistributeAppendixes(templates);
    }

    public Reports redistributeAppendixes(Templates _templates) {
        Reports reports = new Reports("");
        if (_templates == null || _templates.size() <= 0) {
            reports.setTitle(I18NMessage.get(TemplateMgr.class, "TemplateMgr.label3", "\u4e0d\u5b58\u5728\u9700\u8981\u91cd\u65b0\u5206\u53d1\u9644\u4ef6\u7684\u6a21\u677f\u3002"));
            reports.addWarnedReport(I18NMessage.get(TemplateMgr.class, "TemplateMgr.label4", "\u4e0d\u5b58\u5728\u9700\u8981\u91cd\u65b0\u5206\u53d1\u9644\u4ef6\u7684\u6a21\u677f"), null);
            return reports;
        }
        for (int i = 0; i < _templates.size(); ++i) {
            Template template = (Template)_templates.getAt(i);
            if (template == null) continue;
            try {
                this.m_parseMgr.uploadAppendixes(template, true);
                reports.addSucessedReport(CMyString.format(I18NMessage.get(TemplateMgr.class, "TemplateMgr.label5", "\u91cd\u65b0\u5206\u53d1\u6a21\u677f[{0}]\u7684\u9644\u4ef6\u6210\u529f"), new Object[]{template}));
                continue;
            }
            catch (Exception e) {
                s_logger.error((Object)("redistribute appendixes failed for template:" + template), (Throwable)e);
                reports.addFailedReport(CMyString.format(I18NMessage.get(TemplateMgr.class, "TemplateMgr.label7", "\u91cd\u65b0\u5206\u53d1\u6a21\u677f[{0}]\u7684\u9644\u4ef6\u5931\u8d25"), new Object[]{template}), e);
            }
        }
        StringBuffer sb = new StringBuffer(256);
        sb.append(I18NMessage.get(TemplateMgr.class, "TemplateMgr.label8", "\u91cd\u65b0\u5206\u53d1\u6a21\u677f\u9644\u52a0\u6210\u529f\uff01\n"));
        sb.append(I18NMessage.get(TemplateMgr.class, "TemplateMgr.label9", "\u6210\u529f\u5206\u53d1["));
        sb.append(reports.getSucessedReporter().size());
        sb.append(I18NMessage.get(TemplateMgr.class, "TemplateMgr.label10", "]\u4e2a\u6a21\u677f\uff1b\u6709["));
        sb.append(reports.getFailedReporter().size());
        sb.append(I18NMessage.get(TemplateMgr.class, "TemplateMgr.label11", "]\u4e2a\u6a21\u677f\u5931\u8d25\u3002"));
        reports.setTitle(sb.toString());
        return reports;
    }

    public void updateNestedTemplateName(Templates templates, String sOldName, String sNewName) throws WCMException {
        if (templates == null || templates.size() <= 0) {
            return;
        }
        if (sOldName == null || (sOldName = sOldName.trim()).length() <= 0) {
            throw new IllegalArgumentException("Source template name is null.");
        }
        if (sNewName == null || (sNewName = sNewName.trim()).length() <= 0) {
            throw new IllegalArgumentException("Target template name is null.");
        }
        for (int i = 0; i < templates.size(); ++i) {
            TagItem tagItem;
            Template template = (Template)templates.getAt(i);
            if (template == null) continue;
            TagDocument tagDoc = null;
            try {
                tagDoc = this.m_parseMgr.parse(template);
            }
            catch (Exception e) {
                s_logger.info((Object)("Template[" + template + "] has parse error:"), (Throwable)e);
                continue;
            }
            boolean zChanged = false;
            Iterator itr = tagDoc.findItems("TRS_TEMPLATE");
            while (itr.hasNext() && (tagItem = (TagItem)itr.next()) != null) {
                if (!sOldName.equals(tagItem.getAttribute("TEMPNAME"))) continue;
                tagItem.setAttribute("TEMPNAME", sNewName);
                zChanged = true;
            }
            if (!zChanged) continue;
            template.setText(tagDoc.toString());
            template.save();
        }
    }

    private void validate(Template _currTemplate) throws WCMException {
        if (_currTemplate == null) {
            throw new WCMException(10, I18NMessage.get(TemplateMgr.class, "TemplateMgr.label12", "\u6a21\u677f\u4e3a\u7a7a\uff01"));
        }
        if (_currTemplate.getName() == null || _currTemplate.getName().trim().length() == 0) {
            throw new WCMException(10, I18NMessage.get(TemplateMgr.class, "TemplateMgr.label13", "\u6a21\u677f\u540d\u79f0\u4e3a\u7a7a\uff01"));
        }
        if (CMyString.isEmpty(_currTemplate.getTempText())) {
            throw new BizError("\u6a21\u677f\u5185\u5bb9\u4e0d\u5e94\u4e3a\u7a7a\uff01");
        }
        if (_currTemplate.getRootId() == 0) {
            throw new WCMException(1106, I18NMessage.get(TemplateMgr.class, "TemplateMgr.label14", "\u6a21\u677f\u6240\u5c5e\u7ad9\u70b9\u6ca1\u6709\u8bbe\u7f6e\uff01"));
        }
    }

    private Template prepareSave(Template _currTemplate, HashMap _tempapds, boolean _bDowithAppendix, int _nPicMode) throws Exception {
        if (_currTemplate == null) {
            throw new WCMException(20, I18NMessage.get(TemplateMgr.class, "TemplateMgr.label15", "\u6a21\u677f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01"));
        }
        if (_currTemplate.getName() == null) {
            throw new WCMException(10, I18NMessage.get(TemplateMgr.class, "TemplateMgr.label16", "\u6a21\u677f\u540d\u79f0\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01"));
        }
        _currTemplate = this.processContent(_currTemplate, _tempapds, _bDowithAppendix, _nPicMode);
        this.setDefaultTypeIfNecessary(_currTemplate);
        return _currTemplate;
    }

    private void setDefaultTypeIfNecessary(Template _currTemplate) throws WCMException {
        if (_currTemplate.isAddMode() && _currTemplate.getProperty("TEMPTYPE") == null) {
            _currTemplate.setType(Template.guessTypeByName(_currTemplate.getName()));
        }
    }

    public Template processContent(Template _template, HashMap _tempapds, boolean _bDoWithAppendix, int _nPicMode) throws Exception {
        if (!_bDoWithAppendix) {
            return _template;
        }
        if (!_template.isAddMode() && _template.getNewProperty("TEMPTEXT") == null) {
            return _template;
        }
        Template template = _template;
        String sNewContent = this.getNewContent(template, _tempapds, _nPicMode);
        template.setProperty("TEMPTEXT", new CDBText(DBManager.getDBManager().getDBTypeAsInt(), sNewContent));
        return template;
    }

    private String getNewContent(Template _template, HashMap _tempapds, int _nPicMode) throws Exception {
        if (_template.isAddMode()) {
            _template.setNextId();
        }
        if ("XML".equalsIgnoreCase(_template.getFinalPropertyAsString("TEMPEXT", "html"))) {
            return this.getContent(_template);
        }
        String[] sWithSrcTags = PublishServerConfigMapper.getTemplateTagsHavingSrc();
        String[] sSrcAttributeNames = PublishServerConfigMapper.getTemplateTagSrcAttributeNames();
        String sContent = this.getContent(_template);
        if (sWithSrcTags == null || sSrcAttributeNames == null) {
            return sContent;
        }
        String sAppendixLocalPath = FilesMan.getFilesMan().getTemplateAppendixPath(_template.getRootType(), _template.getRootId(), 0, true);
        sAppendixLocalPath = CMyString.setStrEndWith(sAppendixLocalPath, File.separatorChar);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("sAppendixLocalPath:" + sAppendixLocalPath));
        }
        HashMap hImgRecs = new HashMap(5, 1.0f);
        boolean[] bAddNewAppendixRelation = new boolean[1];
        HtmlElementFinder finder = null;
        int nTagCount = sWithSrcTags.length > sSrcAttributeNames.length ? sSrcAttributeNames.length : sWithSrcTags.length;
        for (int i = 0; i < nTagCount; ++i) {
            finder = new HtmlElementFinder(sContent);
            HtmlElement element = null;
            String sTagName = sWithSrcTags[i];
            String sSrcAttributeName = sSrcAttributeNames[i];
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("sTagName:" + sTagName));
            }
            while ((element = finder.findNextElement(sTagName, true)) != null) {
                String sSrcAttributeValue = element.getAttributeValue(sSrcAttributeName);
                if (!CMyString.isEmpty(sSrcAttributeValue) && element.getAttribute(ATTRIBUTE_IGNOREAPD) == null) {
                    ImgRec imgRec;
                    int nPos = sSrcAttributeValue.lastIndexOf(92);
                    if (nPos < 0) {
                        nPos = sSrcAttributeValue.lastIndexOf(47);
                    }
                    String sResFileName = sSrcAttributeValue.substring(nPos + 1);
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("sSrcAttributeValue:" + sSrcAttributeValue + ";sResFileName:" + sResFileName));
                    }
                    if ((imgRec = (ImgRec)hImgRecs.get(sSrcAttributeValue)) != null) {
                        this.setElementAttribute(element, sSrcAttributeName, imgRec);
                    } else if (this.isExistsTemplateApdRelation(_template.getId(), element, sSrcAttributeName)) {
                        String sUpdateFile;
                        this.putNewHTMLRecord(hImgRecs, sSrcAttributeValue, Integer.parseInt(element.getAttributeValue(ATTRIBUTE_OLDID)), element.getAttributeValue(ATTRIBUTE_OLDSRC));
                        if (_nPicMode == 1 && !CMyString.isEmpty(sUpdateFile = (String)_tempapds.get(sResFileName.toLowerCase()))) {
                            CMyFile.copyFile(sUpdateFile, sAppendixLocalPath + sResFileName);
                            bAddNewAppendixRelation[0] = true;
                            String typeAttr = element.getAttributeValue("type");
                            if ("link".equals(sTagName.toLowerCase()) && "text/css".equalsIgnoreCase(typeAttr)) {
                                this.processCSSFile(sResFileName, _template, _tempapds, _nPicMode, hImgRecs, bAddNewAppendixRelation);
                            }
                        }
                    } else {
                        this.removeExtraAttributes(element);
                        String sSrcFile = null;
                        if (_tempapds != null && _tempapds.size() > 0) {
                            sSrcFile = (String)_tempapds.get(CMyFile.extractFileName(sSrcAttributeValue, null).toLowerCase());
                        }
                        if (s_logger.isDebugEnabled()) {
                            s_logger.debug((Object)("sSrcFile:" + sSrcFile + "\n_tempapds:" + _tempapds));
                        }
                        if (!CMyString.isEmpty(sSrcFile) || !FilesMan.isValidFile(sResFileName, "W0") || CMyFile.fileExists(sSrcFile = FilesMan.getFilesMan().mapFilePath(sResFileName, 0) + sResFileName)) {
                            TempAppendix appendix = null;
                            appendix = CMyString.isEmpty(sSrcFile) ? this.processAppendix(_template, sSrcAttributeValue, null, sAppendixLocalPath, _nPicMode, bAddNewAppendixRelation) : this.processAppendix(_template, sSrcAttributeValue, CMyFile.extractFilePath(sSrcFile), sAppendixLocalPath, _nPicMode, bAddNewAppendixRelation);
                            if (appendix == null) {
                                element.setAttribute(sSrcAttributeName, sSrcAttributeValue);
                            } else {
                                String typeAttr = element.getAttributeValue("type");
                                if ("link".equals(sTagName.toLowerCase()) && "text/css".equalsIgnoreCase(typeAttr)) {
                                    this.processCSSFile(sResFileName, _template, _tempapds, _nPicMode, hImgRecs, bAddNewAppendixRelation);
                                }
                                String sAppendixFile = appendix.getFile();
                                element.setAttribute(ATTRIBUTE_OLDSRC, sAppendixFile, '\"');
                                element.setAttribute(ATTRIBUTE_OLDID, String.valueOf(appendix.getId()), '\"');
                                element.setAttribute(sSrcAttributeName, sAppendixFile, '\"');
                                element.setAttribute(ATTRIBUTE_RELATED, "1", '\"');
                                this.putNewHTMLRecord(hImgRecs, sSrcAttributeValue, appendix.getId(), sAppendixFile);
                            }
                        }
                    }
                }
                finder.putElement(element);
            }
            sContent = finder.getContent();
        }
        boolean bMatch = false;
        Matcher oMatcher = Template.m_oBackgroundImagePattern.matcher(sContent);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)_tempapds);
        }
        while (oMatcher.find()) {
            String sSrcFile;
            String sSrcAttributeValue = oMatcher.group(2);
            int nPos = sSrcAttributeValue.lastIndexOf(92);
            if (nPos < 0) {
                nPos = sSrcAttributeValue.lastIndexOf(47);
            }
            String sResFileName = sSrcAttributeValue.substring(nPos + 1);
            ImgRec imgRec = (ImgRec)hImgRecs.get(sSrcAttributeValue);
            if (imgRec != null) continue;
            int nAppendixId = this.queryTemplateApdRelationId(_template.getId(), sResFileName);
            if (nAppendixId > 0) {
                String sUpdateFile;
                this.putNewHTMLRecord(hImgRecs, CMyFile.extractFileName(sSrcAttributeValue, null).toLowerCase(), nAppendixId, sSrcAttributeValue);
                if (_nPicMode != 1 || CMyString.isEmpty(sUpdateFile = (String)_tempapds.get(sResFileName.toLowerCase()))) continue;
                CMyFile.copyFile(sUpdateFile, sAppendixLocalPath + sResFileName);
                bAddNewAppendixRelation[0] = true;
            }
            if (CMyString.isEmpty(sSrcFile = (String)_tempapds.get(sResFileName.toLowerCase())) && FilesMan.isValidFile(sResFileName, "W0")) {
                sSrcFile = FilesMan.getFilesMan().mapFilePath(sResFileName, 0) + sResFileName;
            }
            if (CMyString.isEmpty(sSrcFile) || !CMyFile.fileExists(sSrcFile)) continue;
            TempAppendix appendix = null;
            appendix = this.processAppendix(_template, sSrcAttributeValue, CMyFile.extractFilePath(sSrcFile), sAppendixLocalPath, _nPicMode, bAddNewAppendixRelation);
            if (appendix == null) continue;
            String sAppendixFile = appendix.getFile();
            this.putNewHTMLRecord(hImgRecs, sSrcAttributeValue, appendix.getId(), sAppendixFile);
            bMatch = true;
        }
        if (s_logger.isDebugEnabled() && !bMatch) {
            s_logger.debug((Object)Template.m_oBackgroundImagePattern);
            s_logger.debug((Object)sContent);
        }
        this.delTempApdRel(_template, hImgRecs);
        if (bAddNewAppendixRelation[0]) {
            _template.setApdModified(true);
        }
        if (finder == null) {
            return sContent;
        }
        return finder.getContent();
    }

    private void processCSSFile(String _sCSSFileName, Template _template, HashMap _tempapds, int _nPicMode, HashMap _hImgRecs, boolean[] _bAddNewAppendixRelation) throws WCMException, CMyException {
        String sAppendixLocalPath = FilesMan.getFilesMan().getTemplateAppendixPath(_template.getRootType(), _template.getRootId(), 0, true);
        CSSResourceProcessor cssProcessor = new CSSResourceProcessor();
        String sCSSFile = sAppendixLocalPath + _sCSSFileName;
        if (!CMyFile.fileExists(sCSSFile)) {
            return;
        }
        String sEncoding = CharsetDetector.detect(sCSSFile);
        String sFileContent = null;
        try {
            sFileContent = CMyFile.readFile(sCSSFile, sEncoding);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(TemplateMgr.class, "TemplateMgr.label17", "\u8bfb\u53d6\u6837\u5f0f\u6587\u4ef6\u5931\u8d25\uff01[File=") + _sCSSFileName + "]", e);
        }
        boolean bStartImagesSite = "TRUE".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("START_IMAGE_SITE", "false"));
        String sNewCSSContent = null;
        if (bStartImagesSite) {
            IPublishFolder rootFolder = _template.getRoot();
            if (rootFolder == null) {
                throw new WCMException(I18NMessage.get(Template.class, "Template.label18", "\u6a21\u677f[") + _template + I18NMessage.get(Template.class, "Template.label19", "]\u7684Root[ID=") + _template.getRootId() + I18NMessage.get(Template.class, "Template.label20", "]\u4e0d\u5b58\u5728\uff01"));
            }
            String[] pImgSrcPre = Template.convertURL2ImageURL(rootFolder.getDataPath());
            sNewCSSContent = cssProcessor.processConent(sFileContent, _tempapds, sAppendixLocalPath, pImgSrcPre);
        } else {
            sNewCSSContent = cssProcessor.processConent(sFileContent, _tempapds, sAppendixLocalPath);
        }
        if (sNewCSSContent == null) {
            return;
        }
        String[] pRelateFiles = cssProcessor.getRelateFiles();
        for (int nRelateFileIndex = 0; nRelateFileIndex < pRelateFiles.length; ++nRelateFileIndex) {
            TempAppendix appendix;
            String sFileName = pRelateFiles[nRelateFileIndex];
            String sFilePath = sAppendixLocalPath;
            if (!_tempapds.isEmpty() && _tempapds.containsKey(sFileName.toLowerCase())) {
                sFilePath = CMyFile.extractFilePath((String)_tempapds.get(sFileName.toLowerCase()));
            }
            if ((appendix = this.processAppendix(_template, sFileName, sFilePath, sAppendixLocalPath, _nPicMode, _bAddNewAppendixRelation)) == null) continue;
            this.putNewHTMLRecord(_hImgRecs, sFileName, appendix.getId(), sFileName);
        }
        CMyFile.writeFile(sAppendixLocalPath + _sCSSFileName, sNewCSSContent, sEncoding);
    }

    private void removeExtraAttributes(HtmlElement element) {
        element.removeAttribute(ATTRIBUTE_RELATED);
        element.removeAttribute(ATTRIBUTE_OLDSRC);
        element.removeAttribute(ATTRIBUTE_OLDID);
    }

    private void putNewHTMLRecord(HashMap _hHTMLRecs, String _sHTMLRecordKey, int _nTemplateAppendixId, String _sApdFileName) {
        ImgRec newImgRec = new ImgRec();
        newImgRec.oldId = _nTemplateAppendixId;
        newImgRec.pubSrc = newImgRec.oldSrc = _sApdFileName;
        _hHTMLRecs.put(_sHTMLRecordKey, newImgRec);
    }

    private boolean isExistsTemplateApdRelation(int _nTemplateId, HtmlElement _element, String _sSrcAttributeName) throws WCMException {
        int nApdId;
        String sOldSrc = _element.getAttributeValue(ATTRIBUTE_OLDSRC);
        if (sOldSrc == null || (sOldSrc = sOldSrc.trim()).length() <= 0) {
            return false;
        }
        try {
            nApdId = Integer.parseInt(_element.getAttributeValue(ATTRIBUTE_OLDID));
        }
        catch (NumberFormatException e) {
            return false;
        }
        String sApdFile = TemplateMgr.extractFileName(_element.getAttributeValue(_sSrcAttributeName), null);
        if (!sOldSrc.equalsIgnoreCase(sApdFile)) {
            return false;
        }
        TempAppendix tempAppendix = TempAppendix.findById(nApdId);
        if (tempAppendix == null || !tempAppendix.getFile().equals(sApdFile)) {
            return false;
        }
        DBManager dbMgr = DBManager.getDBManager();
        String strSQL = "select TempId from WCMTempApdRel where TempId=? and AppendixId=?";
        return dbMgr.sqlExecuteIntQuery(strSQL, new int[]{_nTemplateId, nApdId}) > 0;
    }

    private int queryTemplateApdRelationId(int _nTemplateId, String _sSrcAttributeName) throws WCMException {
        DBManager dbMgr = DBManager.getDBManager();
        String strSQL = "select AppendixId from WCMTempApdRel where TempId=? and exists(select 1 from wcmtempappendix where ApdFile=? and WCMTempApdRel.AppendixId=wcmtempappendix.TempAppendixId)";
        ArrayList<Object> lParameters = new ArrayList<Object>();
        lParameters.add(new Integer(_nTemplateId));
        lParameters.add(_sSrcAttributeName);
        return dbMgr.sqlExecuteIntQuery(strSQL, lParameters);
    }

    private TempAppendix processAppendix(Template _template, String _sAppendixFile, String _sSrcFilePath, String _sDestPath, int _nPicMode, boolean[] _bAddNewAppendixRelateion) throws WCMException {
        FileService file;
        if (!this.isValidRes(_sAppendixFile)) {
            return null;
        }
        String sFileName = this.getFullFileNameFrom(_sAppendixFile, _sSrcFilePath);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("_sAppendixFile:" + _sAppendixFile));
            s_logger.debug((Object)("_sSrcFilePath:" + _sSrcFilePath));
            s_logger.debug((Object)("==>sFileName:" + sFileName));
            s_logger.debug((Object)("_sDestPath:" + _sDestPath));
        }
        if ((sFileName = this.copyAppendixFile(sFileName, _sDestPath, _nPicMode)) == null) {
            sFileName = TemplateMgr.extractFileName(_sAppendixFile, null);
        }
        if (!(file = new FileService(_sDestPath + sFileName)).exists() || file.isDirectory()) {
            return null;
        }
        TempAppendix appendix = this.getTemplateAppendix(_template.getRootType(), _template.getRootId(), sFileName);
        boolean bNeedToAddRelation = false;
        if (appendix == null) {
            appendix = _template.addAppendix(ContextHelper.getLoginUser(), sFileName, false);
            bNeedToAddRelation = true;
        } else {
            boolean bl = bNeedToAddRelation = !this.hasTempApdRel(_template, appendix);
        }
        if (bNeedToAddRelation) {
            this.addTempApdRel(_template, appendix);
            if (!_bAddNewAppendixRelateion[0]) {
                _bAddNewAppendixRelateion[0] = true;
            }
        }
        return appendix;
    }

    private boolean isValidRes(String _sFileName) throws WCMException {
        if (CMyString.isEmpty(_sFileName)) {
            return false;
        }
        if (_sFileName.indexOf(46) < 0) {
            return false;
        }
        return !FileHelper.isForbidFileExt(_sFileName);
    }

    private String copyAppendixFile(String _sFileName, String _sDestPath, int _nPicMode) throws WCMException {
        if (CMyString.isEmpty(_sFileName)) {
            return null;
        }
        if (this.isFromHttp(_sFileName)) {
            return this.copyAppendixFileViaHttp(_sFileName, _sDestPath, _nPicMode);
        }
        return this.copyAppendixFileFromLocal(_sFileName, _sDestPath, _nPicMode);
    }

    private String copyAppendixFileFromLocal(String _sFullFileName, String _sDestPath, int _nPicMode) throws WCMException {
        if (!CMyFile.fileExists(_sFullFileName)) {
            s_logger.warn((Object)(_sFullFileName + " not exists!"));
            SimpleLogServer.warn(LogConstant.Module.OTHERMODULE.desc, LogUserUtil.getLogUser(), "\u6587\u4ef6\u590d\u5236", "\u6587\u4ef6\u4e0d\u5b58\u5728", String.format("\u6587\u4ef6[%s]\u4e0d\u5b58\u5728", _sFullFileName));
            return null;
        }
        String sFileName = CMyFile.extractFileName(_sFullFileName);
        if ((sFileName = this.processFileNameIfNecessary(sFileName, _sDestPath, _nPicMode)) != null) {
            try {
                CMyFile.copyFile(_sFullFileName, _sDestPath + sFileName);
            }
            catch (CMyException e) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.error((Object)("failed to copy a local file[" + _sFullFileName + "]!"), (Throwable)e);
                    SimpleLogServer.error(LogConstant.Module.OTHERMODULE.desc, LogUserUtil.getLogUser(), "\u6587\u4ef6\u590d\u5236", "\u6587\u4ef6\u590d\u5236\u5931\u8d25", String.format("\u590d\u5236\u6587\u4ef6[%s]\u5931\u8d25", _sFullFileName), e);
                }
                s_logger.warn((Object)("failed to copy a local file[" + _sFullFileName + "]!"));
                SimpleLogServer.warn(LogConstant.Module.OTHERMODULE.desc, LogUserUtil.getLogUser(), "\u6587\u4ef6\u590d\u5236", "\u6587\u4ef6\u590d\u5236\u5931\u8d25", String.format("\u590d\u5236\u6587\u4ef6[%s]\u5931\u8d25", _sFullFileName));
            }
        }
        return sFileName;
    }

    private String copyAppendixFileViaHttp(String _sFullFileName, String _sDestPath, int _nPicMode) throws WCMException {
        String sFileName = CMyFile.extractHttpFileName(_sFullFileName);
        if ((sFileName = this.processFileNameIfNecessary(sFileName, _sDestPath, _nPicMode)) != null) {
            try {
                CMy3WLib.getFile(_sFullFileName, _sDestPath + sFileName);
            }
            catch (CMyException e) {
                s_logger.error((Object)("failed to get the file via http[" + _sFullFileName + "]"), (Throwable)e);
            }
        }
        return sFileName;
    }

    private String processFileNameIfNecessary(String _sFileName, String _sDestPath, int _nPicMode) throws WCMException {
        if (CMyFile.fileExists(_sDestPath + _sFileName)) {
            switch (_nPicMode) {
                case 1: {
                    return _sFileName;
                }
                case 3: {
                    return this.getNewFileName(_sFileName, _sDestPath);
                }
                case 2: {
                    return null;
                }
                case 4: {
                    throw new WCMException(10, I18NMessage.get(TemplateMgr.class, "TemplateMgr.label18", "\u5b58\u5728\u540c\u540d\u7684\u6587\u4ef6[") + _sFileName + "]");
                }
            }
            throw new WCMException(10, I18NMessage.get(TemplateMgr.class, "TemplateMgr.label19", "\u65e0\u6548\u7684\u9644\u4ef6\u5904\u7406\u7c7b\u578b!"));
        }
        return _sFileName;
    }

    private String getNewFileName(String _sFileName, String _sDestPath) {
        int nDotPos = _sFileName.indexOf(".");
        String sTemp = _sFileName.substring(0, nDotPos);
        String sExt = _sFileName.substring(nDotPos, _sFileName.length());
        int k = 1;
        while (CMyFile.fileExists(_sDestPath + _sFileName)) {
            _sFileName = sTemp + "_" + k + sExt;
            ++k;
        }
        return _sFileName;
    }

    private String getFullFileNameFrom(String _sSrcAttributeValue, String _sSrcFilePath) {
        if (this.isFromHttp(_sSrcAttributeValue)) {
            return _sSrcAttributeValue;
        }
        if (this.isAbsoluteFile(_sSrcAttributeValue) || CMyString.isEmpty(_sSrcFilePath)) {
            return _sSrcAttributeValue;
        }
        if (this.isAbsoluteFile(_sSrcFilePath)) {
            return _sSrcFilePath;
        }
        if (File.separator != "/") {
            _sSrcAttributeValue = CMyString.replaceStr(_sSrcAttributeValue, "/", File.separator);
        }
        return _sSrcFilePath + CMyFile.extractFileName(_sSrcAttributeValue);
    }

    private boolean isAbsoluteFile(String _sFileName) {
        if (CMyString.isEmpty(_sFileName)) {
            return false;
        }
        FileService file = new FileService(_sFileName);
        return file.exists() && file.isFile();
    }

    private void setElementAttribute(HtmlElement _element, String _sSrcAttributeName, ImgRec _imgRec) {
        _element.setAttribute(ATTRIBUTE_OLDSRC, _imgRec.oldSrc, '\"');
        if (_imgRec.oldId > 0) {
            _element.setAttribute(ATTRIBUTE_OLDID, String.valueOf(_imgRec.oldId), '\"');
        }
        _element.setAttribute(_sSrcAttributeName, _imgRec.pubSrc, '\"');
        _element.setAttribute(ATTRIBUTE_RELATED, "1", '\"');
    }

    private String getContent(Template _template) {
        String sContent = "";
        sContent = _template.isAddMode() ? _template.getText() : _template.getNewPropertyAsString("TEMPTEXT");
        return sContent;
    }

    private void delTempApdRel(Template _template, HashMap _hImgRecs) {
        String sUsedPicIds = this.getUsedPicIds(_hImgRecs);
        this.delTempApdRel(_template, sUsedPicIds);
    }

    private String getUsedPicIds(HashMap _hImgRecs) {
        String sUsedPicIds = "";
        if (_hImgRecs != null) {
            for (ImgRec imgRec : _hImgRecs.values()) {
                sUsedPicIds = sUsedPicIds + String.valueOf(imgRec.oldId) + ",";
            }
            _hImgRecs.clear();
        }
        return sUsedPicIds.length() > 1 ? sUsedPicIds.substring(0, sUsedPicIds.length() - 1) : null;
    }

    private boolean isFromHttp(String _sSrc) {
        return _sSrc.toLowerCase().indexOf("http:") >= 0;
    }

    private TempAppendix getTemplateAppendix(int _nRootType, int _nRootId, String _sFileName) throws WCMException {
        if (_sFileName == null || (_sFileName = _sFileName.trim()).length() == 0) {
            return null;
        }
        String sWhere = "ROOTID=" + _nRootId + " AND ROOTTYPE=" + _nRootType + " AND APDFILE='" + CMyString.filterForSQL(_sFileName) + "'";
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        TempAppendixes appendixes = TempAppendixes.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
        if (appendixes == null || appendixes.isEmpty()) {
            return null;
        }
        return (TempAppendix)appendixes.getAt(0);
    }

    private boolean hasTempApdRel(Template _currTemplate, TempAppendix _currTempAppendix) throws WCMException {
        if (_currTemplate == null || _currTempAppendix == null) {
            throw new WCMException(10, I18NMessage.get(TemplateMgr.class, "TemplateMgr.label20", "\u6a21\u677f\u6216\u9644\u4ef6\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5224\u65ad\uff01"));
        }
        try {
            String strSQL = "select count(*) from WCMTempApdRel  where tempid=" + _currTemplate.getId() + " and appendixid=" + _currTempAppendix.getId();
            return DBManager.getDBManager().sqlExecuteIntQuery(strSQL) >= 1;
        }
        catch (Exception ex) {
            s_logger.error((Object)(I18NMessage.get(TemplateMgr.class, "TemplateMgr.label21", "\u67e5\u8be2\u6a21\u677f\u548c\u6a21\u677f\u9644\u4ef6\u662f\u5426\u5b58\u5728\u5173\u8054\u5173\u7cfb\u65f6\u53d1\u751f\u9519\u8bef\uff01") + ex.toString()));
            return false;
        }
    }

    private boolean addTempApdRel(Template _currTemplate, TempAppendix _currTempAppendix) throws WCMException {
        TempApdRel rel = new TempApdRel();
        rel.setTemplateId(_currTemplate.getId());
        rel.setTempAppendixId(_currTempAppendix.getId());
        rel.insert();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int delTempApdRel(Template _currTemplate, String _sUsedIds) {
        DBManager dbman = DBManager.getDBManager();
        Connection conn = null;
        Statement pstmt = null;
        int[] usedIds = CMyString.splitToInt(_sUsedIds, ",");
        try {
            conn = dbman.getConnection();
            String sql = "select APPENDIXID,RECID from WCMTEMPAPDREL where TEMPID=?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, _currTemplate.getId());
            ResultSet rs = pstmt.executeQuery();
            HashMap<Integer, Integer> retMap = new HashMap<Integer, Integer>();
            while (rs.next()) {
                if (this.isUsedApd(usedIds, rs.getInt(1))) continue;
                retMap.put(new Integer(rs.getInt(1)), new Integer(rs.getInt(2)));
            }
            rs.close();
            pstmt.close();
            if (retMap.isEmpty()) {
                int n = 0;
                return n;
            }
            int ret = retMap.size();
            sql = "delete from WCMTEMPAPDREL where RECID=?";
            pstmt = conn.prepareStatement(sql);
            Iterator<Object> itr = retMap.values().iterator();
            while (itr.hasNext()) {
                pstmt.setInt(1, (Integer)itr.next());
                pstmt.executeUpdate();
            }
            pstmt.close();
            sql = "select count(RECID) from WCMTEMPAPDREL where APPENDIXID=?";
            pstmt = conn.prepareStatement(sql);
            itr = retMap.keySet().iterator();
            while (itr.hasNext()) {
                pstmt.setInt(1, (Integer)itr.next());
                rs = pstmt.executeQuery();
                if (rs.next() && rs.getInt(1) > 0) {
                    itr.remove();
                }
                rs.close();
            }
            pstmt.close();
            if (retMap.isEmpty()) {
                int n = ret;
                return n;
            }
            sql = "delete from WCMTEMPAPPENDIX where TEMPAPPENDIXID=?";
            pstmt = conn.prepareStatement(sql);
            itr = retMap.keySet().iterator();
            while (itr.hasNext()) {
                pstmt.setInt(1, (Integer)itr.next());
                pstmt.executeUpdate();
            }
            int n = ret;
            return n;
        }
        catch (Exception ex) {
            int n = 0;
            return n;
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    dbman.freeConnection(conn);
                }
                catch (Exception exception) {}
            }
        }
    }

    private boolean isUsedApd(int[] usedIds, int id) {
        if (usedIds.length == 0) {
            return false;
        }
        for (int i = usedIds.length - 1; i >= 0; --i) {
            if (id != usedIds[i]) continue;
            return true;
        }
        return false;
    }

    private static String extractFileName(String _sFilePathName, String _sFileSeparator) {
        int nPos = -1;
        if (_sFileSeparator == null) {
            nPos = _sFilePathName.lastIndexOf(File.separatorChar);
            if (nPos < 0) {
                nPos = _sFilePathName.lastIndexOf(File.separatorChar == '/' ? 92 : 47);
            }
        } else {
            nPos = _sFilePathName.lastIndexOf(_sFileSeparator);
        }
        if (nPos < 0) {
            return _sFilePathName;
        }
        return _sFilePathName.substring(nPos + 1);
    }

    public String processTemplateAppendixes(Template _template, String sTempText, int _nPicMode) throws Exception {
        if (CMyString.isEmpty(sTempText)) {
            return sTempText;
        }
        String[] tags = PublishServerConfigMapper.getTemplateTagsHavingSrc();
        String[] attributeNames = PublishServerConfigMapper.getTemplateTagSrcAttributeNames();
        if (tags == null || attributeNames == null) {
            return sTempText;
        }
        String sAppendixLocalPath = FilesMan.getFilesMan().getTemplateAppendixPath(_template.getRootType(), _template.getRootId(), 0, true);
        sAppendixLocalPath = CMyString.setStrEndWith(sAppendixLocalPath, File.separatorChar);
        PublishPathCompass compass = new PublishPathCompass();
        IPublishFolder root = _template.getRoot();
        String sPreviewLocalPath = CMyString.setStrEndWith(compass.getPreviewLocalPath(root), File.separatorChar);
        String sPubLocalPath = CMyString.setStrEndWith(compass.getPublishLocalPath(root), File.separatorChar);
        String[] dirs = new String[]{sPreviewLocalPath + "images" + File.separatorChar, sPubLocalPath + "images" + File.separatorChar};
        HashMap hImgRecs = new HashMap(5, 1.0f);
        HashMap tempapds = new HashMap();
        boolean[] bAddNewAppendixRelation = new boolean[1];
        HtmlElementFinder finder = null;
        int nTagCount = tags.length > attributeNames.length ? attributeNames.length : tags.length;
        boolean bNeedToAddImgSrc = this.addImgSrcIfNeed(tags, attributeNames);
        if (bNeedToAddImgSrc) {
            tags = this.appendToArray(tags, "IMG");
            attributeNames = this.appendToArray(attributeNames, "SRC");
            ++nTagCount;
        }
        for (int i = 0; i < nTagCount; ++i) {
            finder = new HtmlElementFinder(sTempText);
            HtmlElement element = null;
            String sTagName = tags[i];
            String attributeName = attributeNames[i];
            while ((element = finder.findNextElement(sTagName, true)) != null) {
                block22: {
                    int nPos;
                    String attributeValue;
                    block23: {
                        String uploadPic;
                        attributeValue = element.getAttributeValue(attributeName);
                        if (CMyString.isEmpty(attributeValue) || element.getAttribute(ATTRIBUTE_IGNOREAPD) != null) break block22;
                        if (!"IMG".equalsIgnoreCase(sTagName) || !"SRC".equalsIgnoreCase(attributeName) || !CMyString.isEmpty(uploadPic = element.getAttributeValue("uploadpic")) || !CMyString.isEmpty(element.getAttributeValue("oldsrc"))) break block23;
                        if (attributeValue.indexOf("/") >= 0) {
                            element.setAttribute("NeedDownload", "true");
                        }
                        if (!HTMLContent.isNeedDownload(element, attributeValue)) break block22;
                        FilesMan filesMan = FilesMan.getFilesMan();
                        String sExt = CMyFile.extractFileExt(attributeValue);
                        String sFilePathName = filesMan.getNextFilePathName("U0", sExt);
                        CMy3WLib.getFile(attributeValue, sFilePathName);
                        element.setAttribute("uploadpic", CMyFile.extractFileName(sFilePathName));
                    }
                    if ((nPos = attributeValue.lastIndexOf(92)) < 0) {
                        nPos = attributeValue.lastIndexOf(47);
                    }
                    String sResFileName = attributeValue.substring(nPos + 1);
                    ImgRec imgRec = (ImgRec)hImgRecs.get(attributeValue);
                    if (imgRec != null) {
                        this.setElementAttribute(element, attributeName, imgRec);
                    } else if (this.isExistsTemplateApdRelation(_template.getId(), element, attributeName)) {
                        this.putNewHTMLRecord(hImgRecs, attributeValue, Integer.parseInt(element.getAttributeValue(ATTRIBUTE_OLDID)), element.getAttributeValue(ATTRIBUTE_OLDSRC));
                        if (_nPicMode == 1) {
                            String sUpdateFile = (String)tempapds.get(sResFileName.toLowerCase());
                            CMyFile.copyFile(sUpdateFile, sAppendixLocalPath + sResFileName);
                            bAddNewAppendixRelation[0] = true;
                            String typeAttr = element.getAttributeValue("type");
                            if ("link".equals(sTagName.toLowerCase()) && "text/css".equalsIgnoreCase(typeAttr)) {
                                this.processCSSFile(sResFileName, _template, tempapds, _nPicMode, hImgRecs, bAddNewAppendixRelation);
                            }
                        }
                    } else {
                        this.removeExtraAttributes(element);
                        String uploadPic = element.getAttributeValue("uploadpic");
                        if (!CMyString.isEmpty(uploadPic)) {
                            String uploadPicLocalPath = FilesMan.getFilesMan().mapFilePath(uploadPic, 0);
                            String uploadPicLocalFile = CMyString.setStrEndWith(uploadPicLocalPath, File.separatorChar) + uploadPic;
                            CMyFile.copyFile(uploadPicLocalFile, sAppendixLocalPath + uploadPic);
                            attributeValue = uploadPic;
                        }
                        String sSrcFile = (String)tempapds.get(CMyFile.extractFileName(attributeValue, null).toLowerCase());
                        TempAppendix appendix = null;
                        appendix = CMyString.isEmpty(sSrcFile) ? this.processAppendix(_template, attributeValue, null, sAppendixLocalPath, _nPicMode, bAddNewAppendixRelation) : this.processAppendix(_template, attributeValue, CMyFile.extractFilePath(sSrcFile), sAppendixLocalPath, _nPicMode, bAddNewAppendixRelation);
                        this.copyAppendixToDirs(sAppendixLocalPath, attributeValue, dirs);
                        if (appendix == null) {
                            element.setAttribute(attributeName, attributeValue);
                        } else {
                            String typeAttr = element.getAttributeValue("type");
                            if ("link".equals(sTagName.toLowerCase()) && "text/css".equalsIgnoreCase(typeAttr)) {
                                this.processCSSFile(sResFileName, _template, tempapds, _nPicMode, hImgRecs, bAddNewAppendixRelation);
                            }
                            String sAppendixFile = appendix.getFile();
                            element.setAttribute(ATTRIBUTE_OLDSRC, sAppendixFile, '\"');
                            element.setAttribute(ATTRIBUTE_OLDID, String.valueOf(appendix.getId()), '\"');
                            element.setAttribute(attributeName, sAppendixFile, '\"');
                            element.setAttribute(ATTRIBUTE_RELATED, "1", '\"');
                            this.putNewHTMLRecord(hImgRecs, attributeValue, appendix.getId(), sAppendixFile);
                        }
                    }
                }
                finder.putElement(element);
            }
            sTempText = finder.getContent();
        }
        if (bAddNewAppendixRelation[0]) {
            _template.setApdModified(true);
        }
        if (finder == null) {
            return sTempText;
        }
        return finder.getContent();
    }

    private boolean addImgSrcIfNeed(String[] tags, String[] attributeNames) {
        int nTagCount = tags.length > attributeNames.length ? attributeNames.length : tags.length;
        for (int i = 0; i < nTagCount; ++i) {
            String sTagName = tags[i];
            String sAttributeName = attributeNames[i];
            if (!"img".equalsIgnoreCase(sTagName) || !"src".equalsIgnoreCase(sAttributeName)) continue;
            return false;
        }
        return true;
    }

    private void copyAppendixToDirs(String sSrcFilePath, String sAttributeValue, String[] aDestPath) throws CMyException {
        String sSrcFileName = CMyString.replaceStr(sAttributeValue, "/", File.separator);
        sSrcFileName = CMyString.replaceStr(sSrcFileName, "\\", File.separator);
        String sFileName = CMyFile.extractFileName(sSrcFileName);
        if (sSrcFileName.substring(0, 1).equals(File.separator)) {
            sSrcFileName = sSrcFileName.substring(1);
        }
        String sFullFileName = "";
        sFullFileName = CMyFile.fileExists(sSrcFilePath + sSrcFileName) ? sSrcFilePath + sSrcFileName : sSrcFilePath + sFileName;
        for (int i = 0; i < aDestPath.length; ++i) {
            if (CMyFile.fileExists(aDestPath[i] + sFileName)) continue;
            aDestPath[i] = CMyString.setStrEndWith(aDestPath[i], File.separatorChar);
            CMyFile.copyFile(sFullFileName, aDestPath[i] + sFileName);
        }
    }

    public String getTextWithImgFilter(Template _template, String sText, boolean _bRemoveExtraAttribute) throws WCMException {
        int nTagCount;
        if (sText == null || sText.length() == 0) {
            return "";
        }
        String[] _pImgSrcPre = new String[]{FilesMan.getFilesMan().getTemplateAppendixPath(_template.getRootType(), _template.getRootId(), 1, true)};
        String[] arTagName = PublishServerConfigMapper.getTemplateTagsHavingSrc();
        String[] arTagSrcName = PublishServerConfigMapper.getTemplateTagSrcAttributeNames();
        if (arTagName == null || arTagSrcName == null) {
            return sText;
        }
        boolean bNeedAddImgSrc = this.addImgSrcIfNeed(arTagName, arTagSrcName);
        int n = nTagCount = arTagName.length > arTagSrcName.length ? arTagSrcName.length : arTagName.length;
        if (bNeedAddImgSrc) {
            arTagName = this.appendToArray(arTagName, "IMG");
            arTagSrcName = this.appendToArray(arTagSrcName, "SRC");
            ++nTagCount;
        }
        int nImgSrcPreIndex = 0;
        try {
            for (int nTagIndex = 0; nTagIndex < nTagCount; ++nTagIndex) {
                HtmlElement element;
                String currTagName = arTagName[nTagIndex];
                String currTagSrcName = arTagSrcName[nTagIndex];
                HtmlElementFinder imgFinder = new HtmlElementFinder(sText);
                while ((element = imgFinder.findNextElement(currTagName, true)) != null) {
                    String strSrc;
                    if (_bRemoveExtraAttribute) {
                        element.removeAttribute("ignoreapd");
                    }
                    if ((strSrc = element.getAttributeValue(ATTRIBUTE_OLDSRC)) != null) {
                        String sSrcPre = _pImgSrcPre[nImgSrcPreIndex++];
                        strSrc = sSrcPre + strSrc;
                        if (nImgSrcPreIndex >= _pImgSrcPre.length) {
                            nImgSrcPreIndex = 0;
                        }
                        element.setAttribute(currTagSrcName, strSrc);
                        if (_bRemoveExtraAttribute) {
                            element.removeAttribute(ATTRIBUTE_OLDSRC);
                            element.removeAttribute(ATTRIBUTE_OLDID);
                            element.removeAttribute(ATTRIBUTE_RELATED);
                        }
                    }
                    imgFinder.putElement(element);
                }
                sText = imgFinder.getContent();
            }
            return sText;
        }
        catch (Exception ex) {
            throw new WCMException(2, I18NMessage.get(Template.class, "Template.label21", "\u4f7f\u7528\u56fe\u7247\u8fc7\u6ee4\u5668\u63d0\u53d6\u6a21\u677f\u6b63\u6587\u5185\u5bb9\u5931\u8d25"), ex);
        }
    }

    private String[] appendToArray(String[] strs, String _sStr) {
        int nLength = strs.length;
        String[] newArray = new String[strs.length + 1];
        System.arraycopy(strs, 0, newArray, 0, nLength);
        System.arraycopy(new String[]{_sStr}, 0, newArray, nLength, 1);
        return newArray;
    }

    public Reports copyVisualTempToChnls(Channels _toChannels, Template _srcTemplate) throws WCMException {
        if (_srcTemplate == null || !_srcTemplate.getPropertyAsBoolean("VISUAL", false)) {
            throw new WCMException("\u6e90\u6a21\u677f\u4e3a\u7a7a\uff0c\u6216\u6307\u5b9a\u7684\u6a21\u677f\u4e0d\u662f\u53ef\u89c6\u5316\u6a21\u677f\u3002");
        }
        if (_toChannels == null) {
            throw new WCMException("\u8981\u521b\u5efa\u6a21\u677f\u7684\u680f\u76ee\u4e3a\u7a7a\u3002");
        }
        this.m_oReports = new Reports("");
        int nToChannelId = 0;
        Channel currChannel = new Channel();
        String sResultIds = "";
        for (int i = 0; i < _toChannels.size(); ++i) {
            currChannel = (Channel)_toChannels.getAt(i);
            if (currChannel == null) continue;
            try {
                nToChannelId = currChannel.getId();
                IPublishElement publishElement = PublishElementFactory.lookupElement(101, nToChannelId);
                Template newTemplate = (Template)_srcTemplate.cloneToNewObj();
                newTemplate.setName(this.getNewTempName(newTemplate));
                newTemplate.setFolder((IPublishFolder)publishElement);
                this.copyWidgetInstances(_srcTemplate, newTemplate);
                int nNewTemplateId = newTemplate.getId();
                User currUser = this.getLoginUser();
                WCMFolderPublishConfig currPublishConfig = new WCMFolderPublishConfig((IPublishFolder)publishElement);
                currPublishConfig.setFolderType(101, nToChannelId);
                currPublishConfig.setDataPath(nToChannelId + "");
                currPublishConfig.canEdit(currUser);
                if (_srcTemplate.getType() == 1) {
                    currPublishConfig.setOutlineTemplateId(nNewTemplateId + "");
                    currPublishConfig.save(currUser);
                } else {
                    currPublishConfig.setDetailTemplateId(nNewTemplateId);
                    currPublishConfig.save(currUser);
                }
                this.m_oReports.addSucessedReport("\u5728\u680f\u76ee\u3010" + currChannel + "\u3011\u4e0b\u521b\u5efa\u6a21\u677f\u6210\u529f\uff01");
                if (CMyString.isEmpty(sResultIds)) {
                    sResultIds = nNewTemplateId + "";
                    continue;
                }
                sResultIds = sResultIds + "," + nNewTemplateId;
                continue;
            }
            catch (Throwable ex) {
                this.m_oReports.addFailedReport("\u5728\u680f\u76ee\u3010" + currChannel + "\u3011\u4e0b\u521b\u5efa\u6bcd\u677f\u5931\u8d25\uff01", ex);
                throw new WCMException("\u7c7b\u4f3c\u521b\u5efa\u6a21\u677f\u51fa\u73b0\u5f02\u5e38", ex);
            }
        }
        this.m_oReports.setTitle("\u7c7b\u4f3c\u521b\u5efa\u53ef\u89c6\u5316\u6a21\u677f");
        String[] sResult = sResultIds.split(",");
        int[] nResult = new int[sResult.length];
        for (int i = 0; i < sResult.length; ++i) {
            if (CMyString.isEmpty(sResult[i])) {
                sResult[i] = "0";
            }
            nResult[i] = Integer.parseInt(sResult[i]);
        }
        this.m_oReports.setResultIds(nResult);
        return this.m_oReports;
    }

    private String getNewTempName(Template _template) throws WCMException {
        String sTempName = _template.getName();
        String sNewTempName = sTempName = _template.getName().replaceAll("(_\\d+)+", "");
        int nPostNumber = DBManager.getDBManager().sqlExecuteIntQuery("select max(tempid) from wcmtemplate", new int[0]);
        while (this.existsTempName(sNewTempName, _template.getRootId(), _template.getRootType())) {
            sNewTempName = sTempName + "_" + ++nPostNumber;
        }
        return sNewTempName;
    }

    private boolean existsTempName(String _sTempName, int _rootId, int _rootType) throws WCMException {
        WCMFilter filter = new WCMFilter("WCMTEMPLATE", "TEMPNAME=? and ROOTID=? and ROOTTYPE=?", "", "");
        filter.addSearchValues(_sTempName);
        filter.addSearchValues(_rootId);
        filter.addSearchValues(_rootType);
        return DBManager.getDBManager().sqlExecuteCountQuery(filter) > 0;
    }

    private void copyWidgetInstances(Template _srcTemplate, Template _newTemplate) throws Exception {
        if (!_srcTemplate.getPropertyAsBoolean("VISUAL", false)) {
            return;
        }
        StringBuffer sbWhere = new StringBuffer();
        StringBuffer sbIds = new StringBuffer();
        IWidgetInstParameterMgr m_oWidgetInstParameterMgr = (IWidgetInstParameterMgr)DreamFactory.createObjectById("IWidgetInstParameterMgr");
        TagDocument tagDoc = TagDocumentReader.read(_srcTemplate.getText());
        Iterator iterator = tagDoc.findItems("TRS_WIDGET");
        int nWidgetInstanceId = 0;
        while (iterator.hasNext()) {
            TagItem item = (TagItem)iterator.next();
            sbWhere.append("?,");
            nWidgetInstanceId = item.getIntAttribute("id", 0);
            WidgetInstance srcWidgetInstance = WidgetInstance.findById(nWidgetInstanceId);
            if (srcWidgetInstance == null) continue;
            WidgetInstance newWidgetInstance = (WidgetInstance)srcWidgetInstance.cloneToNewObj();
            newWidgetInstance.save(this.getLoginUser());
            Map oParameters = m_oWidgetInstParameterMgr.getParameters(srcWidgetInstance);
            m_oWidgetInstParameterMgr.addParameters(newWidgetInstance, oParameters);
            sbIds.append(newWidgetInstance.getId()).append(",");
        }
        if (sbWhere.length() <= 0) {
            return;
        }
        sbWhere.setLength(sbWhere.length() - 1);
        sbIds.setLength(sbIds.length() - 1);
        tagDoc = TagDocumentReader.read(_newTemplate.getText());
        iterator = tagDoc.findItems("TRS_WIDGET");
        int i = 0;
        String[] sIds = sbIds.toString().split(",");
        while (iterator.hasNext()) {
            TagItem item = (TagItem)iterator.next();
            item.setAttribute("id", sIds[i]);
            ++i;
        }
        _newTemplate.setText(tagDoc.toString());
        _newTemplate.save(this.getLoginUser());
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("update ").append("XWCMWIDGETINSTANCE");
        sbSQL.append(" set templateid=? ");
        sbSQL.append(" where ").append("WIDGETINSTANCEID");
        sbSQL.append(" in (");
        sbSQL.append(sbWhere);
        sbSQL.append(")");
        int nNewTemplateId = _newTemplate.getId();
        sbIds.insert(0, nNewTemplateId + ",");
        try {
            DBManager.getDBManager().sqlExecuteUpdate(new String[]{sbSQL.toString()}, CMyString.splitToInt(sbIds.toString(), ","));
        }
        catch (WCMException e) {
            s_logger.info((Object)"\u7c7b\u4f3c\u521b\u5efa\u53ef\u89c6\u5316\u6a21\u677f\u65f6\uff0c\u6267\u884csql\u66f4\u65b0\u5efa\u7acb\u6a21\u677f\u4e0e\u8d44\u6e90\u5b9e\u4f8bid\u7684\u5173\u8054\u65f6\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            this.m_oReports.addWarnedReport("\u53ef\u89c6\u5316\u6a21\u677f\u3010" + _newTemplate + "\u3011\u4e0e\u8d44\u6e90\u5b9e\u4f8bid\u5173\u8054\u65f6\u51fa\u9519\uff01", e);
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

