/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.template.TemplateCacheMgr;
import com.trs.components.common.publish.domain.template.TemplateMgr;
import com.trs.components.common.publish.domain.template.TemplateParseMgr;
import com.trs.components.common.publish.domain.template.UnZipFile4Template;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.common.publish.widget.WidgetInstParameter;
import com.trs.components.common.publish.widget.WidgetInstance;
import com.trs.components.wcm.content.service.portervisitors.PorterUtil;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.persistent.XmlToObjConverter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.CMyUnzip;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.Reports;
import com.trs.infra.util.jazzlib.ZipEntry;
import com.trs.mlf.log.LogUserUtil;
import com.trs.mlf.simplelog.LogConstant;
import com.trs.mlf.simplelog.SimpleLogServer;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class TemplateImporter {
    private static final Logger m_oLogger = Logger.getLogger((String)TemplateImporter.class.getName());
    private Reports m_importReports;
    private static XmlToObjConverter m_converter = new XmlToObjConverter(2);
    private XmlObject[] m_XmlObjTemplates;

    public String[] extractTemplateNamesFromZip(String _sZipFileName) throws WCMException {
        if (_sZipFileName.indexOf(".") < 0) {
            throw new WCMException(10, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label1", "\u4e0d\u662fzip\u6587\u4ef6\uff0c\u65e0\u6cd5\u5f97\u5230\u6a21\u677f\u540d\u79f0\uff01"));
        }
        if (!_sZipFileName.substring(_sZipFileName.lastIndexOf(".") + 1).toUpperCase().equals("ZIP")) {
            throw new WCMException(10, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label1", "\u4e0d\u662fzip\u6587\u4ef6\uff0c\u65e0\u6cd5\u5f97\u5230\u6a21\u677f\u540d\u79f0\uff01"));
        }
        String sFullName = this.getFullName(_sZipFileName);
        String sUnzipPath = CMyFile.extractFilePath(sFullName);
        sUnzipPath = sUnzipPath + "unziptemplate" + System.currentTimeMillis();
        CMyUnzip currUnzip = new CMyUnzip();
        try {
            currUnzip.setZipFile(sFullName);
            currUnzip.unzip(sUnzipPath, true);
        }
        catch (Exception ex) {
            throw new WCMException(54, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label2", "\u65e0\u6cd5\u6b63\u786e\u89e3\u538b\u7f29\u6587\u4ef6\uff01"));
        }
        ArrayList<String> lTempNames = new ArrayList<String>();
        Enumeration tempImportEnu = null;
        try {
            tempImportEnu = currUnzip.getItems();
        }
        catch (Exception ex) {
            throw new WCMException(54, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label3", "\u65e0\u6cd5\u6b63\u786e\u8bfb\u53d6\u89e3\u538b\u7f29\u540e\u7684\u6587\u4ef6\uff01"));
        }
        while (tempImportEnu.hasMoreElements()) {
            ZipEntry aFile = (ZipEntry)tempImportEnu.nextElement();
            if (aFile == null) continue;
            String sDstFile = aFile.getName();
            if (File.separator != "/") {
                sDstFile = CMyString.replaceStr(sDstFile, "/", File.separator);
            }
            String sItemFullFileName = sUnzipPath + sDstFile;
            String sExt = CMyFile.extractFileExt(sItemFullFileName);
            String sItemFileName = CMyFile.extractFileName(sItemFullFileName);
            if (!this.isSupportedTemplateExt(sExt)) continue;
            lTempNames.add(sItemFileName.substring(0, sItemFileName.lastIndexOf(".")));
        }
        String[] sTempNames = new String[lTempNames.size()];
        for (int i = 0; i < lTempNames.size(); ++i) {
            sTempNames[i] = (String)lTempNames.get(i);
        }
        return sTempNames;
    }

    public Reports importFromZip(IPublishFolder _folder, String _sFileName, int _nImportMode, int _nPicMode, String[] _arSelected) throws WCMException {
        return this.importFromZipFile(_folder, _sFileName, _nImportMode, _nPicMode, _arSelected, null);
    }

    public Reports importFromZip(IPublishFolder _folder, String _sFileName, int _nImportMode, int _nPicMode, String[] _arSelected, Templates _oTemplatesWithNoRight) throws WCMException {
        return this.importFromZipFile(_folder, _sFileName, _nImportMode, _nPicMode, _arSelected, _oTemplatesWithNoRight);
    }

    private Reports importFromZipFile(IPublishFolder _folder, String _sFileName, int _nImportMode, int _nPicMode, String[] _arSelected, Templates _oTemplatesWithNoRight) throws WCMException {
        this.assertNotNullParam(_folder, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label4", "\u65e0\u6548\u7684\u7ad9\u70b9/\u9891\u9053\u5bf9\u8c61,\u65e0\u6cd5\u5b8c\u6210\u6a21\u677f\u7684\u5bfc\u5165!"));
        this.assertNotNullParam(_sFileName, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label5", "\u6ca1\u6709\u6307\u5b9a\u5bfc\u5165\u7684\u6e90zip\u6587\u4ef6,\u65e0\u6cd5\u5b8c\u6210\u6a21\u677f\u5bfc\u5165!"));
        this.assertZipFile(_sFileName);
        String sFullName = this.getFullName(_sFileName);
        String sUnzipPath = CMyFile.extractFilePath(sFullName) + "unzip" + CMyFile.extractFileName(_sFileName) + File.separator;
        HashMap appendixes = new HashMap();
        ArrayList<String> templateFiles = new ArrayList<String>();
        Hashtable files = this.unzip(sFullName, sUnzipPath);
        if (m_oLogger.isDebugEnabled()) {
            m_oLogger.debug((Object)("files:" + files));
        }
        Map exportInfos = this.getExportInfo(files);
        for (String filename : files.keySet()) {
            if ("Thumbs.db".equals(CMyFile.extractFileName(filename, null))) continue;
            String fileext = CMyFile.extractFileExt(filename);
            if (this.isSupportedTemplateExt(fileext)) {
                templateFiles.add(filename);
                continue;
            }
            if (this.isSupportedAppendixExt(fileext)) {
                appendixes.put(CMyFile.extractFileName(filename).toLowerCase(), files.get(filename));
                continue;
            }
            if (this.isTempFileSelected(CMyFile.extractFileName(filename), _arSelected)) {
                templateFiles.add(filename);
                continue;
            }
            m_oLogger.warn((Object)("unsupport file for template[" + CMyFile.extractFileName(filename) + "]!"));
        }
        if (m_oLogger.isDebugEnabled()) {
            m_oLogger.debug((Object)"+++++++++++++++++++++++++++");
            m_oLogger.debug((Object)("templateFiles:" + templateFiles));
        }
        if (m_oLogger.isDebugEnabled()) {
            m_oLogger.debug((Object)"==============================");
            m_oLogger.debug((Object)("appendixes:" + appendixes));
        }
        this.m_importReports = new Reports("");
        ArrayList<Integer> arSavedTemplateId = new ArrayList<Integer>(5);
        ArrayList<Template> templateSaves = new ArrayList<Template>(templateFiles.size());
        StringBuilder templateNames = new StringBuilder();
        StringBuilder templateIds = new StringBuilder();
        for (int i = 0; i < templateFiles.size(); ++i) {
            String templatefile = (String)templateFiles.get(i);
            if (templatefile == null) continue;
            String templatename = CMyFile.extractFileName(templatefile);
            String templateext = "";
            if (templatename.indexOf(".") != -1) {
                templateext = templatename.substring(templatename.lastIndexOf(".") + 1, templatename.length());
                templatename = templatename.substring(0, templatename.lastIndexOf("."));
            }
            Template template = null;
            try {
                templatefile = (String)files.get(templatefile);
                template = this.createTemplateWithFile(_folder, templatefile, _nImportMode, templatename);
                if (template == null) continue;
                if (_oTemplatesWithNoRight != null && _oTemplatesWithNoRight.indexOf(template) > -1) {
                    this.m_importReports.addFailedReport(CMyString.format(I18NMessage.get(TemplateImporter.class, "TemplateImporter.label8", "\u5bfc\u5165[{0}]\u5931\u8d25!"), new Template[]{template}), new WCMException(1002, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label39", "\u6ca1\u6709\u8986\u76d6\u8be5\u6a21\u677f\u7684\u6743\u9650")));
                    continue;
                }
                if (exportInfos != null) {
                    Template tmp = (Template)exportInfos.get(templatename);
                    if (tmp == null) {
                        throw new WCMException("\u5728\u6e90zip\u6587\u4ef6\u4e2d\u7684\u6a21\u677f\u914d\u7f6e\u6587\u4ef6\u3010TemplateTypeInfos.xml\u3011\u4e2d\u6ca1\u6709\u627e\u5230\u6a21\u677f\u540d\u79f0\u4e3a\u3010" + templatename + "\u3011\u7684\u914d\u7f6e\u4fe1\u606f\uff01\u8bf7\u786e\u4fddzip\u6587\u4ef6\u4e2d\u7684\u6a21\u677f\u914d\u7f6e\u6587\u4ef6\u91cc\u5305\u542b\u5bf9\u5e94\u7684\u6a21\u677f\u540d\u79f0\u914d\u7f6e\u540e\u91cd\u65b0\u6267\u884c\u5bfc\u5165\uff01");
                    }
                    template.setProperty("TempType", tmp.getType());
                    template.setProperty("Visual", tmp.getPropertyAsBoolean("Visual", false));
                    if (!CMyString.isEmpty(tmp.getOutputFileName())) {
                        template.setOutputFileName(tmp.getOutputFileName());
                    }
                    template.setDesc(CMyString.showEmpty(tmp.getDesc()));
                }
                template.setProperty("TempExt", templateext);
                PorterUtil.doImports(template, null, this.m_XmlObjTemplates);
                if (m_oLogger.isDebugEnabled()) {
                    m_oLogger.debug((Object)"++++++++++++++++++++++++++++++");
                    m_oLogger.debug((Object)("template:" + template));
                    m_oLogger.debug((Object)"++++++++++++++++++++++++++++++");
                }
                this.getTemplateMgr().save(template, appendixes, true, _nPicMode, false);
                templateSaves.add(template);
                this.m_importReports.addSucessedReport(CMyString.format(I18NMessage.get(TemplateImporter.class, "TemplateImporter.label7", "\u5bfc\u5165[{0}]\u6210\u529f!"), new Template[]{template}));
                arSavedTemplateId.add(new Integer(template.getId()));
                templateNames.append(template.getName());
                templateNames.append(",");
                templateIds.append(template.getId());
                templateIds.append(",");
                continue;
            }
            catch (Throwable t) {
                this.m_importReports.addFailedReport(CMyString.format(I18NMessage.get(TemplateImporter.class, "TemplateImporter.label8", "\u5bfc\u5165[{0}]\u5931\u8d25!"), new Template[]{template}), t);
            }
        }
        String tempTemplateName = templateNames.substring(0, templateNames.length() - 1);
        String tempTemplateId = templateIds.substring(0, templateIds.length() - 1);
        SimpleLogServer.operation(LogConstant.Module.SYSTEMMANAGEMENT.desc, LogUserUtil.getLogUser(), "\u901a\u8fc7Zip\u5bfc\u5165", "\u5bfc\u5165\u4e86\u6a21\u677f[" + tempTemplateName + "][\u6a21\u677fID=" + tempTemplateId + "]", _folder.getInfo());
        if (templateSaves.size() > 0) {
            TemplateParseMgr parseMgr = this.getTemplateParseMgr();
            for (int i = 0; i < templateSaves.size(); ++i) {
                try {
                    parseMgr.notifyTemplateModified((Template)templateSaves.get(i));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.m_importReports.setTitle(CMyString.format(I18NMessage.get(TemplateImporter.class, "TemplateImporter.label10", "\u6210\u529f\u5bfc\u5165{0}\u4e2a,\u5bfc\u5165\u5931\u8d25{1}\u4e2a!"), new int[]{this.m_importReports.getSucessedReporter().size(), this.m_importReports.getFailedReporter().size()}));
        this.m_importReports.setExtraData(arSavedTemplateId);
        CMyFile.deleteFile(_sFileName);
        CMyFile.deleteDir(sUnzipPath);
        return this.m_importReports;
    }

    private void assertZipFile(String _sFileName) throws WCMException {
        String sExpectedExt = "zip";
        String sExt = CMyFile.extractFileExt(_sFileName);
        if (!sExpectedExt.equalsIgnoreCase(sExt)) {
            throw new WCMException(10, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label12", "\u4e0d\u662f\u4e00\u4e2aZip\u6587\u4ef6,\u65e0\u6cd5\u5b8c\u6210\u5bfc\u5165!"));
        }
    }

    private Hashtable unzip(String _sZipFile, String _sUnzipPath) throws WCMException {
        UnZipFile4Template uzf = new UnZipFile4Template(_sZipFile, _sUnzipPath);
        try {
            uzf.setFileNameEncoding("GBK");
            ((CMyUnZipFile)uzf).doUnZipAnd();
        }
        catch (CMyException e) {
            m_oLogger.debug((Object)"failed to unzip the file", (Throwable)e);
            throw new WCMException(200, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label13", "\u89e3\u538b\u6587\u4ef6\u5931\u8d25\uff01"), e);
        }
        return ((CMyUnZipFile)uzf).getAllFileNameIndex();
    }

    private String getFullName(String _sFileName) throws WCMException {
        String sFullName = _sFileName;
        if (!CMyFile.fileExists(_sFileName)) {
            FilesMan filesMan = FilesMan.getFilesMan();
            sFullName = filesMan.mapFilePath(_sFileName, 0) + _sFileName;
        }
        return sFullName;
    }

    private Map getExportInfo(Hashtable _files) throws WCMException {
        String file = (String)_files.remove("TemplateTypeInfos.xml");
        if (file == null) {
            return null;
        }
        XmlObject[] templates = this.m_XmlObjTemplates = m_converter.convertXml(file, null, null);
        HashMap<String, Template> infos = new HashMap<String, Template>(templates.length);
        for (int i = 0; i < templates.length; ++i) {
            Template template = (Template)templates[i].getCurrentObj();
            infos.put(template.getName(), template);
        }
        return infos;
    }

    public Reports importFromHTML(IPublishFolder _folder, String _sFileName, int _nImportMode, String _sSrcName) throws WCMException {
        this.assertNotNullParam(_folder, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label14", "\u65e0\u6548\u7684\u7ad9\u70b9/\u9891\u9053\u5bf9\u8c61,\u65e0\u6cd5\u5b8c\u6210\u6a21\u677f\u5bfc\u5165!"));
        this.assertNotNullParam(_sFileName, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label15", "\u6ca1\u6709\u6307\u5b9a\u8981\u5bfc\u5165\u7684\u6a21\u677f\u6587\u4ef6,\u65e0\u6cd5\u5bfc\u5165!"));
        this.assertNotNullParam(_sSrcName, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label16", "\u65e0\u6548\u7684\u6a21\u677f\u6587\u4ef6\u540d!"));
        this.assertUnSuppportTemplateExt(_sFileName);
        String msgTitle = I18NMessage.get(TemplateImporter.class, "TemplateImporter.label17", "\u5bfc\u5165\u6a21\u677f [") + _sSrcName + "] ";
        this.m_importReports = new Reports(msgTitle);
        try {
            String sSrcName = _sSrcName.substring(0, _sSrcName.lastIndexOf("."));
            String sFullFileName = this.getFullName(_sFileName);
            Template template = this.createTemplateWithFile(_folder, sFullFileName, _nImportMode, sSrcName);
            if (template == null) {
                return this.m_importReports;
            }
            int nLastDotPos = _sFileName.lastIndexOf(".");
            template.setProperty("TempExt", _sFileName.substring(nLastDotPos + 1));
            this.getTemplateMgr().save(template, "", true, 2);
            this.m_importReports.addSucessedReport(I18NMessage.get(TemplateImporter.class, "TemplateImporter.label18", "\u5bfc\u5165\u6210\u529f!"));
            ArrayList<Integer> arSavedTemplateId = new ArrayList<Integer>();
            arSavedTemplateId.add(new Integer(template.getId()));
            this.m_importReports.setExtraData(arSavedTemplateId);
            SimpleLogServer.operation(LogConstant.Module.SYSTEMMANAGEMENT.desc, LogUserUtil.getLogUser(), "\u901a\u8fc7HTML\u5bfc\u5165", "\u5bfc\u5165\u4e86\u6a21\u677f[" + template.getName() + "][\u6a21\u677fID=" + template.getId() + "]", _folder.getInfo());
        }
        catch (Throwable t) {
            m_oLogger.debug((Object)"failed to import template from html file:", t);
            this.m_importReports.addFailedReport(I18NMessage.get(TemplateImporter.class, "TemplateImporter.label19", "\u5bfc\u5165\u5931\u8d25!"), t);
        }
        return this.m_importReports;
    }

    private TemplateMgr getTemplateMgr() {
        TemplateMgr templateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
        return templateMgr;
    }

    private TemplateParseMgr getTemplateParseMgr() {
        TemplateParseMgr templateParseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
        return templateParseMgr;
    }

    private void assertUnSuppportTemplateExt(String _sFileName) throws WCMException {
        String sExt = CMyFile.extractFileExt(_sFileName);
        if (!this.isSupportedTemplateExt(sExt)) {
            throw new WCMException(10, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label20", "\u5728\u652f\u6301\u7684\u6a21\u677f\u6587\u4ef6") + _sFileName);
        }
    }

    private Template createTemplateWithFile(IPublishFolder _folder, String _sFileName, int _nImportMode, String _sRealName) throws WCMException {
        String sContent = this.getFileContent(_sFileName);
        IPublishFolder root = _folder.getRoot();
        Template template = this.getTemplateCacheMgr().lookupByName(root, _sRealName);
        if (template != null) {
            IPublishFolder host = template.getFolder();
            if (host == null) {
                template.delete(ContextHelper.getLoginUser());
                template = null;
            } else if (host.isDeleted()) {
                throw new WCMException(I18NMessage.get(TemplateImporter.class, "TemplateImporter.label21", "\u540c\u540d\u6a21\u677f[TempName=") + _sRealName + I18NMessage.get(TemplateImporter.class, "TemplateImporter.label22", "]\u6240\u5c5e\u680f\u76ee[") + host + I18NMessage.get(TemplateImporter.class, "TemplateImporter.label23", "]\u88ab\u5220\u9664\u5230\u56de\u6536\u7ad9\u4e2d\uff0c\u6b64\u6a21\u677f\u4e0d\u80fd\u88ab\u5bfc\u5165\uff01"));
            }
        }
        if (template != null) {
            String sNewName = this.processTemplateName(_sRealName, _folder, _nImportMode);
            if (sNewName == null) {
                return null;
            }
            template = sNewName.equals(template.getName()) ? this.updateTemplate(template, sContent) : this.createTemplate(_folder, sNewName, sContent, root);
        } else {
            template = this.createTemplate(_folder, _sRealName, sContent, root);
        }
        return template;
    }

    private TemplateCacheMgr getTemplateCacheMgr() {
        return (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
    }

    private Template updateTemplate(Template _template, String _sNewContent) throws WCMException {
        _template.canEdit(ContextHelper.getLoginUser());
        _template.setText(_sNewContent);
        return _template;
    }

    private Template createTemplate(IPublishFolder _folder, String _sRealName, String _sContent, IPublishFolder _root) throws WCMException {
        Template newTemp = Template.createNewInstance();
        newTemp.setText(_sContent);
        newTemp.setFolder(_folder, _root);
        newTemp.setName(_sRealName);
        newTemp.setType(Template.guessTypeByName(_sRealName));
        return newTemp;
    }

    private String getFileContent(String _sFileName) throws WCMException {
        String sContent = "";
        if (CMyFile.fileExists(_sFileName)) {
            try {
                String encoding = CharsetDetector.detect(_sFileName);
                sContent = CMyFile.readFile(_sFileName, encoding);
            }
            catch (CMyException ex) {
                throw new WCMException(ex.getErrNo(), ex.getMyMessage(), ex.getRootCause());
            }
        }
        return sContent;
    }

    private String processTemplateName(String _sRealName, IPublishFolder _folder, int _nImportMode) throws WCMException {
        switch (_nImportMode) {
            case 1: {
                return _sRealName;
            }
            case 3: {
                return this.getNewName(_sRealName, _folder.getRoot());
            }
            case 2: {
                return null;
            }
            case 4: {
                String sFolder = null;
                if (_folder.getType() == 103) {
                    sFolder = I18NMessage.get(TemplateImporter.class, "TemplateImporter.label37", "\u7ad9\u70b9");
                } else if (_folder.getType() == 101) {
                    sFolder = I18NMessage.get(TemplateImporter.class, "TemplateImporter.label38", "\u680f\u76ee");
                }
                WCMException e = new WCMException(CMyString.format(I18NMessage.get(TemplateImporter.class, "TemplateImporter.label24", "\u5728{0}["), new String[]{sFolder}) + _folder.getInfo() + I18NMessage.get(TemplateImporter.class, "TemplateImporter.label25", "]\u4e2d\u5df2\u5b58\u5728\u540d\u79f0\u4e3a[") + _sRealName + I18NMessage.get(TemplateImporter.class, "TemplateImporter.label26", "]\u7684\u6a21\u677f!"));
                this.m_importReports.addFailedReport(I18NMessage.get(TemplateImporter.class, "TemplateImporter.label27", "\u6a21\u677f[") + _sRealName + I18NMessage.get(TemplateImporter.class, "TemplateImporter.label28", "]\u5df2\u5b58\u5728!"), e);
                return null;
            }
        }
        throw new WCMException(10, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label29", "\u65e0\u6548\u7684\u540c\u540d\u5904\u7406\u6a21\u5f0f[") + _nImportMode + I18NMessage.get(TemplateImporter.class, "TemplateImporter.label30", "],\u6709\u6548\u503c\u4e3a(1,2,3,4)!"));
    }

    private String getNewName(String _sRealName, IPublishFolder _root) throws WCMException {
        String sTempName = _sRealName;
        int k = 1;
        TemplateCacheMgr manager = this.getTemplateCacheMgr();
        while (manager.lookupByName(_root, sTempName) != null) {
            sTempName = _sRealName + "_" + k;
            ++k;
        }
        return sTempName;
    }

    private boolean isSupportedTemplateExt(String _sExt) throws WCMException {
        m_oLogger.debug((Object)I18NMessage.get(TemplateImporter.class, "TemplateImporter.label31", "\u5f00\u59cb\u8bc6\u522b\u6a21\u677f\u540e\u7f00"));
        String[] sTempExts = PublishServerConfigMapper.getTemplateSupportedExts();
        if (sTempExts == null || sTempExts.length == 0) {
            return false;
        }
        for (int i = 0; i < sTempExts.length; ++i) {
            if (!_sExt.equalsIgnoreCase(sTempExts[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isSupportedAppendixExt(String _sExt) throws WCMException {
        m_oLogger.debug((Object)I18NMessage.get(TemplateImporter.class, "TemplateImporter.label32", "\u5f00\u59cb\u8bc6\u522b\u6a21\u677f\u9644\u4ef6\u540e\u7f00"));
        String[] sTempApdExts = PublishServerConfigMapper.getTemplateSupportedApdExts();
        if (sTempApdExts == null || sTempApdExts.length == 0) {
            return false;
        }
        for (int i = 0; i < sTempApdExts.length; ++i) {
            if (!_sExt.equalsIgnoreCase(sTempApdExts[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isTempFileSelected(String _sTempFile, String[] _sSelectedFiles) {
        if (_sSelectedFiles == null || _sSelectedFiles.length == 0) {
            return true;
        }
        for (int i = 0; i < _sSelectedFiles.length; ++i) {
            if (!_sTempFile.equals(_sSelectedFiles[i])) continue;
            return true;
        }
        return false;
    }

    private void assertNotNullParam(Object _param, String _desc) throws WCMException {
        if (_param == null) {
            throw new WCMException(10, _desc);
        }
    }

    public static final String[] getSupportedTemplateFileExt() throws WCMException {
        String[] exts = PublishServerConfigMapper.getTemplateSupportedExts();
        if (exts != null) {
            return exts;
        }
        return new String[0];
    }

    static {
        m_converter.registPersistentObj("WCMTEMPLATE", Template.class);
        m_converter.registPersistentObj("XWCMWIDGETINSTANCE", WidgetInstance.class);
        m_converter.registPersistentObj("XWCMWIDGETINSTPARAMETER", WidgetInstParameter.class);
    }
}

