/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.taskdispatch;

import com.trs.components.common.publish.domain.taskdispatch.IPublishTaskDispatcher;
import com.trs.components.common.publish.domain.taskdispatch.PublishTaskRuntime;
import com.trs.components.common.publish.domain.taskdispatch.TaskWorker;
import com.trs.components.common.publish.domain.taskdispatch.ThreadPool;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTask;
import com.trs.infra.common.WCMException;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.aton.container.IClearable;

public class TaskDispatcher
extends Thread
implements IPublishTaskDispatcher,
IClearable {
    private static final Logger s_logger = Logger.getLogger(TaskDispatcher.class);
    private boolean m_zRunning;
    private boolean m_zWaiting;
    private ThreadPool m_oThreadPool;
    private Hashtable m_oAllTasks;
    private Hashtable m_oPauseTasks;
    private List m_oWaitingRealtime;
    private List m_oWaitingHigh;
    private List m_oWaitingNormal;
    private List m_oWaitingLow;

    public TaskDispatcher() {
        this.setName("PublishTaskDispatcher");
        this.setDaemon(true);
    }

    public boolean isRunning() {
        return this.m_zRunning;
    }

    @Override
    public void run() {
        while (this.m_zRunning) {
            this.waitForNewTask();
            this.doRealtimeTasks();
        }
    }

    private TaskWorker newWorker() {
        return new TaskWorker();
    }

    private void runTask(Node node) {
        TaskWorker worker = this.newWorker();
        worker.setTaskRuntime(node);
        this.m_oThreadPool.runIt(worker);
    }

    private void doRealtimeTasks() {
        Node node = this.m_oWaitingRealtime.get();
        while (node != null) {
            if (this.m_oThreadPool.getIdleCount() <= 0) {
                this.runTask(node);
            } else {
                this.interruptTasks();
                this.m_oThreadPool.waitForWorker();
                this.runTask(node);
            }
            node = this.m_oWaitingRealtime.get();
        }
    }

    private void interruptTasks() {
    }

    @Override
    public void startup() throws WCMException {
    }

    @Override
    public void shutdown() {
    }

    public void clear() {
        if (this.m_zRunning) {
            throw new IllegalStateException("Task dispatcher can not be cleared when running!");
        }
    }

    private Node newChainNode() {
        return new Node();
    }

    private synchronized void waitForNewTask() {
        this.m_zWaiting = true;
        try {
            this.wait();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_zWaiting = false;
    }

    private synchronized void notifyNewTask() {
        if (this.m_zWaiting) {
            try {
                this.notify();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushTask(PublishTask _task) throws WCMException {
        if (_task == null) {
            return;
        }
        Node tasNode = null;
        Integer oKey = new Integer(_task.getId());
        TaskDispatcher taskDispatcher = this;
        synchronized (taskDispatcher) {
            if (this.m_oAllTasks.containsKey(oKey)) {
                return;
            }
            tasNode = this.newChainNode();
            tasNode.setPublishTask(_task);
            tasNode.setTaskContext(null);
            this.m_oAllTasks.put(oKey, tasNode);
            if (_task.getStatus() == 12) {
                this.m_oPauseTasks.put(oKey, _task);
                return;
            }
        }
        switch (_task.getPriority()) {
            case 1: {
                this.m_oWaitingLow.put(tasNode);
                break;
            }
            case 5: {
                this.m_oWaitingNormal.put(tasNode);
                break;
            }
            case 9: {
                this.m_oWaitingHigh.put(tasNode);
                break;
            }
            case 13: {
                this.m_oWaitingRealtime.put(tasNode);
                break;
            }
        }
        this.notifyNewTask();
        s_logger.debug((Object)("task[" + _task.getId() + "] is pushed into TaskDispatcher."));
    }

    @Override
    public boolean pauseTask(int iTaskID) throws WCMException {
        return false;
    }

    @Override
    public boolean resumeTask(int iTaskID) throws WCMException {
        return false;
    }

    @Override
    public boolean cancelTask(int _nTaskId) throws WCMException {
        return false;
    }

    @Override
    public boolean changeTaskPriority(int iTask, int iPriority) {
        return false;
    }

    @Override
    public PublishTaskRuntime getTaskRuntime(int iTaskID) {
        return null;
    }

    @Override
    public PublishTask getRunningTask(int iTaskID) {
        return null;
    }

    @Override
    public Iterator getRunningTasks() {
        return null;
    }

    class Node
    extends PublishTaskRuntime {
        List m_list;
        Node m_next = null;
        Node m_prev = null;

        public boolean cutFromList() {
            if (this.m_list == null) {
                return false;
            }
            return this.m_list.cut(this);
        }
    }

    class List {
        private Node m_pole;
        private int m_size = 0;

        public List() {
            this.m_pole.m_next = this.m_pole = new Node();
            this.m_pole.m_prev = this.m_pole;
        }

        public synchronized boolean cut(Node node) {
            if (this.m_size == 0) {
                return false;
            }
            if (node.m_next == null || node.m_prev == null) {
                return false;
            }
            node.m_next.m_prev = node.m_prev;
            node.m_prev.m_next = node.m_next;
            node.m_prev = null;
            node.m_next = null;
            node.m_list = null;
            --this.m_size;
            return true;
        }

        public synchronized Node get() {
            if (this.m_size == 0) {
                return null;
            }
            Node head = this.m_pole.m_next;
            head.m_prev.m_next = head.m_next;
            head.m_next.m_prev = head.m_prev;
            head.m_prev = null;
            head.m_next = null;
            head.m_list = null;
            --this.m_size;
            return head;
        }

        public synchronized void put(Node node) {
            if (node.m_next != null || node.m_prev != null) {
                return;
            }
            Node tail = this.m_pole.m_prev;
            tail.m_next = node;
            node.m_list = this;
            node.m_next = this.m_pole;
            node.m_prev = tail;
            this.m_pole.m_prev = node;
            ++this.m_size;
        }

        public Node peek() {
            if (this.m_size == 0) {
                return null;
            }
            return this.m_pole.m_next;
        }

        public int size() {
            return this.m_size;
        }

        public Iterator values() {
            return new Iterator(){
                Node m_peek;
                {
                    this.m_peek = List.this.m_pole;
                }

                @Override
                public boolean hasNext() {
                    return this.m_peek.m_next != List.this.m_pole;
                }

                public Object next() {
                    this.m_peek = this.m_peek.m_next;
                    return this.m_peek;
                }

                @Override
                public void remove() {
                }
            };
        }
    }
}

