/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.components.common.publish.domain.tagparser.BaseTagParser;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParserFactory;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.infra.common.WCMException;
import java.util.List;

public abstract class TemplateQuoteBaseTagParser
extends BaseTagParser {
    private TagItem mItem;

    @Override
    public void setTagItem(TagItem _item) {
        this.mItem = _item;
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) throws WCMException {
        if (this.mItem == null) {
            return null;
        }
        TemplateQuote[] result = new TemplateQuote[]{};
        List children = this.mItem.getChildren();
        int length = children.size();
        for (int i = 0; i < length; ++i) {
            Object item = children.get(i);
            if (item instanceof String) continue;
            TagItem tag = (TagItem)item;
            String sName = tag.getName();
            ITagParser parser = TagParserFactory.createParserByName(sName);
            if (parser == null) {
                throw new WCMException(10, "Unsupported tag <" + sName + ">");
            }
            parser.setTagItem(tag);
            TemplateQuote[] childResult = parser.analyzeQuotes(_root);
            if (childResult == null) continue;
            TemplateQuote[] tmpResult = new TemplateQuote[result.length + childResult.length];
            System.arraycopy(result, 0, tmpResult, 0, result.length);
            System.arraycopy(childResult, 0, tmpResult, result.length, childResult.length);
            result = tmpResult;
        }
        return result;
    }
}

