/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.components.common.publish.domain.tagparser.TemplateParameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class TemplateParameterList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashMap m_oNameMaps;
    private ArrayList m_oParaList;
    private ArrayList m_oBatchList;
    private boolean m_zNestParsed;

    public TemplateParameterList() {
        this(false);
    }

    public TemplateParameterList(boolean zBatch) {
        if (zBatch) {
            this.m_oNameMaps = null;
            this.m_oParaList = null;
            this.m_oBatchList = new ArrayList();
        } else {
            this.m_oNameMaps = new HashMap();
            this.m_oParaList = new ArrayList();
            this.m_oBatchList = null;
        }
    }

    public HashMap getNameMaps() {
        return this.m_oNameMaps;
    }

    public TemplateParameter getParameter(String _name) {
        if (this.m_oNameMaps != null && _name != null) {
            return (TemplateParameter)this.m_oNameMaps.get(_name);
        }
        return null;
    }

    public synchronized void addParameter(TemplateParameter _parameter) {
        if (this.m_oNameMaps == null) {
            throw new IllegalStateException("In batch mode.");
        }
        Object oPreDeclared = this.m_oNameMaps.get(_parameter.getParameterName());
        if (oPreDeclared != null) {
            _parameter.setPreDeclared((TemplateParameter)oPreDeclared);
            return;
        }
        this.m_oNameMaps.put(_parameter.getParameterName(), _parameter);
        this.m_oParaList.add(_parameter);
    }

    public synchronized void addParameterList(TemplateParameterList _list) {
        if (this.m_oBatchList == null) {
            throw new IllegalStateException("Not in batch mode.");
        }
        if (_list != null) {
            this.m_oBatchList.add(_list);
        }
    }

    public Iterator parameters() {
        if (this.m_oParaList != null) {
            return this.m_oParaList.iterator();
        }
        Iterator r = new Iterator(){
            Iterator m_oCurrList = null;
            int m_iCurrIndex = 0;
            Object m_oCurrObject = null;

            @Override
            public boolean hasNext() {
                return this.m_oCurrObject != null || this.findNext();
            }

            public Object next() {
                if (this.m_oCurrObject != null || this.findNext()) {
                    Object obj = this.m_oCurrObject;
                    this.m_oCurrObject = null;
                    return obj;
                }
                return null;
            }

            private boolean findNext() {
                if (this.m_iCurrIndex == -1) {
                    return false;
                }
                if (this.m_oCurrList != null && this.m_oCurrList.hasNext()) {
                    this.m_oCurrObject = this.m_oCurrList.next();
                    return true;
                }
                TemplateParameterList list = null;
                while (this.m_iCurrIndex < TemplateParameterList.this.m_oBatchList.size()) {
                    list = (TemplateParameterList)TemplateParameterList.this.m_oBatchList.get(this.m_iCurrIndex++);
                    if (list == null) continue;
                    this.m_oCurrList = list.parameters();
                    return this.findNext();
                }
                this.m_iCurrIndex = -1;
                return false;
            }

            @Override
            public void remove() {
            }
        };
        return r;
    }

    public int size() {
        if (this.m_oParaList != null) {
            return this.m_oParaList.size();
        }
        int iTotal = 0;
        for (int i = 0; i < this.m_oBatchList.size(); ++i) {
            TemplateParameterList list = (TemplateParameterList)this.m_oBatchList.get(i);
            if (list == null) continue;
            iTotal += list.size();
        }
        return iTotal;
    }

    public boolean getNestParsed() {
        return this.m_zNestParsed;
    }

    public void setNestParsed(boolean zFlag) {
        this.m_zNestParsed = zFlag;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.m_oNameMaps != null) {
            sb.append("m_oNameMaps:").append(this.m_oNameMaps);
        }
        if (this.m_oParaList != null) {
            sb.append("m_oParaList:").append(this.m_oParaList);
        }
        if (this.m_oBatchList != null) {
            sb.append("m_oBatchList:").append(this.m_oBatchList);
        }
        return sb.toString();
    }
}

