/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.cms.content.CMSObj;
import com.trs.cms.content.HTMLContent;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.tagparser.WCMTagParserDocument;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import com.trs.infra.util.html.HtmlUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class TagParserPageNav4Detail
implements ITagParser {
    private static TagBeanInfo s_TagBeanInfo = null;
    protected TagItem m_tagItem;
    private static final String FLAG_START_STYLE = "<style id=_Custom_V6_Style";
    private static final String FLAG_END_STYLE = "</style>";
    Logger m_logger = Logger.getLogger(TagParserPageNav4Detail.class);

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) throws WCMException {
        return null;
    }

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_PAGENAV4DETAIL");
            tbi.setDesc("TRS_PAGENAV4DETAIL");
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        CMSObj host = this.findHost(_context);
        if (!(host instanceof Document)) {
            StringBuffer sb = new StringBuffer(256);
            sb.append(this.m_tagItem.getDescWithPos()).append(I18NMessage.get(WCMTagParserDocument.class, "TagParserPageNav4Detail.label1", "\u7f6e\u6807\u4f7f\u7528\u7684\u573a\u666f\u4e0d\u5bf9,"));
            sb.append(I18NMessage.get(WCMTagParserDocument.class, "TagParserPageNav4Detail.label2", "\u53ef\u80fd\u76f4\u63a5\u7528\u5728\u4e86\u6982\u89c8\u9875\u9762\u4e2d\u6216\u8005\u5176\u5b83\u975eTRS_DOCUMENTS\u6982\u89c8\u7f6e\u6807\u4e2d\uff01[tag-host="));
            sb.append(host).append(']');
            _context.addWarning(sb.toString());
            return null;
        }
        Document _document = (Document)host;
        return this.separatePages(_context, this.parseHtmlContent(_document, _context));
    }

    private String parseHtmlContent(Document _doc, PublishTagContext _context) throws WCMException {
        if (_doc.getChannel().getType() == 13) {
            return null;
        }
        if (_doc.getType() != 20) {
            return I18NMessage.get(WCMTagParserDocument.class, "TagParserPageNav4Detail.label1", "\u7f6e\u6807\u4f7f\u7528\u7684\u573a\u666f\u4e0d\u5bf9,");
        }
        String sResult = null;
        try {
            IPublishContent content = (IPublishContent)_context.getUpperHost();
            String sImagePath1 = _context.getPathCompass().getAbsoluteHttpPath(content.getRealHome());
            String sImagePath2 = PublishPathCompass.calSubDirectory(content, false);
            String sImagePath = sImagePath1 + sImagePath2;
            if (!_context.getAttribute("UrlIsABS", false)) {
                sImagePath = HtmlUtil.calRelativePath(sImagePath, _context.getPageHttpPath());
            }
            sResult = _doc.getHtmlContentWithImgFilter(sImagePath, true, true);
            if ((sResult = sResult.replaceAll("(?is)<TRS_COMMENT.*?>.*?</TRS_COMMENT>", "")) == null || sResult.length() == 0) {
                sResult = _doc.getContent();
            } else {
                this.distributionHTMLContentFiles(_doc, _context);
            }
            sResult = TagParseHelper.formatTextIfNeeded(_context, sResult);
            return sResult;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(WCMTagParserDocument.class, "TagParserPageNav4Detail.label3", "\u89e3\u6790\u6b63\u6587\u5931\u8d25!"), ex);
        }
    }

    private void distributionHTMLContentFiles(Document _doc, PublishTagContext _context) {
        if (_doc.getType() != 20) {
            return;
        }
        try {
            HTMLContent oHTMLContent = new HTMLContent(_doc.getPubHtmlContent());
            List<String> listFiles = oHTMLContent.getWCMFiles();
            int nSize = listFiles.size();
            if (nSize <= 0) {
                return;
            }
            boolean bPreview = _context.isPreview();
            PublishPathCompass compass = _context.getPathCompass();
            IPublishContent publishContent = (IPublishContent)_context.getUpperHost();
            for (int i = 0; i < nSize; ++i) {
                String sSrcFilePathName;
                String sFileName = listFiles.get(i);
                if (sFileName == null || !CMyFile.fileExists(sSrcFilePathName = FilesMan.getFilesMan().mapFilePath(sFileName, 0) + sFileName)) continue;
                String sLocalPath = compass.getLocalPath(publishContent, bPreview);
                PublishSyncGlobalTuner.insureLocalPathExists(sLocalPath);
                CMyFile.copyFile(sSrcFilePathName, sLocalPath + sFileName);
                if (bPreview) continue;
                _context.getFileDistributeShip().distributeFile(sSrcFilePathName, publishContent, null, true);
            }
        }
        catch (Exception ex) {
            this.m_logger.error((Object)(I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label15", "\u53d1\u5e03") + _doc + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label16", "\u7684HTML\u6b63\u6587\u56fe\u7247\u5931\u8d25\uff01")), (Throwable)ex);
        }
    }

    public String[] separatePages(PublishTagContext _context, String _sText) {
        String[] temp;
        Pattern pattern = Pattern.compile("(?is)<TRS_PAGE_SEPARATOR.*?>.*?</TRS_PAGE_SEPARATOR>");
        Matcher matcher = pattern.matcher(_sText);
        String[] results = new String[1];
        int nPages = 0;
        int nLength = _sText.length();
        int nNextStart = 0;
        String[] titles = new String[1];
        while (matcher.find()) {
            temp = new String[++nPages];
            System.arraycopy(results, 0, temp, 0, nPages - 1);
            results = temp;
            temp = new String[nPages + 1];
            System.arraycopy(titles, 0, temp, 0, nPages);
            titles = temp;
            String sepTitleTag = matcher.group();
            HtmlElementFinder finder = new HtmlElementFinder(sepTitleTag);
            HtmlElement ele = finder.findNextElement("TRS_PAGE_SEPARATOR");
            String pageTitle = CMyString.showEmpty(ele.getAttributeValue("pageTitle"), "");
            if (nPages == 1) {
                String firstPageTitle;
                titles[0] = firstPageTitle = ele.getAttributeValue("firstPageTitle");
            }
            titles[nPages] = pageTitle;
            results[nPages - 1] = _sText.substring(nNextStart, matcher.start());
            nNextStart = matcher.end();
            if (nNextStart + 1 < nLength) continue;
            break;
        }
        if (nNextStart > 0 && nNextStart < nLength) {
            temp = new String[++nPages];
            System.arraycopy(results, 0, temp, 0, nPages - 1);
            results = temp;
            results[nPages - 1] = _sText.substring(nNextStart);
        }
        if (nPages <= 0) {
            return new String[]{_sText};
        }
        if (nPages == 1) {
            return results;
        }
        String sStyle = TagParserPageNav4Detail.extractStyleHTML(results[0]);
        String sDivStartHTML = null;
        if (sStyle != null) {
            sDivStartHTML = TagParserPageNav4Detail.extractDivStartHTML(results[0]);
        }
        if (sDivStartHTML != null) {
            results[0] = results[0] + "</DIV>";
            results[results.length - 1] = sDivStartHTML + sStyle + results[results.length - 1];
            for (int i = 1; i < results.length - 1; ++i) {
                results[i] = sDivStartHTML + sStyle + results[i] + "</DIV>";
            }
        }
        try {
            if (PublishServerConfigMapper.isDetailPageSeperateTo51Style()) {
                for (int i = 0; i < results.length; ++i) {
                    System.out.println("for: " + results[i]);
                    results[i] = results[i] + TagParserPageNav4Detail.outputVar(_context, titles, i, results.length);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(results[0]);
        this.m_logger.debug((Object)results[0]);
        return results;
    }

    private static String outputVar(PublishTagContext _context, String[] titles, int nIndex, int nSize) {
        String sScript = "\n<SCRIPT language=\"javascript\">\n  var nCurrPage = " + (nIndex + 1) + "\n  var nPageCount = " + nSize + "\n  var arrTitle = \"" + CMyString.filterForJs(CMyString.join(titles, "~")) + "\"\n\n  var sValue = window.location.href;\n  var nFileStartPos = sValue.lastIndexOf('/t');\n  var sFile = sValue.substring(nFileNameStartPos);\n  var nFileEndPos = sFile.indexOf('?');\n  if(nFileEndPos < 0){\n      nFileEndPos = sFile.indexOf('#');\n  }\n  if(nFileEndPos > 0){\n      sFile = sFile.substring(0, nFileEndPos);\n  }\n  var nFileNameEndPos = sFile.lastIndexOf('.');   \n  var sFileExt = sFile.substring(nFileNameEndPos+1);\n  var sFileName = sFile.substring(0, nFileNameEndPos);\n  if(nCurrPage>1){\n      var nFileNameStartPos = sFileName.lastIndexOf('_'+ (nCurrPage-1));  \n      sFileName = sFileName.substring(0, nFileNameStartPos);  \n  }\n</SCRIPT>";
        return sScript;
    }

    private static String extractDivStartHTML(String _sContent) {
        int nDivStartPos = _sContent.indexOf("<DIV id='TRS_AUTOADD");
        if (nDivStartPos < 0) {
            nDivStartPos = _sContent.indexOf("<DIV id=\"TRS_AUTOADD");
        }
        if (nDivStartPos < 0) {
            return null;
        }
        int nDivEndPos = _sContent.indexOf(">", nDivStartPos + 6);
        if (nDivEndPos < 0) {
            return null;
        }
        return _sContent.substring(nDivStartPos, nDivEndPos + 1);
    }

    private static String extractStyleHTML(String _sContent) {
        int nStartPos = _sContent.indexOf(FLAG_START_STYLE);
        if (nStartPos <= 0) {
            return null;
        }
        int nEndPos = _sContent.indexOf(FLAG_END_STYLE, nStartPos + 10);
        if (nEndPos <= 0) {
            return null;
        }
        return _sContent.substring(nStartPos, nEndPos + FLAG_END_STYLE.length());
    }

    @Override
    public void setTagItem(TagItem _item) {
        this.m_tagItem = _item;
    }

    public void clear() {
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
    }

    protected CMSObj findHost(PublishTagContext _context) throws WCMException {
        IPublishElement content = _context.getPageElement();
        if (content == null) {
            throw new WCMException(234, "Upper host object required in tag context!");
        }
        return content.getSubstance();
    }
}

