/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.tagparser.TemplateQuoteBaseTagParser;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import java.util.HashMap;
import java.util.List;

public class TagParserCondition
extends TemplateQuoteBaseTagParser {
    private static final Operator s_defaultOperators = new OperatorEqual();
    private static final HashMap s_MapOperator = TagParserCondition.initOperators();
    private static TagBeanInfo s_TagBeanInfo = null;

    private static final HashMap initOperators() {
        HashMap<String, Operator> map = new HashMap<String, Operator>();
        Operator operator = null;
        OperatorNumber opnumber = null;
        OperatorLength oplength = null;
        operator = new OperatorEqualCase();
        map.put("=", operator);
        map.put("equal", operator);
        operator = new OperatorEqual();
        map.put("==", operator);
        opnumber = new OperatorLess();
        opnumber.setType(0);
        map.put("<,INT", opnumber);
        opnumber = new OperatorLess();
        opnumber.setType(1);
        map.put("<,FLOAT", opnumber);
        opnumber = new OperatorLess();
        opnumber.setType(2);
        map.put("<", opnumber);
        opnumber = new OperatorLessEqual();
        opnumber.setType(0);
        map.put("<=,INT", opnumber);
        opnumber = new OperatorLessEqual();
        opnumber.setType(1);
        map.put("<=,FLOAT", opnumber);
        opnumber = new OperatorLessEqual();
        opnumber.setType(2);
        map.put("<=", opnumber);
        opnumber = new OperatorGreater();
        opnumber.setType(0);
        map.put(">,INT", opnumber);
        opnumber = new OperatorGreater();
        opnumber.setType(1);
        map.put(">,FLOAT", opnumber);
        opnumber = new OperatorGreater();
        opnumber.setType(2);
        map.put(">", opnumber);
        opnumber = new OperatorGreaterEqual();
        opnumber.setType(0);
        map.put(">=,INT", opnumber);
        opnumber = new OperatorGreaterEqual();
        opnumber.setType(1);
        map.put(">=,FLOAT", opnumber);
        opnumber = new OperatorGreaterEqual();
        opnumber.setType(2);
        map.put(">=", opnumber);
        operator = new OperatorPresent();
        map.put("present", operator);
        operator = new OperatorBlank();
        map.put("blank", operator);
        operator = new OperatorContain();
        map.put("contain", operator);
        operator = new OperatorStartsWith();
        map.put("startsWith", operator);
        operator = new OperatorEndsWith();
        map.put("endsWith", operator);
        operator = new OperatorMatch();
        map.put("match", operator);
        oplength = new OperatorLength();
        oplength.setCompareType(0);
        map.put("L", oplength);
        map.put("longer", oplength);
        oplength = new OperatorLength();
        oplength.setCompareType(1);
        map.put("L=", oplength);
        oplength = new OperatorLength();
        oplength.setCompareType(2);
        map.put("S", oplength);
        map.put("shorter", oplength);
        oplength = new OperatorLength();
        oplength.setCompareType(3);
        map.put("S=", oplength);
        return map;
    }

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_CONDITION");
            tbi.setDesc("TRS_CONDITION");
            tbi.setType(TagBeanInfo.BodyType.TAMPLATE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CONDITION");
            tbai.setDesc(I18NMessage.get(TagParserCondition.class, "TagParserCondition.label1", "\u6267\u884c\u6761\u4ef6\u5c5e\u6027(CONDITION)"));
            tbai.setRequired(true);
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("REFERENCE");
            tbai.setDesc(I18NMessage.get(TagParserCondition.class, "TagParserCondition.label2", "\u5224\u65ad\u6267\u884c\u6761\u4ef6\u7684\u53c2\u8003\u503c(REFERENCE)"));
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("true");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("OPERATOR");
            tbai.setDesc(I18NMessage.get(TagParserCondition.class, "TagParserCondition.label3", "\u6bd4\u8f83\u8fd0\u7b97\u7b26"));
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"=", "equal", "==", "<", "<=", ">", ">=", "present", "blank", "contain", "startsWith", "endsWith", "match", "L", "L=", "S", "S="});
            tbai.setDefaultValue("==");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("REVERSE");
            tbai.setDesc(I18NMessage.get(TagParserCondition.class, "TagParserCondition.label4", "\u662f\u5426\u7ffb\u8f6c\u53d8\u91cf\u503c\u548c\u53c2\u8003\u503c"));
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TYPE");
            tbai.setDesc(I18NMessage.get(TagParserCondition.class, "TagParserCondition.label5", "\u6bd4\u8f83\u8fd0\u7b97\u4e2d\u6570\u636e\u7c7b\u578b(INT,FLOAT,STRING)"));
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"INT", "FLOAT", "STRING"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("NOT");
            tbai.setDesc(I18NMessage.get(TagParserCondition.class, "TagParserCondition.label6", "\u662f\u5426\u6c42\u53cd"));
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public void setTagItem(TagItem _item) {
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) throws WCMException {
        return null;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        String sReference = this.getReference(_context);
        String sCondition = this.getCondition(_context);
        Operator operator = this.getOperator(_context);
        boolean zReverse = _context.getAttribute("REVERSE", false);
        boolean zNotFlag = _context.getAttribute("NOT", false);
        if (zReverse) {
            String temp = sReference;
            sReference = sCondition;
            sCondition = temp;
        }
        boolean bResult = false;
        if (sReference == null) {
            bResult = operator.compare(sCondition, sReference);
        } else {
            String[] pReferences = sReference.split("~");
            for (int i = 0; i < pReferences.length && !(bResult = operator.compare(sCondition, pReferences[i])); ++i) {
            }
        }
        if (bResult ^ zNotFlag) {
            TagItem item = _context.getTagItem();
            if (item == null) {
                throw new IllegalStateException("no tag on TagContext");
            }
            List list = item.getChildren();
            if (list != null) {
                return TagParseHelper.parseItems(list, _context);
            }
        }
        return null;
    }

    private String getCondition(PublishTagContext _context) throws WCMException {
        String sCondition = _context.getAttribute("CONDITION");
        if (sCondition == null) {
            return null;
        }
        if (sCondition.length() <= 0) {
            return sCondition;
        }
        if (sCondition.charAt(0) == '@') {
            return this.getTagObjAttribute(_context, sCondition.substring(1));
        }
        if (sCondition.charAt(0) == '#') {
            return this.getTagObjAttributeAsAttribute(_context, sCondition.substring(1));
        }
        return sCondition;
    }

    private String getReference(PublishTagContext _context) throws WCMException {
        String sReference = _context.getAttribute("REFERENCE");
        if (sReference == null) {
            return "true";
        }
        if (sReference.length() <= 0) {
            return sReference;
        }
        if (sReference.charAt(0) == '@') {
            return this.getTagObjAttribute(_context, sReference.substring(1));
        }
        if (sReference.charAt(0) == '#') {
            return this.getTagObjAttributeAsAttribute(_context, sReference.substring(1));
        }
        return sReference;
    }

    private String getTagObjAttribute(PublishTagContext _context, String _attribute) throws WCMException {
        if ("System.NowDate".equalsIgnoreCase(_attribute)) {
            return CMyDateTime.now().toString("yyyy-MM-dd");
        }
        if ("ROWNO".equalsIgnoreCase(_attribute)) {
            return String.valueOf(_context.getSequenceNumber());
        }
        if ("TOTALSIZE".equalsIgnoreCase(_attribute)) {
            return String.valueOf(_context.getTagParser4List().getRecordSize());
        }
        String sDomainName = null;
        String sAttribName = null;
        int iSplit = _attribute.indexOf(46);
        if (iSplit >= 0) {
            sDomainName = _attribute.substring(0, iSplit);
            sAttribName = _attribute.substring(iSplit + 1);
        } else {
            sAttribName = _attribute;
        }
        if (sDomainName == null || sDomainName.length() <= 0) {
            CMSObj obj = _context.getUpperHost().getSubstance();
            return obj.getPropertyAsString(sAttribName);
        }
        if ("PAGE".equalsIgnoreCase(sDomainName)) {
            return this.getPageObjAttribute(_context.getPageContext(), sAttribName);
        }
        if ("SITE".equalsIgnoreCase(sDomainName)) {
            CMSObj obj = _context.getRoot().getSubstance();
            return obj.getPropertyAsString(sAttribName);
        }
        if ("PARENT".equalsIgnoreCase(sDomainName)) {
            IPublishElement element = _context.getUpperHost();
            IPublishFolder folder = null;
            folder = element instanceof IPublishFolder ? ((IPublishFolder)element).getParent() : element.getFolder();
            return this.getFolderObjAttribute(folder, sAttribName);
        }
        throw new WCMException(I18NMessage.get(TagParserCondition.class, "TagParserCondition.label7", "\u9519\u8bef\u7684\u9886\u57df\u540d\u79f0\uff0c\u53ea\u652f\u6301[PAGE,SITE,PARENT]"));
    }

    private String getTagObjAttributeAsAttribute(PublishTagContext _context, String _attribute) throws WCMException {
        if ("System.NowDate".equalsIgnoreCase(_attribute)) {
            return CMyDateTime.now().toString("yyyy-MM-dd");
        }
        if ("ROWNO".equalsIgnoreCase(_attribute)) {
            return String.valueOf(_context.getSequenceNumber());
        }
        if ("TOTALSIZE".equalsIgnoreCase(_attribute)) {
            return String.valueOf(_context.getTagParser4List().getRecordSize());
        }
        String sDomainName = null;
        String sAttribName = null;
        int iSplit = _attribute.indexOf(46);
        if (iSplit >= 0) {
            sDomainName = _attribute.substring(0, iSplit);
            sAttribName = _attribute.substring(iSplit + 1);
        } else {
            sAttribName = _attribute;
        }
        if (sDomainName == null || sDomainName.length() <= 0) {
            CMSObj obj = _context.getUpperHost().getSubstance();
            return obj.getAttributeValue(sAttribName);
        }
        if ("PAGE".equalsIgnoreCase(sDomainName)) {
            return this.getPageObjAttributeAsAttribute(_context.getPageContext(), sAttribName);
        }
        if ("SITE".equalsIgnoreCase(sDomainName)) {
            CMSObj obj = _context.getRoot().getSubstance();
            return obj.getAttributeValue(sAttribName);
        }
        if ("PARENT".equalsIgnoreCase(sDomainName)) {
            IPublishElement element = _context.getUpperHost();
            IPublishFolder folder = null;
            folder = element instanceof IPublishFolder ? ((IPublishFolder)element).getParent() : element.getFolder();
            return this.getFolderObjAttributeAsAttribute(folder, sAttribName);
        }
        throw new WCMException(I18NMessage.get(TagParserCondition.class, "TagParserCondition.label7", "\u9519\u8bef\u7684\u9886\u57df\u540d\u79f0\uff0c\u53ea\u652f\u6301[PAGE,SITE,PARENT]"));
    }

    private String getPageObjAttribute(PublishPageContext _context, String _attribute) throws WCMException {
        String sDomainName = null;
        String sAttribName = null;
        int iSplit = _attribute.indexOf(46);
        if (iSplit >= 0) {
            sDomainName = _attribute.substring(0, iSplit);
            sAttribName = _attribute.substring(iSplit + 1);
        } else {
            sAttribName = _attribute;
        }
        if (sDomainName == null || sDomainName.length() <= 0) {
            CMSObj obj = _context.getPageElement().getSubstance();
            return obj.getPropertyAsString(sAttribName);
        }
        if ("SITE".equalsIgnoreCase(sDomainName)) {
            CMSObj obj = _context.getRoot().getSubstance();
            return obj.getPropertyAsString(sAttribName);
        }
        if ("PARENT".equalsIgnoreCase(sDomainName)) {
            IPublishElement element = _context.getPageElement();
            IPublishFolder folder = null;
            folder = element instanceof IPublishFolder ? ((IPublishFolder)element).getParent() : element.getFolder();
            return this.getFolderObjAttribute(folder, sAttribName);
        }
        throw new WCMException(I18NMessage.get(TagParserCondition.class, "TagParserCondition.label8", "\u9519\u8bef\u7684\u9886\u57df\u540d\u79f0\uff0c\u53ea\u652f\u6301[SITE,PARENT]"));
    }

    private String getPageObjAttributeAsAttribute(PublishPageContext _context, String _attribute) throws WCMException {
        String sDomainName = null;
        String sAttribName = null;
        int iSplit = _attribute.indexOf(46);
        if (iSplit >= 0) {
            sDomainName = _attribute.substring(0, iSplit);
            sAttribName = _attribute.substring(iSplit + 1);
        } else {
            sAttribName = _attribute;
        }
        if (sDomainName == null || sDomainName.length() <= 0) {
            CMSObj obj = _context.getPageElement().getSubstance();
            return obj.getAttributeValue(sAttribName);
        }
        if ("SITE".equalsIgnoreCase(sDomainName)) {
            CMSObj obj = _context.getRoot().getSubstance();
            return obj.getAttributeValue(sAttribName);
        }
        if ("PARENT".equalsIgnoreCase(sDomainName)) {
            IPublishElement element = _context.getPageElement();
            IPublishFolder folder = null;
            folder = element instanceof IPublishFolder ? ((IPublishFolder)element).getParent() : element.getFolder();
            return this.getFolderObjAttributeAsAttribute(folder, sAttribName);
        }
        throw new WCMException(I18NMessage.get(TagParserCondition.class, "TagParserCondition.label8", "\u9519\u8bef\u7684\u9886\u57df\u540d\u79f0\uff0c\u53ea\u652f\u6301[SITE,PARENT]"));
    }

    private String getFolderObjAttribute(IPublishFolder _folder, String _attribute) throws WCMException {
        if (_folder == null) {
            throw new WCMException(I18NMessage.get(TagParserCondition.class, "TagParserCondition.label9", "\u9519\u8bef\u7684\u4f7f\u7528\u573a\u666f\uff0c\u5df2\u7ecf\u4e0d\u5b58\u5728\u7236\u76ee\u5f55"));
        }
        String sDomainName = null;
        String sAttribName = null;
        int iSplit = _attribute.indexOf(46);
        if (iSplit >= 0) {
            sDomainName = _attribute.substring(0, iSplit);
            sAttribName = _attribute.substring(iSplit + 1);
        } else {
            sAttribName = _attribute;
        }
        if (sDomainName == null || sDomainName.length() <= 0) {
            CMSObj obj = _folder.getSubstance();
            return obj.getPropertyAsString(sAttribName);
        }
        if ("PARENT".equalsIgnoreCase(sDomainName)) {
            IPublishFolder folder = _folder.getParent();
            return this.getFolderObjAttribute(folder, sAttribName);
        }
        throw new WCMException(I18NMessage.get(TagParserCondition.class, "TagParserCondition.label10", "\u9519\u8bef\u7684\u9886\u57df\u540d\u79f0\uff0c\u53ea\u652f\u6301[PARENT]"));
    }

    private String getFolderObjAttributeAsAttribute(IPublishFolder _folder, String _attribute) throws WCMException {
        if (_folder == null) {
            throw new WCMException(I18NMessage.get(TagParserCondition.class, "TagParserCondition.label9", "\u9519\u8bef\u7684\u4f7f\u7528\u573a\u666f\uff0c\u5df2\u7ecf\u4e0d\u5b58\u5728\u7236\u76ee\u5f55"));
        }
        String sDomainName = null;
        String sAttribName = null;
        int iSplit = _attribute.indexOf(46);
        if (iSplit >= 0) {
            sDomainName = _attribute.substring(0, iSplit);
            sAttribName = _attribute.substring(iSplit + 1);
        } else {
            sAttribName = _attribute;
        }
        if (sDomainName == null || sDomainName.length() <= 0) {
            CMSObj obj = _folder.getSubstance();
            return obj.getAttributeValue(sAttribName);
        }
        if ("PARENT".equalsIgnoreCase(sDomainName)) {
            IPublishFolder folder = _folder.getParent();
            return this.getFolderObjAttributeAsAttribute(folder, sAttribName);
        }
        throw new WCMException(I18NMessage.get(TagParserCondition.class, "TagParserCondition.label10", "\u9519\u8bef\u7684\u9886\u57df\u540d\u79f0\uff0c\u53ea\u652f\u6301[PARENT]"));
    }

    private Operator getOperator(PublishTagContext _context) {
        Operator operator;
        String sOperator = _context.getAttribute("OPERATOR");
        if (sOperator == null) {
            return s_defaultOperators;
        }
        String sType = _context.getAttribute("TYPE");
        if (sType != null && (sType = sType.trim()).length() > 0 && !(sType = sType.toUpperCase()).equals("STRING")) {
            sOperator = sOperator + ',' + sType;
        }
        if ((operator = (Operator)s_MapOperator.get(sOperator)) == null) {
            return s_defaultOperators;
        }
        return operator;
    }

    @Override
    public void clear() {
    }

    private static class OperatorLength
    extends Operator {
        static final int LONGER_THAN = 0;
        static final int LONGER_OR_EQUAL = 1;
        static final int SHORTER_THAN = 2;
        static final int SHORTER_OR_EQUAL = 3;
        private int m_iCompareType = 0;

        private OperatorLength() {
        }

        @Override
        boolean compare(String sCondition, String sReference) {
            int iConditionLength = this.getConditionLength(sCondition);
            int iReferenceLength = this.getReferenceLength(sReference);
            switch (this.m_iCompareType) {
                case 0: {
                    return iConditionLength > iReferenceLength;
                }
                case 1: {
                    return iConditionLength >= iReferenceLength;
                }
                case 2: {
                    return iConditionLength < iReferenceLength;
                }
                case 3: {
                    return iConditionLength <= iReferenceLength;
                }
            }
            return iConditionLength > iReferenceLength;
        }

        private final int getConditionLength(String sCondition) {
            if (sCondition == null) {
                return 0;
            }
            return sCondition.length();
        }

        private final int getReferenceLength(String sReference) {
            if (sReference == null) {
                return 0;
            }
            int length = sReference.length();
            if (length > 10) {
                return length;
            }
            int number = 0;
            for (int i = 0; i < length; ++i) {
                int digit = sReference.charAt(i) - 48;
                if (digit < 0 || digit > 9) {
                    return length;
                }
                number = number * 10 + digit;
            }
            if (number > 0) {
                return number;
            }
            return length;
        }

        int getCompareType() {
            return this.m_iCompareType;
        }

        void setCompareType(int compareType) {
            this.m_iCompareType = compareType;
        }
    }

    private static class OperatorMatch
    extends Operator {
        private OperatorMatch() {
        }

        @Override
        boolean compare(String sCondition, String sReference) {
            if (sCondition == null || sReference == null) {
                return false;
            }
            return sCondition.matches(sReference);
        }
    }

    private static class OperatorEndsWith
    extends Operator {
        private OperatorEndsWith() {
        }

        @Override
        boolean compare(String sCondition, String sReference) {
            if (sCondition == null || sReference == null) {
                return false;
            }
            return sCondition.endsWith(sReference);
        }
    }

    private static class OperatorStartsWith
    extends Operator {
        private OperatorStartsWith() {
        }

        @Override
        boolean compare(String sCondition, String sReference) {
            if (sCondition == null || sReference == null) {
                return false;
            }
            return sCondition.startsWith(sReference);
        }
    }

    private static class OperatorContain
    extends Operator {
        private OperatorContain() {
        }

        @Override
        boolean compare(String sCondition, String sReference) {
            if (sCondition == null || sReference == null) {
                return false;
            }
            return sCondition.indexOf(sReference) >= 0;
        }
    }

    private static class OperatorBlank
    extends Operator {
        private OperatorBlank() {
        }

        @Override
        boolean compare(String sCondition, String sReference) {
            return sCondition == null || sCondition.length() <= 0;
        }
    }

    private static class OperatorPresent
    extends Operator {
        private OperatorPresent() {
        }

        @Override
        boolean compare(String sCondition, String sReference) {
            return sCondition != null;
        }
    }

    private static class OperatorGreaterEqual
    extends OperatorNumber {
        private OperatorGreaterEqual() {
        }

        @Override
        boolean compareInt(int iCondition, int iReference) {
            return iCondition >= iReference;
        }

        @Override
        boolean compareFloat(float fCondition, float fReference) {
            return fCondition >= fReference;
        }

        @Override
        boolean compareString(String sCondition, String sReference) {
            return sCondition.compareTo(sReference) >= 0;
        }
    }

    private static class OperatorGreater
    extends OperatorNumber {
        private OperatorGreater() {
        }

        @Override
        boolean compareInt(int iCondition, int iReference) {
            return iCondition > iReference;
        }

        @Override
        boolean compareFloat(float fCondition, float fReference) {
            return fCondition > fReference;
        }

        @Override
        boolean compareString(String sCondition, String sReference) {
            return sCondition.compareTo(sReference) > 0;
        }
    }

    private static class OperatorLessEqual
    extends OperatorNumber {
        private OperatorLessEqual() {
        }

        @Override
        boolean compareInt(int iCondition, int iReference) {
            return iCondition <= iReference;
        }

        @Override
        boolean compareFloat(float fCondition, float fReference) {
            return fCondition <= fReference;
        }

        @Override
        boolean compareString(String sCondition, String sReference) {
            return sCondition.compareTo(sReference) <= 0;
        }
    }

    private static class OperatorLess
    extends OperatorNumber {
        private OperatorLess() {
        }

        @Override
        boolean compareInt(int iCondition, int iReference) {
            return iCondition < iReference;
        }

        @Override
        boolean compareFloat(float fCondition, float fReference) {
            return fCondition < fReference;
        }

        @Override
        boolean compareString(String sCondition, String sReference) {
            return sCondition.compareTo(sReference) < 0;
        }
    }

    private static abstract class OperatorNumber
    extends Operator {
        static final int TYPE_INT = 0;
        static final int TYPE_FLOAT = 1;
        static final int TYPE_STRING = 2;
        int m_iCompareType = 2;

        private OperatorNumber() {
        }

        void setType(int type) {
            this.m_iCompareType = type;
        }

        @Override
        boolean compare(String sCondition, String sReference) {
            if (sCondition == null) {
                return false;
            }
            switch (this.m_iCompareType) {
                case 0: {
                    int iCondition = Integer.parseInt(sCondition);
                    int iReference = Integer.parseInt(sReference);
                    return this.compareInt(iCondition, iReference);
                }
                case 1: {
                    float fCondition = Float.parseFloat(sCondition);
                    float fReference = Float.parseFloat(sReference);
                    return this.compareFloat(fCondition, fReference);
                }
            }
            return this.compareString(sCondition, sReference);
        }

        abstract boolean compareInt(int var1, int var2);

        abstract boolean compareFloat(float var1, float var2);

        abstract boolean compareString(String var1, String var2);
    }

    private static class OperatorEqualCase
    extends Operator {
        private OperatorEqualCase() {
        }

        @Override
        boolean compare(String sCondition, String sReference) {
            if (sCondition == null) {
                return sReference == null;
            }
            return sCondition.equals(sReference);
        }
    }

    private static class OperatorEqual
    extends Operator {
        private OperatorEqual() {
        }

        @Override
        boolean compare(String sCondition, String sReference) {
            if (sCondition == null) {
                return sReference == null;
            }
            boolean bResult = sCondition.equalsIgnoreCase(sReference);
            if (bResult) {
                return true;
            }
            if (sCondition.equalsIgnoreCase("true")) {
                sCondition = "1";
            } else if (sCondition.equalsIgnoreCase("false")) {
                sCondition = "0";
            } else {
                return bResult;
            }
            return sCondition.equalsIgnoreCase(sReference);
        }
    }

    public static abstract class Operator {
        abstract boolean compare(String var1, String var2);
    }
}

