/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.DefaultObjs;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser4List;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import org.apache.log4j.Logger;

public abstract class BaseTagParserDefaultObjects
extends BaseTagParser4List {
    private static Logger logger = Logger.getLogger(BaseTagParserDefaultObjects.class);

    protected abstract String getDBTableName(PublishTagContext var1);

    protected abstract String getIdFieldName(PublishTagContext var1);

    protected abstract WCMFilter makeExtraFilter(PublishTagContext var1) throws WCMException;

    @Override
    protected CMSBaseObjs findObjects(PublishTagContext _context) throws WCMException {
        String sTableName = this.getDBTableName(_context);
        String sIdFieldName = this.getIdFieldName(_context);
        return this.queryDefaultObjects(_context, sTableName, sIdFieldName);
    }

    @Override
    protected boolean isValidate(PublishTagContext _context) {
        String sTableName = this.getDBTableName(_context);
        if (sTableName == null || (sTableName = sTableName.trim()).length() <= 0) {
            return false;
        }
        String sIdFieldName = this.getIdFieldName(_context);
        return sIdFieldName != null && (sIdFieldName = sIdFieldName.trim()).length() > 0;
    }

    private DefaultObjs queryDefaultObjects(PublishTagContext _context, String _sTableName, String _sIdFieldName) throws WCMException {
        boolean bLoadObjectsByPageMode = _context.getAttribute("LoadObjectdByPageMode", true);
        int nMaxSize = _context.getAttribute("NUM", 20);
        int nStartPos = _context.getAttribute("STARTPOS", 0);
        String sWhere = _context.getAttribute("WHERE");
        String sOrder = _context.getAttribute("ORDER");
        String sSelect = _context.getAttribute("SELECT");
        WCMFilter filter = new WCMFilter(_sTableName, sWhere, sOrder, sSelect);
        filter.mergeWith(this.makeExtraFilter(_context));
        filter.setMaxRowNumber(nStartPos + nMaxSize);
        DefaultObjs currDefaultObjs = new DefaultObjs(null, _sTableName, _sIdFieldName);
        if (bLoadObjectsByPageMode) {
            currDefaultObjs.setMaxBufferSize(40);
        } else {
            currDefaultObjs.setMaxBufferSize(filter.getMaxRowNumber());
        }
        currDefaultObjs.open(filter);
        return currDefaultObjs;
    }
}

