/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.publisher;

import com.trs.cms.ContextHelper;
import com.trs.components.common.publish.domain.distribute.FileDistributeShip;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTask;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import org.apache.batik.dom.util.HashTable;
import org.apache.log4j.Logger;
import org.aton.container.IClearable;

public class PublishTaskContext
implements IClearable {
    private Logger s_logger = Logger.getLogger(PublishTaskContext.class);
    private PublishTask m_task;
    private IPublishFolder m_startFolder;
    private IPublishFolder m_root = null;
    private PublishPathCompass m_pathCompass = null;
    private FileDistributeShip m_fileDistributeShip = null;
    private int m_iDetailPageCount = 0;
    private int m_iOutlinePageCount = 0;
    private HashTable m_hCache = null;

    public PublishTaskContext(PublishTask _task, IPublishFolder _startFolder) {
        this.m_task = _task;
        this.m_startFolder = _startFolder;
        this.m_pathCompass = new PublishPathCompass();
    }

    public void clear() {
        this.m_root = null;
        if (this.m_pathCompass != null) {
            this.m_pathCompass.clear();
        }
        if (this.m_fileDistributeShip != null) {
            this.m_fileDistributeShip.clear();
        }
        if (this.m_hCache != null) {
            this.m_hCache.clear();
            this.m_hCache = null;
        }
    }

    public PublishTask getTask() {
        return this.m_task;
    }

    public IPublishFolder getStartFolder() {
        return this.m_startFolder;
    }

    public void setStartFolder(IPublishFolder folder) {
        this.m_startFolder = folder;
    }

    public boolean isPreview() {
        return this.m_task == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPublishFolder getRoot() throws WCMException {
        if (this.m_root == null) {
            PublishTaskContext publishTaskContext = this;
            synchronized (publishTaskContext) {
                if (this.m_root == null) {
                    this.m_root = this.m_startFolder.getRoot();
                }
            }
        }
        return this.m_root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublishPathCompass getPathCompass() {
        if (this.m_pathCompass == null) {
            PublishTaskContext publishTaskContext = this;
            synchronized (publishTaskContext) {
                if (this.m_pathCompass == null) {
                    this.m_pathCompass = new PublishPathCompass();
                }
            }
        }
        return this.m_pathCompass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileDistributeShip getFileDistributeShip() {
        if (this.m_fileDistributeShip == null) {
            PublishTaskContext publishTaskContext = this;
            synchronized (publishTaskContext) {
                if (this.m_fileDistributeShip == null) {
                    this.m_fileDistributeShip = new FileDistributeShip(this.getPathCompass());
                    this.m_fileDistributeShip.setBatchMode(true);
                }
            }
        }
        return this.m_fileDistributeShip;
    }

    public int getDetailPageCount() {
        return this.m_iDetailPageCount;
    }

    public synchronized void incDetailPageCount() {
        ++this.m_iDetailPageCount;
    }

    public int getOutlinePageCount() {
        return this.m_iOutlinePageCount;
    }

    public synchronized void incOutlinePageCount() {
        ++this.m_iOutlinePageCount;
    }

    public void addErrorLog(int iResult, IPublishElement element, String sDesc, String sError) {
        try {
            this.s_logger.error((Object)(sError + "\n" + sDesc));
            if (this.m_task != null && this.m_task.isValidInstance()) {
                this.m_task.addErrorLog(ContextHelper.getLoginUser(), element, sDesc, iResult, sError);
            }
        }
        catch (Throwable t) {
            this.s_logger.error((Object)"Failed to add error log for publish task!", t);
        }
    }

    public void addErrorLog(int iResult, IPublishElement element, String sDesc, Throwable t) {
        this.addErrorLog(iResult, element, sDesc, CMyException.getStackTraceText(t));
    }

    public synchronized Object putInCache(String _sKey, Object _oCacheObject) {
        String sKey;
        Object oCachedObject;
        if (this.m_hCache == null) {
            this.m_hCache = new HashTable(1);
        }
        if ((oCachedObject = this.m_hCache.get((Object)(sKey = _sKey.toUpperCase()))) != null) {
            return oCachedObject;
        }
        this.m_hCache.put((Object)sKey, _oCacheObject);
        return _oCacheObject;
    }

    public Object getCachObject(String _sKey) {
        if (this.m_hCache == null) {
            return null;
        }
        String sKey = _sKey.toUpperCase();
        return this.m_hCache.get((Object)sKey);
    }
}

